/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.storage.liquid;

import codechicken.core.ClientUtils;
import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.EnderStorage;
import codechicken.enderstorage.api.EnderStorageManager;
import codechicken.enderstorage.common.RenderCustomEndPortal;
import codechicken.enderstorage.common.RenderEnderStorage;
import codechicken.enderstorage.internal.EnderStorageClientProxy;
import codechicken.enderstorage.storage.liquid.TileEnderTank;
import codechicken.lib.math.MathHelper;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.uv.UVTranslation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.SwapYZ;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class EnderTankRenderer
extends TileEntitySpecialRenderer {
    static final CCModel tankModel;
    static final CCModel valveModel;
    static final CCModel[] buttons;
    static final UVTranslation[] UVTranslationButtons;
    static final UVTranslation UVTvalveOwned;
    static final UVTranslation UVTvalveNotOwned;
    static final Vector3 Y;
    static final Vector3 Z;
    static final Vector3 point;
    static final Cuboid6 cuboidFLuid;
    static final RenderCustomEndPortal renderEndPortal;

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        TileEnderTank tank = (TileEnderTank)tile;
        CCRenderState state = CCRenderState.instance();
        state.reset();
        state.pullLightmap();
        state.useNormals = true;
        EnderTankRenderer.renderTank(state, tank.rotation, (float)MathHelper.interpolate((double)tank.pressure_state.b_rotate, (double)tank.pressure_state.a_rotate, (double)f) * 0.01745f, tank.freq, !tank.owner.equals("global"), x, y, z, EnderStorageClientProxy.getTimeOffset(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
        EnderTankRenderer.renderLiquid(tank.liquid_state.c_liquid, x, y, z);
    }

    public static void renderTank(CCRenderState state, int rotation, float valve, int freq, boolean owned, double x, double y, double z, int offset) {
        if (!EnderStorage.disableFXTank) {
            TileEntityRendererDispatcher info = TileEntityRendererDispatcher.field_147556_a;
            renderEndPortal.render(x, y, z, 0.0f, info.field_147560_j, info.field_147560_j, info.field_147561_k, info.field_147553_e);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotatef((float)(-90 * (rotation + 2)), (float)0.0f, (float)1.0f, (float)0.0f);
        CCRenderState.changeTexture((String)"enderstorage:textures/endertank.png");
        state.startDrawing(4);
        tankModel.render(new CCRenderState.IVertexOperation[0]);
        state.draw();
        CCRenderState.changeTexture((String)"enderstorage:textures/buttons.png");
        state.startDrawing(7);
        for (int i = 0; i < 3; ++i) {
            int colour = EnderStorageManager.getColourFromFreq(freq, i);
            buttons[i].render(new CCRenderState.IVertexOperation[]{UVTranslationButtons[colour]});
        }
        state.draw();
        new Rotation((double)valve, Z).at(point).glApply();
        CCRenderState.changeTexture((String)"enderstorage:textures/endertank.png");
        state.startDrawing(4);
        valveModel.render(new CCRenderState.IVertexOperation[]{owned ? UVTvalveOwned : UVTvalveNotOwned});
        state.draw();
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
        double time = ClientUtils.getRenderTime() + (double)offset;
        Matrix4 pearlMat = CCModelLibrary.getRenderMatrix((Vector3)new Vector3(x + 0.5, y + 0.45 + (double)(EnderStorageClientProxy.getPearlBob(time) * 2.0f), z + 0.5), (Rotation)new Rotation(time / 3.0, Y), (double)0.04);
        GL11.glDisable((int)2896);
        CCRenderState.changeTexture((String)"enderstorage:textures/hedronmap.png");
        state.startDrawing(4);
        CCModelLibrary.icosahedron4.render(new CCRenderState.IVertexOperation[]{pearlMat});
        state.draw();
        GL11.glEnable((int)2896);
    }

    public static void renderLiquid(FluidStack liquid, double x, double y, double z) {
        RenderUtils.renderFluidCuboid((FluidStack)liquid, (Cuboid6)cuboidFLuid.add(new Vector3(x, y, z)), (double)((double)liquid.amount / ((double)EnderStorage.enderTankSize * (double)FluidUtils.B)), (double)0.75);
    }

    static {
        UVTranslationButtons = new UVTranslation[16];
        UVTvalveOwned = new UVTranslation(0.0, 0.203125);
        UVTvalveNotOwned = new UVTranslation(0.0, 0.0);
        Y = new Vector3(0.0, 1.0, 0.0);
        Z = new Vector3(0.0, 0.0, 1.0);
        point = new Vector3(0.0, 0.4165, 0.0);
        cuboidFLuid = new Cuboid6(0.22, 0.12, 0.22, 0.78, 0.751, 0.78);
        renderEndPortal = new RenderCustomEndPortal(0.1205, 0.24, 0.76, 0.24, 0.76);
        Map models = CCModel.parseObjModels((ResourceLocation)new ResourceLocation("enderstorage", "models/endertank.obj"), (Transformation)new SwapYZ());
        ArrayList tankParts = new ArrayList();
        tankParts.add(models.get("Blazerod1"));
        tankParts.add(models.get("Blazerod2"));
        tankParts.add(models.get("Blazerod3"));
        tankParts.add(models.get("Blazerod4"));
        tankParts.add(models.get("Top"));
        tankParts.add(models.get("Top2"));
        tankParts.add(models.get("Base"));
        tankParts.add(models.get("Glass"));
        tankParts.add(models.get("Valvebase"));
        Translation fix = new Translation(-0.5099, 0.0, -0.5027);
        tankModel = CCModel.combine(tankParts).apply((Transformation)fix).computeNormals();
        valveModel = ((CCModel)models.get("Valve")).apply((Transformation)fix).computeNormals();
        buttons = new CCModel[3];
        for (int i = 0; i < 3; ++i) {
            EnderTankRenderer.buttons[i] = RenderEnderStorage.button.copy().apply((Transformation)TileEnderTank.buttonT[i].with((Transformation)new Translation(-0.5, 0.0, -0.5)));
        }
        for (int colour = 0; colour < 16; ++colour) {
            EnderTankRenderer.UVTranslationButtons[colour] = new UVTranslation(0.25 * (double)(colour % 4), 0.25 * (double)(colour / 4));
        }
    }
}

