/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.api.content.BOPCBlocks;
import biomesoplenty.common.blocks.BlockBOPNewGrass;
import biomesoplenty.common.utils.ISubLocalization;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBOPNewFarmland
extends BlockFarmland
implements ISubLocalization {
    IIcon[] dry = new IIcon[BlockBOPNewGrass.grassTypes.length];
    IIcon[] wet = new IIcon[BlockBOPNewGrass.grassTypes.length];
    IIcon[] dirts = new IIcon[BlockBOPNewGrass.grassTypes.length];

    public BlockBOPNewFarmland() {
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_149672_a(field_149767_g);
    }

    @Override
    public String getUnlocalizedName(String baseName, ItemStack itemStack) {
        int meta = itemStack.func_77960_j();
        if (meta > BlockBOPNewGrass.grassTypes.length - 1) {
            meta = 0;
        }
        return baseName + "." + BlockBOPNewGrass.grassTypes[meta / 2];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item block, CreativeTabs creativeTab, List blockList) {
        for (int i = 0; i < BlockBOPNewGrass.grassTypes.length * 2; ++i) {
            blockList.add(new ItemStack(block, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        for (int dirt = 0; dirt < BlockBOPNewGrass.grassTypes.length; ++dirt) {
            this.dry[dirt] = iconRegister.func_94245_a("biomesoplenty:farmland_dry_" + BlockBOPNewGrass.grassTypes[dirt]);
            this.wet[dirt] = iconRegister.func_94245_a("biomesoplenty:farmland_wet_" + BlockBOPNewGrass.grassTypes[dirt]);
            this.dirts[dirt] = iconRegister.func_94245_a("biomesoplenty:dirt_" + BlockBOPNewGrass.grassTypes[dirt]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta > BlockBOPNewGrass.grassTypes.length - 1) {
            meta = 0;
        }
        return side == 1 ? ((meta & 1) == 0 ? this.dry[meta / 2] : this.wet[meta / 2]) : this.dirts[meta / 2];
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        int meta = world.func_72805_g(x, y, z);
        if (!this.waterNearby(world, x, y, z) && !world.func_72951_B(x, y + 1, z)) {
            if ((meta & 1) == 1) {
                world.func_72921_c(x, y, z, meta - 1, 2);
            } else if (!this.hasFlower(world, x, y, z)) {
                world.func_147465_d(x, y, z, BOPCBlocks.newBopDirt, meta, 2);
            }
        } else {
            world.func_72921_c(x, y, z, meta / 2 * 2 + 1, 2);
        }
    }

    private boolean waterNearby(World world, int x, int y, int z) {
        for (int l = x - 4; l <= x + 4; ++l) {
            for (int i1 = y; i1 <= y + 1; ++i1) {
                for (int j1 = z - 4; j1 <= z + 4; ++j1) {
                    if (world.func_147439_a(l, i1, j1).func_149688_o() != Material.field_151586_h) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasFlower(World world, int x, int y, int z) {
        int b0 = 0;
        for (int l = x - b0; l <= x + b0; ++l) {
            for (int i1 = z - b0; i1 <= z + b0; ++i1) {
                Block block = world.func_147439_a(l, y + 1, i1);
                if (!(block instanceof IPlantable) || !this.canSustainPlant((IBlockAccess)world, x, y, z, ForgeDirection.UP, (IPlantable)block)) continue;
                return true;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        Material material = world.func_147439_a(x, y + 1, z).func_149688_o();
        if (material.func_76220_a()) {
            world.func_147465_d(x, y, z, BOPCBlocks.newBopDirt, world.func_72805_g(x, y, z) / 2 * 2, 2);
        }
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float fallDistance) {
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < fallDistance - 0.5f) {
            if (!(entity instanceof EntityPlayer) && !world.func_82736_K().func_82766_b("mobGriefing")) {
                return;
            }
            world.func_147465_d(x, y, z, BOPCBlocks.newBopDirt, world.func_72805_g(x, y, z) / 2 * 2, 2);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack(BOPCBlocks.newBopDirt, 1, metadata / 2 * 2));
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return new ItemStack(BOPCBlocks.newBopDirt, 1, world.func_72805_g(x, y, z) / 2 * 2).func_77973_b();
    }

    public boolean canSustainPlant(IBlockAccess world, int x, int y, int z, ForgeDirection direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, x, y + 1, z);
        switch (plantType) {
            case Crop: {
                return true;
            }
        }
        return super.canSustainPlant(world, x, y, z, direction, plantable);
    }
}

