/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.voxelmap;

import com.gtnewhorizons.navigator.api.voxelmap.VoxelMapWaypointManager;
import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.hooks.ProspectingNotificationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.GregTechAPI;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.item.ItemStack;

public class VoxelMapEventHandler {
    @SubscribeEvent
    public void onVeinProspected(ProspectingNotificationEvent.OreVein event) {
        if (event.isCanceled()) {
            return;
        }
        OreVeinPosition pos = event.getPosition();
        short[] color = GregTechAPI.sGeneratedMaterials[pos.veinType.primaryOreMeta].getRGBA();
        TreeSet<Integer> dim = new TreeSet<Integer>();
        dim.add(pos.dimensionId);
        VoxelMapWaypointManager.addVoxelMapWaypoint((String)pos.veinType.getPrimaryOreName(), (int)pos.getBlockX(), (int)pos.getBlockZ(), (int)VoxelMapEventHandler.getY(), (boolean)Config.enableVoxelMapWaypointsByDefault, (float)((float)color[0] / 255.0f), (float)((float)color[1] / 255.0f), (float)((float)color[2] / 255.0f), (String)"Pickaxe", dim);
    }

    @SubscribeEvent
    public void onFluidProspected(ProspectingNotificationEvent.UndergroundFluid event) {
        if (event.isCanceled()) {
            return;
        }
        UndergroundFluidPosition pos = event.getPosition();
        int x = Utils.coordChunkToBlock(pos.chunkX);
        int z = Utils.coordChunkToBlock(pos.chunkZ);
        int color = pos.fluid.getColor();
        TreeSet<Integer> dim = new TreeSet<Integer>();
        dim.add(pos.dimensionId);
        VoxelMapWaypointManager.addVoxelMapWaypoint((String)pos.fluid.getLocalizedName(), (int)x, (int)z, (int)Minecraft.func_71410_x().field_71441_e.func_72976_f(x, z), (boolean)Config.enableVoxelMapWaypointsByDefault, (float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (String)"Science", dim);
    }

    private static int getY() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || !heldItem.func_77977_a().contains("gt.detrav.metatool.01")) {
            return (int)player.field_70163_u;
        }
        return 65;
    }
}

