/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.mixins;

import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.gtnewhorizons.gravisuiteneo.util.QuantumShieldHelper;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.ItemGraviChestPlate;
import gravisuite.ServerProxy;
import ic2.api.item.ElectricItem;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemGraviChestPlate.class})
public class MixinItemGraviChestPlate {
    @Inject(at={@At(opcode=153, ordinal=7, value="JUMP")}, cancellable=true, method={"onArmorTick"}, remap=false)
    private void gravisuiteneo$handleShieldAndNanobots(World worldObj, EntityPlayer player, ItemStack itemStack, CallbackInfo ci) {
        if (!QuantumShieldHelper.readShieldMode(itemStack)) {
            return;
        }
        if (!QuantumShieldHelper.hasValidShieldEquipment(player)) {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.invalidSetupShieldBreak")));
            QuantumShieldHelper.saveShieldMode(itemStack, false);
            QuantumShieldHelper.notifyWorldShieldDown(player);
            ci.cancel();
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (ItemGraviChestPlate.getCharge((ItemStack)itemStack) < 5000) {
                ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.graviChestPlate.lowpowerShieldBreak")));
                QuantumShieldHelper.saveShieldMode(itemStack, false);
                QuantumShieldHelper.notifyWorldShieldDown(player);
                ci.cancel();
                return;
            }
            ElectricItem.manager.discharge(itemStack, 5000.0, 4, false, false, false);
            QuantumShieldHelper.runHealthMonitor(player, itemStack);
        }
    }

    @ModifyExpressionValue(at={@At(target="Lnet/minecraft/entity/player/EntityPlayer;isBurning()Z", value="INVOKE", remap=true)}, method={"onArmorTick"}, remap=false)
    private boolean gravisuiteneo$checkCanExtinguish(boolean original, World worldObj, EntityPlayer player, ItemStack itemStack) {
        if (original && ElectricItem.manager.canUse(itemStack, 1000.0)) {
            ElectricItem.manager.discharge(itemStack, 1000.0, 4, true, false, false);
            return true;
        }
        return false;
    }

    @Inject(at={@At(value="TAIL")}, method={"onArmorTick"}, remap=false)
    private void gravisuiteneo$curePotions(World worldObj, EntityPlayer player, ItemStack itemStack, CallbackInfo ci) {
        QuantumShieldHelper.curePotions(itemStack, player, false);
    }

    @SideOnly(value=Side.CLIENT)
    @Inject(at={@At(value="TAIL")}, method={"addInformation"})
    private void gravisuiteneo$addShieldInformation(ItemStack itemStack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips, CallbackInfo ci) {
        String shieldStatus = QuantumShieldHelper.readShieldMode(itemStack) ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"message.text.on") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.text.off");
        tooltip.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"message.graviChestPlate.shieldMode") + ": " + shieldStatus);
    }

    @Overwrite(remap=false)
    public int getEnergyPerDamage() {
        return 3000;
    }

    @Overwrite(remap=false)
    public double getDamageAbsorptionRatio() {
        return Properties.ArmorPresets.GraviChestPlate.absorptionRatio;
    }

    @Overwrite(remap=false)
    private double getBaseAbsorptionRatio() {
        return 1.0;
    }
}

