/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class FindItConfig {
    public static int SEARCH_RADIUS = 16;
    public static int SEARCH_COOLDOWN = 10;
    public static int MAX_RESPONSE_SIZE = 20;
    public static boolean ENABLE_ROTATE_VIEW = false;
    public static boolean USE_PARTICLE_HIGHLIGHTER = false;
    public static boolean SEARCH_ITEMS_ON_GROUND = true;
    public static boolean SEARCH_IN_GT_PIPES = false;
    public static boolean SEARCH_IN_ENDERIO_CONDUITS = false;
    public static int ITEM_HIGHLIGHTING_DURATION = 10;
    public static int BLOCK_HIGHLIGHTING_DURATION = 8;

    public static void setup(File file) {
        Configuration config = new Configuration(file);
        try {
            config.load();
            SEARCH_RADIUS = config.get("general", "SearchRadius", "16", "Radius to search within").getInt();
            SEARCH_COOLDOWN = config.get("general", "SearchCooldown", "10", "Search cooldown in ticks").getInt();
            MAX_RESPONSE_SIZE = config.get("general", "MaxResponseSize", "20", "Maximum number of positions that can be displayed by item/block search").getInt();
            USE_PARTICLE_HIGHLIGHTER = config.get("general", "UseParticleHighlighter", "false", "Use Particle for Block Highlighter").getBoolean();
            SEARCH_IN_GT_PIPES = config.get("general", "SearchInGregTechPipes", "false", "Search items & fluids in GT pipes").getBoolean();
            SEARCH_IN_ENDERIO_CONDUITS = config.get("general", "SearchInEnderIOConduits", "false", "Search items & fluids in EnderIO conduits").getBoolean();
            SEARCH_ITEMS_ON_GROUND = config.get("general", "SearchItemsOnGround", "true", "Search items dropped on ground").getBoolean();
            ITEM_HIGHLIGHTING_DURATION = config.get("general", "ItemHighlightingDuration", "10", "Item highlighting duration").getInt();
            BLOCK_HIGHLIGHTING_DURATION = config.get("general", "BlockHighlightingDuration", "8", "Block highlighting duration in seconds").getInt();
            ENABLE_ROTATE_VIEW = config.get("general", "EnableRotateView", "false", "Rotate player's view when searched").getBoolean();
        }
        catch (Exception exception) {
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }
}

