/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.value.sync;

import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.fluid.FluidInteractions;
import com.cleanroommc.modularui.value.sync.ValueSyncHandler;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidSlotSyncHandler
extends ValueSyncHandler<FluidStack> {
    @Nullable
    private FluidStack cache;
    private final IFluidTank fluidTank;
    private boolean canFillSlot = true;
    private boolean canDrainSlot = true;
    private boolean controlsAmount = true;
    private boolean phantom = false;
    @Nullable
    private FluidStack lastStoredPhantomFluid;

    public static boolean isFluidEmpty(@Nullable FluidStack fluidStack) {
        return fluidStack == null || fluidStack.amount <= 0;
    }

    @Nullable
    public static FluidStack copyFluid(@Nullable FluidStack fluidStack) {
        return FluidSlotSyncHandler.isFluidEmpty(fluidStack) ? null : fluidStack.copy();
    }

    public FluidSlotSyncHandler(IFluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }

    @Override
    @Nullable
    public FluidStack getValue() {
        return this.cache;
    }

    @Override
    public void setValue(@Nullable FluidStack value, boolean setSource, boolean sync) {
        this.cache = FluidSlotSyncHandler.copyFluid(value);
        if (setSource && !NetworkUtils.isClient()) {
            this.fluidTank.drain(Integer.MAX_VALUE, true);
            if (!FluidSlotSyncHandler.isFluidEmpty(value)) {
                this.fluidTank.fill(value.copy(), true);
            }
        }
        if (sync) {
            if (NetworkUtils.isClient()) {
                this.syncToServer(0, this::write);
            } else {
                this.syncToClient(0, this::write);
            }
        }
        this.onValueChanged();
    }

    public boolean needsSync() {
        FluidStack current = this.fluidTank.getFluid();
        if (current == this.cache) {
            return false;
        }
        if (current == null || this.cache == null) {
            return true;
        }
        return current.amount != this.cache.amount || !current.isFluidEqual(this.cache);
    }

    @Override
    public boolean updateCacheFromSource(boolean isFirstSync) {
        if (isFirstSync || this.needsSync()) {
            this.setValue(this.fluidTank.getFluid(), false, false);
            return true;
        }
        return false;
    }

    @Override
    public void write(PacketBuffer buffer) {
        NetworkUtils.writeFluidStack(buffer, this.cache);
    }

    @Override
    public void read(PacketBuffer buffer) {
        this.setValue(NetworkUtils.readFluidStack(buffer), true, false);
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) {
        if (id == 0) {
            this.read(buf);
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) {
        if (id == 0) {
            if (this.phantom) {
                this.read(buf);
            }
        } else if (id == 1) {
            if (this.phantom) {
                this.tryClickPhantom(MouseData.readPacket(buf));
            } else {
                this.tryClickContainer(MouseData.readPacket(buf));
            }
        } else if (id == 2) {
            if (this.phantom) {
                this.tryScrollPhantom(MouseData.readPacket(buf));
            }
        } else if (id == 3) {
            this.controlsAmount = buf.readBoolean();
        } else if (id == 4) {
            MouseData mouseData = MouseData.readPacket(buf);
            ItemStack draggedStack = NetworkUtils.readItemStack(buf);
            if (this.phantom && draggedStack != null) {
                this.tryClickPhantom(mouseData, draggedStack);
            }
        }
    }

    private void tryClickContainer(MouseData mouseData) {
        boolean processFullStack = mouseData.shift;
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.fluidTank.getFluid();
        FluidStack heldFluid = FluidInteractions.getFluidForRealItem(heldItemSizedOne);
        if (heldFluid != null && heldFluid.amount <= 0) {
            heldFluid = null;
        }
        if (currentFluid == null) {
            if (!this.canFillSlot) {
                return;
            }
            if (heldFluid == null) {
                return;
            }
            this.fillFluid(heldFluid, processFullStack);
            return;
        }
        if (heldFluid != null && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            if (this.canFillSlot) {
                this.fillFluid(heldFluid, processFullStack);
                return;
            }
            if (!this.canDrainSlot) {
                return;
            }
            this.drainFluid(processFullStack);
            return;
        }
        if (!this.canDrainSlot) {
            return;
        }
        this.drainFluid(processFullStack);
    }

    private void tryClickPhantom(MouseData mouseData) {
        ItemStack cursorStack = this.getSyncManager().getCursorItem();
        this.tryClickPhantom(mouseData, cursorStack);
    }

    private void tryClickPhantom(MouseData mouseData, ItemStack cursorStack) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (mouseData.mouseButton == 0) {
            if (cursorStack == null) {
                if (this.canDrainSlot) {
                    this.fluidTank.drain(mouseData.shift ? Integer.MAX_VALUE : 1000, true);
                }
            } else {
                ItemStack heldItemSizedOne = cursorStack.func_77946_l();
                heldItemSizedOne.field_77994_a = 1;
                FluidStack heldFluid = FluidInteractions.getFluidForPhantomItem(heldItemSizedOne);
                if ((this.controlsAmount || currentFluid == null) && heldFluid != null) {
                    this.fillPhantom(heldFluid);
                } else if (this.canDrainSlot) {
                    this.fluidTank.drain(mouseData.shift ? Integer.MAX_VALUE : 1000, true);
                    if (!this.controlsAmount && heldFluid != null && this.fluidTank.getFluidAmount() <= 0) {
                        this.fillPhantom(heldFluid);
                    }
                }
            }
        } else if (mouseData.mouseButton == 1) {
            if (this.canFillSlot) {
                if (currentFluid != null) {
                    if (this.controlsAmount) {
                        FluidStack toFill = currentFluid.copy();
                        toFill.amount = 1000;
                        this.fluidTank.fill(toFill, true);
                    }
                } else if (this.lastStoredPhantomFluid != null) {
                    FluidStack toFill = this.lastStoredPhantomFluid.copy();
                    toFill.amount = this.controlsAmount ? 1000 : 1;
                    this.fluidTank.fill(this.lastStoredPhantomFluid, true);
                }
            }
        } else if (mouseData.mouseButton == 2 && currentFluid != null && this.canDrainSlot) {
            this.fluidTank.drain(mouseData.shift ? Integer.MAX_VALUE : 1000, true);
        }
    }

    private void fillPhantom(@NotNull FluidStack heldFluid) {
        if (this.canFillSlot) {
            if (!this.controlsAmount) {
                heldFluid.amount = 1;
            }
            if (this.fluidTank.fill(heldFluid, true) > 0) {
                this.lastStoredPhantomFluid = heldFluid.copy();
            }
        }
    }

    protected void drainFluid(boolean processFullStack) {
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid == null) {
            return;
        }
        currentFluid = currentFluid.copy();
        int originalFluidAmount = this.fluidTank.getFluidAmount();
        ItemStack filledContainer = FluidInteractions.fillFluidContainer(currentFluid, heldItemSizedOne);
        if (filledContainer != null) {
            int filledAmount = originalFluidAmount - currentFluid.amount;
            if (filledAmount < 1) {
                return;
            }
            this.fluidTank.drain(filledAmount, true);
            if (processFullStack) {
                int additionalParallel = Math.min(heldItem.field_77994_a - 1, currentFluid.amount / filledAmount);
                this.fluidTank.drain(filledAmount * additionalParallel, true);
                filledContainer.field_77994_a += additionalParallel;
            }
            this.replaceCursorItemStack(filledContainer);
            this.playSound(currentFluid, false);
        }
    }

    protected void fillFluid(@NotNull FluidStack heldFluid, boolean processFullStack) {
        ItemStack heldItem = this.getSyncManager().getCursorItem();
        if (heldItem == null || heldItem.field_77994_a == 0) {
            return;
        }
        ItemStack heldItemSizedOne = heldItem.func_77946_l();
        heldItemSizedOne.field_77994_a = 1;
        FluidStack currentFluid = this.fluidTank.getFluid();
        if (currentFluid != null && !currentFluid.isFluidEqual(heldFluid)) {
            return;
        }
        int freeSpace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freeSpace <= 0) {
            return;
        }
        ItemStack itemStackEmptied = null;
        int fluidAmountTaken = 0;
        if (freeSpace >= heldFluid.amount) {
            itemStackEmptied = FluidInteractions.getContainerForFilledItem(heldItemSizedOne);
            fluidAmountTaken = heldFluid.amount;
        }
        if (itemStackEmptied == null) {
            return;
        }
        int parallel = processFullStack ? Math.min(freeSpace / fluidAmountTaken, heldItem.field_77994_a) : 1;
        FluidStack copiedFluidStack = heldFluid.copy();
        copiedFluidStack.amount = fluidAmountTaken * parallel;
        this.fluidTank.fill(copiedFluidStack, true);
        itemStackEmptied.field_77994_a = parallel;
        this.replaceCursorItemStack(itemStackEmptied);
        this.playSound(heldFluid, true);
    }

    public void tryScrollPhantom(MouseData mouseData) {
        FluidStack currentFluid = this.fluidTank.getFluid();
        int amount = mouseData.mouseButton;
        if (mouseData.shift) {
            amount *= 10;
        }
        if (mouseData.ctrl) {
            amount *= 100;
        }
        if (mouseData.alt) {
            amount *= 1000;
        }
        if (currentFluid == null) {
            if (amount > 0 && this.lastStoredPhantomFluid != null) {
                FluidStack toFill = this.lastStoredPhantomFluid.copy();
                toFill.amount = this.controlsAmount ? amount : 1;
                this.fluidTank.fill(toFill, true);
            }
            return;
        }
        if (amount > 0 && this.controlsAmount) {
            FluidStack toFill = currentFluid.copy();
            toFill.amount = amount;
            this.fluidTank.fill(toFill, true);
        } else if (amount < 0) {
            this.fluidTank.drain(-amount, true);
        }
    }

    private void playSound(FluidStack fluid, boolean fill) {
    }

    protected void replaceCursorItemStack(ItemStack resultStack) {
        EntityPlayer player = this.getSyncManager().getPlayer();
        int resultStackMaxStackSize = resultStack.func_77976_d();
        while (resultStack.field_77994_a > resultStackMaxStackSize) {
            player.field_71071_by.func_70445_o().field_77994_a -= resultStackMaxStackSize;
            FluidSlotSyncHandler.addItemToPlayerInventory(player, resultStack.func_77979_a(resultStackMaxStackSize));
        }
        if (this.getSyncManager().getCursorItem().field_77994_a == resultStack.field_77994_a) {
            this.getSyncManager().setCursorItem(resultStack);
        } else {
            ItemStack heldItem = this.getSyncManager().getCursorItem();
            heldItem.field_77994_a -= resultStack.field_77994_a;
            FluidSlotSyncHandler.addItemToPlayerInventory(player, resultStack);
        }
    }

    protected static void addItemToPlayerInventory(EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (!player.field_71071_by.func_70441_a(stack) && !player.field_70170_p.field_72995_K) {
            EntityItem dropItem = player.func_70099_a(stack, 0.0f);
            dropItem.field_145804_b = 0;
        }
    }

    public IFluidTank getFluidTank() {
        return this.fluidTank;
    }

    public boolean canDrainSlot() {
        return this.canDrainSlot;
    }

    public boolean canFillSlot() {
        return this.canFillSlot;
    }

    public boolean controlsAmount() {
        return this.controlsAmount;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public FluidSlotSyncHandler phantom(boolean phantom) {
        this.phantom = phantom;
        return this;
    }

    public FluidSlotSyncHandler controlsAmount(boolean controlsAmount) {
        this.controlsAmount = controlsAmount;
        if (this.isValid()) {
            this.sync(3, buffer -> buffer.writeBoolean(controlsAmount));
        }
        return this;
    }

    public FluidSlotSyncHandler canDrainSlot(boolean canDrainSlot) {
        this.canDrainSlot = canDrainSlot;
        return this;
    }

    public FluidSlotSyncHandler canFillSlot(boolean canFillSlot) {
        this.canFillSlot = canFillSlot;
        return this;
    }
}

