/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.network;

import com.cleanroommc.modularui.network.IPacket;
import com.cleanroommc.modularui.network.packets.OpenGuiPacket;
import com.cleanroommc.modularui.network.packets.PacketSyncHandler;
import com.cleanroommc.modularui.network.packets.SClipboard;
import com.cleanroommc.modularui.network.packets.SyncConfig;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class NetworkHandler {
    public static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("modularui2");
    private static int packetId = 0;
    static final IMessageHandler<IPacket, IPacket> S2CHandler = (message, ctx) -> {
        NetHandlerPlayClient handler = ctx.getClientHandler();
        return message.executeClient(handler);
    };
    static final IMessageHandler<IPacket, IPacket> C2SHandler = (message, ctx) -> {
        NetHandlerPlayServer handler = ctx.getServerHandler();
        return message.executeServer(handler);
    };

    public static void init() {
        NetworkHandler.registerS2C(SClipboard.class);
        NetworkHandler.registerS2C(PacketSyncHandler.class);
        NetworkHandler.registerC2S(PacketSyncHandler.class);
        NetworkHandler.registerC2S(SyncConfig.class);
        NetworkHandler.registerS2C(OpenGuiPacket.class);
    }

    private static void registerC2S(Class<? extends IPacket> clazz) {
        CHANNEL.registerMessage(C2SHandler, clazz, packetId++, Side.SERVER);
    }

    private static void registerS2C(Class<? extends IPacket> clazz) {
        CHANNEL.registerMessage(S2CHandler, clazz, packetId++, Side.CLIENT);
    }

    public static void sendToServer(IPacket packet) {
        CHANNEL.sendToServer((IMessage)packet);
    }

    public static void sendToWorld(IPacket packet, World world) {
        CHANNEL.sendToDimension((IMessage)packet, world.field_73011_w.field_76574_g);
    }

    public static void sendToPlayer(IPacket packet, EntityPlayerMP player) {
        CHANNEL.sendTo((IMessage)packet, player);
    }
}

