/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.single;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTUtility;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.reflect.FieldUtils;
import tectech.TecTech;
import tectech.thing.metaTileEntity.Textures;
import tectech.util.CommonValues;
import tectech.util.TTUtility;

public class MTEOwnerDetector
extends MTETieredMachineBlock {
    private static GTRenderedTexture OWNER_ONLINE;
    private static GTRenderedTexture OWNER_OFFLINE;
    private String uuid;
    private boolean interdimensional = true;

    public MTEOwnerDetector(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.ownerdetector.desc.0"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.ownerdetector.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.ownerdetector.desc.2")}, new ITexture[0]);
        TTUtility.setTier(aTier, this);
    }

    public MTEOwnerDetector(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        TTUtility.setTier(aTier, this);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEOwnerDetector(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        OWNER_ONLINE = new GTRenderedTexture(new Textures.BlockIcons.CustomIcon("iconsets/OWNER_ONLINE"));
        OWNER_OFFLINE = new GTRenderedTexture(new Textures.BlockIcons.CustomIcon("iconsets/OWNER_OFFLINE"));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.MACHINE_CASINGS_TT[this.mTier][colorIndex + 1], aActive ? OWNER_ONLINE : OWNER_OFFLINE};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74778_a("eUUID", this.uuid);
        aNBT.func_74757_a("eInterDim", this.interdimensional);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.uuid = aNBT.func_74779_i("eUUID");
        this.interdimensional = aNBT.func_74767_n("eInterDim");
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        String name;
        if (aBaseMetaTileEntity.isServerSide() && (this.uuid == null || this.uuid.length() == 0) && !"Player".equals(name = aBaseMetaTileEntity.getOwnerName())) {
            this.uuid = TecTech.proxy.getUUID(name);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 6L) {
            boolean detected = TecTech.proxy.isOnlineUUID(this.uuid) || this.uuid != null && this.uuid.length() > 0 && TecTech.proxy.isOnlineName(aBaseMetaTileEntity.getOwnerName());
            aBaseMetaTileEntity.setActive(detected);
            aBaseMetaTileEntity.setGenericRedstoneOutput(detected);
            byte value = (byte)(detected ? 15 : 0);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                aBaseMetaTileEntity.setStrongOutputRedstoneSignal(side, value);
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        String clientLocale;
        try {
            EntityPlayerMP player = (EntityPlayerMP)aPlayer;
            clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
        }
        catch (Exception e) {
            clientLocale = "en_US";
        }
        this.interdimensional ^= true;
        GTUtility.sendChatToPlayer(aPlayer, this.interdimensional ? StatCollector.func_74837_a((String)"tt.keyphrase.Running_interdimensional_scan", (Object[])new Object[]{clientLocale}) : StatCollector.func_74837_a((String)"tt.keyphrase.Running_local_dimension_scan", (Object[])new Object[]{clientLocale}));
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public long maxAmperesIn() {
        return 0L;
    }

    @Override
    public long maxAmperesOut() {
        return 0L;
    }

    @Override
    public long maxEUInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long maxEUOutput() {
        return 0L;
    }

    @Override
    public long maxEUStore() {
        return 0L;
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public int getProgresstime() {
        return this.interdimensional ? 1 : 0;
    }

    @Override
    public int maxProgresstime() {
        return 1;
    }

    @Override
    public boolean hasSidedRedstoneOutputBehavior() {
        return true;
    }

    @Override
    public boolean allowGeneralRedstoneOutput() {
        return true;
    }
}

