/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.WirelessComputationPacket;
import gregtech.common.WirelessDataStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.mechanics.dataTransport.InventoryDataPacket;
import tectech.recipe.TTRecipeAdder;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataItemsInput;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataItemsOutput;
import tectech.thing.metaTileEntity.hatch.MTEHatchWirelessDataItemsOutput;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;
import tectech.util.CommonValues;

public class MTEDataBank
extends TTMultiblockBase
implements ISurvivalConstructable {
    private final ArrayList<MTEHatchDataItemsOutput> eStacksDataOutputs = new ArrayList();
    private final ArrayList<MTEHatchWirelessDataItemsOutput> eWirelessStacksDataOutputs = new ArrayList();
    private final ArrayList<IInventory> eDataAccessHatches = new ArrayList();
    private boolean slave = false;
    private boolean wirelessModeEnabled = false;
    private static final String[] description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.databank.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.databank.hint.1")};
    private static final IStructureDefinition<MTEDataBank> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"BCCCB", "BDDDB", "BDDDB"}, {"BC~CB", "BAAAB", "BDDDB"}, {"BCCCB", "BDDDB", "BDDDB"}})).addElement('A', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1)).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)2)).addElement('C', MTEDataBank.classicHatches(1024, 1, TTCasingsContainer.sBlockCasingsTT, 0)).addElement('D', GTStructureUtility.buildHatchAdder(MTEDataBank.class).atLeast(DataBankHatches.OutboundConnector, DataBankHatches.InboundConnector, DataBankHatches.WirelessOutboundConnector).casingIndex(1025).dot(2).buildAndChain(DataBankHatches.DataStick.newAnyOrCasing(1025, 2, TTCasingsContainer.sBlockCasingsTT, 1))).build();
    public static final ResourceLocation activitySound = new ResourceLocation("tectech:fx_hi_freq");

    public MTEDataBank(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEDataBank(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEDataBank(this.mName);
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.databank.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.databank.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.databank.desc.1")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.databank.desc.2")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.databank.desc.3")).addInfo(StatCollector.func_74838_a((String)"tt.keyword.Structure.StructureTooComplex")).addSeparator().beginStructureBlock(5, 3, 3, false).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataAccessHatch"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasing"), 2).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.dataoutass.tier.07.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasing"), 2).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyHighPowerCasing"), 1).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyHighPowerCasing"), 1).toolTipFinisher(CommonValues.TEC_MARK_EM);
        return tt;
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.eDataAccessHatches.clear();
        this.eStacksDataOutputs.clear();
        this.eWirelessStacksDataOutputs.clear();
        this.slave = false;
        return this.structureCheck_EM("main", 2, 1, 0);
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        if (this.eDataAccessHatches.size() > 0 && (this.eStacksDataOutputs.size() > 0 || this.eWirelessStacksDataOutputs.size() > 0)) {
            this.mEUt = -((int)GTValues.V[this.slave ? 6 : 4]);
            this.eAmpereFlow = 1L + (long)(this.eStacksDataOutputs.size() + this.eWirelessStacksDataOutputs.size()) * (long)this.eDataAccessHatches.size();
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            return SimpleCheckRecipeResult.ofSuccess("providing_data");
        }
        return SimpleCheckRecipeResult.ofFailure("no_data");
    }

    @Override
    public void outputAfterRecipe_EM() {
        block7: {
            block6: {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (IInventory iInventory : this.eDataAccessHatches) {
                    int count = iInventory.func_70302_i_();
                    for (int i = 0; i < count; ++i) {
                        ItemStack stack = iInventory.func_70301_a(i);
                        if (stack == null) continue;
                        stacks.add(stack);
                    }
                }
                if (stacks.size() <= 0) break block6;
                ItemStack[] arr = stacks.toArray(TTRecipeAdder.nullItem);
                for (MTEHatchDataItemsOutput hatch : this.eStacksDataOutputs) {
                    hatch.q = new InventoryDataPacket(arr);
                }
                if (!this.wirelessModeEnabled) break block7;
                for (MTEHatchWirelessDataItemsOutput hatch : this.eWirelessStacksDataOutputs) {
                    hatch.dataPacket = new InventoryDataPacket(arr);
                }
                break block7;
            }
            for (MTEHatchDataItemsOutput mTEHatchDataItemsOutput : this.eStacksDataOutputs) {
                mTEHatchDataItemsOutput.q = null;
            }
            for (MTEHatchWirelessDataItemsOutput mTEHatchWirelessDataItemsOutput : this.eWirelessStacksDataOutputs) {
                mTEHatchWirelessDataItemsOutput.dataPacket = null;
            }
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1], new TTRenderedExtendedFacingTexture(aActive ? TTMultiblockBase.ScreenON : TTMultiblockBase.ScreenOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][1]};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySound() {
        return activitySound;
    }

    public final boolean addDataBankHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchWirelessDataItemsOutput) {
            ((MTEHatchWirelessDataItemsOutput)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eWirelessStacksDataOutputs.add((MTEHatchWirelessDataItemsOutput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchDataItemsOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eStacksDataOutputs.add((MTEHatchDataItemsOutput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchDataAccess && !(aMetaTileEntity instanceof MTEHatchDataItemsInput)) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eDataAccessHatches.add((IInventory)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchDataItemsInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.slave = true;
            return this.eDataAccessHatches.add((IInventory)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.mMachine && aBaseMetaTileEntity.isActive() && this.wirelessModeEnabled && aTick % 200L == 0L) {
            WirelessDataStore wirelessStore = WirelessDataStore.getWirelessDataSticks(aBaseMetaTileEntity.getOwnerUuid());
            wirelessStore.clearData();
            for (MTEHatchWirelessDataItemsOutput hatch : this.eWirelessStacksDataOutputs) {
                hatch.uploadedSinceReset = false;
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            boolean bl = this.wirelessModeEnabled = !this.wirelessModeEnabled;
            if (this.wirelessModeEnabled) {
                GTUtility.sendChatToPlayer(aPlayer, "Wireless mode enabled");
                WirelessComputationPacket.enableWirelessNetWork(this.getBaseMetaTileEntity());
            } else {
                GTUtility.sendChatToPlayer(aPlayer, "Wireless mode disabled");
                WirelessComputationPacket.disableWirelessNetWork(this.getBaseMetaTileEntity());
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("wirelessModeEnabled", this.wirelessModeEnabled);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.wirelessModeEnabled = aNBT.func_74764_b("wirelessModeEnabled") ? aNBT.func_74767_n("wirelessModeEnabled") : false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("main", 2, 1, 0, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece("main", stackSize, 2, 1, 0, elementBudget, source, actor, false, true);
    }

    public IStructureDefinition<MTEDataBank> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    @Override
    public boolean isPowerPassButtonEnabled() {
        return true;
    }

    @Override
    public boolean isSafeVoidButtonEnabled() {
        return false;
    }

    @Override
    public boolean isAllowedToWorkButtonEnabled() {
        return true;
    }

    private static enum DataBankHatches implements IHatchElement<MTEDataBank>
    {
        DataStick(new Class[]{MTEHatchDataAccess.class}){

            @Override
            public long count(MTEDataBank t) {
                return t.eDataAccessHatches.size();
            }
        }
        ,
        OutboundConnector(new Class[]{MTEHatchDataItemsOutput.class}){

            @Override
            public long count(MTEDataBank t) {
                return t.eStacksDataOutputs.size();
            }
        }
        ,
        InboundConnector(new Class[]{MTEHatchDataItemsInput.class}){

            @Override
            public long count(MTEDataBank t) {
                return t.eDataAccessHatches.size();
            }
        }
        ,
        WirelessOutboundConnector(new Class[]{MTEHatchWirelessDataItemsOutput.class}){

            @Override
            public long count(MTEDataBank t) {
                return t.eWirelessStacksDataOutputs.size();
            }
        };

        private final List<? extends Class<? extends IMetaTileEntity>> mteClasses;

        @SafeVarargs
        private DataBankHatches(Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEDataBank> adder() {
            return MTEDataBank::addDataBankHatchToMachineList;
        }
    }
}

