/*
 * Decompiled with CFR 0.152.
 */
package tectech.loader.recipe;

import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IItemContainer;
import tectech.TecTech;
import tectech.loader.recipe.Assembler;
import tectech.loader.recipe.AssemblyLine;
import tectech.loader.recipe.CircuitAssembler;
import tectech.loader.recipe.Crafting;
import tectech.loader.recipe.Extractor;
import tectech.loader.recipe.Godforge;
import tectech.loader.recipe.ResearchStationAssemblyLine;

public class BaseRecipeLoader {
    private static Class CUSTOM_ITEM_LIST;

    public static IItemContainer getItemContainer(String name) {
        return (IItemContainer)Enum.valueOf(CUSTOM_ITEM_LIST, name);
    }

    public static Materials getOrDefault(String name, Materials def) {
        Materials mat = Materials.get(name);
        return mat == Materials._NULL ? def : mat;
    }

    public void run() {
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            new Assembler().run();
            new AssemblyLine().run();
            new CircuitAssembler().run();
            new Crafting().run();
            new Extractor().run();
            new ResearchStationAssemblyLine().run();
            new Godforge().run();
        }
    }

    static {
        try {
            CUSTOM_ITEM_LIST = Class.forName("com.dreammaster.gthandler.CustomItemList");
        }
        catch (Exception e) {
            TecTech.LOGGER.error((Object)"NHCoreMod not present. Disabling all the recipes");
        }
    }
}

