/*
 * Decompiled with CFR 0.152.
 */
package tectech.loader;

import cpw.mods.fml.common.ProgressManager;
import gregtech.api.enums.Mods;
import net.minecraft.block.Block;
import net.minecraft.util.DamageSource;
import tectech.TecTech;
import tectech.loader.NetworkDispatcher;
import tectech.loader.gui.CreativeTabTecTech;
import tectech.loader.recipe.BaseRecipeLoader;
import tectech.loader.recipe.ResearchStationAssemblyLine;
import tectech.loader.thing.CoverLoader;
import tectech.loader.thing.MachineLoader;
import tectech.loader.thing.ThingsLoader;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.Textures;

public final class MainLoader {
    public static DamageSource microwaving;

    private MainLoader() {
    }

    public static void preLoad() {
        TecTech.creativeTabTecTech = new CreativeTabTecTech("TecTech");
        try {
            Textures.run();
        }
        catch (Throwable t) {
            TecTech.LOGGER.error("Loading textures...", (Object)t);
        }
    }

    public static void load() {
        ProgressManager.ProgressBar progressBarLoad = ProgressManager.push((String)"TecTech Loader", (int)6);
        progressBarLoad.step("Regular Things");
        new ThingsLoader().run();
        TecTech.LOGGER.info((Object)"Block/Item Init Done");
        progressBarLoad.step("Machine Things");
        new MachineLoader().run();
        TecTech.LOGGER.info((Object)"Machine Init Done");
        progressBarLoad.step("Cover Things");
        new CoverLoader().run();
        TecTech.LOGGER.info((Object)"Cover Init Done");
        progressBarLoad.step("Add damage types");
        microwaving = new DamageSource("microwaving").func_76348_h();
        TecTech.LOGGER.info((Object)"Damage types addition Done");
        progressBarLoad.step("Register Packet Dispatcher");
        new NetworkDispatcher();
        TecTech.LOGGER.info((Object)"Packet Dispatcher registered");
        progressBarLoad.step("Register GUI Handler");
        TecTech.proxy.registerRenderInfo();
        TecTech.LOGGER.info((Object)"GUI Handler registered");
        ProgressManager.pop((ProgressManager.ProgressBar)progressBarLoad);
    }

    public static void postLoad() {
        ProgressManager.ProgressBar progressBarPostLoad = ProgressManager.push((String)"TecTech Post Loader", (int)2);
        progressBarPostLoad.step("Dreamcraft Compatibility");
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            try {
                Class<?> clazz = Class.forName("com.dreammaster.gthandler.casings.GT_Container_CasingsNH");
                TTCasingsContainer.sBlockCasingsNH = (Block)clazz.getField("sBlockCasingsNH").get(null);
                if (TTCasingsContainer.sBlockCasingsNH == null) {
                    throw new NullPointerException("sBlockCasingsNH Is not set at this time");
                }
            }
            catch (Exception e) {
                throw new Error("Unable to get NH casings", e);
            }
        }
        progressBarPostLoad.step("Recipes");
        new BaseRecipeLoader().run();
        TecTech.LOGGER.info((Object)"Recipe Init Done");
    }

    public static void onLoadCompleted() {
        new ResearchStationAssemblyLine().runLateRecipes();
    }
}

