/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock;

import bartworks.API.BorosilicateGlass;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.screen.ModularUIContext;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.builder.UIInfo;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.Column;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedColumn;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchOutputBus;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.VoidProtectionHelper;
import gregtech.common.tileentities.machines.MTEHatchOutputBusME;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kubatech.api.EIGDynamicInventory;
import kubatech.api.Variables;
import kubatech.api.eig.EIGBucket;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.eig.EIGMode;
import kubatech.api.enums.EIGModes;
import kubatech.api.implementations.KubaTechGTMultiBlockBase;
import kubatech.api.utils.ItemUtils;
import kubatech.client.effect.CropRenderer;
import kubatech.tileentity.gregtech.multiblock.eigbuckets.EIGIC2Bucket;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEExtremeIndustrialGreenhouse
extends KubaTechGTMultiBlockBase<MTEExtremeIndustrialGreenhouse> {
    public static final int EIG_BALANCE_IC2_ACCELERATOR_TIER = 5;
    public static final int EIG_BALANCE_REGULAR_MODE_MIN_TIER = 4;
    public static final int EIG_BALANCE_IC2_MODE_MIN_TIER = 6;
    public static final double EIG_BALANCE_MAX_FERTILIZER_BOOST = 4.0;
    public static final int EIG_BALANCE_WEED_EX_USAGE_BEGINS_AT = 1000;
    public static final int EIG_BALANCE_WATER_USAGE_PER_SEED = 1000;
    private static final Fluid WEEDEX_FLUID = Materials.WeedEX9000.mFluid;
    private static final LinkedList<ItemStack> FERTILIZER_ITEM_LIST = new LinkedList();
    private static final boolean debug = false;
    private static final int NBT_REVISION = 1;
    private static final int CONFIGURATION_WINDOW_ID = 999;
    public final List<EIGBucket> buckets = new LinkedList<EIGBucket>();
    public final EIGDropTable dropTracker = new EIGDropTable();
    public Collection<EIGMigrationHolder> toMigrate;
    public EIGDropTable guiDropTracker = new EIGDropTable();
    private HashMap<ItemStack, Double> synchedGUIDropTracker = new HashMap();
    private int maxSeedTypes = 0;
    private int maxSeedCount = 0;
    private int setupPhase = 1;
    private int waterUsage = 0;
    private byte glassTier = 0;
    private int weedEXUsage = 0;
    private EIGMode mode = EIGModes.Normal;
    private boolean useNoHumidity = false;
    private int mCasing = 0;
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEExtremeIndustrialGreenhouse> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"ccccc", "clllc", "clllc", "clllc", "ccccc"}, {"ggggg", "g---g", "g---g", "g---g", "ggggg"}, {"ggggg", "g---g", "g---g", "g---g", "ggggg"}, {"ccccc", "cdddc", "cdwdc", "cdddc", "ccccc"}, {"cc~cc", "cCCCc", "cCCCc", "cCCCc", "ccccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1)), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 49, 1)})).addElement('C', StructureUtility.onElementPass(t -> ++t.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1))).addElement('l', (IStructureElement)(Mods.ProjectRedIllumination.isModLoaded() ? StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)Block.func_149684_b((String)"ProjRed|Illumination:projectred.illumination.lamp"), (int)10), StructureUtility.ofBlock((Block)Block.func_149684_b((String)"ProjRed|Illumination:projectred.illumination.lamp"), (int)26)}) : StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)Blocks.field_150379_bu, (int)0), StructureUtility.ofBlock((Block)Blocks.field_150374_bv, (int)0)}))).addElement('g', BorosilicateGlass.ofBoroGlass((byte)0, (byte)1, (byte)127, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('d', StructureUtility.ofBlock((Block)(Mods.RandomThings.isModLoaded() ? Block.func_149684_b((String)"RandomThings:fertilizedDirt_tilled") : Blocks.field_150458_ak), (int)0)).addElement('w', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)Blocks.field_150355_j, (int)0), StructureUtility.ofBlock((Block)BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater), (int)0)})).build();
    private static final UIInfo<?, ?> GreenhouseUI = MTEExtremeIndustrialGreenhouse.createKTMetaTileEntityUI(KT_ModulaUIContainer_ExtremeIndustrialGreenhouse::new);
    EIGDynamicInventory<EIGBucket> dynamicInventory = new EIGDynamicInventory<EIGBucket>(128, 60, () -> this.maxSeedTypes, () -> this.maxSeedCount, this.buckets::size, this::getTotalSeedCount, this.buckets, EIGBucket::getSeedStack).allowInventoryInjection(this::addCrop).allowInventoryExtraction((bucket, player) -> {
        if (bucket == null) {
            return null;
        }
        int maxRemove = bucket.getSeedStack().func_77976_d();
        ItemStack[] outputs = bucket.tryRemoveSeed(maxRemove, false);
        if (outputs == null || outputs.length <= 0) {
            return null;
        }
        ItemStack ret = outputs[0];
        for (int i = 1; i < outputs.length; ++i) {
            ItemStack suppertItem = outputs[i];
            if (player.field_71071_by.func_70441_a(suppertItem)) continue;
            player.func_70099_a(suppertItem, 0.0f);
        }
        if (bucket.getSeedCount() <= 0) {
            this.buckets.remove(bucket);
        }
        return ret;
    }).setEnabled(() -> this.mMaxProgresstime == 0);
    private boolean isInInventory = true;

    public static void addFertilizerItem(ItemStack fertilizer) {
        FERTILIZER_ITEM_LIST.addLast(fertilizer);
    }

    public boolean isInNoHumidityMode() {
        return this.useNoHumidity;
    }

    @Override
    public IStructureDefinition<MTEExtremeIndustrialGreenhouse> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        boolean valid;
        this.mCasing = 0;
        this.glassTier = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 5, 0)) {
            return false;
        }
        if (this.glassTier < 8 && !this.mEnergyHatches.isEmpty()) {
            for (MTEHatchEnergy hatchEnergy : this.mEnergyHatches) {
                if (this.glassTier >= hatchEnergy.mTier) continue;
                return false;
            }
        }
        boolean bl = valid = this.mMaintenanceHatches.size() == 1 && !this.mEnergyHatches.isEmpty() && this.mCasing >= 70;
        if (valid) {
            this.updateSeedLimits();
        }
        return valid;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 5, 0);
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        String fertilizerBoostMax = String.format("%.0f", 400.0);
        tt.addMachineType("Crop Farm").addInfo("Controller block for the Extreme Industrial Greenhouse").addInfo(Variables.Author).addInfo("Grow your crops like a chad!").addInfo("Use screwdriver to enable/change/disable setup mode").addInfo("Use screwdriver while sneaking to enable/disable IC2 mode").addInfo("Use wire cutters to give incoming IC2 seeds 0 humidity").addInfo("Uses 1000L of water per seed per operation").addInfo("Uses 1L of " + new FluidStack(WEEDEX_FLUID, 1).getLocalizedName() + " per operation per seed if it contains more than " + 1000 + " seeds").addInfo("Otherwise, around 1% of seeds will be voided each operation").addInfo("You can insert fertilizer each operation to get more drops (max + " + fertilizerBoostMax + ")").addInfo("--------------------- SETUP MODE ---------------------").addInfo("Does not take power").addInfo("There are two modes: input / output").addInfo("Input mode: machine will take seeds from input bus and plant them").addInfo("[IC2] You need to also input block that is required under the crop").addInfo("Output mode: machine will take planted seeds and output them");
        EIGModes.addTooltipInfo(tt);
        tt.addInfo(Variables.StructureHologram).addSeparator().beginStructureBlock(5, 6, 5, false).addController("Front bottom center").addCasingInfoMin("Clean Stainless Steel Casings", 70, false).addOtherStructurePart("Borosilicate Glass", "Hollow two middle layers").addStructureInfo("The glass tier limits the Energy Input tier").addStructureInfo("The dirt is from RandomThings, must be tilled").addStructureInfo("Regular water and IC2 Distilled Water are accepted").addStructureInfo("Purple lamps are from ProjectRedIllumination. They can be powered and/or inverted").addMaintenanceHatch("Any casing (Except inner bottom ones)", 1).addInputBus("Any casing (Except inner bottom ones)", 1).addOutputBus("Any casing (Except inner bottom ones)", 1).addInputHatch("Any casing (Except inner bottom ones)", 1).addEnergyHatch("Any casing (Except inner bottom ones)", 1).toolTipFinisher("KubaTech");
        return tt;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getStructureDescription(stackSize)));
        info.add("The dirt is from RandomThings, must be tilled");
        info.add("Purple lamps are from ProjectRedIllumination. They can be powered and/or inverted");
        return info.toArray(new String[0]);
    }

    public MTEExtremeIndustrialGreenhouse(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEExtremeIndustrialGreenhouse(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEExtremeIndustrialGreenhouse(this.mName);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        block5: {
            super.onFirstTick(aBaseMetaTileEntity);
            if (this.toMigrate == null) break block5;
            if (this.mode == EIGModes.IC2) {
                for (EIGMigrationHolder holder : this.toMigrate) {
                    this.buckets.add(new EIGIC2Bucket(holder.seed, holder.count, holder.supportBlock, holder.useNoHumidity));
                }
            } else {
                this.mode = EIGModes.Normal;
                for (EIGMigrationHolder holder : this.toMigrate) {
                    holder.seed.field_77994_a = holder.count;
                    EIGBucket bucket = this.mode.tryCreateNewBucket(this, holder.seed, Integer.MAX_VALUE, false);
                    if (bucket == null) {
                        holder.seed.field_77994_a = holder.count;
                        this.addOutput(holder.seed);
                        continue;
                    }
                    this.buckets.add(bucket);
                }
            }
        }
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        this.buckets.removeIf(this::tryEmptyBucket);
        if (this.buckets.isEmpty()) {
            return;
        }
        IGregTechTileEntity mte = this.getBaseMetaTileEntity();
        for (EIGBucket bucket : this.buckets) {
            for (ItemStack stack : bucket.tryRemoveSeed(bucket.getSeedCount(), false)) {
                EntityItem entityitem = new EntityItem(mte.getWorld(), (double)mte.getXCoord(), (double)mte.getYCoord(), (double)mte.getZCoord(), stack);
                entityitem.field_145804_b = 10;
                mte.getWorld().func_72838_d((Entity)entityitem);
            }
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            this.tryChangeMode(aPlayer);
        } else {
            this.tryChangeSetupPhase(aPlayer);
        }
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.tryChangeHumidityMode(aPlayer);
        return true;
    }

    private void tryChangeSetupPhase(EntityPlayer aPlayer) {
        if (this.mMaxProgresstime > 0) {
            GTUtility.sendChatToPlayer(aPlayer, "You can't enable/disable setup if the machine is working!");
            return;
        }
        ++this.setupPhase;
        if (this.setupPhase == 3) {
            this.setupPhase = 0;
        }
        String phaseChangeMessage = "EIG is now running in ";
        switch (this.setupPhase) {
            case 0: {
                phaseChangeMessage = phaseChangeMessage + "operational mode.";
                break;
            }
            case 1: {
                phaseChangeMessage = phaseChangeMessage + "seed input mode.";
                break;
            }
            case 2: {
                phaseChangeMessage = phaseChangeMessage + "seed output mode.";
                break;
            }
            default: {
                phaseChangeMessage = phaseChangeMessage + "an invalid mode please send us a ticket!";
            }
        }
        this.updateSeedLimits();
        GTUtility.sendChatToPlayer(aPlayer, phaseChangeMessage);
    }

    private void tryChangeMode(EntityPlayer aPlayer) {
        if (this.mMaxProgresstime > 0) {
            GTUtility.sendChatToPlayer(aPlayer, "You can't change mode if the machine is working!");
            return;
        }
        if (!this.buckets.isEmpty()) {
            GTUtility.sendChatToPlayer(aPlayer, "You can't change mode if there are seeds inside!");
            return;
        }
        this.mode = EIGModes.getNextMode(this.mode);
        this.updateSeedLimits();
        GTUtility.sendChatToPlayer(aPlayer, "Changed mode to: " + this.mode.getName());
    }

    private void tryChangeHumidityMode(EntityPlayer aPlayer) {
        boolean bl = this.useNoHumidity = !this.useNoHumidity;
        if (this.useNoHumidity) {
            GTUtility.sendChatToPlayer(aPlayer, "No Humidity mode enabled.");
        } else {
            GTUtility.sendChatToPlayer(aPlayer, "No Humidity mode disabled.");
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("version", 1);
        aNBT.func_74774_a("glassTier", this.glassTier);
        aNBT.func_74768_a("setupPhase", this.setupPhase);
        aNBT.func_74778_a("mode", this.mode.getName());
        aNBT.func_74757_a("isNoHumidity", this.useNoHumidity);
        NBTTagList bucketListNBT = new NBTTagList();
        for (EIGBucket b : this.buckets) {
            bucketListNBT.func_74742_a((NBTBase)b.save());
        }
        aNBT.func_74782_a("progress", (NBTBase)this.dropTracker.intersect(this.guiDropTracker).save());
        aNBT.func_74782_a("buckets", (NBTBase)bucketListNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int revision;
        super.loadNBTData(aNBT);
        int n = revision = aNBT.func_150297_b("version", 3) ? aNBT.func_74762_e("version") : 0;
        if (revision <= 0) {
            this.glassTier = aNBT.func_74771_c("glasTier");
            this.setupPhase = aNBT.func_74762_e("setupphase");
            this.mode = aNBT.func_74767_n("isIC2Mode") ? EIGModes.IC2 : EIGModes.Normal;
            this.useNoHumidity = aNBT.func_74767_n("isNoHumidity");
            HashMap<String, EIGMigrationHolder> toMigrate = new HashMap<String, EIGMigrationHolder>();
            for (int i = 0; i < aNBT.func_74762_e("mStorageSize"); ++i) {
                EIGMigrationHolder holder = new EIGMigrationHolder(aNBT.func_74775_l("mStorage." + i));
                if (toMigrate.containsKey(holder.getKey())) {
                    ((EIGMigrationHolder)toMigrate.get((Object)holder.getKey())).count += holder.count;
                    continue;
                }
                toMigrate.put(holder.getKey(), holder);
            }
            this.toMigrate = toMigrate.values();
        } else {
            this.glassTier = aNBT.func_74771_c("glassTier");
            this.setupPhase = aNBT.func_74762_e("setupPhase");
            this.mode = EIGModes.getModeFromName(aNBT.func_74779_i("mode"));
            this.useNoHumidity = aNBT.func_74767_n("isNoHumidity");
            this.mode.restoreBuckets(aNBT.func_150295_c("buckets", 10), this.buckets);
            new EIGDropTable(aNBT.func_150295_c("progress", 10)).addTo(this.dropTracker);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnVisualCrops(World world, int x, int y, int z, int age) {
        CropRenderer crop = new CropRenderer(world, x, y, z, age);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)crop);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aTick % 40L == 0L) {
            int[] abc = new int[]{0, -2, 2};
            int[] xyz = new int[]{0, 0, 0};
            this.getExtendedFacing().getWorldOffset(abc, xyz);
            xyz[0] = xyz[0] + aBaseMetaTileEntity.getXCoord();
            xyz[1] = xyz[1] + aBaseMetaTileEntity.getYCoord();
            xyz[2] = xyz[2] + aBaseMetaTileEntity.getZCoord();
            this.spawnVisualCrops(aBaseMetaTileEntity.getWorld(), xyz[0], xyz[1], xyz[2], 40);
        }
    }

    private int getTotalSeedCount() {
        return this.buckets.parallelStream().reduce(0, (b, t) -> b + t.getSeedCount(), Integer::sum);
    }

    private void updateSeedLimits() {
        this.maxSeedTypes = this.mode.getSlotCount(this.getVoltageTier());
        this.maxSeedCount = this.maxSeedTypes * this.mode.getSeedCapacityPerSlot();
    }

    private boolean tryDrain(FluidStack toConsume, boolean drainPartial) {
        if (toConsume == null || toConsume.amount <= 0) {
            return true;
        }
        ArrayList<FluidStack> fluids = this.getStoredFluids();
        ArrayList<FluidStack> fluidsToUse = new ArrayList<FluidStack>(fluids.size());
        int remaining = toConsume.amount;
        for (FluidStack fluid : fluids) {
            if (!fluid.isFluidEqual(toConsume)) continue;
            fluidsToUse.add(fluid);
            if ((remaining -= fluid.amount) > 0) continue;
            break;
        }
        if (!drainPartial && remaining > 0) {
            return false;
        }
        boolean success = remaining <= 0;
        remaining = toConsume.amount - Math.max(0, remaining);
        for (FluidStack fluid : fluidsToUse) {
            int used = Math.min(remaining, fluid.amount);
            fluid.amount -= used;
            remaining -= used;
        }
        return success;
    }

    public static boolean isFertilizer(ItemStack item) {
        if (item == null || item.field_77994_a <= 0) {
            return false;
        }
        for (ItemStack fert : FERTILIZER_ITEM_LIST) {
            if (!GTUtility.areStacksEqual(item, fert)) continue;
            return true;
        }
        return false;
    }

    private boolean tryEmptyBucket(EIGBucket bucket) {
        if (bucket.getSeedCount() <= 0) {
            return true;
        }
        for (MTEHatchOutputBus tHatch : GTUtility.validMTEList(this.mOutputBusses)) {
            if (!(tHatch instanceof MTEHatchOutputBusME)) continue;
            for (ItemStack stack : bucket.tryRemoveSeed(bucket.getSeedCount(), false)) {
                ((MTEHatchOutputBusME)tHatch).store(stack);
            }
            return true;
        }
        ItemStack[] simulated = bucket.tryRemoveSeed(1, true);
        VoidProtectionHelper helper = new VoidProtectionHelper().setMachine(this, true, false).setItemOutputs(simulated).setMaxParallel(bucket.getSeedCount()).build();
        if (helper.getMaxParallel() > 0) {
            for (ItemStack toOutput : bucket.tryRemoveSeed(helper.getMaxParallel(), false)) {
                MTEHatchOutputBus tHatch;
                Iterator iterator = GTUtility.validMTEList(this.mOutputBusses).iterator();
                while (iterator.hasNext() && !(tHatch = (MTEHatchOutputBus)iterator.next()).storeAll(toOutput)) {
                }
            }
        }
        return bucket.getSeedCount() <= 0;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        IGregTechTileEntity baseMTE;
        int killLimit;
        int toKill;
        int tier = this.getVoltageTier();
        this.updateSeedLimits();
        if (this.setupPhase > 0) {
            if (this.buckets.size() >= this.maxSeedTypes && this.setupPhase == 1 || this.buckets.isEmpty() && this.setupPhase == 2) {
                return CheckRecipeResultRegistry.NO_RECIPE;
            }
            if (this.setupPhase == 1) {
                ArrayList<ItemStack> inputs = this.getStoredInputs();
                for (ItemStack input : inputs) {
                    this.addCrop(input);
                    if (this.buckets.size() < this.maxSeedTypes) continue;
                    break;
                }
            } else if (this.setupPhase == 2) {
                Iterator<EIGBucket> iterator = this.buckets.iterator();
                while (iterator.hasNext()) {
                    EIGBucket bucket = iterator.next();
                    if (this.tryEmptyBucket(bucket)) {
                        iterator.remove();
                        continue;
                    }
                    this.mMaxProgresstime = 20;
                    this.lEUt = 0L;
                    return CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
                }
            }
            this.updateSlots();
            this.mMaxProgresstime = 5;
            this.lEUt = 0L;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        if (this.maxSeedTypes < this.buckets.size()) {
            return SimpleCheckRecipeResult.ofFailure("EIG_slotoverflow");
        }
        int seedCount = this.getTotalSeedCount();
        if (this.maxSeedCount < seedCount) {
            return SimpleCheckRecipeResult.ofFailure("EIG_seedOverflow");
        }
        Iterator<EIGBucket> iterator = this.buckets.iterator();
        while (iterator.hasNext()) {
            EIGBucket bucket = iterator.next();
            if (bucket.isValid() || bucket.revalidate(this)) continue;
            this.tryEmptyBucket(bucket);
            if (bucket.getSeedCount() > 0) continue;
            iterator.remove();
        }
        if (this.buckets.isEmpty()) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.waterUsage = seedCount * 1000;
        this.weedEXUsage = (seedCount >= 1000 ? seedCount : 0) * this.mode.getWeedEXMultiplier();
        if (!this.tryDrain(new FluidStack(FluidRegistry.WATER, this.waterUsage), false)) {
            return SimpleCheckRecipeResult.ofFailure("EIG_missingwater");
        }
        if (this.weedEXUsage > 0 && !this.tryDrain(new FluidStack(WEEDEX_FLUID, this.weedEXUsage), true) && (toKill = Math.min(killLimit = seedCount - 1000 + 1, (baseMTE = this.getBaseMetaTileEntity()).getRandomNumber((int)((double)seedCount * 0.02) + 1))) > 0) {
            Iterator<EIGBucket> iterator2 = this.buckets.iterator();
            while (iterator2.hasNext()) {
                EIGBucket bucket = iterator2.next();
                ItemStack[] removed = bucket.tryRemoveSeed(toKill, false);
                if (removed == null || removed[0].field_77994_a <= 0) continue;
                toKill -= removed[0].field_77994_a;
                if (bucket.getSeedCount() <= 0) {
                    iterator2.remove();
                }
                if (toKill > 0) continue;
                break;
            }
        }
        int consumedFertilizer = 0;
        int maxFertilizerToConsume = 0;
        for (EIGBucket eIGBucket : this.buckets) {
            maxFertilizerToConsume += eIGBucket.getSeedCount() * this.mode.getMaxFertilizerUsagePerSeed();
        }
        ArrayList<ItemStack> inputs = this.getStoredInputs();
        for (ItemStack i : inputs) {
            if (MTEExtremeIndustrialGreenhouse.isFertilizer(i)) {
                int used = Math.min(i.field_77994_a, maxFertilizerToConsume - consumedFertilizer);
                i.field_77994_a -= used;
                consumedFertilizer += used;
            }
            if (consumedFertilizer != maxFertilizerToConsume) continue;
            break;
        }
        double d = 1.0 + (double)consumedFertilizer / (double)maxFertilizerToConsume * 4.0;
        this.guiDropTracker = new EIGDropTable();
        if (this.mode == EIGModes.IC2) {
            if (this.glassTier < 6) {
                return SimpleCheckRecipeResult.ofFailure("EIG_ic2glass");
            }
            this.mMaxProgresstime = 100;
            double timeElapsed = (double)this.mMaxProgresstime * 32.0;
            for (EIGBucket bucket : this.buckets) {
                bucket.addProgress(timeElapsed * d, this.guiDropTracker);
            }
        } else if (this.mode == EIGModes.Normal) {
            this.mMaxProgresstime = Math.max(20, 100 / (tier - 3));
            for (EIGBucket bucket : this.buckets) {
                bucket.addProgress(d, this.guiDropTracker);
            }
        }
        this.guiDropTracker.addTo(this.dropTracker, d);
        this.mOutputItems = this.dropTracker.getDrops();
        this.lEUt = -((long)((double)GTValues.V[tier] * 0.99));
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private ItemStack addCrop(ItemStack input) {
        return this.addCrop(input, false) ? input : null;
    }

    private boolean addCrop(ItemStack input, boolean simulate) {
        int addCap;
        if (input == null || input.field_77994_a <= 0) {
            return true;
        }
        if (simulate) {
            input = input.func_77946_l();
        }
        if ((addCap = Math.min(input.field_77994_a, this.maxSeedCount - this.getTotalSeedCount())) <= 0) {
            return false;
        }
        for (EIGBucket bucket : this.buckets) {
            int consumed = bucket.tryAddSeed(this, input, addCap, simulate);
            if (consumed <= 0) continue;
            return input.field_77994_a <= 0;
        }
        if (this.maxSeedTypes <= this.buckets.size()) {
            return false;
        }
        EIGBucket bucket = this.mode.tryCreateNewBucket(this, input, addCap, simulate);
        if (bucket == null) {
            return false;
        }
        this.buckets.add(bucket);
        return input.field_77994_a <= 0;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        GreenhouseUI.open(aPlayer, aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity.getXCoord(), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord());
        return true;
    }

    @Override
    protected void addConfigurationWidgets(DynamicPositionedRow configurationElements, UIBuildContext buildContext) {
        buildContext.addSyncedWindow(999, this::createConfigurationWindow);
        configurationElements.setSynced(false);
        configurationElements.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(999);
            }
        }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_CYCLIC}).addTooltip("Configuration").setSize(16, 16));
    }

    @Override
    public void createInventorySlots() {
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.isInInventory = !this.getBaseMetaTileEntity().isActive();
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setPos(4, 4).setSize(190, 85).setEnabled(w -> !this.isInInventory));
        builder.widget(this.dynamicInventory.asWidget(builder, buildContext).setPos(10, 16).setEnabled(w -> this.isInInventory));
        builder.widget(new CycleButtonWidget().setToggle(() -> this.isInInventory, i -> {
            this.isInInventory = i;
        }).setTextureGetter(i -> i == 0 ? new Text("Inventory") : new Text("Status")).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD}).setPos(140, 91).setSize(55, 16));
        DynamicPositionedColumn screenElements = new DynamicPositionedColumn();
        this.drawTexts(screenElements, null);
        builder.widget(((Scrollable)new Scrollable().setVerticalScroll().widget(screenElements.setPos(10, 0))).setPos(0, 7).setSize(190, 79).setEnabled(w -> !this.isInInventory));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget((Widget)this.createPowerSwitchButton((IWidgetBuilder)builder))).widget((Widget)this.createVoidExcessButton((IWidgetBuilder)builder))).widget((Widget)this.createInputSeparationButton((IWidgetBuilder)builder))).widget((Widget)this.createBatchModeButton((IWidgetBuilder)builder))).widget((Widget)this.createLockToSingleRecipeButton((IWidgetBuilder)builder))).widget((Widget)this.createStructureUpdateButton((IWidgetBuilder)builder));
        DynamicPositionedRow configurationElements = new DynamicPositionedRow();
        this.addConfigurationWidgets(configurationElements, buildContext);
        builder.widget(configurationElements.setSpace(2).setAlignment(MainAxisAlignment.SPACE_BETWEEN).setPos(this.getRecipeLockingButtonPos().add(18, 0)));
    }

    protected ModularWindow createConfigurationWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)100);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CYCLIC).setPos(5, 5).setSize(16, 16))).widget(new TextWidget("Configuration").setPos(25, 9))).widget(ButtonWidget.closeWindowButton((boolean)true).setPos(185, 3))).widget(((Column)((Column)((Column)new Column().widget(new CycleButtonWidget().setLength(3).setGetter(() -> this.setupPhase).setSetter(val -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            this.tryChangeSetupPhase(player);
        }).addTooltip(0, new Text("Operating").color(Color.GREEN.dark(3))).addTooltip(1, new Text("Input").color(Color.YELLOW.dark(3))).addTooltip(2, new Text("Output").color(Color.YELLOW.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Operating").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : (i == 1 ? new Text("Input").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Output").color(Color.YELLOW.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f))).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GTUITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("Setup mode"))).widget(new CycleButtonWidget().setLength(2).setGetter(() -> this.mode.getUIIndex()).setSetter(val -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            this.tryChangeMode(player);
        }).addTooltip(0, new Text("Disabled").color(Color.RED.dark(3))).addTooltip(1, new Text("Enabled").color(Color.GREEN.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Disabled").color(Color.RED.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Enabled").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f)).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GTUITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("IC2 mode"))).widget(new CycleButtonWidget().setLength(2).setGetter(() -> this.useNoHumidity ? 1 : 0).setSetter(val -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            this.tryChangeHumidityMode(player);
        }).addTooltip(0, new Text("Disabled").color(Color.RED.dark(3))).addTooltip(1, new Text("Enabled").color(Color.GREEN.dark(3))).setTextureGetter(i -> i == 0 ? new Text("Disabled").color(Color.RED.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f) : new Text("Enabled").color(Color.GREEN.dark(3)).withFixedSize(52.0f, 18.0f, 15.0f, 0.0f)).setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND, GTUITextures.OVERLAY_BUTTON_CYCLIC.withFixedSize(18.0f, 18.0f)}).setSize(70, 18).addTooltip("No Humidity mode"))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(10, 30))).widget(((Column)((Column)((Column)new Column().widget(new TextWidget("Setup mode").setSize(100, 18))).widget(new TextWidget("IC2 mode").setSize(100, 18))).widget(new TextWidget("No Humidity mode").setSize(100, 18))).setEnabled(widget -> !this.getBaseMetaTileEntity().isActive()).setPos(80, 30))).widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.OVERLAY_BUTTON_CROSS).setSize(18, 18).setPos(10, 30).addTooltip(new Text("Can't change configuration when running !").color(Color.RED.dark(3))).setEnabled(widget -> this.getBaseMetaTileEntity().isActive()));
        return builder.build();
    }

    @Override
    protected String generateCurrentRecipeInfoString() {
        StringBuilder ret = new StringBuilder(EnumChatFormatting.WHITE + "Progress: ").append(String.format("%,.2f", (double)this.mProgresstime / 20.0)).append("s / ").append(String.format("%,.2f", (double)this.mMaxProgresstime / 20.0)).append("s (").append(String.format("%,.1f", (double)this.mProgresstime / (double)this.mMaxProgresstime * 100.0)).append("%)\n");
        for (Map.Entry drop : this.synchedGUIDropTracker.entrySet().stream().sorted(Comparator.comparing(a -> ((ItemStack)a.getKey()).toString().toLowerCase())).collect(Collectors.toList())) {
            int outputSize = Arrays.stream(this.mOutputItems).filter(s -> s.func_77969_a((ItemStack)drop.getKey())).mapToInt(i -> i.field_77994_a).sum();
            ret.append(EnumChatFormatting.AQUA).append(((ItemStack)drop.getKey()).func_82833_r()).append(EnumChatFormatting.WHITE).append(": ");
            if (outputSize == 0) {
                ret.append(String.format("%.2f", (Double)drop.getValue() * 100.0)).append("%\n");
                continue;
            }
            ret.append(EnumChatFormatting.GOLD).append(String.format("x%d %s(+%.2f/sec)\n", outputSize, EnumChatFormatting.WHITE, (double)outputSize / (double)(this.mMaxProgresstime / 20)));
        }
        return ret.toString();
    }

    @Override
    protected void drawTexts(DynamicPositionedColumn screenElements, SlotWidget inventorySlot) {
        screenElements.widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.mode == EIGModes.IC2, b -> {
            this.mode = b != false ? EIGModes.IC2 : EIGModes.Normal;
        }));
        screenElements.widget((Widget)new FakeSyncWidget(() -> {
            HashMap<ItemStack, Double> ret = new HashMap<ItemStack, Double>();
            for (Map.Entry<ItemStack, Double> drop : this.guiDropTracker.entrySet()) {
                ret.merge(drop.getKey(), drop.getValue(), Double::sum);
            }
            return ret;
        }, h -> {
            this.synchedGUIDropTracker = h;
        }, (buffer, h) -> {
            buffer.func_150787_b(h.size());
            for (Map.Entry itemStackDoubleEntry : h.entrySet()) {
                try {
                    buffer.func_150788_a((ItemStack)itemStackDoubleEntry.getKey());
                    buffer.writeDouble(((Double)itemStackDoubleEntry.getValue()).doubleValue());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }, buffer -> {
            int len = buffer.func_150792_a();
            HashMap<ItemStack, Double> ret = new HashMap<ItemStack, Double>(len);
            for (int i = 0; i < len; ++i) {
                try {
                    ret.put(buffer.func_150791_c(), buffer.readDouble());
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return ret;
        }));
        super.drawTexts(screenElements, inventorySlot);
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList("Running in mode: " + EnumChatFormatting.GREEN + (this.setupPhase == 0 ? this.mode.getName() : "Setup mode " + (this.setupPhase == 1 ? "(input)" : "(output)")) + EnumChatFormatting.RESET, "Uses " + this.waterUsage + "L/operation of water", "Uses " + this.weedEXUsage + "L/second of Weed-EX 9000", "Max slots: " + EnumChatFormatting.GREEN + this.maxSeedTypes + EnumChatFormatting.RESET, "Used slots: " + (this.buckets.size() > this.maxSeedTypes ? EnumChatFormatting.RED : EnumChatFormatting.GREEN) + this.buckets.size() + EnumChatFormatting.RESET));
        for (EIGBucket bucket : this.buckets) {
            info.add(bucket.getInfoData());
        }
        if (this.buckets.size() > this.maxSeedTypes) {
            info.add(EnumChatFormatting.DARK_RED + "There are too many seed types inside to run!" + EnumChatFormatting.RESET);
        }
        if (this.getTotalSeedCount() > this.maxSeedCount) {
            info.add(EnumChatFormatting.DARK_RED + "There are too many seeds inside to run!" + EnumChatFormatting.RESET);
        }
        info.addAll(Arrays.asList(super.getInfoData()));
        return info.toArray(new String[0]);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    private static class EIGMigrationHolder {
        public final ItemStack seed;
        public final ItemStack supportBlock;
        public final boolean useNoHumidity;
        public int count;
        public boolean isValid = false;

        public EIGMigrationHolder(NBTTagCompound nbt) {
            this.seed = ItemUtils.readItemStackFromNBT(nbt.func_74775_l("input"));
            this.count = this.seed.field_77994_a;
            this.seed.field_77994_a = 1;
            this.supportBlock = nbt.func_150297_b("undercrop", 10) ? ItemUtils.readItemStackFromNBT(nbt.func_74775_l("undercrop")) : null;
            this.useNoHumidity = nbt.func_74767_n("noHumidity");
            this.isValid = true;
        }

        public String getKey() {
            if (this.supportBlock == null) {
                return this.seed.toString();
            }
            return "(" + this.seed.toString() + "," + this.supportBlock + ")";
        }
    }

    private static class KT_ModulaUIContainer_ExtremeIndustrialGreenhouse
    extends ModularUIContainer {
        final WeakReference<MTEExtremeIndustrialGreenhouse> parent;

        public KT_ModulaUIContainer_ExtremeIndustrialGreenhouse(ModularUIContext context, ModularWindow mainWindow, MTEExtremeIndustrialGreenhouse mte) {
            super(context, mainWindow);
            this.parent = new WeakReference<MTEExtremeIndustrialGreenhouse>(mte);
        }

        public ItemStack func_82846_b(EntityPlayer aPlayer, int aSlotIndex) {
            if (!(aPlayer instanceof EntityPlayerMP)) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            Slot s = this.func_75139_a(aSlotIndex);
            if (s == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (aSlotIndex >= 36) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            ItemStack aStack = s.func_75211_c();
            if (aStack == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            MTEExtremeIndustrialGreenhouse mte = (MTEExtremeIndustrialGreenhouse)this.parent.get();
            if (mte == null) {
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            if (mte.mMaxProgresstime > 0) {
                GTUtility.sendChatToPlayer(aPlayer, EnumChatFormatting.RED + "Can't insert while running !");
                return super.func_82846_b(aPlayer, aSlotIndex);
            }
            mte.addCrop(aStack);
            if (aStack.field_77994_a <= 0) {
                s.func_75215_d(null);
            } else {
                s.func_75215_d(aStack);
            }
            this.func_75142_b();
            return null;
        }
    }
}

