/*
 * Decompiled with CFR 0.152.
 */
package gtnhlanth.loader;

import bartworks.system.material.Werkstoff;
import bartworks.util.BWUtil;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTShapedRecipe;
import gregtech.api.util.GTUtility;
import gtnhlanth.common.register.WerkstoffMaterialPool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ZPMRubberChanges
implements Runnable {
    @Override
    public void run() {
        List bufferedRecipeList = null;
        try {
            bufferedRecipeList = (List)FieldUtils.getDeclaredField(GTModHandler.class, (String)"sBufferRecipeList", (boolean)true).get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        HashSet<ItemStack> ZPMPlusComponents = new HashSet<ItemStack>();
        OrePrefixes[] RubberGenerated = new OrePrefixes[]{OrePrefixes.plate};
        Arrays.stream(ItemList.values()).filter(item -> (item.toString().contains("ZPM") || item.toString().contains("UV") || item.toString().contains("UHV") || item.toString().contains("UEV")) && item.hasBeenSet()).forEach(item -> ZPMPlusComponents.add(item.get(1L, new Object[0])));
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            ZPMRubberChanges.addDreamcraftItemListItems(ZPMPlusComponents);
        }
        for (ItemStack component : ZPMPlusComponents) {
            GTLog.out.print(component.func_82833_r() + " ");
        }
        ZPMRubberChanges.replaceAllRecipes(ZPMPlusComponents, RubberGenerated, bufferedRecipeList);
    }

    private static void replaceAllRecipes(Collection<ItemStack> ZPMPlusComponents, OrePrefixes[] RubberGenerated, List<IRecipe> bufferedRecipeList) {
        for (GTRecipe.RecipeAssemblyLine recipeAssemblyLine : GTRecipe.RecipeAssemblyLine.sAssemblylineRecipes) {
            for (ItemStack stack : ZPMPlusComponents) {
                ZPMRubberChanges.rewriteAsslineRecipes(stack, RubberGenerated, recipeAssemblyLine);
            }
        }
        for (RecipeMap recipeMap : RecipeMap.ALL_RECIPE_MAPS.values()) {
            for (GTRecipe recipe : recipeMap.getAllRecipes()) {
                for (ItemStack stack : ZPMPlusComponents) {
                    ZPMRubberChanges.rewriteMachineRecipes(stack, RubberGenerated, recipe);
                }
            }
        }
        for (ItemStack itemStack : ZPMPlusComponents) {
            Predicate<Object> recipeFilter = obj -> obj instanceof GTShapedRecipe && GTUtility.areStacksEqual(((GTShapedRecipe)obj).func_77571_b(), stack, true);
            ZPMRubberChanges.rewriteCraftingRecipes(bufferedRecipeList, RubberGenerated, recipeFilter);
        }
    }

    private static void addDreamcraftItemListItems(Collection ZPMPlusComponents) {
        try {
            Class<?> customItemListClass = Class.forName("com.dreammaster.gthandler.CustomItemList");
            Method hasnotBeenSet = MethodUtils.getAccessibleMethod(customItemListClass, (String)"hasBeenSet", (Class[])new Class[0]);
            Method get = MethodUtils.getAccessibleMethod(customItemListClass, (String)"get", (Class[])new Class[]{Long.TYPE, Object[].class});
            for (Enum customItemList : (Enum[])FieldUtils.getField(customItemListClass, (String)"$VALUES", (boolean)true).get(null)) {
                if (!customItemList.toString().contains("ZPM") && !customItemList.toString().contains("UV") && !customItemList.toString().contains("UHV") && !customItemList.toString().contains("UEV") || !((Boolean)hasnotBeenSet.invoke((Object)customItemList, new Object[0])).booleanValue()) continue;
                ZPMPlusComponents.add((ItemStack)get.invoke((Object)customItemList, 1, new Object[0]));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void rewriteCraftingRecipes(List<IRecipe> bufferedRecipeList, OrePrefixes[] RubberGenerated, Predicate recipeFilter) {
        for (OrePrefixes prefixes : RubberGenerated) {
            Consumer<Object> recipeAction = obj -> {
                ZPMRubberChanges.doStacksCointainAndReplace(((GTShapedRecipe)obj).getInput(), GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(((GTShapedRecipe)obj).getInput(), GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            };
            CraftingManager.func_77594_a().func_77592_b().stream().filter(recipeFilter).forEach(recipeAction);
            bufferedRecipeList.stream().filter(recipeFilter).forEach(recipeAction);
        }
    }

    private static void rewriteMachineRecipes(ItemStack stack, OrePrefixes[] RubberGenerated, GTRecipe recipe) {
        if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
            for (OrePrefixes prefixes : RubberGenerated) {
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GTOreDictUnificator.get(prefixes, Materials.Silicon, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            }
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
        if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, stack, false, new ItemStack[0])) {
            for (OrePrefixes prefixes : RubberGenerated) {
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mOutputs, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            }
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidOutputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
    }

    private static void rewriteAsslineRecipes(ItemStack stack, OrePrefixes[] RubberGenerated, GTRecipe.RecipeAssemblyLine recipe) {
        for (OrePrefixes prefixes : RubberGenerated) {
            if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
                GTLog.out.print(Arrays.toString(recipe.mInputs));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
                ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            }
            if (!ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) continue;
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GTOreDictUnificator.get(prefixes, Materials.Silicone, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
            ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, GTOreDictUnificator.get(prefixes, Materials.StyreneButadieneRubber, 1L), true, WerkstoffMaterialPool.PTMEGElastomer.get(prefixes));
        }
        if (ZPMRubberChanges.doStacksCointainAndReplace(recipe.mInputs, stack, false, new ItemStack[0])) {
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.Silicone.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
        if (ZPMRubberChanges.doStacksCointainAndReplace(new Object[]{recipe.mOutput}, stack, false, new ItemStack[0])) {
            ZPMRubberChanges.doStacksCointainAndReplace(recipe.mFluidInputs, Materials.StyreneButadieneRubber.getMolten(1L), true, WerkstoffMaterialPool.PTMEGElastomer.getMolten(1).getFluid());
        }
    }

    private static ItemStack[] replaceArrayWith(ItemStack[] stackArray, Materials source, Werkstoff target) {
        for (int i = 0; i < stackArray.length; ++i) {
            ItemStack stack = stackArray[i];
            if (!BWUtil.checkStackAndPrefix(stack)) continue;
            stackArray[i] = ZPMRubberChanges.replaceStackWith(stack, source, target);
        }
        return stackArray;
    }

    private static ItemStack replaceStackWith(ItemStack stack, Materials source, Werkstoff target) {
        ItemData ass = GTOreDictUnificator.getAssociation(stack);
        if (ass.mMaterial.mMaterial.equals(source) && target.hasItemType(ass.mPrefix)) {
            stack = target.get(ass.mPrefix, stack.field_77994_a);
        }
        return stack;
    }

    private static boolean doStacksCointainAndReplace(FluidStack[] stacks, FluidStack stack, boolean replace, Fluid ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            if (!GTUtility.areFluidsEqual(stack, stacks[i])) continue;
            if (!replace) {
                return true;
            }
            int amount = stacks[i].amount;
            stacks[i] = new FluidStack(replacement[0], amount);
            replaced = true;
        }
        return replaced;
    }

    private static boolean doStacksCointainAndReplace(Object[] stacks, ItemStack stack, boolean replace, ItemStack ... replacement) {
        boolean replaced = false;
        for (int i = 0; i < stacks.length; ++i) {
            int amount;
            if (!GTUtility.isStackValid(stacks[i])) {
                if (!(stacks[i] instanceof ArrayList) || ((ArrayList)stacks[i]).size() <= 0 || !GTUtility.areStacksEqual(stack, (ItemStack)((ArrayList)stacks[i]).get(0), true)) continue;
                if (!replace) {
                    return true;
                }
                amount = ((ItemStack)((ArrayList)stacks[i]).get((int)0)).field_77994_a;
                stacks[i] = new ArrayList();
                ((ArrayList)stacks[i]).add(BWUtil.setStackSize(replacement[0], amount));
                replaced = true;
                GTLog.out.print("Replaced recipe!: " + stack.func_82833_r() + " ");
                continue;
            }
            if (!GTUtility.areStacksEqual(stack, (ItemStack)stacks[i], true)) continue;
            if (!replace) {
                return true;
            }
            amount = ((ItemStack)stacks[i]).field_77994_a;
            stacks[i] = BWUtil.setStackSize(replacement[0], amount);
            replaced = true;
        }
        return replaced;
    }
}

