/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.registration.gregtech;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.metatileentity.implementations.MTEFluid;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialsAlloy;
import gtPlusPlus.core.material.MaterialsElements;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechOrePrefixes;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GTPPMTECable;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GTPPMTEFluid;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GregtechConduits {
    private static final int BaseWireID = 30600;
    private static final int BasePipeID = 30700;
    private static int BasePipeHexadecupleID = 30100;

    public static void run() {
        GregtechConduits.run1();
        GregtechConduits.run2();
        GregtechConduits.run3();
    }

    private static void run3() {
        GregtechConduits.generateFluidMultiPipes(Materials.Copper, MaterialUtils.getMaterialName(Materials.Copper), "Copper", BasePipeHexadecupleID++, 60, 1000);
        GregtechConduits.generateFluidMultiPipes(Materials.Bronze, MaterialUtils.getMaterialName(Materials.Bronze), "Bronze", BasePipeHexadecupleID++, 120, 2000);
        GregtechConduits.generateFluidMultiPipes(Materials.Steel, MaterialUtils.getMaterialName(Materials.Steel), "Steel", BasePipeHexadecupleID++, 240, 2500);
        GregtechConduits.generateFluidMultiPipes(Materials.StainlessSteel, MaterialUtils.getMaterialName(Materials.StainlessSteel), "Stainless Steel", BasePipeHexadecupleID++, 360, 3000);
        GregtechConduits.generateFluidMultiPipes(Materials.Titanium, MaterialUtils.getMaterialName(Materials.Titanium), "Titanium", BasePipeHexadecupleID++, 480, 5000);
        GregtechConduits.generateFluidMultiPipes(Materials.TungstenSteel, MaterialUtils.getMaterialName(Materials.TungstenSteel), "Tungsten Steel", BasePipeHexadecupleID++, 600, 7500);
        GregtechConduits.generateFluidMultiPipes(Materials.Plastic, MaterialUtils.getMaterialName(Materials.Plastic), "Plastic", BasePipeHexadecupleID++, 360, 350);
        Materials aPTFE = Materials.get("Polytetrafluoroethylene");
        GregtechConduits.generateFluidMultiPipes(aPTFE, MaterialUtils.getMaterialName(aPTFE), "PTFE", BasePipeHexadecupleID++, 480, 600);
    }

    private static void generateFluidMultiPipes(Materials aMaterial, String name, String displayName, int startID, int transferRatePerSec, int heatCapacity) {
        int transferRatePerTick = transferRatePerSec / 20;
        MTEFluid aPipe = new MTEFluid(startID, "GT_Pipe_" + name + "_Hexadecuple", "Hexadecuple " + displayName + " Fluid Pipe", 1.0f, aMaterial, transferRatePerTick, heatCapacity, true, 16);
        GTOreDictUnificator.registerOre("pipeHexadecuple" + aMaterial, aPipe.getStackForm(1L));
    }

    private static void run1() {
        GregtechConduits.wireFactory("RedstoneAlloy", 32, 30645, 0L, 2L, 1L, new short[]{178, 34, 34, 0});
        GregtechConduits.makeCustomWires(MaterialsElements.STANDALONE.HYPOGEN, 30585, 0L, 0L, 8L, GTValues.V[11], false, true);
    }

    private static void run2() {
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Staballoy, MaterialsAlloy.STABALLOY, 30700, 12500, 7500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Tantalloy60, MaterialsAlloy.TANTALLOY_60, 30705, 10000, 4250, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Tantalloy61, MaterialsAlloy.TANTALLOY_61, 30710, 12000, 5800, true);
        if (Mods.Thaumcraft.isModLoaded()) {
            GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Void, null, 30715, 1600, 25000, true);
        }
        GregtechConduits.generateGTFluidPipes(Materials.Europium, 30720, 12000, 7500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Potin, MaterialsAlloy.POTIN, 30725, 500, 2000, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.MaragingSteel300, MaterialsAlloy.MARAGING300, 30730, 14000, 2500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.MaragingSteel350, MaterialsAlloy.MARAGING350, 30735, 16000, 2500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Inconel690, MaterialsAlloy.INCONEL_690, 30740, 15000, 4800, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.Inconel792, MaterialsAlloy.INCONEL_792, 30745, 16000, 5500, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.HastelloyX, MaterialsAlloy.HASTELLOY_X, 30750, 20000, 4200, true);
        GregtechConduits.generateGTFluidPipes(Materials.Tungsten, 30755, 4320, 7200, true);
        if (Mods.EnderIO.isModLoaded()) {
            GregtechConduits.generateGTFluidPipes(Materials.DarkSteel, 30760, 2320, 2750, true);
        }
        GregtechConduits.generateGTFluidPipes(Materials.Clay, 30765, 100, 500, false);
        GregtechConduits.generateGTFluidPipes(Materials.Lead, 30770, 350, 1200, true);
        GregtechConduits.generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials.TriniumNaquadahCarbonite, MaterialsAlloy.TRINIUM_NAQUADAH_CARBON, 30500, 20, 250000, true);
    }

    private static void wireFactory(String Material2, int Voltage2, int ID, long insulatedLoss, long uninsulatedLoss, long Amps, short[] rgb) {
        Materials T = Materials.get(Material2);
        byte V = GTUtility.getTier(Voltage2);
        if (V == -1) {
            Logger.ERROR("Failed to set voltage on " + Material2 + ". Invalid voltage of " + Voltage2 + "V set.");
            Logger.ERROR(Material2 + " has defaulted to 8v.");
            V = 0;
        }
        GregtechConduits.makeWires(T, ID, insulatedLoss, uninsulatedLoss, Amps, GTValues.V[V], true, false, rgb);
    }

    private static void makeWires(Materials aMaterial, int aStartID, long aLossInsulated, long aLoss, long aAmperage, long aVoltage, boolean aInsulatable, boolean aAutoInsulated, short[] aRGB) {
        Logger.WARNING("Gregtech5u Content | Registered " + aMaterial.mName + " as a new material for Wire & Cable.");
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt01, aMaterial, new GTPPMTECable(aStartID + 0, "wire." + aMaterial.mName.toLowerCase() + ".01", "1x " + aMaterial.mDefaultLocalName + " Wire", 0.125f, aMaterial, aLoss, 1L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt02, aMaterial, new GTPPMTECable(aStartID + 1, "wire." + aMaterial.mName.toLowerCase() + ".02", "2x " + aMaterial.mDefaultLocalName + " Wire", 0.25f, aMaterial, aLoss, 2L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt04, aMaterial, new GTPPMTECable(aStartID + 2, "wire." + aMaterial.mName.toLowerCase() + ".04", "4x " + aMaterial.mDefaultLocalName + " Wire", 0.375f, aMaterial, aLoss, 4L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt08, aMaterial, new GTPPMTECable(aStartID + 3, "wire." + aMaterial.mName.toLowerCase() + ".08", "8x " + aMaterial.mDefaultLocalName + " Wire", 0.5f, aMaterial, aLoss, 8L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt12, aMaterial, new GTPPMTECable(aStartID + 4, "wire." + aMaterial.mName.toLowerCase() + ".12", "12x " + aMaterial.mDefaultLocalName + " Wire", 0.625f, aMaterial, aLoss, 12L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt16, aMaterial, new GTPPMTECable(aStartID + 5, "wire." + aMaterial.mName.toLowerCase() + ".16", "16x " + aMaterial.mDefaultLocalName + " Wire", 0.75f, aMaterial, aLoss, 16L * aAmperage, aVoltage, false, !aAutoInsulated, aRGB).getStackForm(1L));
        if (aInsulatable) {
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt01, aMaterial, new GTPPMTECable(aStartID + 6, "cable." + aMaterial.mName.toLowerCase() + ".01", "1x " + aMaterial.mDefaultLocalName + " Cable", 0.25f, aMaterial, aLossInsulated, 1L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt02, aMaterial, new GTPPMTECable(aStartID + 7, "cable." + aMaterial.mName.toLowerCase() + ".02", "2x " + aMaterial.mDefaultLocalName + " Cable", 0.375f, aMaterial, aLossInsulated, 2L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt04, aMaterial, new GTPPMTECable(aStartID + 8, "cable." + aMaterial.mName.toLowerCase() + ".04", "4x " + aMaterial.mDefaultLocalName + " Cable", 0.5f, aMaterial, aLossInsulated, 4L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt08, aMaterial, new GTPPMTECable(aStartID + 9, "cable." + aMaterial.mName.toLowerCase() + ".08", "8x " + aMaterial.mDefaultLocalName + " Cable", 0.625f, aMaterial, aLossInsulated, 8L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt12, aMaterial, new GTPPMTECable(aStartID + 10, "cable." + aMaterial.mName.toLowerCase() + ".12", "12x " + aMaterial.mDefaultLocalName + " Cable", 0.75f, aMaterial, aLossInsulated, 12L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt16, aMaterial, new GTPPMTECable(aStartID + 11, "cable." + aMaterial.mName.toLowerCase() + ".16", "16x " + aMaterial.mDefaultLocalName + " Cable", 0.875f, aMaterial, aLossInsulated, 16L * aAmperage, aVoltage, true, false, aRGB).getStackForm(1L));
        }
    }

    private static void customWireFactory(Material Material2, int Voltage2, int ID, long insulatedLoss, long uninsulatedLoss, long Amps) {
        byte V = GTUtility.getTier(Voltage2);
        if (V == -1) {
            Logger.ERROR("Failed to set voltage on " + Material2 + ". Invalid voltage of " + Voltage2 + "V set.");
            Logger.ERROR(Material2 + " has defaulted to 8v.");
            V = 0;
        }
        GregtechConduits.makeCustomWires(Material2, ID, insulatedLoss, uninsulatedLoss, Amps, GTValues.V[V], true, false);
    }

    private static void makeCustomWires(Material aMaterial, int aStartID, long aLossInsulated, long aLoss, long aAmperage, long aVoltage, boolean aInsulatable, boolean aAutoInsulated) {
        Logger.WARNING("Gregtech5u Content | Registered " + aMaterial.getLocalizedName() + " as a new material for Wire & Cable.");
        GregtechConduits.registerOre(OrePrefixes.wireGt01, aMaterial, new GTPPMTECable(aStartID + 0, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".01", "1x " + aMaterial.getLocalizedName() + " Wire", 0.125f, aLoss, 1L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt02, aMaterial, new GTPPMTECable(aStartID + 1, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".02", "2x " + aMaterial.getLocalizedName() + " Wire", 0.25f, aLoss, 2L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt04, aMaterial, new GTPPMTECable(aStartID + 2, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".04", "4x " + aMaterial.getLocalizedName() + " Wire", 0.375f, aLoss, 4L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt08, aMaterial, new GTPPMTECable(aStartID + 3, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".08", "8x " + aMaterial.getLocalizedName() + " Wire", 0.5f, aLoss, 8L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt12, aMaterial, new GTPPMTECable(aStartID + 4, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".12", "12x " + aMaterial.getLocalizedName() + " Wire", 0.625f, aLoss, 12L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        GregtechConduits.registerOre(OrePrefixes.wireGt16, aMaterial, new GTPPMTECable(aStartID + 5, "wire." + aMaterial.getLocalizedName().toLowerCase() + ".16", "16x " + aMaterial.getLocalizedName() + " Wire", 0.75f, aLoss, 16L * aAmperage, aVoltage, false, !aAutoInsulated, aMaterial.getRGBA()).getStackForm(1L));
        if (aInsulatable) {
            GregtechConduits.registerOre(OrePrefixes.cableGt01, aMaterial, new GTPPMTECable(aStartID + 6, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".01", "1x " + aMaterial.getLocalizedName() + " Cable", 0.25f, aLossInsulated, 1L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt02, aMaterial, new GTPPMTECable(aStartID + 7, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".02", "2x " + aMaterial.getLocalizedName() + " Cable", 0.375f, aLossInsulated, 2L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt04, aMaterial, new GTPPMTECable(aStartID + 8, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".04", "4x " + aMaterial.getLocalizedName() + " Cable", 0.5f, aLossInsulated, 4L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt08, aMaterial, new GTPPMTECable(aStartID + 9, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".08", "8x " + aMaterial.getLocalizedName() + " Cable", 0.625f, aLossInsulated, 8L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt12, aMaterial, new GTPPMTECable(aStartID + 10, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".12", "12x " + aMaterial.getLocalizedName() + " Cable", 0.75f, aLossInsulated, 12L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
            GregtechConduits.registerOre(OrePrefixes.cableGt16, aMaterial, new GTPPMTECable(aStartID + 11, "cable." + aMaterial.getLocalizedName().toLowerCase() + ".16", "16x " + aMaterial.getLocalizedName() + " Cable", 0.875f, aLossInsulated, 16L * aAmperage, aVoltage, true, false, aMaterial.getRGBA()).getStackForm(1L));
        }
    }

    private static void generateGTFluidPipes(Materials material, int startID, int transferRatePerSec, int heatResistance, boolean isGasProof) {
        int transferRatePerTick = transferRatePerSec / 20;
        long mass = material.getMass();
        long voltage = material.mMeltingPoint >= 2800 ? 64L : 16L;
        GTOreDictUnificator.registerOre(OrePrefixes.pipeTiny.get(material), new MTEFluid(startID, "GT_Pipe_" + material.mDefaultLocalName + "_Tiny", "Tiny " + material.mDefaultLocalName + " Fluid Pipe", 0.25f, material, transferRatePerTick * 2, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeSmall.get(material), new MTEFluid(startID + 1, "GT_Pipe_" + material.mDefaultLocalName + "_Small", "Small " + material.mDefaultLocalName + " Fluid Pipe", 0.375f, material, transferRatePerTick * 4, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeMedium.get(material), new MTEFluid(startID + 2, "GT_Pipe_" + material.mDefaultLocalName, material.mDefaultLocalName + " Fluid Pipe", 0.5f, material, transferRatePerTick * 12, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeLarge.get(material), new MTEFluid(startID + 3, "GT_Pipe_" + material.mDefaultLocalName + "_Large", "Large " + material.mDefaultLocalName + " Fluid Pipe", 0.75f, material, transferRatePerTick * 24, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeHuge.get(material), new MTEFluid(startID + 4, "GT_Pipe_" + material.mDefaultLocalName + "_Huge", "Huge " + material.mDefaultLocalName + " Fluid Pipe", 0.875f, material, transferRatePerTick * 48, heatResistance, isGasProof).getStackForm(1L));
    }

    private static void generateNonGTFluidPipes(GregtechOrePrefixes.GT_Materials material, Material GGMaterial2, int startID, int transferRatePerSec, int heatResistance, boolean isGasProof) {
        int transferRatePerTick = transferRatePerSec / 20;
        GTOreDictUnificator.registerOre(OrePrefixes.pipeTiny.get(material), new GTPPMTEFluid(startID, "GT_Pipe_" + material.mDefaultLocalName + "_Tiny", "Tiny " + material.mDefaultLocalName + " Fluid Pipe", 0.25f, material, transferRatePerTick * 2, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeSmall.get(material), new GTPPMTEFluid(startID + 1, "GT_Pipe_" + material.mDefaultLocalName + "_Small", "Small " + material.mDefaultLocalName + " Fluid Pipe", 0.375f, material, transferRatePerTick * 4, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeMedium.get(material), new GTPPMTEFluid(startID + 2, "GT_Pipe_" + material.mDefaultLocalName, material.mDefaultLocalName + " Fluid Pipe", 0.5f, material, transferRatePerTick * 12, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeLarge.get(material), new GTPPMTEFluid(startID + 3, "GT_Pipe_" + material.mDefaultLocalName + "_Large", "Large " + material.mDefaultLocalName + " Fluid Pipe", 0.75f, material, transferRatePerTick * 24, heatResistance, isGasProof).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeHuge.get(material), new GTPPMTEFluid(startID + 4, "GT_Pipe_" + material.mDefaultLocalName + "_Huge", "Huge " + material.mDefaultLocalName + " Fluid Pipe", 0.875f, material, transferRatePerTick * 48, heatResistance, isGasProof).getStackForm(1L));
    }

    public static void generatePipeRecipes(String materialName, long Mass, long vMulti) {
        String output = materialName.substring(0, 1).toUpperCase() + materialName.substring(1);
        if ((output = Utils.sanitizeString(output)).equals("VoidMetal")) {
            output = "Void";
        }
        Logger.INFO("Generating " + output + " pipes & respective recipes.");
        ItemStack pipeIngot = ItemUtils.getItemStackOfAmountFromOreDict("ingot" + output, 1);
        ItemStack pipePlate = ItemUtils.getItemStackOfAmountFromOreDict("plate" + output, 1);
        if (pipeIngot == null && pipePlate != null) {
            pipeIngot = pipePlate;
        }
        Logger.WARNING("Generated pipeTiny from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeTiny" + output, 1) != null));
        Logger.WARNING("Generated pipeSmall from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeSmall" + output, 1) != null));
        Logger.WARNING("Generated pipeNormal from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeMedium" + output, 1) != null));
        Logger.WARNING("Generated pipeLarge from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeLarge" + output, 1) != null));
        Logger.WARNING("Generated pipeHuge from " + materialName + "? " + (ItemUtils.getItemStackOfAmountFromOreDict("pipeHuge" + output, 1) != null));
        int eut = (int)(8L * vMulti);
        RecipeUtils.addShapedRecipe(pipePlate, "craftingToolWrench", pipePlate, pipePlate, null, pipePlate, pipePlate, "craftingToolHardHammer", pipePlate, ItemUtils.getItemStackOfAmountFromOreDict("pipeSmall" + output, 6));
        RecipeUtils.addShapedRecipe(pipePlate, pipePlate, pipePlate, "craftingToolWrench", null, "craftingToolHardHammer", pipePlate, pipePlate, pipePlate, ItemUtils.getItemStackOfAmountFromOreDict("pipeMedium" + output, 2));
        RecipeUtils.addShapedRecipe(pipePlate, "craftingToolHardHammer", pipePlate, pipePlate, null, pipePlate, pipePlate, "craftingToolWrench", pipePlate, ItemUtils.getItemStackOfAmountFromOreDict("pipeLarge" + output, 1));
        if (pipeIngot != null && ItemUtils.checkForInvalidItems(pipeIngot)) {
            int inputMultiplier = materialName.equals("Clay") ? 2 : 1;
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(pipeIngot, 1 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Tiny.get(0L, new Object[0])).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDictNoBroken("pipeTiny" + output, 2)).duration(5).eut(eut).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(pipeIngot, 1 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Small.get(0L, new Object[0])).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("pipeSmall" + output, 1)).duration(10).eut(eut).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(pipeIngot, 3 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Medium.get(0L, new Object[0])).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("pipeMedium" + output, 1)).duration(20).eut(eut).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(pipeIngot, 6 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Large.get(0L, new Object[0])).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("pipeLarge" + output, 1)).duration(40).eut(eut).addTo(RecipeMaps.extruderRecipes);
            GTValues.RA.stdBuilder().itemInputs(ItemUtils.getSimpleStack(pipeIngot, 12 * inputMultiplier), ItemList.Shape_Extruder_Pipe_Huge.get(0L, new Object[0])).itemOutputs(ItemUtils.getItemStackOfAmountFromOreDict("pipeHuge" + output, 1)).duration(80).eut(eut).addTo(RecipeMaps.extruderRecipes);
        }
        if (eut < 512 && !output.equals("Void")) {
            ItemStack pipePlateDouble = ItemUtils.getItemStackOfAmountFromOreDict("plateDouble" + output, 1);
            if (pipePlateDouble != null) {
                pipePlateDouble = pipePlateDouble.func_77946_l();
                RecipeUtils.addShapedRecipe(pipePlateDouble, "craftingToolHardHammer", pipePlateDouble, pipePlateDouble, null, pipePlateDouble, pipePlateDouble, "craftingToolWrench", pipePlateDouble, ItemUtils.getItemStackOfAmountFromOreDict("pipeHuge" + output, 1));
            } else {
                Logger.INFO("Failed to add a recipe for " + materialName + " Huge pipes. Double plates probably do not exist.");
            }
        }
    }

    public static boolean registerOre(OrePrefixes aPrefix, Material aMaterial, ItemStack aStack) {
        return GregtechConduits.registerOre(aPrefix.get(Utils.sanitizeString(aMaterial.getLocalizedName())), aStack);
    }

    public static boolean registerOre(Object aName, ItemStack aStack) {
        if (aName == null || GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        String tName = aName.toString();
        if (GTUtility.isStringInvalid(tName)) {
            return false;
        }
        ArrayList<ItemStack> tList = GTOreDictUnificator.getOres(tName);
        for (ItemStack itemStack : tList) {
            if (!GTUtility.areStacksEqual(itemStack, aStack, true)) continue;
            return false;
        }
        OreDictionary.registerOre((String)tName, (ItemStack)GTUtility.copyAmount(1L, new Object[]{aStack}));
        return true;
    }

    public static boolean generateWireRecipes(Material aMaterial) {
        ItemStack aPlate = aMaterial.getPlate(1);
        ItemStack aIngot = aMaterial.getIngot(1);
        ItemStack aRod = aMaterial.getRod(1);
        ItemStack aWire01 = aMaterial.getWire01(1);
        ItemStack aWire02 = aMaterial.getWire02(1);
        ItemStack aWire04 = aMaterial.getWire04(1);
        ItemStack aWire08 = aMaterial.getWire08(1);
        ItemStack aWire12 = aMaterial.getWire12(1);
        ItemStack aWire16 = aMaterial.getWire16(1);
        ItemStack aCable01 = aMaterial.getCable01(1);
        ItemStack aCable02 = aMaterial.getCable02(1);
        ItemStack aCable04 = aMaterial.getCable04(1);
        ItemStack aCable08 = aMaterial.getCable08(1);
        ItemStack aCable12 = aMaterial.getCable12(1);
        ItemStack aCable16 = aMaterial.getCable16(1);
        ItemStack aFineWire = aMaterial.getFineWire(1);
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aPlate, aWire01})) {
            RecipeUtils.addShapedRecipe(aPlate, CI.craftingToolWireCutter, null, null, null, null, null, null, null, aWire01);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aIngot, aWire01, aWire02, aWire04, aWire08, aWire12, aWire16})) {
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getIngot(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(aMaterial.getWire01(2)).duration(100).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getIngot(1), GTUtility.getIntegratedCircuit(2)).itemOutputs(aMaterial.getWire02(1)).duration(150).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getIngot(2), GTUtility.getIntegratedCircuit(4)).itemOutputs(aMaterial.getWire04(1)).duration(200).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getIngot(4), GTUtility.getIntegratedCircuit(8)).itemOutputs(aMaterial.getWire08(1)).duration(250).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getIngot(6), GTUtility.getIntegratedCircuit(12)).itemOutputs(aMaterial.getWire12(1)).duration(300).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getIngot(8), GTUtility.getIntegratedCircuit(16)).itemOutputs(aMaterial.getWire16(1)).duration(350).eut(4).addTo(RecipeMaps.wiremillRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aRod, aWire01, aWire02, aWire04, aWire08, aWire12, aWire16})) {
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getRod(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(aMaterial.getWire01(1)).duration(50).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getRod(2), GTUtility.getIntegratedCircuit(2)).itemOutputs(aMaterial.getWire02(1)).duration(100).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getRod(4), GTUtility.getIntegratedCircuit(4)).itemOutputs(aMaterial.getWire04(1)).duration(150).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getRod(8), GTUtility.getIntegratedCircuit(8)).itemOutputs(aMaterial.getWire08(1)).duration(200).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getRod(12), GTUtility.getIntegratedCircuit(12)).itemOutputs(aMaterial.getWire12(1)).duration(250).eut(4).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getRod(16), GTUtility.getIntegratedCircuit(16)).itemOutputs(aMaterial.getWire16(1)).duration(300).eut(4).addTo(RecipeMaps.wiremillRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aIngot, aFineWire})) {
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getIngot(1), GTUtility.getIntegratedCircuit(3)).itemOutputs(aMaterial.getFineWire(8)).duration(100).eut(4).addTo(RecipeMaps.wiremillRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aRod, aFineWire})) {
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getRod(1), GTUtility.getIntegratedCircuit(3)).itemOutputs(aMaterial.getFineWire(4)).duration(50).eut(4).addTo(RecipeMaps.wiremillRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aFineWire})) {
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getWire01(1), GTUtility.getIntegratedCircuit(1)).itemOutputs(aMaterial.getFineWire(4)).duration(200).eut(8).addTo(RecipeMaps.wiremillRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aIngot, aWire01})) {
            GTValues.RA.stdBuilder().itemInputs(aIngot, ItemList.Shape_Extruder_Wire.get(0L, new Object[0])).itemOutputs(aMaterial.getWire01(2)).duration(196).eut(96).addTo(RecipeMaps.extruderRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aCable01, aWire01})) {
            GTValues.RA.stdBuilder().itemInputs(aCable01).itemOutputs(aWire01).duration(100).eut(8).addTo(RecipeMaps.unpackagerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire02}, aMaterial.getWire01(2));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire04})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04}, aMaterial.getWire01(4));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire08})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire08}, aMaterial.getWire01(8));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire12})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire12}, aMaterial.getWire01(12));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire16})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire16}, aMaterial.getWire01(16));
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire01, aWire01}, aWire02);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire02, aWire04})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire02, aWire02}, aWire04);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aWire08})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04, aWire04}, aWire08);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aWire08, aWire12})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04, aWire08}, aWire12);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aWire12, aWire16})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire04, aWire12}, aWire16);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire08, aWire16})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire08, aWire08}, aWire16);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire04})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire01, aWire01, aWire01, aWire01}, aWire04);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire08})) {
            RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{aWire01, aWire01, aWire01, aWire01, aWire01, aWire01, aWire01, aWire01}, aWire08);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aCable01})) {
            GTValues.RA.stdBuilder().itemInputs(aWire01, GTUtility.getIntegratedCircuit(24)).itemOutputs(aCable01).fluidInputs(FluidUtils.getFluidStack("molten.rubber", 144)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire02, aCable02})) {
            GTValues.RA.stdBuilder().itemInputs(aWire02, GTUtility.getIntegratedCircuit(24)).itemOutputs(aCable02).fluidInputs(FluidUtils.getFluidStack("molten.rubber", 144)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire04, aCable04})) {
            GTValues.RA.stdBuilder().itemInputs(aWire04, GTUtility.getIntegratedCircuit(24)).itemOutputs(aCable04).fluidInputs(FluidUtils.getFluidStack("molten.rubber", 288)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire08, aCable08})) {
            GTValues.RA.stdBuilder().itemInputs(aWire08, GTUtility.getIntegratedCircuit(24)).itemOutputs(aCable08).fluidInputs(FluidUtils.getFluidStack("molten.rubber", 432)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire12, aCable12})) {
            GTValues.RA.stdBuilder().itemInputs(aWire12, GTUtility.getIntegratedCircuit(24)).itemOutputs(aCable12).fluidInputs(FluidUtils.getFluidStack("molten.rubber", 576)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire16, aCable16})) {
            GTValues.RA.stdBuilder().itemInputs(aWire16, GTUtility.getIntegratedCircuit(24)).itemOutputs(aCable16).fluidInputs(FluidUtils.getFluidStack("molten.rubber", 720)).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        if (ItemUtils.checkForInvalidItems(new ItemStack[]{aWire01, aWire02})) {
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getWire01(2), GTUtility.getIntegratedCircuit(2)).itemOutputs(aWire02).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getWire01(4), GTUtility.getIntegratedCircuit(4)).itemOutputs(aWire04).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getWire01(8), GTUtility.getIntegratedCircuit(8)).itemOutputs(aWire08).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getWire01(12), GTUtility.getIntegratedCircuit(12)).itemOutputs(aWire12).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
            GTValues.RA.stdBuilder().itemInputs(aMaterial.getWire01(16), GTUtility.getIntegratedCircuit(16)).itemOutputs(aWire16).duration(100).eut(8).addTo(RecipeMaps.assemblerRecipes);
        }
        return true;
    }
}

