/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.FishPondFakeRecipe;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.config.Configuration;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEIndustrialFishingPond
extends GTPPMultiBlockBase<MTEIndustrialFishingPond>
implements ISurvivalConstructable {
    private boolean isUsingControllerCircuit = false;
    private static final Item circuit = GTUtility.getIntegratedCircuit(0).func_77973_b();
    private int mCasing;
    private static IStructureDefinition<MTEIndustrialFishingPond> STRUCTURE_DEFINITION = null;
    private static final Class<?> cofhWater = ReflectionUtils.getClass("cofh.asmhooks.block.BlockWater");
    private static ArrayList<ArrayList<WeightedRandomFishable>> categories = new ArrayList();
    private static ArrayList<WeightedRandomFishable> categoryFish = new ArrayList();
    private static ArrayList<WeightedRandomFishable> categoryJunk = new ArrayList();
    private static ArrayList<WeightedRandomFishable> categoryLoot = new ArrayList();
    private static boolean hasGenerateRecipes = false;
    private int mMode = 14;
    private int mMax = 8;
    private static Map<WeightedRandomFishable, ItemStack> reflectiveFishMap = new HashMap<WeightedRandomFishable, ItemStack>();

    public MTEIndustrialFishingPond(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEIndustrialFishingPond(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEIndustrialFishingPond(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Fish Trap";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Fishing Pond").addInfo("Can process (Tier + 1) * 2 recipes").addInfo("Put a numbered circuit into the input bus.").addInfo("Circuit 14 for Fish").addInfo("Circuit 15 for Junk").addInfo("Circuit 16 for Treasure").addInfo("Need to be filled with water.").addInfo("Will automatically fill water from input hatch.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(9, 3, 9, true).addController("Front Center").addCasingInfoMin("Aquatic Casings", 64, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).addEnergyHatch("Any Casing", 1).addMaintenanceHatch("Any Casing", 1).addMufflerHatch("Any Casing", 1).toolTipFinisher(GTPPCore.GT_Tooltip_Builder.get());
        return tt;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public IStructureDefinition<MTEIndustrialFishingPond> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXX~XXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX"}})).addElement('X', GTStructureUtility.buildHatchAdder(MTEIndustrialFishingPond.class).atLeast(HatchElement.InputBus, HatchElement.OutputBus, HatchElement.Maintenance, HatchElement.Energy, HatchElement.Muffler, HatchElement.InputHatch).casingIndex(this.getCasingTextureIndex()).dot(1).buildAndChain(StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)this.getCasingBlock(), (int)this.getCasingMeta())))).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 1, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 4, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 4, 1, 0) && this.mCasing >= 64 && this.checkHatch();
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return Textures.BlockIcons.OVERLAY_FRONT_VACUUM_FREEZER;
    }

    @Override
    protected int getCasingTextureId() {
        return this.getCasingTextureIndex();
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GTPPRecipeMaps.fishPondRecipes;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        ItemStack controllerStack = this.getControllerSlot();
        if (controllerStack != null) {
            if (controllerStack.func_77973_b() == circuit) {
                this.isUsingControllerCircuit = true;
                this.mMode = controllerStack.func_77960_j();
            } else {
                this.isUsingControllerCircuit = false;
            }
        } else {
            this.isUsingControllerCircuit = false;
        }
        if (!hasGenerateRecipes) {
            this.generateRecipes();
        }
        if (!this.checkForWater()) {
            return SimpleCheckRecipeResult.ofFailure("no_water");
        }
        ItemStack[] tItemInputs = this.getStoredInputs().toArray(new ItemStack[0]);
        FluidStack[] tFluidInputs = this.getStoredFluids().toArray(new FluidStack[0]);
        if (!this.isUsingControllerCircuit && tItemInputs.length == 0) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        long tEnergy = this.getMaxInputEnergy();
        this.getCircuit(tItemInputs);
        ItemStack[] mFishOutput = this.generateLoot(this.mMode);
        mFishOutput = ArrayUtils.removeNulls(mFishOutput);
        GTRecipe g = new GTRecipe(true, new ItemStack[0], mFishOutput, null, new int[0], tFluidInputs, null, 200, 16, 0);
        OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt(g.mEUt).setEUt(tEnergy).setDuration(g.mDuration);
        ParallelHelper helper = new ParallelHelper().setRecipe(g).setItemInputs(tItemInputs).setFluidInputs(tFluidInputs).setAvailableEUt(tEnergy).setMaxParallel(this.getMaxParallelRecipes()).setConsumption(true).setOutputCalculation(true).setMachine(this).enableBatchMode(this.batchMode ? 128 : 1).setCalculator(calculator);
        helper.build();
        if (helper.getCurrentParallel() == 0) {
            return CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.lEUt = -calculator.getConsumption();
        this.mMaxProgresstime = (int)Math.ceil((double)calculator.getDuration() * helper.getDurationMultiplierDouble());
        this.mOutputItems = helper.getItemOutputs();
        this.mOutputFluids = null;
        this.updateSlots();
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2 * (GTUtility.getTier(this.getMaxInputVoltage()) + 1);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return Configuration.pollution.pollutionPerSecondMultiIndustrialFishingPond;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings3Misc;
    }

    public byte getCasingMeta() {
        return 0;
    }

    public int getCasingTextureIndex() {
        return TAE.GTPP_INDEX(32);
    }

    public boolean checkForWater() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int mDirectionX = aBaseMetaTileEntity.getBackFacing().offsetX;
        int mOffsetX_Lower = 0;
        int mOffsetX_Upper = 0;
        int mOffsetZ_Lower = 0;
        int mOffsetZ_Upper = 0;
        int mCurrentDirectionX = 4;
        int mCurrentDirectionZ = 4;
        mOffsetX_Lower = -4;
        mOffsetX_Upper = 4;
        mOffsetZ_Lower = -4;
        mOffsetZ_Upper = 4;
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * mCurrentDirectionX;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * mCurrentDirectionZ;
        int tAmount = 0;
        for (int i = mOffsetX_Lower + 1; i <= mOffsetX_Upper - 1; ++i) {
            for (int j = mOffsetZ_Lower + 1; j <= mOffsetZ_Upper - 1; ++j) {
                for (int h = 0; h < 2; ++h) {
                    byte tMeta;
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if (this.isNotStaticWater(tBlock, tMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j)) && this.getStoredFluids() != null) {
                        for (FluidStack stored : this.getStoredFluids()) {
                            if (!stored.isFluidEqual(FluidUtils.getFluidStack("water", 1)) || stored.amount < 1000) continue;
                            stored.amount -= 1000;
                            Block fluidUsed = Blocks.field_150355_j;
                            aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, fluidUsed);
                        }
                    }
                    if ((tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j)) != Blocks.field_150355_j && tBlock != Blocks.field_150358_i) continue;
                    ++tAmount;
                }
            }
        }
        return tAmount >= 60;
    }

    private boolean isNotStaticWater(Block block, byte meta) {
        return block == Blocks.field_150350_a || block == Blocks.field_150358_i || block == BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater) || cofhWater != null && cofhWater.isAssignableFrom(block.getClass()) && meta != 0;
    }

    private void generateRecipes() {
        if (hasGenerateRecipes) {
            return;
        }
        categories.add(categoryFish);
        categories.add(categoryJunk);
        categories.add(categoryLoot);
        categoryFish.addAll(FishPondFakeRecipe.fish);
        categoryJunk.addAll(FishPondFakeRecipe.junk);
        categoryLoot.addAll(FishPondFakeRecipe.treasure);
        hasGenerateRecipes = true;
    }

    private int getCircuit(ItemStack[] t) {
        block8: {
            ItemStack[] itemStackArray;
            int n;
            int n2;
            if (this.isUsingControllerCircuit || (n2 = 0) >= (n = (itemStackArray = t).length)) break block8;
            ItemStack j = itemStackArray[n2];
            if (j.func_77973_b() == GTUtility.getIntegratedCircuit(0).func_77973_b()) {
                if (j.func_77960_j() == 14) {
                    this.mMax = 8 + (this.getMaxParallelRecipes() - 2);
                    this.mMode = 14;
                } else if (j.func_77960_j() == 15) {
                    this.mMode = 15;
                    this.mMax = 4;
                } else if (j.func_77960_j() == 16) {
                    this.mMode = 16;
                    this.mMax = 4;
                } else {
                    this.mMode = 0;
                    this.mMax = 0;
                }
            } else {
                this.mMode = 0;
                this.mMax = 0;
            }
        }
        return this.mMode;
    }

    private ItemStack reflectiveFish(WeightedRandomFishable y) {
        if (reflectiveFishMap.containsKey(y)) {
            return reflectiveFishMap.get(y);
        }
        try {
            ItemStack t = (ItemStack)ReflectionUtils.getField(WeightedRandomFishable.class, "field_150711_b").get(y);
            ItemStack k = ItemUtils.getSimpleStack(t, 1);
            reflectiveFishMap.put(y, k);
            return t;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
    }

    private ItemStack[] generateLoot(int mode) {
        ItemStack[] mFishOutput = new ItemStack[this.mMax];
        if (this.mMode == 14) {
            for (int k = 0; k < this.mMax; ++k) {
                if (mFishOutput[k] != null) continue;
                for (WeightedRandomFishable g : categoryFish) {
                    ItemStack t;
                    if (MathUtils.randInt(0, 65 - this.getMaxParallelRecipes()) > 2 || (t = this.reflectiveFish(g)) == null) continue;
                    mFishOutput[k] = ItemUtils.getSimpleStack(t, 1);
                }
            }
        } else if (this.mMode == 15) {
            for (int k = 0; k < this.mMax; ++k) {
                if (mFishOutput[k] != null) continue;
                for (WeightedRandomFishable g : categoryJunk) {
                    ItemStack t;
                    if (MathUtils.randInt(0, 100) > 1 || (t = this.reflectiveFish(g)) == null) continue;
                    mFishOutput[k] = ItemUtils.getSimpleStack(t, 1);
                }
            }
        } else if (this.mMode == 16) {
            for (int k = 0; k < this.mMax; ++k) {
                if (mFishOutput[k] != null) continue;
                for (WeightedRandomFishable g : categoryLoot) {
                    ItemStack t;
                    if (MathUtils.randInt(0, 1000) > 2 || (t = this.reflectiveFish(g)) == null) continue;
                    mFishOutput[k] = ItemUtils.getSimpleStack(t, 1);
                }
            }
        } else {
            mFishOutput = null;
        }
        return mFishOutput;
    }
}

