/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.agrichem.item.algae;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.plugin.agrichem.AlgaeDefinition;
import gtPlusPlus.plugin.agrichem.IAlgalItem;
import gtPlusPlus.plugin.agrichem.logic.AlgaeGeneticData;
import gtPlusPlus.plugin.agrichem.logic.AlgaeGrowthRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemAlgaeBase
extends Item
implements IAlgalItem {
    protected IIcon base;
    protected IIcon overlay;

    public ItemAlgaeBase() {
        this.func_77627_a(true);
        this.func_77656_e(127);
        this.setNoRepair();
        this.func_77625_d(32);
        this.func_77655_b("BasicAlgaeItem");
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean func_77629_n_() {
        return super.func_77629_n_();
    }

    public void func_77663_a(ItemStack p_77663_1_, World p_77663_2_, Entity p_77663_3_, int p_77663_4_, boolean p_77663_5_) {
        if (!p_77663_1_.func_77942_o() || p_77663_1_.func_77978_p().func_82582_d()) {
            p_77663_1_ = ItemAlgaeBase.initNBT(p_77663_1_);
        }
        super.func_77663_a(p_77663_1_, p_77663_2_, p_77663_3_, p_77663_4_, p_77663_5_);
    }

    public String func_77653_i(ItemStack aStack) {
        return EnumChatFormatting.UNDERLINE + super.func_77653_i(aStack);
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer p_77624_2_, List aList, boolean p_77624_4_) {
        int aDam = aStack.func_77960_j();
        try {
            aList.add(AlgaeDefinition.getByIndex((int)aDam).mSimpleName);
            if (!aStack.func_77942_o() || aStack.func_77978_p().func_82582_d()) {
                aStack = ItemAlgaeBase.initNBT(aStack);
            } else {
                NBTTagCompound aNBT = aStack.func_77978_p();
                boolean mRequiresLight = aNBT.func_74767_n("mRequiresLight");
                boolean mSaltWater = aNBT.func_74767_n("mSaltWater");
                boolean mFreshWater = aNBT.func_74767_n("mFreshWater");
                byte mTempTolerance = aNBT.func_74771_c("mTempTolerance");
                float mFertility = aNBT.func_74760_g("mFertility");
                float mProductionSpeed = aNBT.func_74760_g("mProductionSpeed");
                byte mLifespan = aNBT.func_74771_c("mLifespan");
                int mGeneration = aNBT.func_74762_e("mGeneration");
                aList.add("Requires Light: " + mRequiresLight);
                aList.add("Salt Water: " + mSaltWater);
                aList.add("Fresh Water: " + mFreshWater);
                aList.add("Temp Tolerance: " + mTempTolerance);
                aList.add("Growth: " + mFertility);
                aList.add("Production: " + mProductionSpeed);
                aList.add("Lifespan in days: " + mLifespan);
                aList.add("Generation: " + mGeneration);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        super.func_77624_a(aStack, p_77624_2_, aList, p_77624_4_);
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.uncommon;
    }

    public boolean func_77623_v() {
        return true;
    }

    public void func_150895_a(Item aItem, CreativeTabs p_150895_2_, List aList) {
        for (int i = 0; i < AlgaeDefinition.values().length; ++i) {
            aList.add(ItemUtils.simpleMetaStack(aItem, i, 1));
        }
    }

    public boolean func_82789_a(ItemStack p_82789_1_, ItemStack p_82789_2_) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public int func_82790_a(ItemStack aStack, int aMeta) {
        return AlgaeDefinition.getByIndex((int)aStack.func_77960_j()).mColour;
    }

    public IIcon func_77618_c(int damage, int pass) {
        if (pass == 0) {
            return this.base;
        }
        return this.overlay;
    }

    public void func_94581_a(IIconRegister i) {
        this.base = i.func_94245_a(Mods.GTPlusPlus.ID + ":bioscience/BasicAlgae");
        this.overlay = i.func_94245_a(Mods.GTPlusPlus.ID + ":bioscience/BasicAlgae_Overlay");
    }

    public static ItemStack initNBT(ItemStack aFreshAlgae) {
        NBTTagCompound aNewTag = new NBTTagCompound();
        if (aFreshAlgae.func_77973_b() instanceof ItemAlgaeBase) {
            ItemAlgaeBase aItem = (ItemAlgaeBase)aFreshAlgae.func_77973_b();
            if (!aFreshAlgae.func_77942_o()) {
                AlgaeGeneticData y = aItem.getSpeciesData(aFreshAlgae);
                aNewTag = y.writeToNBT();
                aFreshAlgae.func_77982_d(aNewTag);
            } else {
                aNewTag = aFreshAlgae.func_77978_p();
            }
        }
        return aFreshAlgae;
    }

    @Override
    public AlgaeDefinition getAlgaeType(ItemStack aStack) {
        return AlgaeDefinition.getByIndex(aStack != null ? aStack.func_77960_j() : 3);
    }

    @Override
    public AlgaeGeneticData getSpeciesData(ItemStack aStack) {
        NBTTagCompound aTag;
        if (!aStack.func_77942_o() || aStack.func_77978_p().func_82582_d()) {
            aTag = new NBTTagCompound();
            if (aStack.func_77960_j() < 3 || aStack.func_77960_j() > 5) {
                AlgaeGeneticData aGenes = new AlgaeGeneticData();
                aTag = aGenes.writeToNBT();
            } else {
                float aFert;
                int aDam = aStack.func_77960_j();
                byte aTemp = (byte)(aDam == 3 ? 0 : (aDam == 4 ? 2 : 1));
                byte aLifespan = (byte)(aDam == 3 ? 1.0f : (aDam == 4 ? 3.0f : 2.0f));
                float f = aDam == 3 ? 2.0f : (aFert = aDam == 4 ? 1.0f : 1.75f);
                float aSpeed = aDam == 3 ? 1.0f : (aDam == 4 ? 1.5f : 2.0f);
                AlgaeGeneticData aGenes = new AlgaeGeneticData(true, true, AlgaeDefinition.getByIndex((int)aDam).mSaltWater, AlgaeDefinition.getByIndex((int)aDam).mFreshWater, aTemp, aFert, aSpeed, aLifespan, 0, new ArrayList<AlgaeGrowthRequirement>());
                aTag = aGenes.writeToNBT();
            }
        } else {
            aTag = aStack.func_77978_p();
        }
        return new AlgaeGeneticData(aTag);
    }
}

