/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.base.itemblock;

import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.block.base.BlockBaseModular;
import gtPlusPlus.core.block.base.BlockBaseOre;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.material.Material;
import gtPlusPlus.core.material.MaterialStack;
import gtPlusPlus.core.util.minecraft.EntityUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemBlockGtBlock
extends ItemBlock {
    public static HashMap<String, String> sNameCache = new HashMap();
    protected final int blockColour;
    private int sRadiation;
    private Material mMaterial;
    protected BasicBlock.BlockTypes thisBlockType;
    private final Block thisBlock;
    private boolean isOre = false;
    private boolean isModular = false;

    public ItemBlockGtBlock(Block block) {
        super(block);
        this.thisBlock = block;
        if (block instanceof BlockBaseOre) {
            this.isOre = true;
        } else if (block instanceof BlockBaseModular) {
            this.isModular = true;
        }
        BlockBaseModular baseBlock = (BlockBaseModular)block;
        this.blockColour = this.isModular ? baseBlock.func_149741_i(0) : (this.isOre ? block.func_149635_D() : block.func_149635_D());
        if (block instanceof BlockBaseModular) {
            BlockBaseModular g = (BlockBaseModular)block;
            this.mMaterial = g.getMaterialEx();
            this.thisBlockType = g.thisBlock;
        } else {
            this.mMaterial = null;
            this.thisBlockType = BasicBlock.BlockTypes.STANDARD;
        }
    }

    public int getBlockTypeMeta() {
        if (this.thisBlockType.equals((Object)BasicBlock.BlockTypes.STANDARD)) {
            return 0;
        }
        if (this.thisBlockType.equals((Object)BasicBlock.BlockTypes.FRAME)) {
            return 1;
        }
        if (this.thisBlockType.equals((Object)BasicBlock.BlockTypes.ORE)) {
            return 2;
        }
        return 0;
    }

    public String getUnlocalizedBlockName() {
        return "block." + this.mMaterial.getUnlocalizedName() + "." + this.thisBlockType.name().toLowerCase();
    }

    public String GetProperName() {
        String tempIngot = sNameCache.get(this.getUnlocalizedBlockName());
        if (tempIngot == null) {
            tempIngot = "BAD.UNLOCAL.NAME";
        }
        return tempIngot;
    }

    public String func_77653_i(ItemStack stack) {
        return this.thisBlock.func_149732_F();
    }

    public int getRenderColor(int aMeta) {
        return this.blockColour;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        Block b;
        if (this.mMaterial != null) {
            list.add(this.mMaterial.vChemicalFormula);
        } else {
            try {
                BlockBaseModular g = (BlockBaseModular)this.thisBlock;
                this.mMaterial = g.getMaterialEx();
            }
            catch (Throwable g) {
                // empty catch block
            }
        }
        if (this.isOre) {
            if (KeyboardUtils.isCtrlKeyDown()) {
                b = Block.func_149634_a((Item)stack.func_77973_b());
                if (b != null) {
                    String aTool = b.getHarvestTool(stack.func_77960_j());
                    int aMiningLevel1 = b.getHarvestLevel(stack.func_77960_j());
                    if (this.mMaterial != null) {
                        list.add("Mining Level: " + Math.min(Math.max(aMiningLevel1, 0), 5));
                        list.add("Contains:    ");
                        if (this.mMaterial.getComposites().isEmpty()) {
                            list.add("- " + this.mMaterial.getLocalizedName());
                        } else {
                            for (MaterialStack m : this.mMaterial.getComposites()) {
                                list.add("- " + m.getStackMaterial().getLocalizedName() + " x" + m.getPartsPerOneHundred());
                            }
                        }
                    }
                }
            } else {
                list.add(EnumChatFormatting.DARK_GRAY + "Hold Ctrl to show additional info.");
            }
        } else {
            b = Block.func_149634_a((Item)stack.func_77973_b());
            if (b != null) {
                String aTool = b.getHarvestTool(stack.func_77960_j());
                int aMiningLevel1 = b.getHarvestLevel(stack.func_77960_j());
                list.add("Mining Level: " + Math.min(Math.max(aMiningLevel1, 0), 5));
            }
        }
        if (this.mMaterial != null && this.mMaterial.vRadiationLevel > 0) {
            list.add(GTPPCore.GT_Tooltip_Radioactive.get());
        }
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    public void func_77663_a(ItemStack iStack, World world, Entity entityHolding, int p_77663_4_, boolean p_77663_5_) {
        if (!this.isModular && !this.isOre) {
            this.mMaterial = null;
        } else {
            if (this.mMaterial == null) {
                Block b = Block.func_149634_a((Item)iStack.func_77973_b());
                this.mMaterial = this.isOre ? ((BlockBaseOre)b).getMaterialEx() : ((BlockBaseModular)b).getMaterialEx();
                this.sRadiation = this.mMaterial != null ? (int)this.mMaterial.vRadiationLevel : 0;
            }
            if (this.sRadiation > 0) {
                EntityUtils.applyRadiationDamageToEntity(iStack.field_77994_a, this.sRadiation, world, entityHolding);
            }
        }
    }
}

