/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ProcessingStone
implements IOreRecipeRegistrator {
    public ProcessingStone() {
        OrePrefixes.stone.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        Block aBlock = GTUtility.getBlockFromStack(aStack);
        switch (aMaterial.mName) {
            case "NULL": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), new ItemStack(Blocks.field_150429_aA, 2)).itemOutputs(new ItemStack(Items.field_151107_aW, 1)).fluidInputs(Materials.Redstone.getMolten(144L)).duration(100).eut(48).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case "Sand": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(new ItemStack((Block)Blocks.field_150354_m, 1, 0)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Endstone": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, Materials.Endstone, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Tungstate, 1L)).outputChances(10000, 500).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Netherrack": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, Materials.Netherrack, 1L), GTOreDictUnificator.get(OrePrefixes.nugget, Materials.Gold, 1L)).outputChances(10000, 500).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "NetherBrick": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(new ItemStack(Blocks.field_150386_bk, 1)).duration(100).eut(4).addTo(RecipeMaps.assemblerRecipes);
                break;
            }
            case "Obsidian": {
                if (aBlock == Blocks.field_150350_a) break;
                aBlock.func_149752_b(20.0f);
                break;
            }
            case "Concrete": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, 18)))).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(GTModHandler.getDistilledWater(Math.max(3, Math.min(750, 14)))).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, 2)))).duration(100).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Rhyolite": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.PotassiumFeldspar, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Quartz, 1L)).outputChances(10000, 2000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Komatiite": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.Biotite, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Uranium, 1L)).outputChances(10000, 500).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Dacite": 
            case "Andesite": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.SiliconDioxide, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Obsidian, 1L)).outputChances(10000, 2000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Gabbro": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.PotassiumFeldspar, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Pyrite, 1L)).outputChances(10000, 2000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Eclogite": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.SiliconDioxide, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Rutile, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Soapstone": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, Materials.Talc, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.Chromite, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Greenschist": 
            case "Blueschist": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Glauconite, 2L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Basalt, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Gneiss": 
            case "Migmatite": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dust, Materials.SiliconDioxide, 1L), GTOreDictUnificator.get(OrePrefixes.dustImpure, Materials.GraniteBlack, 1L)).outputChances(10000, 5000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Redrock": 
            case "Marble": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, 37)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(GTModHandler.getDistilledWater(Math.max(3, Math.min(750, 28)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, 4)))).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
            }
            case "Basalt": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, 37)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(GTModHandler.getDistilledWater(Math.max(3, Math.min(750, 28)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, 4)))).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
            }
            case "Quartzite": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).outputChances(10000, 1000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "Flint": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 2L), new ItemStack(Items.field_151145_ak, 1)).outputChances(10000, 5000).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "GraniteBlack": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, 37)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(GTModHandler.getDistilledWater(Math.max(3, Math.min(750, 28)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, 4)))).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dust, Materials.Thorium, 1L)).outputChances(10000, 100).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
                break;
            }
            case "GraniteRed": {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Water.getFluid(Math.max(4, Math.min(1000, 37)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(GTModHandler.getDistilledWater(Math.max(3, Math.min(750, 28)))).duration(400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).fluidInputs(Materials.Lubricant.getFluid(Math.max(1, Math.min(250, 4)))).duration(200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.cutterRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.dustImpure, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, Materials.Uranium, 1L)).outputChances(10000, 100).duration(400).eut(2).addTo(RecipeMaps.maceratorRecipes);
            }
        }
    }
}

