/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.interfaces.ITexture;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.CoverBehavior;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.common.covers.CoverLens;
import net.minecraft.item.ItemStack;

public class ProcessingLens
implements IOreRecipeRegistrator {
    public ProcessingLens() {
        OrePrefixes.lens.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aMaterial.mName) {
            case "Diamond": 
            case "Glass": {
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L)).duration(1200).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.latheRecipes);
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.lens, aMaterial, 3L), GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L)).duration(2400).eut(16).addTo(RecipeMaps.latheRecipes);
                break;
            }
            case "ChromaticGlass": {
                GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 16L)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L)).duration(12000).eut(TierEU.RECIPE_UHV).addTo(RecipeMaps.compressorRecipes);
                break;
            }
            default: {
                GTRecipeBuilder recipeBuilder;
                if (GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                    recipeBuilder = GTValues.RA.stdBuilder();
                    recipeBuilder.itemInputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L));
                    if (GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L) == null) {
                        recipeBuilder.itemOutputs(GTOreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L));
                    } else {
                        recipeBuilder.itemOutputs(GTOreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L));
                    }
                    recipeBuilder.duration(1200).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.latheRecipes);
                }
                if (GTOreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L) != null) {
                    recipeBuilder = GTValues.RA.stdBuilder();
                    recipeBuilder.itemInputs(GTOreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L));
                    if (GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L) == null) {
                        recipeBuilder.itemOutputs(GTOreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L));
                    } else {
                        recipeBuilder.itemOutputs(GTOreDictUnificator.get(OrePrefixes.lens, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 2L));
                    }
                    recipeBuilder.duration(2400).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.latheRecipes);
                }
                ITexture lensCoverTexture = TextureFactory.of(Textures.BlockIcons.OVERLAY_LENS, aMaterial.mRGBa, false);
                GregTechAPI.registerCover(aStack, TextureFactory.of(Textures.BlockIcons.MACHINE_CASINGS[2][0], lensCoverTexture), (CoverBehavior)new CoverLens(aMaterial.mColor.mIndex, lensCoverTexture));
            }
        }
    }
}

