/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import gregtech.common.GTProxy;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ProcessingGem
implements IOreRecipeRegistrator {
    public ProcessingGem() {
        OrePrefixes.gem.add(this);
        OrePrefixes.gemChipped.add(this);
        OrePrefixes.gemExquisite.add(this);
        OrePrefixes.gemFlawed.add(this);
        OrePrefixes.gemFlawless.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        long aMaterialMass = aMaterial.getMass();
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aNoWorking = aMaterial.contains(SubTag.NO_WORKING);
        boolean aNoSmelting = aMaterial.contains(SubTag.NO_SMELTING);
        boolean aSpecialRecipeReq = aMaterial.contains(SubTag.MORTAR_GRINDABLE);
        boolean aFuelPower = aMaterial.mFuelPower > 0;
        switch (aPrefix) {
            case gem: {
                if (aFuelPower) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower * 2).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (!OrePrefixes.block.isIgnored(aMaterial) && GTOreDictUnificator.get(OrePrefixes.block, aMaterial, 1L) != null && aMaterial != Materials.Iridium) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.block, aMaterial, 1L)).duration(300).eut(2).addTo(RecipeMaps.compressorRecipes);
                }
                if (!aNoSmelting) {
                    GTModHandler.addSmeltingRecipe(GTUtility.copyAmount(1, aStack), GTOreDictUnificator.get(OrePrefixes.ingot, aMaterial.mSmeltInto, 1L));
                }
                if (aNoSmashing) {
                    if (GTOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(aStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 2L)).duration(64).eut(16).addTo(RecipeMaps.hammerRecipes);
                    }
                } else {
                    if (GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null && aMaterial != Materials.Iridium) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).duration(Math.max(aMaterialMass, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.hammerRecipes);
                    }
                    if (aMaterial != Materials.Iridium) {
                        if (GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L)).duration((int)Math.max(aMaterialMass * 2L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 24)).addTo(RecipeMaps.benderRecipes);
                        }
                        if (GTOreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(2, aStack), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateDouble, aMaterial, 1L)).duration(Math.max(aMaterialMass * 2L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                        }
                        if (GTOreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateTriple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 3L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                        }
                        if (GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(4, aStack), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 4L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                        }
                        if (GTOreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(5, aStack), GTUtility.getIntegratedCircuit(5)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateQuintuple, aMaterial, 1L)).duration(Math.max(aMaterialMass * 5L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                        }
                        if (GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(9, aStack), GTUtility.getIntegratedCircuit(9)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L)).duration(Math.max(aMaterialMass * 9L, 1L)).eut(GTUtility.calculateRecipeEU(aMaterial, 96)).addTo(RecipeMaps.benderRecipes);
                        }
                    }
                }
                if (aNoWorking) {
                    if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV && GTOreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stick, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 2L)).duration((int)Math.max(aMaterialMass, 1L) * 1).eut(GTUtility.calculateRecipeEU(aMaterial, 16)).addTo(RecipeMaps.latheRecipes);
                    }
                } else if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                    if (GTOreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 8).addTo(RecipeMaps.implosionRecipes);
                    }
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 2L), GTProxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gemFlawless.get(aMaterial)});
                    if (aMaterial.contains(SubTag.SMELTING_TO_GEM)) {
                        GTModHandler.addCraftingRecipe(GTUtility.copyAmount(1, aStack), GTProxy.tBits, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), OrePrefixes.nugget.get(aMaterial)});
                    }
                    if (aSpecialRecipeReq) {
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GTProxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                    }
                }
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    if (GTOreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L) == null) continue;
                    is.field_77994_a = 0;
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), is).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 1L)).duration(1200).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.laserEngraverRecipes);
                }
                break;
            }
            case gemChipped: {
                if (aFuelPower) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower / 2).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (!aNoWorking) {
                    if (GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, aMaterial, 1L)).duration((int)Math.max(aMaterialMass, 1L) * 1).eut(8).addTo(RecipeMaps.latheRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                        if (GTOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 8).addTo(RecipeMaps.implosionRecipes);
                        }
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, 2L), GTProxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gemFlawed.get(aMaterial)});
                        if (aSpecialRecipeReq) {
                            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L), GTProxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemChipped.get(aMaterial)});
                        }
                    }
                }
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    is.field_77994_a = 0;
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), is).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 1L)).duration(600).eut(30).addTo(RecipeMaps.laserEngraverRecipes);
                }
                break;
            }
            case gemExquisite: {
                if (aFuelPower) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower * 8).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (!aNoWorking && aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && aSpecialRecipeReq) {
                    GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 4L), GTProxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemExquisite.get(aMaterial)});
                }
                GTValues.RA.stdBuilder().itemInputs(aStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 2L)).duration(64).eut(16).addTo(RecipeMaps.hammerRecipes);
                break;
            }
            case gemFlawed: {
                if (aFuelPower) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (!aNoWorking) {
                    if (GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.bolt, aMaterial, 2L), GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 1L)).duration((int)Math.max(aMaterialMass, 1L) * 1).eut(12).addTo(RecipeMaps.latheRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                        if (GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 8).addTo(RecipeMaps.implosionRecipes);
                        }
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.gemFlawed, aMaterial, 2L), GTProxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                        if (aSpecialRecipeReq) {
                            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.dustSmall, aMaterial, 2L), GTProxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemFlawed.get(aMaterial)});
                        }
                    }
                }
                GTValues.RA.stdBuilder().itemInputs(aStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemChipped, aMaterial, 2L)).duration(64).eut(16).addTo(RecipeMaps.hammerRecipes);
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    is.field_77994_a = 0;
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), is).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 1L)).duration(600).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.laserEngraverRecipes);
                }
                break;
            }
            case gemFlawless: {
                if (aFuelPower) {
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).metadata(GTRecipeConstants.FUEL_VALUE, aMaterial.mFuelPower * 4).metadata(GTRecipeConstants.FUEL_TYPE, aMaterial.mFuelType).addTo(GTRecipeConstants.Fuel);
                }
                if (!aNoWorking) {
                    if (GTOreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L) != null) {
                        GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.stickLong, aMaterial, 1L), GTOreDictUnificator.getDust(aMaterial, aPrefix.mMaterialAmount - OrePrefixes.stickLong.mMaterialAmount)).duration((int)Math.max(aMaterialMass * 5L, 1L) * 1).eut(16).addTo(RecipeMaps.latheRecipes);
                    }
                    if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
                        if (GTOreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L) != null) {
                            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L), GTOreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 2L)).duration(20).eut(TierEU.RECIPE_LV).metadata(GTRecipeConstants.ADDITIVE_AMOUNT, 8).addTo(RecipeMaps.implosionRecipes);
                        }
                        GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.gemFlawless, aMaterial, 2L), GTProxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gemExquisite.get(aMaterial)});
                        if (aSpecialRecipeReq) {
                            GTModHandler.addCraftingRecipe(GTOreDictUnificator.get(OrePrefixes.dust, aMaterial, 2L), GTProxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.gemFlawless.get(aMaterial)});
                        }
                    }
                }
                GTValues.RA.stdBuilder().itemInputs(aStack).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gem, aMaterial, 2L)).duration(64).eut(16).addTo(RecipeMaps.hammerRecipes);
                for (ItemStack is : OreDictionary.getOres((String)("craftingLens" + aMaterial.mColor.mName.replace(" ", "")))) {
                    is.field_77994_a = 0;
                    GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(3, aStack), is).itemOutputs(GTOreDictUnificator.get(OrePrefixes.gemExquisite, aMaterial, 1L)).duration(2400).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.laserEngraverRecipes);
                }
                break;
            }
        }
    }
}

