/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import galacticgreg.api.enums.DimensionDef;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.util.GTLog;
import gregtech.api.world.GTWorldgen;
import gregtech.common.OreMixBuilder;
import gregtech.common.blocks.TileEntityOres;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldgenGTOreLayer
extends GTWorldgen {
    public static ArrayList<WorldgenGTOreLayer> sList = new ArrayList();
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public final short mPrimaryMeta;
    public final short mSecondaryMeta;
    public final short mBetweenMeta;
    public final short mSporadicMeta;
    public final String mRestrictBiome;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;
    public final boolean mEndAsteroid;
    public final boolean twilightForest;
    public static final int WRONG_BIOME = 0;
    public static final int WRONG_DIMENSION = 1;
    public static final int NO_ORE_IN_BOTTOM_LAYER = 2;
    public static final int NO_OVERLAP = 3;
    public static final int ORE_PLACED = 4;
    public static final int NO_OVERLAP_AIR_BLOCK = 5;
    public final String aTextWorldgen = "worldgen.";
    public Class[] mAllowedProviders;

    public WorldgenGTOreLayer(OreMixBuilder mix) {
        super(mix.oreMixName, sList, mix.enabledByDefault);
        this.mOverworld = mix.dimsEnabled.getOrDefault("Overworld", false);
        this.mNether = mix.dimsEnabled.getOrDefault("Nether", false);
        this.mEnd = mix.dimsEnabled.getOrDefault("TheEnd", false);
        this.mEndAsteroid = mix.dimsEnabled.getOrDefault(DimensionDef.EndAsteroids.modDimensionDef.getDimensionName(), false);
        this.twilightForest = mix.dimsEnabled.getOrDefault("Twilight Forest", false);
        this.mMinY = (short)mix.minY;
        short mMaxY = (short)mix.maxY;
        if (mMaxY < this.mMinY + 9) {
            GTLog.out.println("Oremix " + this.mWorldGenName + " has invalid Min/Max heights!");
            mMaxY = (short)(this.mMinY + 9);
        }
        this.mMaxY = mMaxY;
        this.mWeight = (short)mix.weight;
        this.mDensity = (short)mix.density;
        this.mSize = (short)Math.max(1, mix.size);
        this.mPrimaryMeta = (short)mix.primary.mMetaItemSubID;
        this.mSecondaryMeta = (short)mix.secondary.mMetaItemSubID;
        this.mBetweenMeta = (short)mix.between.mMetaItemSubID;
        this.mSporadicMeta = (short)mix.sporadic.mMetaItemSubID;
        this.mRestrictBiome = "None";
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
        ArrayList<Class<WorldProviderEnd>> allowedProviders = new ArrayList<Class<WorldProviderEnd>>();
        if (this.mNether) {
            allowedProviders.add(WorldProviderHell.class);
        }
        if (this.mOverworld) {
            allowedProviders.add(WorldProviderSurface.class);
        }
        if (this.mEnd) {
            allowedProviders.add(WorldProviderEnd.class);
        }
        this.mAllowedProviders = allowedProviders.toArray(new Class[allowedProviders.size()]);
    }

    @Override
    public int executeWorldgenChunkified(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, int aSeedX, int aSeedZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        int placeZ;
        int tZ;
        int placeX;
        int tX;
        int sZ;
        if (this.mWorldGenName.equals("NoOresInVein")) {
            if (GTValues.debugOrevein) {
                GTLog.out.println(" NoOresInVein");
            }
            return 4;
        }
        if (!this.isGenerationAllowed(aWorld, this.mAllowedProviders)) {
            return 1;
        }
        if (!this.mRestrictBiome.equals("None") && !this.mRestrictBiome.equals(aBiome)) {
            return 0;
        }
        String tDimensionName = aWorld.field_73011_w.func_80007_l();
        boolean isUnderdark = tDimensionName.equals("Underdark");
        int[] placeCount = new int[4];
        int tMinY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int wXVein = aSeedX - aRandom.nextInt(this.mSize);
        int eXVein = aSeedX + 16 + aRandom.nextInt(this.mSize);
        int wX = Math.max(wXVein, aChunkX + 2);
        int eX = Math.min(eXVein, aChunkX + 2 + 16);
        Block tBlock = aWorld.func_147439_a(aChunkX + 7, tMinY, aChunkZ + 9);
        if (wX >= eX) {
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.field_150377_bs) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTechAPI.sBlockGranites) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTechAPI.sBlockStones)) {
                return 3;
            }
            return 5;
        }
        int nZVein = aSeedZ - aRandom.nextInt(this.mSize);
        int sZVein = aSeedZ + 16 + aRandom.nextInt(this.mSize);
        int nZ = Math.max(nZVein, aChunkZ + 2);
        if (nZ >= (sZ = Math.min(sZVein, aChunkZ + 2 + 16))) {
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.field_150348_b) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.field_150424_aL) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.field_150377_bs) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTechAPI.sBlockGranites) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTechAPI.sBlockStones)) {
                return 3;
            }
            return 5;
        }
        if (GTValues.debugOrevein) {
            GTLog.out.print("Trying Orevein:" + this.mWorldGenName + " Dimension=" + tDimensionName + " mX=" + aChunkX / 16 + " mZ=" + aChunkZ / 16 + " oreseedX=" + aSeedX / 16 + " oreseedZ=" + aSeedZ / 16 + " cY=" + tMinY);
        }
        int localDensity = Math.max(1, this.mDensity / (int)Math.sqrt(2.0 + Math.pow(aChunkX / 16 - aSeedX / 16, 2.0) + Math.pow(aChunkZ / 16 - aSeedZ / 16, 2.0)));
        int level = tMinY - 1;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (placeCount[1] + placeCount[3] == 0) {
            if (GTValues.debugOrevein) {
                GTLog.out.println(" No ore in bottom layer");
            }
            return 2;
        }
        for (level = tMinY; level < tMinY + 2; ++level) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                    if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta > 0) {
                        if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, isUnderdark)) continue;
                        placeCount[1] = placeCount[1] + 1;
                        continue;
                    }
                    if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
        }
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(wXVein - tX)), MathHelper.func_76130_a((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(sZVein - tZ)), MathHelper.func_76130_a((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !TileEntityOres.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (GTValues.oreveinPlacerOres) {
            int nSmallOres = (eX - wX) * (sZ - nZ) * this.mDensity / 10 * GTValues.oreveinPlacerOresMultiplier;
            for (int nSmallOresCount = 0; nSmallOresCount < nSmallOres; ++nSmallOresCount) {
                int tX2 = aRandom.nextInt(16) + aChunkX + 2;
                int tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                int tY = aRandom.nextInt(160) + 10;
                if (this.mPrimaryMeta > 0) {
                    TileEntityOres.setOreBlock(aWorld, tX2, tY, tZ2, this.mPrimaryMeta, true, isUnderdark);
                }
                tX2 = aRandom.nextInt(16) + aChunkX + 2;
                tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                tY = aRandom.nextInt(160) + 10;
                if (this.mSecondaryMeta > 0) {
                    TileEntityOres.setOreBlock(aWorld, tX2, tY, tZ2, this.mSecondaryMeta, true, isUnderdark);
                }
                tX2 = aRandom.nextInt(16) + aChunkX + 2;
                tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                tY = aRandom.nextInt(160) + 10;
                if (this.mBetweenMeta > 0) {
                    TileEntityOres.setOreBlock(aWorld, tX2, tY, tZ2, this.mBetweenMeta, true, isUnderdark);
                }
                tX2 = aRandom.nextInt(16) + aChunkX + 2;
                tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                tY = aRandom.nextInt(190) + 10;
                if (this.mSporadicMeta <= 0) continue;
                TileEntityOres.setOreBlock(aWorld, tX2, tY, tZ2, this.mSporadicMeta, true, isUnderdark);
            }
        }
        if (GTValues.debugOrevein) {
            GTLog.out.println(" wXVein" + wXVein + " eXVein" + eXVein + " nZVein" + nZVein + " sZVein" + sZVein + " locDen=" + localDensity + " Den=" + this.mDensity + " Sec=" + placeCount[1] + " Spo=" + placeCount[3] + " Bet=" + placeCount[2] + " Pri=" + placeCount[0]);
        }
        return 4;
    }
}

