/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.common.misc.GlobalVariableStorage;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import java.util.UUID;
import tectech.mechanics.dataTransport.QuantumDataPacket;

public class WirelessComputationPacket {
    public boolean wirelessEnabled = false;
    private final long[] computationStored = new long[]{0L, 0L};
    private long computationDownloaded = 0L;
    private int currentIndex = 0;
    public Vec3Impl controllerPosition = null;

    public long getTotalComputationStored() {
        return this.computationStored[0] + this.computationStored[1];
    }

    private long getAvailableComputationStored() {
        return this.getTotalComputationStored() - this.computationDownloaded;
    }

    private QuantumDataPacket download(long dataIn, long aTick) {
        if (!this.wirelessEnabled || this.controllerPosition == null) {
            return new QuantumDataPacket(0L);
        }
        if (this.getAvailableComputationStored() >= dataIn) {
            this.computationDownloaded += dataIn;
            return new QuantumDataPacket(dataIn);
        }
        return new QuantumDataPacket(0L);
    }

    private void update(IGregTechTileEntity entity, long aTick) {
        int nextIndex = (this.currentIndex + 1) % 2;
        long availableInPrevious = this.computationStored[nextIndex];
        this.computationStored[nextIndex] = 0L;
        if (this.computationDownloaded > availableInPrevious) {
            long toDrainFromCurrent = this.computationDownloaded - availableInPrevious;
            int n = this.currentIndex;
            this.computationStored[n] = this.computationStored[n] - toDrainFromCurrent;
        }
        this.computationDownloaded = 0L;
        this.currentIndex = nextIndex;
    }

    private void setWirelessEnabled(boolean wirelessEnabled) {
        this.wirelessEnabled = wirelessEnabled;
    }

    private void upload(long dataOut, long aTick) {
        int n = this.currentIndex;
        this.computationStored[n] = this.computationStored[n] + dataOut;
    }

    public static QuantumDataPacket downloadData(UUID userId, long dataIn, long aTick) {
        return WirelessComputationPacket.getPacketByUserId(userId).download(dataIn, aTick);
    }

    public static void uploadData(UUID userId, long dataOut, long aTick) {
        WirelessComputationPacket.getPacketByUserId(userId).upload(dataOut, aTick);
    }

    public static void updatePacket(IGregTechTileEntity entity, long aTick) {
        WirelessComputationPacket.getPacketByUserId(entity.getOwnerUuid()).update(entity, aTick);
    }

    public static boolean enableWirelessNetWork(IGregTechTileEntity entity) {
        WirelessComputationPacket packet = WirelessComputationPacket.getPacketByUserId(entity.getOwnerUuid());
        Vec3Impl pos = new Vec3Impl(entity.getXCoord(), (int)entity.getYCoord(), entity.getZCoord());
        if (packet.wirelessEnabled && packet.controllerPosition != null && pos.compareTo(packet.controllerPosition) != 0) {
            return false;
        }
        WirelessComputationPacket.getPacketByUserId(entity.getOwnerUuid()).setWirelessEnabled(true);
        if (packet.controllerPosition == null) {
            packet.controllerPosition = new Vec3Impl(entity.getXCoord(), (int)entity.getYCoord(), entity.getZCoord());
        }
        return true;
    }

    public static void disableWirelessNetWork(IGregTechTileEntity entity) {
        WirelessComputationPacket packet = WirelessComputationPacket.getPacketByUserId(entity.getOwnerUuid());
        Vec3Impl pos = new Vec3Impl(entity.getXCoord(), (int)entity.getYCoord(), entity.getZCoord());
        if (packet.controllerPosition != null && packet.controllerPosition.compareTo(pos) != 0) {
            return;
        }
        WirelessComputationPacket.getPacketByUserId(entity.getOwnerUuid()).setWirelessEnabled(false);
    }

    public static WirelessComputationPacket getPacketByUserId(UUID userId) {
        UUID team = SpaceProjectManager.getLeader(userId);
        if (GlobalVariableStorage.GlobalWirelessComputation.get(team) == null) {
            GlobalVariableStorage.GlobalWirelessComputation.put(team, new WirelessComputationPacket());
        }
        return GlobalVariableStorage.GlobalWirelessComputation.get(team);
    }
}

