/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm;

import bartworks.common.configs.Configuration;
import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import gregtech.mixin.Mixin;
import gtPlusPlus.core.config.ASMConfiguration;
import gtPlusPlus.preloader.PreloaderCore;
import gtPlusPlus.preloader.asm.PreloaderDummyContainer;
import gtPlusPlus.preloader.asm.transformers.Preloader_Transformer_Handler;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

@IFMLLoadingPlugin.SortingIndex(value=0x7FFFFFFF)
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
@IFMLLoadingPlugin.TransformerExclusions(value={"bartworks.ASM", "gtPlusPlus.preloader", "gregtech.asm"})
@IFMLLoadingPlugin.Name(value="GregTech 5 Unofficial core plugin")
public class GTCorePlugin
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static File minecraftDir;
    private static Boolean islwjgl3Present;

    public GTCorePlugin() {
        if (minecraftDir != null) {
            return;
        }
        minecraftDir = (File)FMLInjectionData.data()[6];
    }

    public String[] getASMTransformerClass() {
        return new String[]{Preloader_Transformer_Handler.class.getName()};
    }

    public String getModContainerClass() {
        return PreloaderDummyContainer.class.getName();
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
        PreloaderCore.DEV_ENVIRONMENT = (Boolean)data.get("runtimeDeobfuscationEnabled") == false;
        File mcDir = (File)data.get("mcLocation");
        if (mcDir != null && mcDir.exists()) {
            PreloaderCore.setMinecraftDirectory(mcDir);
        }
        PreloaderCore.DEBUG_MODE = ASMConfiguration.debug.debugMode;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public String getMixinConfig() {
        return "mixins.gregtech.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        return Mixin.getEarlyMixins(loadedCoreMods);
    }

    public static boolean islwjgl3Present() {
        if (islwjgl3Present == null) {
            try {
                String className = "org/lwjgl/system/Platform.class";
                islwjgl3Present = ClassLoader.getSystemClassLoader().getResource("org/lwjgl/system/Platform.class") != null;
            }
            catch (Exception e) {
                islwjgl3Present = Boolean.FALSE;
            }
        }
        return islwjgl3Present;
    }

    static {
        try {
            ConfigurationManager.registerConfig(Configuration.class);
            ConfigurationManager.registerConfig(ASMConfiguration.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
        islwjgl3Present = null;
    }
}

