/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.HatchElementBuilder;
import gregtech.api.util.IGTHatchAdder;
import gregtech.common.blocks.BlockCasings5;
import gregtech.common.blocks.BlockCyclotronCoils;
import gregtech.common.blocks.BlockFrameBox;
import gregtech.common.blocks.ItemMachines;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class GTStructureUtility {
    private GTStructureUtility() {
        throw new AssertionError((Object)"Not instantiable");
    }

    public static boolean hasMTE(IGregTechTileEntity aTile, Class<? extends IMetaTileEntity> clazz) {
        return aTile != null && clazz.isInstance(aTile.getMetaTileEntity());
    }

    public static <T> IStructureElementNoPlacement<T> ofHatchAdder(IGTHatchAdder<T> aHatchAdder, int aTextureIndex, int aDots) {
        return GTStructureUtility.ofHatchAdder(aHatchAdder, aTextureIndex, StructureLibAPI.getBlockHint(), aDots - 1);
    }

    public static <T> IStructureElement<T> ofFrame(final Materials aFrameMaterial) {
        if (aFrameMaterial == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){
            private IIcon[] mIcons;

            public boolean check(T t, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                if (block instanceof BlockFrameBox) {
                    BlockFrameBox frameBox = (BlockFrameBox)block;
                    int meta = world.func_72805_g(x, y, z);
                    Materials material = BlockFrameBox.getMaterial(meta);
                    return aFrameMaterial == material;
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.mIcons == null) {
                    this.mIcons = new IIcon[6];
                    Arrays.fill(this.mIcons, aFrameMaterial.mIconSet.mTextures[OrePrefixes.frameGt.mTextureIndex].getIcon());
                }
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.mIcons, (short[])aFrameMaterial.mRGBa);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                Item item;
                ItemStack tFrameStack = this.getFrameStack();
                if (!GTUtility.isStackValid(tFrameStack) || !((item = tFrameStack.func_77973_b()) instanceof ItemBlock)) {
                    return false;
                }
                ItemBlock tFrameStackItem = (ItemBlock)item;
                return tFrameStackItem.placeBlockAt(tFrameStack, null, world, x, y, z, 6, 0.0f, 0.0f, 0.0f, Items.field_151008_G.getDamage(tFrameStack));
            }

            private ItemStack getFrameStack() {
                return GTOreDictUnificator.get(OrePrefixes.frameGt, aFrameMaterial, 1L);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                ItemStack tFrameStack = this.getFrameStack();
                if (!GTUtility.isStackValid(tFrameStack) || !(tFrameStack.func_77973_b() instanceof ItemBlock)) {
                    return IStructureElement.BlocksToPlace.errored;
                }
                return IStructureElement.BlocksToPlace.create((ItemStack)tFrameStack);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                ItemStack tFrameStack = this.getFrameStack();
                if (!GTUtility.isStackValid(tFrameStack) || !(tFrameStack.func_77973_b() instanceof ItemBlock)) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                return StructureUtility.survivalPlaceBlock((ItemStack)tFrameStack, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.IGNORE_KNOWN_INSIGNIFICANT_TAGS, null, (boolean)false, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public static <T> HatchElementBuilder<T> buildHatchAdder() {
        return HatchElementBuilder.builder();
    }

    public static <T> HatchElementBuilder<T> buildHatchAdder(Class<T> typeToken) {
        return HatchElementBuilder.builder();
    }

    public static <T> IStructureElementNoPlacement<T> ofHatchAdder(final IGTHatchAdder<T> aHatchAdder, final int aTextureIndex, final Block aHintBlock, final int aHintMeta) {
        if (aHatchAdder == null || aHintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && aHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)aTextureIndex);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aHintBlock, (int)aHintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofHatchAdder(final IGTHatchAdder<T> aHatchAdder, final int aTextureIndex, final Block aHintBlock, final int aHintMeta, final BiPredicate<T, IGregTechTileEntity> shouldSkip, final Function<T, Class<? extends IMetaTileEntity>> aMetaId, final IStructureElement.PlaceResult acceptType) {
        if (aHatchAdder == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && aHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)aTextureIndex);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aHintBlock, (int)aHintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int i, int i1, int i2, ItemStack itemStack) {
                return false;
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                Class clazz = (Class)aMetaId.apply(t);
                if (clazz == null) {
                    return IStructureElement.BlocksToPlace.createEmpty();
                }
                return IStructureElement.BlocksToPlace.create(is -> clazz.isInstance(ItemMachines.getMetaTileEntity(is)));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                TileEntity tileEntity;
                if (shouldSkip != null && (tileEntity = world.func_147438_o(x, y, z)) instanceof IGregTechTileEntity && shouldSkip.test(t, (IGregTechTileEntity)tileEntity)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)env.getActor())) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                Class clazz = (Class)aMetaId.apply(t);
                if (clazz == null) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                ItemStack taken = env.getSource().takeOne(is -> clazz.isInstance(ItemMachines.getMetaTileEntity(is)), true);
                if (GTUtility.isStackInvalid(taken)) {
                    env.getChatter().accept(new ChatComponentTranslation("GT5U.autoplace.error.no_mte.class_name", new Object[]{clazz.getSimpleName()}));
                    return IStructureElement.PlaceResult.REJECT;
                }
                if (StructureUtility.survivalPlaceBlock((ItemStack)taken, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, null, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor()) == IStructureElement.PlaceResult.ACCEPT) {
                    return acceptType;
                }
                return IStructureElement.PlaceResult.REJECT;
            }
        };
    }

    public static <T> IStructureElement<T> ofHatchAdder(final IGTHatchAdder<T> aHatchAdder, final int aTextureIndex, final Block aHintBlock, final int aHintMeta, final BiPredicate<T, IGregTechTileEntity> shouldSkip, final ToIntFunction<T> aMetaId) {
        if (aHatchAdder == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && aHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)aTextureIndex);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aHintBlock, (int)aHintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int i, int i1, int i2, ItemStack itemStack) {
                return false;
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                ItemMachines item = (ItemMachines)Item.func_150898_a((Block)GregTechAPI.sBlockMachines);
                int meta = aMetaId.applyAsInt(t);
                if (meta < 0) {
                    return IStructureElement.BlocksToPlace.createEmpty();
                }
                return IStructureElement.BlocksToPlace.create((Predicate)ItemStackPredicate.from((Item)item).setMeta(meta));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                TileEntity tileEntity;
                if (shouldSkip != null && (tileEntity = world.func_147438_o(x, y, z)) instanceof IGregTechTileEntity && shouldSkip.test(t, (IGregTechTileEntity)tileEntity)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                if (!StructureLibAPI.isBlockTriviallyReplaceable((World)world, (int)x, (int)y, (int)z, (EntityPlayer)env.getActor())) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                ItemMachines item = (ItemMachines)Item.func_150898_a((Block)GregTechAPI.sBlockMachines);
                int meta = aMetaId.applyAsInt(t);
                if (meta < 0) {
                    return IStructureElement.PlaceResult.REJECT;
                }
                ItemStack taken = env.getSource().takeOne((Predicate)ItemStackPredicate.from((Item)item).setMeta(meta), true);
                if (GTUtility.isStackInvalid(taken)) {
                    env.getChatter().accept(new ChatComponentTranslation("GT5U.autoplace.error.no_mte.id", new Object[]{meta}));
                    return IStructureElement.PlaceResult.REJECT;
                }
                return StructureUtility.survivalPlaceBlock((ItemStack)taken, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, null, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor()) == IStructureElement.PlaceResult.ACCEPT ? IStructureElement.PlaceResult.ACCEPT_STOP : IStructureElement.PlaceResult.REJECT;
            }
        };
    }

    public static <T> IStructureElement<T> ofHatchAdderOptional(IGTHatchAdder<T> aHatchAdder, int textureIndex, int dots, Block placeCasing, int placeCasingMeta) {
        return GTStructureUtility.ofHatchAdderOptional(aHatchAdder, textureIndex, StructureLibAPI.getBlockHint(), dots - 1, placeCasing, placeCasingMeta);
    }

    public static <T> IStructureElement<T> ofHatchAdderOptional(final IGTHatchAdder<T> aHatchAdder, final int aTextureIndex, final Block aHintBlock, final int hintMeta, final Block placeCasing, final int placeCasingMeta) {
        if (aHatchAdder == null || aHintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.func_147438_o(x, y, z);
                Block worldBlock = world.func_147439_a(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && aHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)aTextureIndex) || worldBlock == placeCasing && worldBlock.func_149643_k(world, x, y, z) == placeCasingMeta;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aHintBlock, (int)hintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, placeCasing, placeCasingMeta, 2);
                return true;
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)placeCasing, (int)placeCasingMeta, (World)world, (int)x, (int)y, (int)z, (IItemSource)s, (EntityPlayerMP)actor, chatter);
            }
        };
    }

    public static <T> IStructureElement<T> ofCoil(BiConsumer<T, HeatingCoilLevel> aHeatingCoilSetter, Function<T, HeatingCoilLevel> aHeatingCoilGetter) {
        return GTStructureUtility.ofCoil((T t, HeatingCoilLevel l) -> {
            aHeatingCoilSetter.accept((Object)t, (HeatingCoilLevel)((Object)l));
            return true;
        }, aHeatingCoilGetter);
    }

    public static <T> IStructureElement<T> ofCoil(final BiPredicate<T, HeatingCoilLevel> aHeatingCoilSetter, final Function<T, HeatingCoilLevel> aHeatingCoilGetter) {
        if (aHeatingCoilSetter == null || aHeatingCoilGetter == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                if (!(block instanceof IHeatingCoil)) {
                    return false;
                }
                HeatingCoilLevel existingLevel = (HeatingCoilLevel)((Object)aHeatingCoilGetter.apply(t));
                HeatingCoilLevel newLevel = ((IHeatingCoil)block).getCoilHeat(world.func_72805_g(x, y, z));
                if (existingLevel == null || existingLevel == HeatingCoilLevel.None) {
                    return aHeatingCoilSetter.test(t, newLevel);
                }
                return newLevel == existingLevel;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTechAPI.sBlockCasings5, (int)this.getMetaFromHint(trigger));
                return true;
            }

            private int getMetaFromHint(ItemStack trigger) {
                return BlockCasings5.getMetaFromCoilHeat(this.getHeatFromHint(trigger));
            }

            private HeatingCoilLevel getHeatFromHint(ItemStack trigger) {
                return HeatingCoilLevel.getFromTier((byte)Math.min(HeatingCoilLevel.getMaxTier(), Math.max(0, trigger.field_77994_a - 1)));
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, GregTechAPI.sBlockCasings5, this.getMetaFromHint(trigger), 3);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)GregTechAPI.sBlockCasings5, (int)this.getMetaFromHint(trigger));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                boolean isCoil;
                Block block = world.func_147439_a(x, y, z);
                boolean bl = isCoil = block instanceof IHeatingCoil && ((IHeatingCoil)block).getCoilHeat(world.func_72805_g(x, y, z)) == this.getHeatFromHint(trigger);
                if (isCoil) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)GregTechAPI.sBlockCasings5, (int)this.getMetaFromHint(trigger), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public static <T> IStructureElement<T> ofSolenoidCoil(BiConsumer<T, Byte> aSolenoidTierSetter, Function<T, Byte> aSolenoidTierGetter) {
        return GTStructureUtility.ofSolenoidCoil((T t, Byte l) -> {
            aSolenoidTierSetter.accept((Object)t, (Byte)l);
            return true;
        }, aSolenoidTierGetter);
    }

    public static <T> IStructureElement<T> ofSolenoidCoil(final BiPredicate<T, Byte> aSolenoidTierSetter, final Function<T, Byte> aSolenoidTierGetter) {
        if (aSolenoidTierSetter == null || aSolenoidTierGetter == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block block = world.func_147439_a(x, y, z);
                if (block != GregTechAPI.sSolenoidCoilCasings) {
                    return false;
                }
                BlockCyclotronCoils coils = (BlockCyclotronCoils)GregTechAPI.sSolenoidCoilCasings;
                Byte existingLevel = (Byte)aSolenoidTierGetter.apply(t);
                byte newLevel = (byte)coils.getVoltageTier(world.func_72805_g(x, y, z));
                if (existingLevel == null) {
                    return aSolenoidTierSetter.test(t, newLevel);
                }
                return newLevel == existingLevel;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTechAPI.sSolenoidCoilCasings, (int)this.getMetaFromHint(trigger));
                return true;
            }

            private int getMetaFromHint(ItemStack trigger) {
                return Math.min(Math.max(trigger.field_77994_a - 1, 0), 10);
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, GregTechAPI.sSolenoidCoilCasings, this.getMetaFromHint(trigger), 3);
            }

            public IStructureElement.BlocksToPlace getBlocksToPlace(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return IStructureElement.BlocksToPlace.create((Block)GregTechAPI.sSolenoidCoilCasings, (int)this.getMetaFromHint(trigger));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                boolean isCoil;
                Block block = world.func_147439_a(x, y, z);
                boolean bl = isCoil = block == GregTechAPI.sSolenoidCoilCasings && world.func_72805_g(x, y, z) == this.getMetaFromHint(trigger);
                if (isCoil) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)GregTechAPI.sSolenoidCoilCasings, (int)this.getMetaFromHint(trigger), (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    @Nonnull
    public static Predicate<ItemStack> filterByMTEClass(List<? extends Class<? extends IMetaTileEntity>> list) {
        return is -> {
            IMetaTileEntity tile = ItemMachines.getMetaTileEntity(is);
            return tile != null && list.stream().anyMatch(c -> c.isInstance(tile));
        };
    }

    @Nonnull
    public static Predicate<ItemStack> filterByMTETier(int aMinTier, int aMaxTier) {
        return is -> {
            IMetaTileEntity tile = ItemMachines.getMetaTileEntity(is);
            return tile instanceof MTETieredMachineBlock && ((MTETieredMachineBlock)tile).mTier <= aMaxTier && ((MTETieredMachineBlock)tile).mTier >= aMinTier;
        };
    }
}

