/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import ic2.api.reactor.IReactorComponent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GTRecipeRegistrator {
    public static final List<Materials> sRodMaterialList = new ArrayList<Materials>();
    private static final ItemStack sMt1 = new ItemStack(Blocks.field_150346_d, 1, 0);
    private static final ItemStack sMt2 = new ItemStack(Blocks.field_150346_d, 1, 0);
    private static final String s_H = "h";
    private static final String s_F = "f";
    private static final String s_I = "I";
    private static final String s_P = "P";
    private static final String s_R = "R";
    private static final RecipeShape[] sShapes = new RecipeShape[]{new RecipeShape(sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1, null), new RecipeShape(sMt1, null, sMt1, sMt1, null, sMt1, sMt1, sMt1, sMt1), new RecipeShape(null, sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, null, sMt1, null, null, null), new RecipeShape(sMt1, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, null, sMt1, sMt1, null, sMt1), new RecipeShape(null, null, null, sMt1, null, sMt1, sMt1, null, sMt1), new RecipeShape(null, sMt1, null, null, sMt1, null, null, sMt2, null), new RecipeShape(sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, null, null, sMt2, null, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, sMt1, null, sMt2, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, sMt1, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, null, sMt1, null, null, null, sMt1, sMt2), new RecipeShape(null, sMt1, null, null, null, sMt1, sMt2, sMt1, null), new RecipeShape(null, sMt1, null, sMt1, null, sMt1, null, null, sMt2), new RecipeShape(null, sMt1, null, sMt1, null, sMt1, sMt2, null, null), new RecipeShape(null, sMt2, null, null, sMt1, null, null, sMt1, null), new RecipeShape(null, sMt2, null, null, sMt2, null, sMt1, sMt1, sMt1), new RecipeShape(null, sMt2, null, null, sMt2, null, null, sMt1, null), new RecipeShape(null, sMt2, null, sMt1, sMt2, null, sMt1, sMt1, null), new RecipeShape(null, sMt2, null, null, sMt2, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, null, sMt2, null, sMt1, sMt1, null), new RecipeShape(sMt1, null, null, null, sMt2, null, null, null, sMt2), new RecipeShape(null, null, sMt1, null, sMt2, null, sMt2, null, null), new RecipeShape(sMt1, null, null, null, sMt2, null, null, null, null), new RecipeShape(null, null, sMt1, null, sMt2, null, null, null, null), new RecipeShape(sMt1, sMt2, null, null, null, null, null, null, null), new RecipeShape(sMt2, sMt1, null, null, null, null, null, null, null), new RecipeShape(sMt1, null, null, sMt2, null, null, null, null, null), new RecipeShape(sMt2, null, null, sMt1, null, null, null, null, null), new RecipeShape(sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt1, sMt2, sMt1, sMt1, null), new RecipeShape(null, sMt1, sMt1, sMt2, sMt1, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, sMt2, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt2, sMt2, sMt1, sMt1, null), new RecipeShape(null, sMt1, sMt1, sMt2, sMt2, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, sMt1, sMt2, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, null, null, null, sMt1, null, null, null, null), new RecipeShape(null, sMt1, null, sMt1, null, null, null, null, null), new RecipeShape(sMt1, sMt1, null, sMt2, null, sMt1, sMt2, null, null), new RecipeShape(null, sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2)};
    public static final Field SHAPED_ORE_RECIPE_WIDTH = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"width"});
    public static final Field SHAPED_ORE_RECIPE_HEIGHT = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"height"});
    private static volatile Map<RecipeShape, List<IRecipe>> indexedRecipeListCache;
    private static final String[][] sShapesA;
    private static final Materials[] VANILLA_MATS;

    public static void registerMaterialRecycling(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByproduct) {
        if (GTUtility.isStackInvalid(aStack)) {
            return;
        }
        if (aByproduct != null) {
            aByproduct = aByproduct.clone();
            aByproduct.mAmount /= (long)aStack.field_77994_a;
        }
        GTOreDictUnificator.addItemData(GTUtility.copyAmount(1, aStack), new ItemData(aMaterial, aMaterialAmount / (long)aStack.field_77994_a, aByproduct));
    }

    public static void registerMaterialRecycling(ItemStack aStack, ItemData aData) {
        if (GTUtility.isStackInvalid(aStack) || GTUtility.areStacksEqual(new ItemStack(Items.field_151072_bj), aStack) || aData == null || !aData.hasValidMaterialData() || !aData.mMaterial.mMaterial.mAutoGenerateRecycleRecipes || aData.mMaterial.mAmount <= 0L || GTUtility.getFluidForFilledItem(aStack, false) != null || aData.mMaterial.mMaterial.mSubTags.contains(SubTag.NO_RECIPES)) {
            return;
        }
        GTRecipeRegistrator.registerReverseMacerating(GTUtility.copyAmount(1, aStack), aData, aData.mPrefix == null);
        if (!GTUtility.areStacksEqual(GTModHandler.getIC2Item("iridiumOre", 1L), aStack)) {
            GTRecipeRegistrator.registerReverseSmelting(GTUtility.copyAmount(1, aStack), aData.mMaterial.mMaterial, aData.mMaterial.mAmount, true);
            GTRecipeRegistrator.registerReverseFluidSmelting(GTUtility.copyAmount(1, aStack), aData.mMaterial.mMaterial, aData.mMaterial.mAmount, aData.getByProduct(0));
            GTRecipeRegistrator.registerReverseArcSmelting(GTUtility.copyAmount(1, aStack), aData);
        }
    }

    public static void registerReverseFluidSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByproduct) {
        long powerUsage;
        byte powerTier;
        if (aStack == null || aMaterial == null || aMaterial.mSmeltInto.mStandardMoltenFluid == null || !aMaterial.contains(SubTag.SMELTING_TO_FLUID) || 144L * aMaterialAmount / (3628800L * (long)aStack.field_77994_a) <= 0L) {
            return;
        }
        ItemStack recipeOutput = aByproduct == null ? null : (aByproduct.mMaterial.contains(SubTag.NO_SMELTING) || !aByproduct.mMaterial.contains(SubTag.METAL) ? (aByproduct.mMaterial.contains(SubTag.FLAMMABLE) ? GTOreDictUnificator.getDust(Materials.Ash, aByproduct.mAmount / 2L) : (aByproduct.mMaterial.contains(SubTag.UNBURNABLE) ? GTOreDictUnificator.getDustOrIngot(aByproduct.mMaterial.mSmeltInto, aByproduct.mAmount) : null)) : GTOreDictUnificator.getIngotOrDust(aByproduct.mMaterial.mSmeltInto, aByproduct.mAmount));
        GTRecipeBuilder builder = GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack));
        if (recipeOutput != null) {
            builder.itemOutputs(recipeOutput);
        }
        if ((powerTier = GTUtility.getTier(powerUsage = Math.max(8L, (long)Math.sqrt(2 * aMaterial.mSmeltInto.mStandardMoltenFluid.getTemperature())))) > 0 && powerTier < GTValues.VP.length && powerUsage > GTValues.VP[powerTier]) {
            powerUsage = GTValues.VP[powerTier];
        }
        builder.fluidOutputs(aMaterial.mSmeltInto.getMolten(144L * aMaterialAmount / (3628800L * (long)aStack.field_77994_a))).duration((int)Math.max(1L, 24L * aMaterialAmount / 3628800L)).eut(powerUsage).recipeCategory(RecipeCategories.fluidExtractorRecycling).addTo(RecipeMaps.fluidExtractionRecipes);
    }

    public static void registerReverseSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, boolean aAllowAlloySmelter) {
        if (aStack == null || aMaterial == null || aMaterialAmount <= 0L || aMaterial.contains(SubTag.NO_SMELTING) || aMaterialAmount > 3628800L && aMaterial.contains(SubTag.METAL) || (long)aMaterial.getProcessingMaterialTierEU() > TierEU.IV) {
            return;
        }
        if (aMaterial == Materials.Naquadah || aMaterial == Materials.NaquadahEnriched) {
            return;
        }
        aMaterialAmount /= (long)aStack.field_77994_a;
        if (aAllowAlloySmelter) {
            GTModHandler.addSmeltingAndAlloySmeltingRecipe(GTUtility.copyAmount(1, aStack), GTOreDictUnificator.getIngot(aMaterial.mSmeltInto, aMaterialAmount), false);
        } else {
            GTModHandler.addSmeltingRecipe(GTUtility.copyAmount(1, aStack), GTOreDictUnificator.getIngot(aMaterial.mSmeltInto, aMaterialAmount));
        }
    }

    public static void registerReverseArcSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByProduct01, MaterialStack aByProduct02, MaterialStack aByProduct03) {
        GTRecipeRegistrator.registerReverseArcSmelting(aStack, new ItemData(aMaterial == null ? null : new MaterialStack(aMaterial, aMaterialAmount), aByProduct01, aByProduct02, aByProduct03));
    }

    public static void registerReverseArcSmelting(ItemStack aStack, ItemData aData) {
        if (aStack == null || aData == null) {
            return;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        boolean isRecycle = true;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            Object stackData;
            if (!(tMaterial.mMaterial != Materials.Iron && tMaterial.mMaterial != Materials.Copper && tMaterial.mMaterial != Materials.WroughtIron && tMaterial.mMaterial != Materials.AnnealedCopper || (stackData = GTOreDictUnificator.getItemData(aStack)) == null || ((ItemData)stackData).mPrefix != OrePrefixes.ingot && ((ItemData)stackData).mPrefix != OrePrefixes.dust)) {
                isRecycle = false;
            }
            if (tMaterial.mMaterial.contains(SubTag.UNBURNABLE)) {
                tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mArcSmeltInto;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                tMaterial.mMaterial = Materials.Ash;
                tMaterial.mAmount /= 16L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.FLAMMABLE)) {
                tMaterial.mMaterial = Materials.Ash;
                tMaterial.mAmount /= 8L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.NO_SMELTING)) {
                tMaterial.mAmount = 0L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.METAL)) {
                tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mArcSmeltInto;
                continue;
            }
            tMaterial.mAmount = 0L;
        }
        aData = new ItemData(aData);
        if (aData.mByProducts.length > 3) {
            for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
                if (tMaterial.mMaterial != Materials.Ash) continue;
                tMaterial.mAmount = 0L;
            }
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        long tAmount = 0L;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tAmount += tMaterial.mAmount * tMaterial.mMaterial.getMass();
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (GTOreDictUnificator.getIngotOrDust(aData.mMaterial) != null) {
            outputs.add(GTOreDictUnificator.getIngotOrDust(aData.mMaterial));
        }
        for (int i = 0; i < 8; ++i) {
            if (GTOreDictUnificator.getIngotOrDust(aData.getByProduct(i)) == null) continue;
            outputs.add(GTOreDictUnificator.getIngotOrDust(aData.getByProduct(i)));
        }
        if (!outputs.isEmpty()) {
            GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
            recipeBuilder.itemInputs(aStack).itemOutputs(outputs.toArray(new ItemStack[0])).fluidInputs(Materials.Oxygen.getGas((int)Math.max(16L, tAmount / 3628800L))).duration((int)Math.max(16L, tAmount / 3628800L) * 1).eut(90).metadata(GTRecipeConstants.RECYCLE, isRecycle).addTo(GTRecipeConstants.UniversalArcFurnace);
        }
    }

    public static void registerReverseMacerating(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByProduct01, MaterialStack aByProduct02, MaterialStack aByProduct03, boolean aAllowHammer) {
        GTRecipeRegistrator.registerReverseMacerating(aStack, new ItemData(aMaterial == null ? null : new MaterialStack(aMaterial, aMaterialAmount), aByProduct01, aByProduct02, aByProduct03), aAllowHammer);
    }

    public static void registerReverseMacerating(ItemStack aStack, ItemData aData, boolean aAllowHammer) {
        if (aStack == null || aData == null) {
            return;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tMaterial.mMaterial = tMaterial.mMaterial.mMacerateInto;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        long tAmount = 0L;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tAmount += tMaterial.mAmount * tMaterial.mMaterial.getMass();
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (GTOreDictUnificator.getDust(aData.mMaterial) != null) {
            outputs.add(GTOreDictUnificator.getDust(aData.mMaterial));
        }
        for (int i = 0; i < 3; ++i) {
            if (GTOreDictUnificator.getDust(aData.getByProduct(i)) == null) continue;
            outputs.add(GTOreDictUnificator.getDust(aData.getByProduct(i)));
        }
        if (!outputs.isEmpty()) {
            ItemStack[] outputsArray = outputs.toArray(new ItemStack[0]);
            GTRecipeBuilder recipeBuilder = GTValues.RA.stdBuilder();
            recipeBuilder.itemInputs(aStack).itemOutputs(outputsArray).duration((aData.mMaterial.mMaterial == Materials.Marble ? 1 : (int)Math.max(16L, tAmount / 3628800L)) * 1).eut(4).recipeCategory(RecipeCategories.maceratorRecycling).addTo(RecipeMaps.maceratorRecipes);
        }
        if (!aAllowHammer) {
            return;
        }
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            if (!tMaterial.mMaterial.contains(SubTag.CRYSTAL) || tMaterial.mMaterial.contains(SubTag.METAL) || tMaterial.mMaterial == Materials.Glass || GTOreDictUnificator.getDust(aData.mMaterial) == null) continue;
            GTValues.RA.stdBuilder().itemInputs(GTUtility.copyAmount(1, aStack)).itemOutputs(GTOreDictUnificator.getDust(aData.mMaterial)).duration(200).eut(TierEU.RECIPE_LV).recipeCategory(RecipeCategories.forgeHammerRecycling).addTo(RecipeMaps.hammerRecipes);
            break;
        }
    }

    public static synchronized void registerUsagesForMaterials(String aPlate, boolean aRecipeReplacing, ItemStack ... aMats) {
        for (ItemStack aMat : aMats) {
            if ((aMat = GTUtility.copyOrNull(aMat)) == null) continue;
            ItemData aItemData = GTOreDictUnificator.getItemData(aMat);
            if (aItemData == null || aItemData.mPrefix != OrePrefixes.ingot) {
                aPlate = null;
            }
            if (aPlate != null && GTOreDictUnificator.getFirstOre(aPlate, 1L) == null) {
                aPlate = null;
            }
            sMt1.func_150996_a(aMat.func_77973_b());
            GTRecipeRegistrator.sMt1.field_77994_a = 1;
            Items.field_151008_G.setDamage(sMt1, Items.field_151008_G.getDamage(aMat));
            sMt2.func_150996_a(new ItemStack(Blocks.field_150346_d).func_77973_b());
            GTRecipeRegistrator.sMt2.field_77994_a = 1;
            Items.field_151008_G.setDamage(sMt2, 0);
            if (aItemData != null && aItemData.hasValidPrefixMaterialData()) {
                for (RecipeShape tRecipe : sShapes) {
                    for (ItemStack tCrafted : GTModHandler.getRecipeOutputsBuffered(tRecipe.shape)) {
                        GTOreDictUnificator.addItemData(tCrafted, new ItemData(aItemData.mMaterial.mMaterial, aItemData.mMaterial.mAmount * (long)tRecipe.amount1, new MaterialStack[0]));
                    }
                }
            }
            GTRecipeRegistrator.registerStickStuff(aPlate, aItemData, aRecipeReplacing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<IRecipe> getRecipeList(RecipeShape shape) {
        boolean force;
        boolean bl = force = !GregTechAPI.sPostloadStarted || GregTechAPI.sPostloadFinished;
        if (!force && indexedRecipeListCache != null) return indexedRecipeListCache.get(shape);
        Class<GTRecipeRegistrator> clazz = GTRecipeRegistrator.class;
        synchronized (GTRecipeRegistrator.class) {
            if (indexedRecipeListCache != null && !force) return indexedRecipeListCache.get(shape);
            indexedRecipeListCache = GTRecipeRegistrator.createIndexedRecipeListCache();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return indexedRecipeListCache.get(shape);
        }
    }

    private static Map<RecipeShape, List<IRecipe>> createIndexedRecipeListCache() {
        IdentityHashMap<RecipeShape, List<IRecipe>> result = new IdentityHashMap<RecipeShape, List<IRecipe>>();
        ArrayList allRecipeList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        HashMultimap filter = HashMultimap.create();
        for (RecipeShape shape : sShapes) {
            for (List<Integer> list : shape.getEmptySlotsAllVariants()) {
                filter.put(list, (Object)shape);
            }
        }
        ArrayList<Integer> buffer = new ArrayList<Integer>(9);
        for (IRecipe tRecipe : allRecipeList) {
            if (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) continue;
            buffer.clear();
            ItemStack tStack = tRecipe.func_77571_b();
            if (!GTUtility.isStackValid(tStack) || tStack.func_77976_d() != 1 || tStack.func_77958_k() <= 0 || tStack.func_77973_b() instanceof ItemBlock || tStack.func_77973_b() instanceof IReactorComponent || GTModHandler.isElectricItem(tStack) || GTUtility.isStackInList(tStack, GTModHandler.sNonReplaceableItems)) continue;
            if (tRecipe instanceof ShapedOreRecipe) {
                ShapedOreRecipe tShapedRecipe = (ShapedOreRecipe)tRecipe;
                if (!GTRecipeRegistrator.checkRecipeShape(buffer, tShapedRecipe.getInput(), GTRecipeRegistrator.getRecipeWidth(tShapedRecipe), GTRecipeRegistrator.getRecipeHeight(tShapedRecipe))) continue;
                for (RecipeShape s : filter.get(buffer)) {
                    result.computeIfAbsent(s, k -> new ArrayList()).add(tRecipe);
                }
                continue;
            }
            if (tRecipe instanceof ShapedRecipes) {
                ShapedRecipes tShapedRecipe = (ShapedRecipes)tRecipe;
                if (!GTRecipeRegistrator.checkRecipeShape(buffer, tShapedRecipe.field_77574_d, GTRecipeRegistrator.getRecipeWidth(tShapedRecipe), GTRecipeRegistrator.getRecipeHeight(tShapedRecipe))) continue;
                for (RecipeShape s : filter.get(buffer)) {
                    result.computeIfAbsent(s, k -> new ArrayList()).add(tRecipe);
                }
                continue;
            }
            for (RecipeShape s : sShapes) {
                result.computeIfAbsent(s, k -> new ArrayList()).add(tRecipe);
            }
        }
        return result;
    }

    private static boolean checkRecipeShape(List<Integer> emptySlotIndexesBuffer, Object[] input, int tRecipeWidth, int tRecipeHeight) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                if (x >= tRecipeWidth || y >= tRecipeHeight) {
                    emptySlotIndexesBuffer.add(x + y * 3);
                    continue;
                }
                Object tObject = input[x + y * tRecipeWidth];
                if (tObject == null) {
                    emptySlotIndexesBuffer.add(x + y * 3);
                    continue;
                }
                if (tObject instanceof ItemStack && (((ItemStack)tObject).func_77973_b() == null || ((ItemStack)tObject).func_77976_d() < 2 || ((ItemStack)tObject).func_77958_k() > 0 || ((ItemStack)tObject).func_77973_b() instanceof ItemBlock)) {
                    return false;
                }
                if (!(tObject instanceof List) || !((List)tObject).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private static synchronized void registerStickStuff(String aPlate, ItemData aItemData, boolean aRecipeReplacing) {
        for (Materials tMaterial : sRodMaterialList) {
            ItemStack tMt2 = GTOreDictUnificator.get(OrePrefixes.stick, tMaterial, 1L);
            if (tMt2 == null) continue;
            sMt2.func_150996_a(tMt2.func_77973_b());
            GTRecipeRegistrator.sMt2.field_77994_a = 1;
            Items.field_151008_G.setDamage(sMt2, Items.field_151008_G.getDamage(tMt2));
            for (int i = 0; i < sShapes.length; ++i) {
                RecipeShape tRecipe = sShapes[i];
                block6: for (ItemStack tCrafted : GTModHandler.getRecipeOutputs(GTRecipeRegistrator.getRecipeList(tRecipe), true, tRecipe.shape)) {
                    if (aItemData != null && aItemData.hasValidPrefixMaterialData()) {
                        GTOreDictUnificator.addItemData(tCrafted, new ItemData(aItemData.mMaterial.mMaterial, aItemData.mMaterial.mAmount * (long)tRecipe.amount1, new MaterialStack(tMaterial, OrePrefixes.stick.mMaterialAmount * (long)tRecipe.amount2)));
                    }
                    if (!aRecipeReplacing || aPlate == null || sShapesA[i] == null || sShapesA[i].length <= 1) continue;
                    assert (aItemData != null);
                    ItemStack tStack = GTModHandler.removeRecipe(tRecipe.shape);
                    if (null == tStack) continue;
                    switch (sShapesA[i].length) {
                        case 2: {
                            GTModHandler.addCraftingRecipe(tStack, GTModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                            continue block6;
                        }
                        case 3: {
                            GTModHandler.addCraftingRecipe(tStack, GTModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], sShapesA[i][2], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                            continue block6;
                        }
                    }
                    GTModHandler.addCraftingRecipe(tStack, GTModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], sShapesA[i][2], sShapesA[i][3], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                }
            }
        }
    }

    public static void registerWiremillRecipes(Materials aMaterial, int baseDuration, int aEUt) {
        GTRecipeRegistrator.registerWiremillRecipes(aMaterial, baseDuration, GTUtility.calculateRecipeEU(aMaterial, aEUt), OrePrefixes.ingot, OrePrefixes.stick, 2);
    }

    public static void registerWiremillRecipes(Materials aMaterial, int baseDuration, int aEUt, OrePrefixes prefix1, OrePrefixes prefix2, int multiplier) {
        if (GTOreDictUnificator.get(prefix1, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix1, aMaterial, 1L), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, (long)multiplier)).duration(baseDuration * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix1, aMaterial, 2L / (long)multiplier), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt02, aMaterial, 1L)).duration((int)((float)baseDuration * 1.5f) * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix1, aMaterial, 4L / (long)multiplier), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt04, aMaterial, 1L)).duration(baseDuration * 2 * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix1, aMaterial, 8L / (long)multiplier), GTUtility.getIntegratedCircuit(8)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt08, aMaterial, 1L)).duration((int)((float)baseDuration * 2.5f) * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix1, aMaterial, 12L / (long)multiplier), GTUtility.getIntegratedCircuit(12)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt12, aMaterial, 1L)).duration(baseDuration * 3 * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix1, aMaterial, 16L / (long)multiplier), GTUtility.getIntegratedCircuit(16)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt16, aMaterial, 1L)).duration((int)((float)baseDuration * 3.5f) * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
        }
        if (GTOreDictUnificator.get(prefix2, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix2, aMaterial, 1L), GTUtility.getIntegratedCircuit(1)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt01, aMaterial, 2L / (long)multiplier)).duration((int)((float)baseDuration * 0.5f) * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix2, aMaterial, 4L / (long)multiplier), GTUtility.getIntegratedCircuit(2)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt02, aMaterial, 1L)).duration(baseDuration * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix2, aMaterial, 8L / (long)multiplier), GTUtility.getIntegratedCircuit(4)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt04, aMaterial, 1L)).duration((int)((float)baseDuration * 1.5f) * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix2, aMaterial, 16L / (long)multiplier), GTUtility.getIntegratedCircuit(8)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt08, aMaterial, 1L)).duration(baseDuration * 2 * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix2, aMaterial, 24L / (long)multiplier), GTUtility.getIntegratedCircuit(12)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt12, aMaterial, 1L)).duration((int)((float)baseDuration * 2.5f) * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix2, aMaterial, 32L / (long)multiplier), GTUtility.getIntegratedCircuit(16)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireGt16, aMaterial, 1L)).duration(baseDuration * 3 * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
        }
        if (GTOreDictUnificator.get(prefix1, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix1, aMaterial, 1L), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 4L * (long)multiplier)).duration(baseDuration * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
        }
        if (GTOreDictUnificator.get(prefix2, aMaterial, 1L) != null && GTOreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 1L) != null) {
            GTValues.RA.stdBuilder().itemInputs(GTOreDictUnificator.get(prefix2, aMaterial, 1L), GTUtility.getIntegratedCircuit(3)).itemOutputs(GTOreDictUnificator.get(OrePrefixes.wireFine, aMaterial, 2L * (long)multiplier)).duration((int)((float)baseDuration * 0.5f) * 1).eut(aEUt).addTo(RecipeMaps.wiremillRecipes);
        }
    }

    public static boolean hasVanillaRecipes(Materials materials) {
        return Arrays.stream(VANILLA_MATS).anyMatch(mat -> mat == materials);
    }

    private static int getRecipeWidth(ShapedOreRecipe r) {
        try {
            return (Integer)SHAPED_ORE_RECIPE_WIDTH.get(r);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getRecipeHeight(ShapedOreRecipe r) {
        try {
            return (Integer)SHAPED_ORE_RECIPE_HEIGHT.get(r);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getRecipeHeight(ShapedRecipes r) {
        return r.field_77577_c;
    }

    private static int getRecipeWidth(ShapedRecipes r) {
        return r.field_77576_b;
    }

    static {
        sShapesA = new String[][]{null, null, null, {"Helmet", "PPP", "PhP"}, {"ChestPlate", "PhP", "PPP", "PPP"}, {"Pants", "PPP", "PhP", "P P"}, {"Boots", "P P", "PhP"}, {"Sword", " P ", "fPh", " R "}, {"Pickaxe", "PII", "fRh", " R "}, {"Shovel", "fPh", " R ", " R "}, {"Axe", "PIh", "PR ", "fR "}, {"Axe", "PIh", "PR ", "fR "}, {"Hoe", "PIh", "fR ", " R "}, {"Hoe", "PIh", "fR ", " R "}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sword", " R ", "fPh", " P "}, {"Pickaxe", " R ", "fRh", "PII"}, {"Shovel", " R ", " R ", "fPh"}, {"Axe", "fR ", "PR ", "PIh"}, {"Axe", "fR ", "PR ", "PIh"}, {"Hoe", " R ", "fR ", "PIh"}, {"Hoe", " R ", "fR ", "PIh"}, {"Spear", "Ph ", "fR ", "  R"}, {"Spear", "Ph ", "fR ", "  R"}, {"Knive", "hP", "Rf"}, {"Knive", "fh", "PR"}, {"Knive", "fh", "PR"}, {"Knive", "Pf", "Rh"}, {"Knive", "Pf", "Rh"}, null, null, null, null, {"WarAxe", "PPP", "PRP", "fRh"}, null, null, null, {"Shears", "hP", "Pf"}, {"Shears", "hP", "Pf"}, {"Scythe", "IPh", "RfP", "R  "}, {"Scythe", "hPI", "PfR", "  R"}};
        GregTechAPI.sAfterGTPostload.add(() -> {
            indexedRecipeListCache = null;
        });
        VANILLA_MATS = new Materials[]{Materials.Cobalt, Materials.Gold, Materials.Iron, Materials.Lead, Materials.FierySteel, Materials.Void, Materials.Bronze, Materials.Diamond, Materials.Ruby, Materials.Sapphire, Materials.Steel, Materials.IronWood, Materials.Steeleaf, Materials.Knightmetal, Materials.Thaumium, Materials.DarkSteel};
    }

    private static class RecipeShape {
        private final ItemStack[] shape;
        private int amount1;
        private int amount2;

        public RecipeShape(ItemStack ... shape) {
            this.shape = shape;
            for (ItemStack stack : shape) {
                if (stack == sMt1) {
                    ++this.amount1;
                }
                if (stack != sMt2) continue;
                ++this.amount2;
            }
        }

        public List<List<Integer>> getEmptySlotsAllVariants() {
            ImmutableList.Builder b = ImmutableList.builder();
            for (int i = -1; i < 2; ++i) {
                if (i != 0 && !this.isColClear(i + 1)) continue;
                for (int j = -1; j < 2; ++j) {
                    if (j != 0 && !this.isRowClear(j + 1)) continue;
                    b.add(this.getEmptySlots(i, j));
                }
            }
            return b.build();
        }

        private boolean isRowClear(int row) {
            for (int i = 0; i < 3; ++i) {
                if (this.shape[i + row * 3] == null) continue;
                return false;
            }
            return true;
        }

        private boolean isColClear(int col) {
            for (int i = 0; i < 3; ++i) {
                if (this.shape[col + i * 3] == null) continue;
                return false;
            }
            return true;
        }

        private List<Integer> getEmptySlots(int offsetX, int offsetY) {
            ImmutableList.Builder b = ImmutableList.builder();
            for (int i = 0; i < this.shape.length; ++i) {
                int mappedIndex = i - offsetX - offsetY * 3;
                if (mappedIndex >= 0 && mappedIndex <= 8 && this.shape[mappedIndex] != null) continue;
                b.add((Object)i);
            }
            return b.build();
        }
    }
}

