/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.WorldCoord;
import appeng.helpers.ICustomNameObject;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructableProvider;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.graphs.GenerateNodeMap;
import gregtech.api.graphs.GenerateNodeMapPower;
import gregtech.api.graphs.Node;
import gregtech.api.interfaces.ICleanroom;
import gregtech.api.interfaces.ICleanroomReceiver;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IDebugableTileEntity;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IGregtechWailaProvider;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.CommonMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.net.GTPacketTileEntity;
import gregtech.api.objects.GTItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.objects.blockupdate.BlockUpdateHandler;
import gregtech.api.util.CoverBehaviorBase;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.api.util.ISerializableObject;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.Pollution;
import gregtech.common.covers.CoverInfo;
import ic2.api.Direction;
import ic2.api.info.Info;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.jetbrains.annotations.NotNull;

public class BaseMetaTileEntity
extends CommonMetaTileEntity
implements IGregTechTileEntity,
IActionHost,
IGridProxyable,
IAlignmentProvider,
IConstructableProvider,
IDebugableTileEntity,
IGregtechWailaProvider,
ICleanroomReceiver,
ICustomNameObject {
    private static final Field ENTITY_ITEM_HEALTH_FIELD = ReflectionHelper.findField(EntityItem.class, (String[])new String[]{"health", "field_70291_e"});
    private final boolean[] mActiveEUInputs = new boolean[]{false, false, false, false, false, false};
    private final boolean[] mActiveEUOutputs = new boolean[]{false, false, false, false, false, false};
    private final int[] mTimeStatistics = new int[GregTechAPI.TICKS_FOR_LAG_AVERAGING];
    private boolean hasTimeStatisticsStarted;
    public long mLastSoundTick = 0L;
    public boolean mWasShutdown = false;
    @Nonnull
    public ShutDownReason lastShutDownReason = ShutDownReasonRegistry.NONE;
    protected MetaTileEntity mMetaTileEntity;
    protected long mStoredEnergy = 0L;
    protected long mStoredSteam = 0L;
    protected int mAverageEUInputIndex = 0;
    protected int mAverageEUOutputIndex = 0;
    protected boolean mReleaseEnergy = false;
    protected final long[] mAverageEUInput = new long[]{0L, 0L, 0L, 0L, 0L};
    protected final long[] mAverageEUOutput = new long[]{0L, 0L, 0L, 0L, 0L};
    private boolean mHasEnoughEnergy = true;
    private boolean mRunningThroughTick = false;
    private boolean mInputDisabled = false;
    private boolean mOutputDisabled = false;
    private boolean mMuffler = false;
    private boolean mLockUpgrade = false;
    private boolean mActive = false;
    private boolean mWorkUpdate = false;
    private boolean mSteamConverter = false;
    private boolean mWorks = true;
    private boolean oRedstone = false;
    private byte mColor = 0;
    private byte oColor = 0;
    private byte oStrongRedstone = 0;
    private byte oRedstoneData = (byte)63;
    private byte oTextureData = 0;
    private byte oUpdateData = 0;
    private byte oTexturePage = 0;
    private byte oLightValueClient = 0;
    private byte oLightValue = (byte)-1;
    private byte mLightValue = 0;
    private byte mOtherUpgrades = 0;
    private byte mWorkData = 0;
    private ForgeDirection mFacing = ForgeDirection.DOWN;
    private ForgeDirection oFacing = ForgeDirection.DOWN;
    private int mDisplayErrorCode = 0;
    private int oX = 0;
    private int oY = 0;
    private int oZ = 0;
    private int mTimeStatisticsIndex = 0;
    private int mLagWarningCount = 0;
    private long oOutput = 0L;
    private long mAcceptedAmperes = Long.MAX_VALUE;
    private long mLastCheckTick = 0L;
    private String mOwnerName = "";
    private UUID mOwnerUuid = GTUtility.defaultUuid;
    private NBTTagCompound mRecipeStuff = new NBTTagCompound();
    private int cableUpdateDelay = 30;

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        try {
            super.func_145841_b(nbt);
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.", e);
        }
        try {
            nbt.func_74757_a("mWasShutdown", this.mWasShutdown);
            nbt.func_74768_a("mID", (int)this.mID);
            nbt.func_74772_a("mStoredSteam", this.mStoredSteam);
            nbt.func_74772_a("mStoredEnergy", this.mStoredEnergy);
            this.writeCoverNBT(nbt, false);
            nbt.func_74774_a("mColor", this.mColor);
            nbt.func_74774_a("mLightValue", this.mLightValue);
            nbt.func_74774_a("mOtherUpgrades", this.mOtherUpgrades);
            nbt.func_74774_a("mWorkData", this.mWorkData);
            nbt.func_74777_a("mFacing", (short)this.mFacing.ordinal());
            nbt.func_74778_a("mOwnerName", this.mOwnerName);
            nbt.func_74778_a("mOwnerUuid", this.mOwnerUuid == null ? "" : this.mOwnerUuid.toString());
            nbt.func_74757_a("mLockUpgrade", this.mLockUpgrade);
            nbt.func_74757_a("mMuffler", this.mMuffler);
            nbt.func_74757_a("mSteamConverter", this.mSteamConverter);
            nbt.func_74757_a("mActive", this.mActive);
            nbt.func_74757_a("mWorks", !this.mWorks);
            nbt.func_74757_a("mInputDisabled", this.mInputDisabled);
            nbt.func_74757_a("mOutputDisabled", this.mOutputDisabled);
            nbt.func_74782_a("GT.CraftingComponents", (NBTBase)this.mRecipeStuff);
            nbt.func_74778_a("shutDownReasonID", this.getLastShutDownReason().getID());
            nbt.func_74782_a("shutDownReason", (NBTBase)this.getLastShutDownReason().writeToNBT(new NBTTagCompound()));
        }
        catch (Throwable e) {
            GTMod.GT_FML_LOGGER.error("Encountered CRITICAL ERROR while saving MetaTileEntity.", e);
        }
        this.saveMetaTileNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound aNBT) {
        super.func_145839_a(aNBT);
        this.setInitialValuesAsNBT(aNBT, (short)0);
    }

    @Override
    public void setInitialValuesAsNBT(NBTTagCompound aNBT, short aID) {
        if (aNBT == null) {
            byte[] byArray;
            if (aID > 0) {
                this.mID = aID;
            } else {
                short s = this.mID = this.mID > 0 ? this.mID : (short)0;
            }
            if (this.mID != 0) {
                this.createNewMetatileEntity(this.mID);
            }
            if (this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
                byte[] byArray2 = new byte[6];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = 0;
                byArray2[3] = 0;
                byArray2[4] = 0;
                byArray = byArray2;
                byArray2[5] = 0;
            } else {
                byte[] byArray3 = new byte[6];
                byArray3[0] = 15;
                byArray3[1] = 15;
                byArray3[2] = 15;
                byArray3[3] = 15;
                byArray3[4] = 15;
                byArray = byArray3;
                byArray3[5] = 15;
            }
            this.mSidedRedstone = byArray;
        } else {
            this.mID = aID <= 0 ? (short)aNBT.func_74762_e("mID") : aID;
            this.mStoredSteam = aNBT.func_74763_f("mStoredSteam");
            this.mStoredEnergy = aNBT.func_74763_f("mStoredEnergy");
            this.mColor = aNBT.func_74771_c("mColor");
            this.mLightValue = aNBT.func_74771_c("mLightValue");
            this.mWorkData = aNBT.func_74771_c("mWorkData");
            this.mFacing = this.oFacing = ForgeDirection.getOrientation((int)aNBT.func_74765_d("mFacing"));
            this.mOwnerName = aNBT.func_74779_i("mOwnerName");
            this.setShutdownStatus(aNBT.func_74767_n("mWasShutdown"));
            String shutDownReasonID = aNBT.func_74779_i("shutDownReasonID");
            if (ShutDownReasonRegistry.isRegistered(shutDownReasonID)) {
                ShutDownReason reason = (ShutDownReason)ShutDownReasonRegistry.getSampleFromRegistry(shutDownReasonID).newInstance();
                reason.readFromNBT(aNBT.func_74775_l("shutDownReason"));
                this.setShutDownReason(reason);
            }
            try {
                this.mOwnerUuid = UUID.fromString(aNBT.func_74779_i("mOwnerUuid"));
            }
            catch (IllegalArgumentException e) {
                this.mOwnerUuid = null;
            }
            this.mLockUpgrade = aNBT.func_74767_n("mLockUpgrade");
            this.mMuffler = aNBT.func_74767_n("mMuffler");
            this.mSteamConverter = aNBT.func_74767_n("mSteamConverter");
            this.mActive = aNBT.func_74767_n("mActive");
            this.mWorks = !aNBT.func_74767_n("mWorks");
            this.mInputDisabled = aNBT.func_74767_n("mInputDisabled");
            this.mOutputDisabled = aNBT.func_74767_n("mOutputDisabled");
            this.mOtherUpgrades = (byte)(aNBT.func_74771_c("mOtherUpgrades") + aNBT.func_74771_c("mBatteries") + aNBT.func_74771_c("mLiBatteries"));
            this.mRecipeStuff = aNBT.func_74775_l("GT.CraftingComponents");
            int nbtVersion = aNBT.func_74762_e("nbtVersion");
            this.readCoverNBT(aNBT);
            this.loadMetaTileNBT(aNBT);
        }
        if (this.mSidedRedstone.length != 6) {
            this.mSidedRedstone = this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior() ? new byte[]{0, 0, 0, 0, 0, 0} : new byte[]{15, 15, 15, 15, 15, 15};
        }
        this.updateCoverBehavior();
    }

    public void updateStatus() {
    }

    public void chargeItem(ItemStack aStack) {
        this.decreaseStoredEU(GTModHandler.chargeElectricItem(aStack, (int)Math.min(Integer.MAX_VALUE, this.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getOutputTier()), false, false), true);
    }

    public void dischargeItem(ItemStack aStack) {
        this.increaseStoredEnergyUnits(GTModHandler.dischargeElectricItem(aStack, (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity() - this.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getInputTier()), false, false, false), true);
    }

    protected boolean isRainPossible() {
        BiomeGenBase biome = this.getBiome();
        return biome.field_76751_G > 0.0f && (biome.func_76738_d() || biome.func_76746_c());
    }

    public boolean isRainExposed() {
        int precipitationHeightAtSide2 = this.field_145850_b.func_72874_g(this.field_145851_c, this.field_145849_e - 1);
        int precipitationHeightAtSide3 = this.field_145850_b.func_72874_g(this.field_145851_c, this.field_145849_e + 1);
        int precipitationHeightAtSide4 = this.field_145850_b.func_72874_g(this.field_145851_c - 1, this.field_145849_e);
        int precipitationHeightAtSide5 = this.field_145850_b.func_72874_g(this.field_145851_c + 1, this.field_145849_e);
        return this.getCoverIDAtSide(ForgeDirection.UP) == 0 && this.field_145850_b.func_72874_g(this.field_145851_c, this.field_145849_e) - 2 < this.field_145848_d || this.getCoverIDAtSide(ForgeDirection.NORTH) == 0 && precipitationHeightAtSide2 - 1 < this.field_145848_d && precipitationHeightAtSide2 > -1 || this.getCoverIDAtSide(ForgeDirection.SOUTH) == 0 && precipitationHeightAtSide3 - 1 < this.field_145848_d && precipitationHeightAtSide3 > -1 || this.getCoverIDAtSide(ForgeDirection.WEST) == 0 && precipitationHeightAtSide4 - 1 < this.field_145848_d && precipitationHeightAtSide4 > -1 || this.getCoverIDAtSide(ForgeDirection.EAST) == 0 && precipitationHeightAtSide5 - 1 < this.field_145848_d && precipitationHeightAtSide5 > -1;
    }

    @Override
    public void func_145845_h() {
        boolean aSideServer;
        long tTime;
        block67: {
            super.func_145845_h();
            if (!this.hasValidMetaTileEntity()) {
                if (this.mMetaTileEntity == null) {
                    return;
                }
                this.mMetaTileEntity.setBaseMetaTileEntity(this);
            }
            this.mRunningThroughTick = true;
            tTime = this.hasTimeStatisticsStarted ? System.nanoTime() : 0L;
            aSideServer = this.isServerSide();
            boolean aSideClient = this.isClientSide();
            try {
                int k;
                if (!this.hasValidMetaTileEntity()) break block67;
                if (this.mTickTimer++ == 0L) {
                    this.oX = this.field_145851_c;
                    this.oY = this.field_145848_d;
                    this.oZ = this.field_145849_e;
                    if (aSideServer) {
                        this.checkDropCover();
                    } else {
                        this.requestCoverDataIfNeeded();
                    }
                    this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                    this.mMetaTileEntity.onFirstTick(this);
                    if (!this.hasValidMetaTileEntity()) {
                        this.mRunningThroughTick = false;
                        return;
                    }
                }
                if (aSideClient) {
                    if (this.mColor != this.oColor) {
                        this.oColor = this.mColor;
                        this.mMetaTileEntity.onColorChangeClient(this.oColor);
                        this.issueTextureUpdate();
                    }
                    if (this.mLightValue != this.oLightValueClient) {
                        this.field_145850_b.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.mLightValue);
                        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                        this.oLightValueClient = this.mLightValue;
                        this.issueTextureUpdate();
                    }
                    if (this.mNeedsUpdate) {
                        if (GTMod.gregtechproxy.mUseBlockUpdateHandler) {
                            BlockUpdateHandler.Instance.enqueueBlockUpdate(this.field_145850_b, (WorldCoord)this.getLocation());
                        } else {
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        }
                        this.mNeedsUpdate = false;
                    }
                }
                if (aSideServer && this.mTickTimer > 10L && !this.doCoverThings()) {
                    this.mRunningThroughTick = false;
                    return;
                }
                if (aSideServer) {
                    if (++this.mAverageEUInputIndex >= this.mAverageEUInput.length) {
                        this.mAverageEUInputIndex = 0;
                    }
                    if (++this.mAverageEUOutputIndex >= this.mAverageEUOutput.length) {
                        this.mAverageEUOutputIndex = 0;
                    }
                    this.mAverageEUInput[this.mAverageEUInputIndex] = 0L;
                    this.mAverageEUOutput[this.mAverageEUOutputIndex] = 0L;
                }
                this.mMetaTileEntity.onPreTick(this, this.mTickTimer);
                if (!this.hasValidMetaTileEntity()) {
                    this.mRunningThroughTick = false;
                    return;
                }
                if (aSideServer) {
                    if (this.mRedstone != this.oRedstone || this.mTickTimer == 10L) {
                        this.updateCoverBehavior();
                        this.oRedstone = this.mRedstone;
                        this.issueBlockUpdate();
                    }
                    if (this.mTickTimer == 10L) {
                        this.joinEnet();
                    }
                    if (this.field_145851_c != this.oX || this.field_145848_d != this.oY || this.field_145849_e != this.oZ) {
                        this.oX = this.field_145851_c;
                        this.oY = this.field_145848_d;
                        this.oZ = this.field_145849_e;
                        this.issueClientUpdate();
                        this.clearTileEntityBuffer();
                    }
                    if (this.mFacing != this.oFacing) {
                        this.oFacing = this.mFacing;
                        this.checkDropCover();
                        this.issueBlockUpdate();
                    }
                    if (this.mTickTimer > 20L && this.mMetaTileEntity.isElectric()) {
                        this.mAcceptedAmperes = 0L;
                        if (this.getOutputVoltage() != this.oOutput) {
                            this.oOutput = this.getOutputVoltage();
                        }
                        if (this.mMetaTileEntity.isEnetOutput() || this.mMetaTileEntity.isEnetInput()) {
                            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                                int ordinalSide = side.ordinal();
                                boolean temp = this.isEnergyInputSide(side);
                                if (temp != this.mActiveEUInputs[ordinalSide]) {
                                    this.mActiveEUInputs[ordinalSide] = temp;
                                }
                                if ((temp = this.isEnergyOutputSide(side)) == this.mActiveEUOutputs[ordinalSide]) continue;
                                this.mActiveEUOutputs[ordinalSide] = temp;
                            }
                        }
                        if (this.mMetaTileEntity.isEnetOutput() && this.oOutput > 0L) {
                            long tOutputVoltage = Math.max(this.oOutput, this.oOutput + (1L << Math.max(0, GTUtility.getTier(this.oOutput) - 1)));
                            long tUsableAmperage = Math.min(this.getOutputAmperage(), (this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU()) / tOutputVoltage);
                            if (tUsableAmperage > 0L) {
                                long tEU = tOutputVoltage * IEnergyConnected.Util.emitEnergyToNetwork(this.oOutput, tUsableAmperage, this);
                                int n = this.mAverageEUOutputIndex;
                                this.mAverageEUOutput[n] = this.mAverageEUOutput[n] + tEU;
                                this.decreaseStoredEU(tEU, true);
                            }
                        }
                        if (this.getEUCapacity() > 0L) {
                            Block tBlock2;
                            if (GregTechAPI.sMachineFireExplosions && this.getRandomNumber(1000) == 0 && (tBlock2 = this.getBlockAtSide(ForgeDirection.getOrientation((int)this.getRandomNumber(6)))) instanceof BlockFire) {
                                this.doEnergyExplosion();
                            }
                            if (!this.hasValidMetaTileEntity()) {
                                this.mRunningThroughTick = false;
                                return;
                            }
                            if (GregTechAPI.sMachineRainExplosions && this.mMetaTileEntity.willExplodeInRain() && this.getRandomNumber(1000) == 0 && this.isRainPossible()) {
                                if (this.field_145850_b.func_72896_J() && this.isRainExposed()) {
                                    if (this.getRandomNumber(10) == 0) {
                                        try {
                                            GTMod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "badweather");
                                        }
                                        catch (Exception tBlock2) {
                                            // empty catch block
                                        }
                                        GTLog.exp.println("Machine at: " + this.getXCoord() + " | " + this.getYCoord() + " | " + this.getZCoord() + " DIMID: " + this.field_145850_b.field_73011_w.field_76574_g + " explosion due to rain!");
                                        this.doEnergyExplosion();
                                    } else {
                                        GTLog.exp.println("Machine at: " + this.getXCoord() + " | " + this.getYCoord() + " | " + this.getZCoord() + " DIMID: " + this.field_145850_b.field_73011_w.field_76574_g + "  set to Fire due to rain!");
                                        this.setOnFire();
                                    }
                                }
                                if (!this.hasValidMetaTileEntity()) {
                                    this.mRunningThroughTick = false;
                                    return;
                                }
                                if (GregTechAPI.sMachineThunderExplosions && this.field_145850_b.func_72911_I() && this.getRandomNumber(3) == 0 && this.isRainExposed()) {
                                    try {
                                        GTMod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "badweather");
                                    }
                                    catch (Exception tBlock2) {
                                        // empty catch block
                                    }
                                    GTLog.exp.println("Machine at: " + this.getXCoord() + " | " + this.getYCoord() + " | " + this.getZCoord() + " DIMID: " + this.field_145850_b.field_73011_w.field_76574_g + " explosion due to Thunderstorm!");
                                    this.doEnergyExplosion();
                                }
                            }
                        }
                    }
                    if (!this.hasValidMetaTileEntity()) {
                        this.mRunningThroughTick = false;
                        return;
                    }
                }
                if (aSideServer && this.mMetaTileEntity.dechargerSlotCount() > 0 && this.getStoredEU() < this.getEUCapacity()) {
                    int i;
                    k = this.mMetaTileEntity.dechargerSlotCount() + i;
                    for (i = this.mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                        if (this.mMetaTileEntity.mInventory[i] == null || this.getStoredEU() >= this.getEUCapacity()) continue;
                        this.dischargeItem(this.mMetaTileEntity.mInventory[i]);
                        if (Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]) > 0.0 && (double)this.getStoredEU() + Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]) < (double)this.getEUCapacity()) {
                            this.increaseStoredEnergyUnits((long)Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]), false);
                            --this.mMetaTileEntity.mInventory[i].field_77994_a;
                            this.mInventoryChanged = true;
                        }
                        if (this.mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        this.mMetaTileEntity.mInventory[i] = null;
                        this.mInventoryChanged = true;
                    }
                }
                if (aSideServer && this.mMetaTileEntity.rechargerSlotCount() > 0 && this.getStoredEU() > 0L) {
                    int i;
                    k = this.mMetaTileEntity.rechargerSlotCount() + i;
                    for (i = this.mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                        if (this.getStoredEU() <= 0L || this.mMetaTileEntity.mInventory[i] == null) continue;
                        this.chargeItem(this.mMetaTileEntity.mInventory[i]);
                        if (this.mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                        this.mMetaTileEntity.mInventory[i] = null;
                        this.mInventoryChanged = true;
                    }
                }
                this.updateStatus();
                if (!this.hasValidMetaTileEntity()) {
                    this.mRunningThroughTick = false;
                    return;
                }
                this.mMetaTileEntity.onPostTick(this, this.mTickTimer);
                if (!this.hasValidMetaTileEntity()) {
                    this.mRunningThroughTick = false;
                    return;
                }
                if (aSideServer) {
                    if (this.mTickTimer > 20L && this.cableUpdateDelay == 0) {
                        this.generatePowerNodes();
                    }
                    --this.cableUpdateDelay;
                    if (this.mTickTimer % 10L == 0L) {
                        this.sendClientData();
                    }
                    if (this.mTickTimer > 10L) {
                        byte tData = (byte)(this.mFacing.ordinal() & 7 | (this.mActive ? 8 : 0) | (this.mRedstone ? 16 : 0) | (this.mLockUpgrade ? 32 : 0) | (this.mWorks ? 64 : 0) | (this.mMuffler ? 128 : 0));
                        if (tData != this.oTextureData) {
                            this.oTextureData = tData;
                            this.sendBlockEvent((byte)0, this.oTextureData);
                        }
                        if ((tData = this.mMetaTileEntity.getUpdateData()) != this.oUpdateData) {
                            this.oUpdateData = tData;
                            this.sendBlockEvent((byte)1, this.oUpdateData);
                        }
                        if (this.mMetaTileEntity instanceof MTEHatch && (tData = ((MTEHatch)this.mMetaTileEntity).getTexturePage()) != this.oTexturePage) {
                            this.oTexturePage = tData;
                            this.sendBlockEvent((byte)1, (byte)(this.oTexturePage | 0x80));
                        }
                        if (this.mColor != this.oColor) {
                            this.oColor = this.mColor;
                            this.sendBlockEvent((byte)2, this.oColor);
                        }
                        if ((tData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0))) != this.oRedstoneData) {
                            this.oRedstoneData = tData;
                            this.sendBlockEvent((byte)3, this.oRedstoneData);
                        }
                        if (this.mLightValue != this.oLightValue) {
                            this.field_145850_b.func_72915_b(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.mLightValue);
                            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
                            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
                            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
                            this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
                            this.issueTextureUpdate();
                            this.oLightValue = this.mLightValue;
                            this.sendBlockEvent((byte)7, this.oLightValue);
                        }
                    }
                    if (this.mNeedsBlockUpdate) {
                        this.updateNeighbours(this.mStrongRedstone, this.oStrongRedstone);
                        this.oStrongRedstone = this.mStrongRedstone;
                        this.mNeedsBlockUpdate = false;
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                e.printStackTrace(GTLog.err);
                try {
                    this.mMetaTileEntity.onTickFail(this, this.mTickTimer);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    ex.printStackTrace(GTLog.err);
                }
            }
        }
        if (aSideServer && this.hasTimeStatisticsStarted && this.hasValidMetaTileEntity()) {
            tTime = System.nanoTime() - tTime;
            this.mTimeStatisticsIndex = (this.mTimeStatisticsIndex + 1) % this.mTimeStatistics.length;
            this.mTimeStatistics[this.mTimeStatisticsIndex] = (int)tTime;
            if (tTime > 0L && tTime > (long)GregTechAPI.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING * 1000000L && this.mTickTimer > 1000L && this.getMetaTileEntity().doTickProfilingMessageDuringThisTick() && this.mLagWarningCount++ < 10) {
                GTMod.GT_FML_LOGGER.warn("WARNING: Possible Lag Source at [" + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + "] in Dimension " + this.field_145850_b.field_73011_w.field_76574_g + " with " + tTime + "ns caused by an instance of " + this.getMetaTileEntity().getClass());
            }
        }
        this.mRunningThroughTick = false;
        this.mInventoryChanged = false;
        this.mWorkUpdate = false;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (this.hasValidMetaTileEntity()) {
            this.getMetaTileEntity().getWailaBody(itemStack, currentTip, accessor, config);
        }
        super.getWailaBody(itemStack, currentTip, accessor, config);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        if (this.hasValidMetaTileEntity()) {
            this.getMetaTileEntity().getWailaNBTData(player, tile, tag, world, x, y, z);
        }
    }

    private void sendClientData() {
        if (this.mSendClientData) {
            this.oTextureData = (byte)(this.mFacing.ordinal() & 7 | (this.mActive ? 8 : 0) | (this.mRedstone ? 16 : 0) | (this.mLockUpgrade ? 32 : 0) | (this.mWorks ? 64 : 0));
            this.oTexturePage = this.hasValidMetaTileEntity() && this.mMetaTileEntity instanceof MTEHatch ? ((MTEHatch)this.mMetaTileEntity).getTexturePage() : (byte)0;
            this.oUpdateData = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getUpdateData() : (byte)0;
            this.oRedstoneData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0));
            this.oColor = this.mColor;
            GTValues.NW.sendPacketToAllPlayersInRange(this.field_145850_b, new GTPacketTileEntity(this.field_145851_c, (short)this.field_145848_d, this.field_145849_e, this.mID, this.getCoverInfoAtSide(ForgeDirection.DOWN).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.UP).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.NORTH).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.SOUTH).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.WEST).getCoverID(), this.getCoverInfoAtSide(ForgeDirection.EAST).getCoverID(), this.oTextureData, this.oTexturePage, this.oUpdateData, this.oRedstoneData, this.oColor), this.field_145851_c, this.field_145849_e);
            this.mSendClientData = false;
        }
        this.sendCoverDataIfNeeded();
    }

    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aTexturePage, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        this.issueTextureUpdate();
        if (this.mID != aID && aID > 0) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        this.setCoverIDAtSide(ForgeDirection.DOWN, aCover0);
        this.setCoverIDAtSide(ForgeDirection.UP, aCover1);
        this.setCoverIDAtSide(ForgeDirection.NORTH, aCover2);
        this.setCoverIDAtSide(ForgeDirection.SOUTH, aCover3);
        this.setCoverIDAtSide(ForgeDirection.WEST, aCover4);
        this.setCoverIDAtSide(ForgeDirection.EAST, aCover5);
        this.func_145842_c(0, aTextureData);
        this.func_145842_c(1, aUpdateData & 0x7F);
        this.func_145842_c(1, aTexturePage | 0x80);
        this.func_145842_c(2, aColorData);
        this.func_145842_c(3, aRedstoneData);
    }

    public boolean func_145842_c(int aEventID, int aValue) {
        super.func_145842_c(aEventID, aValue);
        if (this.hasValidMetaTileEntity()) {
            try {
                this.mMetaTileEntity.receiveClientEvent((byte)aEventID, (byte)aValue);
            }
            catch (Throwable e) {
                GTLog.err.println("Encountered Exception while receiving Data from the Server, the Client should've been crashed by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
                e.printStackTrace(GTLog.err);
            }
        }
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    this.mFacing = ForgeDirection.getOrientation((int)((byte)(aValue & 7)));
                    this.mActive = (aValue & 8) != 0;
                    this.mRedstone = (aValue & 0x10) != 0;
                    this.mWorks = (aValue & 0x40) != 0;
                    this.mMuffler = (aValue & 0x80) != 0;
                    break;
                }
                case 1: {
                    if (!this.hasValidMetaTileEntity()) break;
                    if ((aValue & 0x80) == 0) {
                        this.mMetaTileEntity.onValueUpdate((byte)(aValue & 0x7F));
                        break;
                    }
                    if (!(this.mMetaTileEntity instanceof MTEHatch)) break;
                    ((MTEHatch)this.mMetaTileEntity).onTexturePageUpdate((byte)(aValue & 0x7F));
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.mColor = (byte)aValue;
                    break;
                }
                case 3: {
                    this.mSidedRedstone[0] = (byte)((aValue & 1) == 1 ? 15 : 0);
                    this.mSidedRedstone[1] = (byte)((aValue & 2) == 2 ? 15 : 0);
                    this.mSidedRedstone[2] = (byte)((aValue & 4) == 4 ? 15 : 0);
                    this.mSidedRedstone[3] = (byte)((aValue & 8) == 8 ? 15 : 0);
                    this.mSidedRedstone[4] = (byte)((aValue & 0x10) == 16 ? 15 : 0);
                    this.mSidedRedstone[5] = (byte)((aValue & 0x20) == 32 ? 15 : 0);
                    break;
                }
                case 4: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.doSound((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 5: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.startSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 6: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.stopSoundLoop((byte)aValue, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                    break;
                }
                case 7: {
                    this.mLightValue = (byte)aValue;
                }
            }
        }
        return true;
    }

    @Override
    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 2) {
            tList.add("Meta-ID: " + EnumChatFormatting.BLUE + this.mID + EnumChatFormatting.RESET + (this.canAccessData() ? EnumChatFormatting.GREEN + " valid" + EnumChatFormatting.RESET : EnumChatFormatting.RED + " invalid" + EnumChatFormatting.RESET) + (this.mMetaTileEntity == null ? EnumChatFormatting.RED + " MetaTileEntity == null!" + EnumChatFormatting.RESET : " "));
        }
        if (aLogLevel > 1 && this.mMetaTileEntity != null) {
            if (this.hasTimeStatisticsStarted) {
                double tAverageTime = 0.0;
                double tWorstTime = 0.0;
                int amountOfZero = 0;
                for (int tTime : this.mTimeStatistics) {
                    tAverageTime += (double)tTime;
                    if ((double)tTime > tWorstTime) {
                        tWorstTime = tTime;
                    }
                    if (tTime != 0) continue;
                    ++amountOfZero;
                }
                int samples = this.mTimeStatistics.length - amountOfZero;
                if (samples > 0) {
                    tList.add("Average CPU load of ~" + GTUtility.formatNumbers(tAverageTime / (double)samples) + "ns over " + GTUtility.formatNumbers(samples) + " ticks with worst time of " + GTUtility.formatNumbers(tWorstTime) + "ns.");
                }
            } else {
                this.startTimeStatistics();
                tList.add("Just started tick time statistics.");
            }
            tList.add("Recorded " + GTUtility.formatNumbers(this.mMetaTileEntity.mSoundRequests) + " sound requests in " + GTUtility.formatNumbers(this.mTickTimer - this.mLastCheckTick) + " ticks.");
            this.mLastCheckTick = this.mTickTimer;
            this.mMetaTileEntity.mSoundRequests = 0L;
            if (this.mLagWarningCount > 0) {
                tList.add("Caused " + (this.mLagWarningCount >= 10 ? "more than 10" : Integer.valueOf(this.mLagWarningCount)) + " Lag Spike Warnings (anything taking longer than " + GregTechAPI.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING + "ms) on the Server.");
            }
            tList.add("Is" + (this.mMetaTileEntity.isAccessAllowed(aPlayer) ? " " : EnumChatFormatting.RED + " not " + EnumChatFormatting.RESET) + "accessible for you");
        }
        if (aLogLevel > 0) {
            if (this.getSteamCapacity() > 0L && this.hasSteamEngineUpgrade()) {
                tList.add(GTUtility.formatNumbers(this.getStoredSteam()) + " of " + GTUtility.formatNumbers(this.getSteamCapacity()) + " Steam");
            }
            tList.add("Machine is " + (this.mActive ? EnumChatFormatting.GREEN + "active" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "inactive" + EnumChatFormatting.RESET));
            if (!this.mHasEnoughEnergy) {
                tList.add(EnumChatFormatting.RED + "ATTENTION: This Device needs more power." + EnumChatFormatting.RESET);
            }
        }
        if (this.joinedIc2Enet) {
            tList.add("Joined IC2 ENet");
        }
        return this.mMetaTileEntity.getSpecialDebugInfo(this, aPlayer, aLogLevel, tList);
    }

    @Override
    public boolean isGivingInformation() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isGivingInformation();
        }
        return false;
    }

    @Override
    public ForgeDirection getBackFacing() {
        return this.mFacing.getOpposite();
    }

    @Override
    public ForgeDirection getFrontFacing() {
        return this.mFacing;
    }

    @Override
    public void setFrontFacing(ForgeDirection aFacing) {
        if (this.isValidFacing(aFacing)) {
            this.mFacing = aFacing;
            this.mMetaTileEntity.onFacingChange();
            this.doEnetUpdate();
            this.cableUpdateDelay = 10;
            if (this.mMetaTileEntity.shouldTriggerBlockUpdate()) {
                GregTechAPI.causeMachineUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            } else {
                this.onMachineBlockUpdate();
            }
        }
    }

    public int func_70302_i_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70301_a(aIndex);
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        this.mInventoryChanged = true;
        if (this.canAccessData()) {
            this.func_70296_d();
            this.mMetaTileEntity.func_70299_a(aIndex, this.field_145850_b.field_72995_K ? aStack : GTOreDictUnificator.setStack(true, aStack));
        }
    }

    public String func_145825_b() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_145825_b();
        }
        if (GregTechAPI.METATILEENTITIES[this.mID] != null) {
            return GregTechAPI.METATILEENTITIES[this.mID].func_145825_b();
        }
        return "";
    }

    public int func_70297_j_() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.func_70297_j_();
        }
        return 64;
    }

    public void func_70295_k_() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onOpenGUI();
        }
    }

    public void func_70305_f() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onCloseGUI();
        }
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return this.canAccessData() && this.playerOwnsThis(aPlayer, false) && this.mTickTimer > 1L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 64.0 && this.mMetaTileEntity.isAccessAllowed(aPlayer);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.mTickTimer = 0L;
    }

    @Override
    public void func_145843_s() {
        this.field_145846_f = false;
        this.leaveEnet();
        if (this.canAccessData()) {
            this.invalidateAE();
            this.mMetaTileEntity.onRemoval();
            this.mMetaTileEntity.setBaseMetaTileEntity(null);
        }
        super.func_145843_s();
    }

    @Override
    public void onChunkUnload() {
        if (this.canAccessData()) {
            this.onCoverUnload();
            this.mMetaTileEntity.onUnload();
        }
        super.onChunkUnload();
        this.onChunkUnloadAE();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    @Override
    public void onMachineBlockUpdate() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onMachineBlockUpdate();
        }
        this.cableUpdateDelay = 10;
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return this.canAccessData() && this.mMetaTileEntity.isMachineBlockUpdateRecursive();
    }

    @Override
    public int getProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.getProgresstime() : 0;
    }

    @Override
    public int getMaxProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.maxProgresstime() : 0;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.canAccessData() && this.mMetaTileEntity.increaseProgress(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
        this.setShutdownStatus(false);
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.onDisableWorking();
        }
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public byte getWorkDataValue() {
        return this.mWorkData;
    }

    @Override
    public void setWorkDataValue(byte aValue) {
        this.mWorkData = aValue;
    }

    @Override
    public int getMetaTileID() {
        return this.mID;
    }

    @Override
    public int setMetaTileID(short aID) {
        this.mID = aID;
        return this.mID;
    }

    @Override
    public boolean isActive() {
        return this.mActive;
    }

    @Override
    public void setActive(boolean aActive) {
        this.mActive = aActive;
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.onSetActive(aActive);
        }
    }

    @Override
    public long getTimer() {
        return this.mTickTimer;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        this.mHasEnoughEnergy = this.decreaseStoredEU(aEnergy, aIgnoreTooLessEnergy) || this.decreaseStoredSteam(aEnergy, false) || aIgnoreTooLessEnergy && this.decreaseStoredSteam(aEnergy, true);
        return this.mHasEnoughEnergy;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.getStoredEU() < this.getEUCapacity() || aIgnoreTooMuchEnergy) {
            this.setStoredEU(this.mMetaTileEntity.getEUVar() + aEnergy);
            return true;
        }
        return false;
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side) {
        return this.inputEnergyFrom(side, true);
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side, boolean waitForActive) {
        if (side == ForgeDirection.UNKNOWN) {
            return true;
        }
        if (this.isServerSide() && waitForActive) {
            return this.mActiveEUInputs[side.ordinal()] && !this.mReleaseEnergy;
        }
        return this.isEnergyInputSide(side);
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side) {
        return this.outputsEnergyTo(side, true);
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side, boolean waitForActive) {
        if (side == ForgeDirection.UNKNOWN) {
            return true;
        }
        if (this.isServerSide() && waitForActive) {
            return this.mActiveEUOutputs[side.ordinal()] || this.mReleaseEnergy;
        }
        return this.isEnergyOutputSide(side);
    }

    @Override
    public boolean isEnetOutput() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.isEnetOutput();
    }

    @Override
    public boolean isEnetInput() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.isEnetInput();
    }

    public void generatePowerNodes() {
        if (this.isServerSide() && (this.isEnetInput() || this.isEnetOutput())) {
            int time = MinecraftServer.func_71276_C().func_71259_af();
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                IGregTechTileEntity TE;
                if (!this.outputsEnergyTo(side, false) && !this.inputEnergyFrom(side, false) || !((TE = this.getIGregTechTileEntityAtSide(side)) instanceof BaseMetaPipeEntity)) continue;
                Node node = ((BaseMetaPipeEntity)TE).getNode();
                if (node == null) {
                    new GenerateNodeMapPower((BaseMetaPipeEntity)TE);
                    continue;
                }
                if (node.mCreationTime == time) continue;
                GenerateNodeMap.clearNodeMap(node, -1);
                new GenerateNodeMapPower((BaseMetaPipeEntity)TE);
            }
        }
    }

    @Override
    public long getOutputAmperage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxAmperesOut();
        }
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
            return this.mMetaTileEntity.maxEUOutput();
        }
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxAmperesIn();
        }
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxEUInput();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean increaseStoredSteam(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getSteamVar() < this.getSteamCapacity() || aIgnoreTooMuchEnergy) {
            this.setStoredSteam(this.mMetaTileEntity.getSteamVar() + aEnergy);
            return true;
        }
        return false;
    }

    @Override
    public long getUniversalEnergyStored() {
        return Math.max(this.getStoredEU(), this.getStoredSteam());
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return Math.max(this.getEUCapacity(), this.getSteamCapacity());
    }

    @Override
    public long getStoredEU() {
        if (this.canAccessData()) {
            return Math.min(this.mMetaTileEntity.getEUVar(), this.getEUCapacity());
        }
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.maxEUStore();
        }
        return 0L;
    }

    @Override
    public long getStoredSteam() {
        if (this.canAccessData()) {
            return Math.min(this.mMetaTileEntity.getSteamVar(), this.getSteamCapacity());
        }
        return 0L;
    }

    @Override
    public long getSteamCapacity() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.maxSteamStore();
        }
        return 0L;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, ForgeDirection side) {
        ITexture[] textureUncovered;
        ITexture coverTexture = this.getCoverTexture(side);
        ITexture[] iTextureArray = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getTexture(this, side, this.mFacing, (byte)(this.mColor - 1), this.mActive, this.getOutputRedstoneSignal(side) > 0) : (textureUncovered = Textures.BlockIcons.ERROR_RENDERING);
        if (coverTexture != null) {
            ITexture[] textureCovered = Arrays.copyOf(textureUncovered, textureUncovered.length + 1);
            textureCovered[textureUncovered.length] = coverTexture;
            return textureCovered;
        }
        return textureUncovered;
    }

    private boolean isEnergyInputSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            if (!this.getCoverInfoAtSide(side).letsEnergyIn()) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return false;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetInput()) {
                return this.mMetaTileEntity.isInputFacing(side);
            }
        }
        return false;
    }

    private boolean isEnergyOutputSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            if (!this.getCoverInfoAtSide(side).letsEnergyOut()) {
                return false;
            }
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return this.mReleaseEnergy;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
                return this.mMetaTileEntity.isOutputFacing(side);
            }
        }
        return false;
    }

    @Override
    protected boolean hasValidMetaTileEntity() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.getBaseMetaTileEntity() == this;
    }

    @Override
    protected boolean canAccessData() {
        return !this.isDead && this.hasValidMetaTileEntity();
    }

    public boolean setStoredEU(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setEUVar(aEnergy);
        return true;
    }

    public boolean setStoredSteam(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setSteamVar(aEnergy);
        return true;
    }

    public boolean decreaseStoredEU(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getEUVar() - aEnergy >= 0L || aIgnoreTooLessEnergy) {
            this.setStoredEU(this.mMetaTileEntity.getEUVar() - aEnergy);
            if (this.mMetaTileEntity.getEUVar() < 0L) {
                this.setStoredEU(0L);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean decreaseStoredSteam(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getSteamVar() - aEnergy >= 0L || aIgnoreTooLessEnergy) {
            this.setStoredSteam(this.mMetaTileEntity.getSteamVar() - aEnergy);
            if (this.mMetaTileEntity.getSteamVar() < 0L) {
                this.setStoredSteam(0L);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean playerOwnsThis(EntityPlayer aPlayer, boolean aCheckPrecicely) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aCheckPrecicely || this.privateAccess() || this.mOwnerName.length() == 0) {
            if (this.mOwnerName.length() == 0 && this.isServerSide()) {
                this.setOwnerName(aPlayer.getDisplayName());
                this.setOwnerUuid(aPlayer.func_110124_au());
            } else {
                return !this.privateAccess() || aPlayer.getDisplayName().equals("Player") || this.mOwnerName.equals("Player") || this.mOwnerName.equals(aPlayer.getDisplayName());
            }
        }
        return true;
    }

    public boolean privateAccess() {
        if (!this.canAccessData()) {
            return this.mLockUpgrade;
        }
        return this.mLockUpgrade || this.mMetaTileEntity.ownerControl();
    }

    @Override
    @Nullable
    public ICleanroom getCleanroom() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getCleanroom();
        }
        return null;
    }

    @Override
    public void setCleanroom(ICleanroom cleanroom) {
        if (this.canAccessData()) {
            this.mMetaTileEntity.setCleanroom(cleanroom);
        }
    }

    public void doEnergyExplosion() {
        if (this.getUniversalEnergyCapacity() > 0L && this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 5L) {
            GTLog.exp.println("Energy Explosion, injected " + this.getUniversalEnergyStored() + "EU >= " + (double)this.getUniversalEnergyCapacity() / 5.0 + "Capacity of the Machine!");
            this.doExplosion(this.oOutput * (long)(this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() ? 4 : (this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 2L ? 2 : 1)));
            GTMod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "electricproblems");
        }
    }

    @Override
    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            if (GregTechAPI.sMachineWireFire && this.mMetaTileEntity.isElectric()) {
                try {
                    this.mReleaseEnergy = true;
                    IEnergyConnected.Util.emitEnergyToNetwork(GTValues.V[5], Math.max(1L, this.getStoredEU() / GTValues.V[5]), this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mReleaseEnergy = false;
            this.mMetaTileEntity.onExplosion();
            if (GTMod.gregtechproxy.mExplosionItemDrop) {
                for (int i = 0; i < this.func_70302_i_(); ++i) {
                    ItemStack tItem = this.func_70301_a(i);
                    if (tItem == null || tItem.field_77994_a <= 0 || !this.isValidSlot(i)) continue;
                    this.dropItems(tItem);
                    this.func_70299_a(i, null);
                }
            }
            if (this.mRecipeStuff != null) {
                for (int i = 0; i < 9; ++i) {
                    if (this.getRandomNumber(100) >= 50) continue;
                    this.dropItems(GTUtility.loadItem(this.mRecipeStuff, "Ingredient." + i));
                }
            }
            Pollution.addPollution(this, GTMod.gregtechproxy.mPollutionOnExplosion);
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    public void dropItems(ItemStack tItem) {
        if (tItem == null) {
            return;
        }
        EntityItem tItemEntity = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)this.field_145848_d + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)this.field_145849_e + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), new ItemStack(tItem.func_77973_b(), tItem.field_77994_a, tItem.func_77960_j()));
        if (tItem.func_77942_o()) {
            tItemEntity.func_92059_d().func_77982_d((NBTTagCompound)tItem.func_77978_p().func_74737_b());
        }
        tItemEntity.field_70159_w = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581;
        tItemEntity.field_70181_x = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581 + 0.2000000029802322;
        tItemEntity.field_70179_y = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581;
        tItemEntity.field_70172_ad = 999999;
        tItemEntity.lifespan = 60000;
        try {
            ENTITY_ITEM_HEALTH_FIELD.setInt(tItemEntity, 99999999);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.field_145850_b.func_72838_d((Entity)tItemEntity);
        tItem.field_77994_a = 0;
    }

    @Override
    public ArrayList<ItemStack> getDrops() {
        ItemStack rStack = new ItemStack(GregTechAPI.sBlockMachines, 1, (int)this.mID);
        NBTTagCompound tNBT = new NBTTagCompound();
        if (this.mRecipeStuff != null && !this.mRecipeStuff.func_82582_d()) {
            tNBT.func_74782_a("GT.CraftingComponents", (NBTBase)this.mRecipeStuff);
        }
        if (this.mMuffler) {
            tNBT.func_74757_a("mMuffler", this.mMuffler);
        }
        if (this.mLockUpgrade) {
            tNBT.func_74757_a("mLockUpgrade", this.mLockUpgrade);
        }
        if (this.mSteamConverter) {
            tNBT.func_74757_a("mSteamConverter", this.mSteamConverter);
        }
        if (this.mColor > 0) {
            tNBT.func_74774_a("mColor", this.mColor);
        }
        if (this.mOtherUpgrades > 0) {
            tNBT.func_74774_a("mOtherUpgrades", this.mOtherUpgrades);
        }
        this.writeCoverNBT(tNBT, true);
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.setItemNBT(tNBT);
        }
        if (!tNBT.func_82582_d()) {
            rStack.func_77982_d(tNBT);
        }
        this.onBaseTEDestroyed();
        return new ArrayList<ItemStack>(Collections.singletonList(rStack));
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return this.mMetaTileEntity == null || this.mMetaTileEntity.shouldDropItemAt(index);
    }

    public int getUpgradeCount() {
        return (this.mMuffler ? 1 : 0) + (this.mLockUpgrade ? 1 : 0) + (this.mSteamConverter ? 1 : 0) + this.mOtherUpgrades;
    }

    @Override
    public boolean onRightclick(EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (this.isClientSide()) {
            if (aPlayer.func_70093_af()) {
                ForgeDirection tSide = this.getCoverIDAtSide(side) == 0 ? GTUtility.determineWrenchingSide(side, aX, aY, aZ) : side;
                return this.getCoverBehaviorAtSideNew(tSide).hasCoverGUI();
            }
            if (this.getCoverBehaviorAtSideNew(side).onCoverRightclickClient(side, this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverInfoAtSide(side).isGUIClickable()) {
                return false;
            }
        }
        if (this.isServerSide() && (!this.privateAccess() || aPlayer.getDisplayName().equalsIgnoreCase(this.getOwnerName()))) {
            ItemStack tCurrentItem = aPlayer.field_71071_by.func_70448_g();
            if (tCurrentItem != null) {
                if (this.getColorization() >= 0 && GTUtility.areStacksEqual(new ItemStack(Items.field_151131_as, 1), tCurrentItem)) {
                    tCurrentItem.func_150996_a(Items.field_151133_ar);
                    this.setColorization((byte)(this.getColorization() >= 16 ? -2 : -1));
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sWrenchList)) {
                    if (aPlayer.func_70093_af() && this.mMetaTileEntity instanceof MTEBasicMachine && ((MTEBasicMachine)this.mMetaTileEntity).setMainFacing(GTUtility.determineWrenchingSide(side, aX, aY, aZ))) {
                        GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.cableUpdateDelay = 10;
                    } else if (this.mMetaTileEntity.onWrenchRightClick(side, GTUtility.determineWrenchingSide(side, aX, aY, aZ), aPlayer, aX, aY, aZ, tCurrentItem)) {
                        GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.cableUpdateDelay = 10;
                    }
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sScrewdriverList)) {
                    if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
                        this.setCoverDataAtSide(side, (ISerializableObject)this.getCoverBehaviorAtSideNew(side).onCoverScrewdriverClick(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this, aPlayer, aX, aY, aZ));
                        this.mMetaTileEntity.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, tCurrentItem);
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sHardHammerList)) {
                    if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        boolean bl = this.mInputDisabled = !this.mInputDisabled;
                        if (this.mInputDisabled) {
                            this.mOutputDisabled = !this.mOutputDisabled;
                        }
                        GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("086", "Auto-Input: ") + (this.mInputDisabled ? GTUtility.trans("087", "Disabled") : GTUtility.trans("088", "Enabled") + GTUtility.trans("089", "  Auto-Output: ") + (this.mOutputDisabled ? GTUtility.trans("087", "Disabled") : GTUtility.trans("088", "Enabled"))));
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.RANDOM_ANVIL_USE, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sSoftHammerList)) {
                    if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        if (this.mWorks) {
                            this.disableWorking();
                        } else {
                            this.enableWorking();
                        }
                        String tChat = GTUtility.trans("090", "Machine Processing: ") + (this.isAllowedToWork() ? GTUtility.trans("088", "Enabled") : GTUtility.trans("087", "Disabled"));
                        if (this.getMetaTileEntity() != null && this.getMetaTileEntity().hasAlternativeModeText()) {
                            tChat = this.getMetaTileEntity().getAlternativeModeText();
                        }
                        GTUtility.sendChatToPlayer(aPlayer, tChat);
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_RUBBER_TRAMPOLINE, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sSolderingToolList)) {
                    ForgeDirection tSide = GTUtility.determineWrenchingSide(side, aX, aY, aZ);
                    if (this.mMetaTileEntity.onSolderingToolRightClick(side, tSide, aPlayer, aX, aY, aZ, tCurrentItem)) {
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_BATTERY_USE, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else if (GTModHandler.useSolderingIron(tCurrentItem, (EntityLivingBase)aPlayer)) {
                        this.mStrongRedstone = (byte)(this.mStrongRedstone ^ tSide.flag);
                        GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("091", "Redstone Output at Side ") + tSide + GTUtility.trans("092", " set to: ") + ((this.mStrongRedstone & tSide.flag) != 0 ? GTUtility.trans("093", "Strong") : GTUtility.trans("094", "Weak")));
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_BATTERY_USE, 3.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        this.issueBlockUpdate();
                    }
                    this.doEnetUpdate();
                    this.cableUpdateDelay = 10;
                    return true;
                }
                if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sWireCutterList)) {
                    ForgeDirection tSide = GTUtility.determineWrenchingSide(side, aX, aY, aZ);
                    if (this.mMetaTileEntity.onWireCutterRightClick(side, tSide, aPlayer, aX, aY, aZ, tCurrentItem)) {
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                    this.doEnetUpdate();
                    this.cableUpdateDelay = 10;
                    return true;
                }
                ForgeDirection coverSide = side;
                if (this.getCoverIDAtSide(side) == 0) {
                    coverSide = GTUtility.determineWrenchingSide(side, aX, aY, aZ);
                }
                if (this.getCoverIDAtSide(coverSide) == 0) {
                    if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sCovers.keySet())) {
                        CoverBehaviorBase<?> coverBehavior = GregTechAPI.getCoverBehaviorNew(tCurrentItem);
                        if (coverBehavior.isCoverPlaceable(coverSide, tCurrentItem, this) && this.mMetaTileEntity.allowCoverOnSide(coverSide, new GTItemStack(tCurrentItem))) {
                            this.setCoverItemAtSide(coverSide, tCurrentItem);
                            coverBehavior.onPlayerAttach(aPlayer, tCurrentItem, this, coverSide);
                            if (!aPlayer.field_71075_bZ.field_75098_d) {
                                --tCurrentItem.field_77994_a;
                            }
                            GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_WRENCH, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            this.sendClientData();
                        }
                        return true;
                    }
                } else {
                    CoverInfo info;
                    if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sCrowbarList)) {
                        if (GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                            GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.RANDOM_BREAK, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                            this.dropCover(coverSide, side, false);
                        }
                        return true;
                    }
                    if (GTUtility.isStackInList(tCurrentItem, GregTechAPI.sJackhammerList) && GTModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer) && (info = this.getCoverInfoAtSide(coverSide)) != CoverInfo.EMPTY_INFO) {
                        CoverBehaviorBase<?> behavior = info.getCoverBehavior();
                        if (behavior.allowsTickRateAddition()) {
                            info.onCoverJackhammer(aPlayer);
                            GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.IC2_TOOLS_DRILL_DRILL_SOFT, 1.0f, 1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        } else {
                            GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"gt.cover.info.chat.tick_rate_not_allowed"));
                        }
                        return true;
                    }
                }
            } else if (aPlayer.func_70093_af()) {
                side = this.getCoverIDAtSide(side) == 0 ? GTUtility.determineWrenchingSide(side, aX, aY, aZ) : side;
                return this.getCoverIDAtSide(side) > 0 && this.getCoverBehaviorAtSideNew(side).onCoverShiftRightClick(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this, aPlayer);
            }
            if (this.getCoverBehaviorAtSideNew(side).onCoverRightClick(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverInfoAtSide(side).isGUIClickable()) {
                return false;
            }
            if (this.isUpgradable() && tCurrentItem != null) {
                if (ItemList.Upgrade_Muffler.isStackEqual(aPlayer.field_71071_by.func_70448_g())) {
                    if (this.addMufflerUpgrade()) {
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.RANDOM_CLICK, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        if (!aPlayer.field_71075_bZ.field_75098_d) {
                            --aPlayer.field_71071_by.func_70448_g().field_77994_a;
                        }
                    }
                    return true;
                }
                if (ItemList.Upgrade_Lock.isStackEqual(aPlayer.field_71071_by.func_70448_g())) {
                    if (this.isUpgradable() && !this.mLockUpgrade) {
                        this.mLockUpgrade = true;
                        this.setOwnerName(aPlayer.getDisplayName());
                        this.setOwnerUuid(aPlayer.func_110124_au());
                        GTUtility.sendSoundToPlayers(this.field_145850_b, SoundResource.RANDOM_CLICK, 1.0f, -1.0f, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        if (!aPlayer.field_71075_bZ.field_75098_d) {
                            --aPlayer.field_71071_by.func_70448_g().field_77994_a;
                        }
                    }
                    return true;
                }
            }
        }
        try {
            if (!aPlayer.func_70093_af() && this.hasValidMetaTileEntity()) {
                return this.mMetaTileEntity.onRightclick(this, aPlayer, side, aX, aY, aZ);
            }
        }
        catch (Throwable e) {
            GTLog.err.println("Encountered Exception while rightclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GTLog.err);
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void onLeftclick(EntityPlayer aPlayer) {
        try {
            if (aPlayer != null && this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.onLeftclick(this, aPlayer);
            }
        }
        catch (Throwable e) {
            GTLog.err.println("Encountered Exception while leftclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GTLog.err);
        }
    }

    @Override
    public boolean isDigitalChest() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isDigitalChest();
        }
        return false;
    }

    @Override
    public ItemStack[] getStoredItemData() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getStoredItemData();
        }
        return null;
    }

    @Override
    public void setItemCount(int aCount) {
        if (this.canAccessData()) {
            this.mMetaTileEntity.setItemCount(aCount);
        }
    }

    @Override
    public int getMaxItemCount() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getMaxItemCount();
        }
        return 0;
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mMetaTileEntity.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int ordinalSide) {
        CoverInfo coverInfo = this.getCoverInfoAtSide(ForgeDirection.getOrientation((int)ordinalSide));
        if (this.canAccessData() && (coverInfo.letsItemsOut(-1) || coverInfo.letsItemsIn(-1))) {
            return this.mMetaTileEntity.func_94128_d(ordinalSide);
        }
        return GTValues.emptyIntArray;
    }

    public boolean func_102007_a(int slotIndex, ItemStack stack, int ordinalSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && this.getCoverInfoAtSide(ForgeDirection.getOrientation((int)ordinalSide)).letsItemsIn(slotIndex) && this.mMetaTileEntity.func_102007_a(slotIndex, stack, ordinalSide);
    }

    public boolean func_102008_b(int slotIndex, ItemStack stack, int ordinalSide) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        return this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && this.getCoverBehaviorAtSideNew(side).letsItemsOut(side, this.getCoverIDAtSide(side), this.getComplexCoverDataAtSide(side), slotIndex, this) && this.mMetaTileEntity.func_102008_b(slotIndex, stack, ordinalSide);
    }

    @Override
    public boolean isUpgradable() {
        return this.canAccessData() && this.getUpgradeCount() < 8;
    }

    @Override
    public byte getGeneralRS(ForgeDirection side) {
        if (this.mMetaTileEntity == null) {
            return 0;
        }
        return this.mMetaTileEntity.allowGeneralRedstoneOutput() ? this.mSidedRedstone[side.ordinal()] : (byte)0;
    }

    @Override
    public boolean isSteamEngineUpgradable() {
        return this.isUpgradable() && !this.hasSteamEngineUpgrade() && this.getSteamCapacity() > 0L;
    }

    @Override
    public boolean addSteamEngineUpgrade() {
        if (this.isSteamEngineUpgradable()) {
            this.issueBlockUpdate();
            this.mSteamConverter = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSteamEngineUpgrade() {
        if (this.canAccessData() && this.mMetaTileEntity.isSteampowered()) {
            return true;
        }
        return this.mSteamConverter;
    }

    @Override
    public boolean hasMufflerUpgrade() {
        return this.mMuffler;
    }

    @Override
    public boolean isMufflerUpgradable() {
        return this.isUpgradable() && !this.hasMufflerUpgrade();
    }

    @Override
    public boolean addMufflerUpgrade() {
        if (this.isMufflerUpgradable()) {
            this.mMuffler = true;
            return true;
        }
        return false;
    }

    @Override
    public void markInventoryBeenModified() {
        this.mInventoryChanged = true;
    }

    @Override
    public int getErrorDisplayID() {
        return this.mDisplayErrorCode;
    }

    @Override
    public void setErrorDisplayID(int aErrorID) {
        this.mDisplayErrorCode = aErrorID;
    }

    @Override
    public IMetaTileEntity getMetaTileEntity() {
        return this.hasValidMetaTileEntity() ? this.mMetaTileEntity : null;
    }

    @Override
    public void setMetaTileEntity(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity instanceof MetaTileEntity || aMetaTileEntity == null) {
            this.mMetaTileEntity = (MetaTileEntity)aMetaTileEntity;
        } else {
            GTMod.GT_FML_LOGGER.error("Unknown meta tile entity set! Class {}, inventory name {}.", new Object[]{aMetaTileEntity.getClass(), aMetaTileEntity.func_145825_b()});
        }
    }

    public byte getLightValue() {
        return this.mLightValue;
    }

    @Override
    public void setLightValue(byte aLightValue) {
        this.mLightValue = (byte)(aLightValue & 0xF);
    }

    @Override
    public long getAverageElectricInput() {
        long rEU = 0L;
        for (int i = 0; i < this.mAverageEUInput.length; ++i) {
            if (i == this.mAverageEUInputIndex) continue;
            rEU += this.mAverageEUInput[i];
        }
        return rEU / (long)(this.mAverageEUInput.length - 1);
    }

    @Override
    public long getAverageElectricOutput() {
        long rEU = 0L;
        for (int i = 0; i < this.mAverageEUOutput.length; ++i) {
            if (i == this.mAverageEUOutputIndex) continue;
            rEU += this.mAverageEUOutput[i];
        }
        return rEU / (long)(this.mAverageEUOutput.length - 1);
    }

    @Override
    protected void updateOutputRedstoneSignal(ForgeDirection side) {
        if (this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
            this.setOutputRedstoneSignal(side, (byte)0);
        } else {
            this.setOutputRedstoneSignal(side, (byte)15);
        }
    }

    @Override
    public String getOwnerName() {
        if (GTUtility.isStringInvalid(this.mOwnerName)) {
            return "Player";
        }
        return this.mOwnerName;
    }

    @Override
    public String setOwnerName(String aName) {
        if (GTUtility.isStringInvalid(aName)) {
            this.mOwnerName = "Player";
            return "Player";
        }
        this.mOwnerName = aName;
        return this.mOwnerName;
    }

    @Override
    public UUID getOwnerUuid() {
        return this.mOwnerUuid;
    }

    @Override
    public void setOwnerUuid(UUID uuid) {
        this.mOwnerUuid = uuid;
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(side) : (byte)0;
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mMetaTileEntity.func_70298_a(aIndex, aAmount);
        }
        return null;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.inputEnergyFrom(side) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.mMetaTileEntity.maxAmperesIn() > this.mAcceptedAmperes)) {
            return 0L;
        }
        if (aVoltage > this.getInputVoltage()) {
            GTLog.exp.println("Energy Explosion, injected " + aVoltage + "EU/t in a " + this.getInputVoltage() + "EU/t Machine!");
            this.doExplosion(aVoltage);
            return 0L;
        }
        if (this.increaseStoredEnergyUnits(aVoltage * (aAmperage = Math.min(aAmperage, Math.min(this.mMetaTileEntity.maxAmperesIn() - this.mAcceptedAmperes, 1L + (this.getEUCapacity() - this.getStoredEU()) / aVoltage))), true)) {
            int n = this.mAverageEUInputIndex;
            this.mAverageEUInput[n] = this.mAverageEUInput[n] + aVoltage * aAmperage;
            this.mAcceptedAmperes += aAmperage;
            return aAmperage;
        }
        return 0L;
    }

    @Override
    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.outputsEnergyTo(side) && this.getStoredEU() - aVoltage * aAmperage >= this.mMetaTileEntity.getMinimumStoredEU())) {
            return false;
        }
        if (this.decreaseStoredEU(aVoltage * aAmperage, false)) {
            int n = this.mAverageEUOutputIndex;
            this.mAverageEUOutput[n] = this.mAverageEUOutput[n] + aVoltage * aAmperage;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsRotationalEnergy(ForgeDirection side) {
        if (!this.canAccessData() || this.getCoverIDAtSide(side) != 0) {
            return false;
        }
        return this.mMetaTileEntity.acceptsRotationalEnergy(side);
    }

    @Override
    public boolean injectRotationalEnergy(ForgeDirection side, long aSpeed, long aEnergy) {
        if (!this.canAccessData() || this.getCoverIDAtSide(side) != 0) {
            return false;
        }
        return this.mMetaTileEntity.injectRotationalEnergy(side, aSpeed, aEnergy);
    }

    public int fill(ForgeDirection side, FluidStack aFluid, boolean doFill) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput(side) && this.getCoverInfoAtSide(side).letsFluidIn(aFluid == null ? null : aFluid.getFluid()))) {
            return this.mMetaTileEntity.fill(side, aFluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection side, int maxDrain, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput(side) && this.getCoverInfoAtSide(side).letsFluidOut(this.mMetaTileEntity.getFluid() == null ? null : this.mMetaTileEntity.getFluid().getFluid()))) {
            return this.mMetaTileEntity.drain(side, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection side, FluidStack aFluid, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput(side) && this.getCoverInfoAtSide(side).letsFluidOut(aFluid == null ? null : aFluid.getFluid()))) {
            return this.mMetaTileEntity.drain(side, aFluid, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection side, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput(side) && this.getCoverInfoAtSide(side).letsFluidIn(aFluid))) {
            return this.mMetaTileEntity.canFill(side, aFluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection side, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput(side) && this.getCoverInfoAtSide(side).letsFluidOut(aFluid))) {
            return this.mMetaTileEntity.canDrain(side, aFluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        if (this.canAccessData() && (side == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput(side) && this.getCoverInfoAtSide(side).letsFluidIn(null) || this.mMetaTileEntity.isLiquidOutput(side) && this.getCoverInfoAtSide(side).letsFluidOut(null))) {
            return this.mMetaTileEntity.getTankInfo(side);
        }
        return new FluidTankInfo[0];
    }

    public double getOutputEnergyUnitsPerTick() {
        return this.oOutput;
    }

    public boolean isTeleporterCompatible(ForgeDirection side) {
        return this.canAccessData() && this.mMetaTileEntity.isTeleporterCompatible();
    }

    public double demandedEnergyUnits() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0.0;
        }
        return this.getEUCapacity() - this.getStoredEU();
    }

    public double injectEnergyUnits(ForgeDirection aDirection, double aAmount) {
        return this.injectEnergyUnits(aDirection, (int)aAmount, 1L) > 0L ? 0.0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return this.inputEnergyFrom(aDirection);
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return this.outputsEnergyTo(aDirection);
    }

    public double getOfferedEnergy() {
        return this.canAccessData() && this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU() >= this.oOutput ? (double)Math.max(0L, this.oOutput) : 0.0;
    }

    public void drawEnergy(double amount) {
        int n = this.mAverageEUOutputIndex;
        this.mAverageEUOutput[n] = (long)((double)this.mAverageEUOutput[n] + amount);
        this.decreaseStoredEU((int)amount, true);
    }

    public int injectEnergy(ForgeDirection aForgeDirection, int aAmount) {
        return this.injectEnergyUnits(aForgeDirection, aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public int addEnergy(int aEnergy) {
        if (!this.canAccessData()) {
            return 0;
        }
        if (aEnergy > 0) {
            this.increaseStoredEnergyUnits(aEnergy, true);
        } else {
            this.decreaseStoredEU(-aEnergy, true);
        }
        return (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getEUVar());
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int demandsEnergy() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0;
        }
        return this.getCapacity() - this.getStored();
    }

    public int getCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity());
    }

    public int getStored() {
        return (int)Math.min(Integer.MAX_VALUE, Math.min(this.getStoredEU(), (long)this.getCapacity()));
    }

    public void setStored(int aEU) {
        if (this.canAccessData()) {
            this.setStoredEU(aEU);
        }
    }

    public int getMaxSafeInput() {
        return (int)Math.min(Integer.MAX_VALUE, this.getInputVoltage());
    }

    public int getMaxEnergyOutput() {
        if (this.mReleaseEnergy) {
            return Integer.MAX_VALUE;
        }
        return this.getOutput();
    }

    public int getOutput() {
        return (int)Math.min(Integer.MAX_VALUE, this.oOutput);
    }

    public int injectEnergy(Direction aDirection, int aAmount) {
        return this.injectEnergyUnits(aDirection.toForgeDirection(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public boolean isTeleporterCompatible(Direction ignoredDirection) {
        return this.canAccessData() && this.mMetaTileEntity.isTeleporterCompatible();
    }

    public boolean acceptsEnergyFrom(TileEntity ignoredTileEntity, Direction aDirection) {
        return this.inputEnergyFrom(aDirection.toForgeDirection());
    }

    public boolean emitsEnergyTo(TileEntity ignoredTileEntity, Direction aDirection) {
        return this.outputsEnergyTo(aDirection.toForgeDirection());
    }

    @Override
    public boolean addStackToSlot(int slotIndex, ItemStack stack) {
        if (GTUtility.isStackInvalid(stack)) {
            return true;
        }
        if (slotIndex < 0 || slotIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack toStack = this.func_70301_a(slotIndex);
        if (GTUtility.isStackInvalid(toStack)) {
            this.func_70299_a(slotIndex, stack);
            return true;
        }
        ItemStack fromStack = GTOreDictUnificator.get(stack);
        if (GTUtility.areStacksEqual(toStack, fromStack) && toStack.field_77994_a + fromStack.field_77994_a <= Math.min(fromStack.func_77976_d(), this.func_70297_j_())) {
            toStack.field_77994_a += fromStack.field_77994_a;
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GTUtility.copyAmount(aAmount, aStack));
    }

    @Override
    public byte getColorization() {
        return (byte)(this.mColor - 1);
    }

    @Override
    public byte setColorization(byte aColor) {
        if (aColor > 15 || aColor < -1) {
            aColor = (byte)-1;
        }
        this.mColor = (byte)(aColor + 1);
        if (this.canAccessData()) {
            this.mMetaTileEntity.onColorChangeServer(aColor);
        }
        return this.mColor;
    }

    @Override
    public float getBlastResistance(ForgeDirection side) {
        return this.canAccessData() ? Math.max(0.0f, this.getMetaTileEntity().getExplosionResistance(side)) : 10.0f;
    }

    @Override
    public void onBlockDestroyed() {
        if (this.canAccessData()) {
            this.getMetaTileEntity().onBlockDestroyed();
        }
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        if (this.getUniversalEnergyStored() >= aEnergyAmount) {
            return true;
        }
        this.mHasEnoughEnergy = false;
        return false;
    }

    @Override
    public String[] getInfoData() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getInfoData();
        }
        return new String[0];
    }

    @Override
    public int getLightOpacity() {
        return this.mMetaTileEntity == null ? (this.getLightValue() > 0 ? 0 : 255) : this.mMetaTileEntity.getLightOpacity();
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        this.mMetaTileEntity.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return this.mMetaTileEntity.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
        this.mMetaTileEntity.onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
    }

    @Override
    protected int migrateInventoryIndex(int slotIndex, int nbtVersion) {
        int newOutputSize;
        int newInputSize;
        int oldOutputSize;
        int oldInputSize;
        int chemistryUpdateVersion = GTMod.calculateTotalGTVersion(509, 31);
        int configCircuitAdditionVersion = GTMod.calculateTotalGTVersion(509, 40);
        int wireAdditionVersion = GTMod.calculateTotalGTVersion(509, 41);
        int disassemblerRemoveVersion = GTMod.calculateTotalGTVersion(509, 42, 44);
        if (nbtVersion < 1000000) {
            nbtVersion *= 1000;
        }
        if (nbtVersion < configCircuitAdditionVersion && this.getMetaTileEntity() instanceof MTEBasicMachine && slotIndex >= 4) {
            ++slotIndex;
        }
        if (this.mID >= 211 && this.mID <= 218) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 2;
            oldOutputSize = 1;
            newInputSize = 6;
            newOutputSize = 1;
        } else if (this.mID >= 421 && this.mID <= 428) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 2;
            oldOutputSize = 1;
            newInputSize = 2;
            newOutputSize = 2;
        } else if (this.mID >= 531 && this.mID <= 538) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 1;
            oldOutputSize = 0;
            newInputSize = 1;
            newOutputSize = 1;
        } else if (this.mID >= 581 && this.mID <= 588) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 4;
            oldOutputSize = 1;
            newInputSize = 6;
            newOutputSize = 1;
        } else if (this.mID >= 351 && this.mID <= 355 || this.mID >= 11050 && this.mID <= 11056) {
            if (nbtVersion >= wireAdditionVersion) {
                return slotIndex;
            }
            oldInputSize = 1;
            oldOutputSize = 1;
            newInputSize = 2;
            newOutputSize = 1;
        } else if (this.mID >= 654 && this.mID <= 655 || this.mID >= 11070 && this.mID <= 11076) {
            if (nbtVersion >= disassemblerRemoveVersion) {
                return slotIndex;
            }
            oldInputSize = 1;
            oldOutputSize = 4;
            newInputSize = 1;
            newOutputSize = 9;
        } else {
            return slotIndex;
        }
        int indexShift = 0;
        if (slotIndex >= 5 + oldInputSize) {
            indexShift += newInputSize - oldInputSize;
        }
        if (slotIndex >= 5 + oldInputSize + oldOutputSize) {
            indexShift += newOutputSize - oldOutputSize;
        }
        return slotIndex + indexShift;
    }

    public IGridNode getGridNode(ForgeDirection forgeDirection) {
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.mMetaTileEntity == null ? AECableType.NONE : this.mMetaTileEntity.getCableConnectionType(forgeDirection);
    }

    public void securityBreak() {
    }

    public IGridNode getActionableNode() {
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    public AENetworkProxy getProxy() {
        return this.mMetaTileEntity == null ? null : this.mMetaTileEntity.getProxy();
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public void gridChanged() {
        if (this.mMetaTileEntity != null) {
            this.mMetaTileEntity.gridChanged();
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    public void readFromNBT_AENetwork(NBTTagCompound data) {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            this.getProxy().readFromNBT(data);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    public void writeToNBT_AENetwork(NBTTagCompound data) {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            gp.writeToNBT(data);
        }
    }

    void onChunkUnloadAE() {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            gp.onChunkUnload();
        }
    }

    void invalidateAE() {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            gp.invalidate();
        }
    }

    @Override
    public boolean wasShutdown() {
        return this.mWasShutdown;
    }

    @Override
    public void setShutdownStatus(boolean newStatus) {
        this.mWasShutdown = newStatus;
    }

    @Override
    public void setShutDownReason(@NotNull ShutDownReason reason) {
        this.lastShutDownReason = reason;
    }

    @Override
    @NotNull
    public ShutDownReason getLastShutDownReason() {
        return this.lastShutDownReason;
    }

    public IAlignment getAlignment() {
        return this.getMetaTileEntity() instanceof IAlignmentProvider ? ((IAlignmentProvider)this.getMetaTileEntity()).getAlignment() : (this.getMetaTileEntity() instanceof IAlignment ? (IAlignment)this.getMetaTileEntity() : null);
    }

    @Nullable
    public IConstructable getConstructable() {
        return this.getMetaTileEntity() instanceof IConstructable ? (IConstructable)this.getMetaTileEntity() : null;
    }

    @Override
    public int[] getTimeStatistics() {
        return this.mTimeStatistics;
    }

    @Override
    public void startTimeStatistics() {
        this.hasTimeStatisticsStarted = true;
    }

    @Override
    @Nullable
    public List<ItemStack> getItemsForHoloGlasses() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getItemsForHoloGlasses();
        }
        return null;
    }

    public String getCustomName() {
        String string;
        IMetaTileEntity iMetaTileEntity = this.getMetaTileEntity();
        if (iMetaTileEntity instanceof ICustomNameObject) {
            ICustomNameObject customNameObject = (ICustomNameObject)iMetaTileEntity;
            string = customNameObject.getCustomName();
        } else {
            string = null;
        }
        return string;
    }

    public boolean hasCustomName() {
        ICustomNameObject customNameObject;
        IMetaTileEntity iMetaTileEntity = this.getMetaTileEntity();
        return iMetaTileEntity instanceof ICustomNameObject && (customNameObject = (ICustomNameObject)iMetaTileEntity).hasCustomName();
    }

    public void setCustomName(String name) {
        IMetaTileEntity iMetaTileEntity = this.getMetaTileEntity();
        if (iMetaTileEntity instanceof ICustomNameObject) {
            ICustomNameObject customNameObject = (ICustomNameObject)iMetaTileEntity;
            customNameObject.setCustomName(name);
        }
    }
}

