/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.util;

import bartworks.system.material.Werkstoff;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.metatileentity.implementations.MTECable;
import gregtech.api.metatileentity.implementations.MTEFluid;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CrackRecipeAdder {
    static float[] coe1 = new float[]{1.25f, 1.2f, 1.1f, 0.9f, 0.85f, 0.8f, 0.75f};
    static float[] coe2 = new float[]{1.4f, 1.25f, 1.2f, 0.8f, 0.75f, 0.7f, 0.65f};
    static float[] coe3 = new float[]{1.6f, 1.5f, 1.45f, 0.7f, 0.6f, 0.55f, 0.45f};

    public static void crackerAdder(FluidStack inputFluid, FluidStack cracker, FluidStack[] outputFluids, ItemStack outputItem, int num, int EUt, int Duration2) {
        int tmp2;
        Fluid tmp1;
        FluidStack[] actOutput = new FluidStack[num];
        String name = inputFluid.getFluid().getName().replaceAll(" ", "");
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(1)).fluidInputs(inputFluid, cracker).fluidOutputs(FluidRegistry.getFluidStack((String)("lightlycracked" + name), (int)1000)).duration(Math.max((long)((double)Duration2 * 0.8), 1L) * 1L).eut(EUt).addTo(RecipeMaps.crackingRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(2)).fluidInputs(inputFluid, cracker).fluidOutputs(FluidRegistry.getFluidStack((String)("moderatelycracked" + name), (int)1000)).duration(Math.max((long)Duration2, 1L) * 1L).eut(EUt).addTo(RecipeMaps.crackingRecipes);
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(3)).fluidInputs(inputFluid, cracker).fluidOutputs(FluidRegistry.getFluidStack((String)("heavilycracked" + name), (int)1000)).duration(Math.max((long)((double)Duration2 * 1.2), 1L) * 1L).eut(EUt).addTo(RecipeMaps.crackingRecipes);
        int i = num - 1;
        int j = 0;
        while (i >= 0) {
            tmp1 = outputFluids[i].getFluid();
            tmp2 = (int)((float)outputFluids[i].amount * coe1[i]);
            actOutput[j] = new FluidStack(tmp1, tmp2);
            --i;
            ++j;
        }
        CrackRecipeAdder.addUniversalDistillationRecipe(FluidRegistry.getFluidStack((String)("lightlycracked" + name), (int)1000), actOutput, outputItem, Duration2 / 2, EUt / 3);
        i = num - 1;
        j = 0;
        while (i >= 0) {
            tmp1 = outputFluids[i].getFluid();
            tmp2 = (int)((float)outputFluids[i].amount * coe2[i]);
            actOutput[j] = new FluidStack(tmp1, tmp2);
            --i;
            ++j;
        }
        CrackRecipeAdder.addUniversalDistillationRecipe(FluidRegistry.getFluidStack((String)("moderatelycracked" + name), (int)1000), actOutput, outputItem, Duration2 / 2, EUt / 3);
        i = num - 1;
        j = 0;
        while (i >= 0) {
            tmp1 = outputFluids[i].getFluid();
            tmp2 = (int)((float)outputFluids[i].amount * coe3[i]);
            actOutput[j] = new FluidStack(tmp1, tmp2);
            --i;
            ++j;
        }
        CrackRecipeAdder.addUniversalDistillationRecipe(FluidRegistry.getFluidStack((String)("heavilycracked" + name), (int)1000), actOutput, outputItem, Duration2 / 2, EUt / 3);
    }

    public static void reAddBlastRecipe(Werkstoff material, int duration, int EUt, int level, boolean gas) {
        ItemStack output;
        ItemStack input = material.get(OrePrefixes.dust, 1);
        ItemStack itemStack = output = level > 1750 ? material.get(OrePrefixes.ingotHot, 1) : material.get(OrePrefixes.ingot, 1);
        if (gas) {
            GTValues.RA.stdBuilder().itemInputs(input, GTUtility.getIntegratedCircuit(11)).fluidInputs(Materials.Helium.getGas(1000L)).itemOutputs(output).duration(duration * 1).eut(EUt).metadata(GTRecipeConstants.COIL_HEAT, level).addTo(RecipeMaps.blastFurnaceRecipes);
        } else {
            GTValues.RA.stdBuilder().itemInputs(input, GTUtility.getIntegratedCircuit(1)).itemOutputs(output).duration(duration * 1).eut(EUt).metadata(GTRecipeConstants.COIL_HEAT, level).addTo(RecipeMaps.blastFurnaceRecipes);
        }
    }

    public static void addUniversalDistillationRecipewithCircuit(FluidStack aInput, ItemStack[] aCircuit, FluidStack[] aOutputs, ItemStack aOutput2, int aDuration, long aEUt) {
        for (int i = 0; i < Math.min(aOutputs.length, 11); ++i) {
            GTRecipeBuilder buildDistillation = GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(i + 1));
            if (aOutput2 != GTValues.NI) {
                buildDistillation.itemOutputs(aOutput2);
            }
            buildDistillation.fluidInputs(aInput).fluidOutputs(aOutputs[i]).duration(2 * aDuration).eut(aEUt / 4L).addTo(RecipeMaps.distilleryRecipes);
        }
        GTRecipeBuilder buildDT = GTValues.RA.stdBuilder().itemInputs(aCircuit);
        if (aOutput2 != GTValues.NI) {
            buildDT.itemOutputs(aOutput2);
        }
        buildDT.fluidInputs(aInput).fluidOutputs(aOutputs).duration(aDuration).eut(aEUt).addTo(RecipeMaps.distillationTowerRecipes);
    }

    public static void addUniversalDistillationRecipe(FluidStack aInput, FluidStack[] aOutputs, ItemStack aOutput2, int aDuration, long aEUt) {
        for (int i = 0; i < Math.min(aOutputs.length, 11); ++i) {
            GTRecipeBuilder buildDistillation = GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(i + 1));
            if (aOutput2 != GTValues.NI) {
                buildDistillation.itemOutputs(aOutput2);
            }
            buildDistillation.fluidInputs(aInput).fluidOutputs(aOutputs[i]).duration(2 * aDuration).eut(aEUt / 4L).addTo(RecipeMaps.distilleryRecipes);
        }
        GTRecipeBuilder buildDT = GTValues.RA.stdBuilder();
        if (aOutput2 != GTValues.NI) {
            buildDT.itemOutputs(aOutput2);
        }
        buildDT.fluidInputs(aInput).fluidOutputs(aOutputs).duration(aDuration).eut(aEUt).addTo(RecipeMaps.distillationTowerRecipes);
    }

    public static FluidStack copyFluidWithAmount(FluidStack fluid, int amount) {
        if (fluid == null || amount <= 0) {
            return null;
        }
        return new FluidStack(fluid.getFluid(), amount);
    }

    public static void registerPipe(int ID, Werkstoff material, int flow, int temp, boolean gas) {
        String unName = material.getDefaultName().replace(" ", "_");
        String Name2 = material.getDefaultName();
        GTOreDictUnificator.registerOre(OrePrefixes.pipeTiny.get(material.getBridgeMaterial()), new MTEFluid(ID, "GT_Pipe_" + unName + "_Tiny", "Tiny " + Name2 + " Fluid Pipe", 0.25f, material.getBridgeMaterial(), flow / 6, temp, gas).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeSmall.get(material.getBridgeMaterial()), new MTEFluid(ID + 1, "GT_Pipe_" + unName + "_Small", "Small " + Name2 + " Fluid Pipe", 0.375f, material.getBridgeMaterial(), flow / 3, temp, gas).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeMedium.get(material.getBridgeMaterial()), new MTEFluid(ID + 2, "GT_Pipe_" + unName, Name2 + " Fluid Pipe", 0.5f, material.getBridgeMaterial(), flow, temp, gas).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeLarge.get(material.getBridgeMaterial()), new MTEFluid(ID + 3, "GT_Pipe_" + unName + "_Large", "Large " + Name2 + " Fluid Pipe", 0.75f, material.getBridgeMaterial(), flow * 2, temp, gas).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.pipeHuge.get(material.getBridgeMaterial()), new MTEFluid(ID + 4, "GT_Pipe_" + unName + "_Huge", "Huge " + Name2 + " Fluid Pipe", 0.875f, material.getBridgeMaterial(), flow * 4, temp, gas).getStackForm(1L));
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 1), ItemList.Shape_Extruder_Pipe_Tiny.get(0L, new Object[0])).itemOutputs(material.get(OrePrefixes.pipeTiny, 2)).duration(material.getStats().getMass() * 1L).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.extruderRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 1), ItemList.Shape_Extruder_Pipe_Small.get(0L, new Object[0])).itemOutputs(material.get(OrePrefixes.pipeSmall, 1)).duration(material.getStats().getMass() * 2L * 1L).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.extruderRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 3), ItemList.Shape_Extruder_Pipe_Medium.get(0L, new Object[0])).itemOutputs(material.get(OrePrefixes.pipeMedium, 1)).duration(material.getStats().getMass() * 6L * 1L).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.extruderRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 6), ItemList.Shape_Extruder_Pipe_Large.get(0L, new Object[0])).itemOutputs(material.get(OrePrefixes.pipeLarge, 1)).duration(material.getStats().getMass() * 12L * 1L).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.extruderRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 12), ItemList.Shape_Extruder_Pipe_Huge.get(0L, new Object[0])).itemOutputs(material.get(OrePrefixes.pipeHuge, 1)).duration(material.getStats().getMass() * 24L * 1L).eut(TierEU.RECIPE_MV).addTo(RecipeMaps.extruderRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Tiny.get(0L, new Object[0])).fluidInputs(material.getMolten(72)).itemOutputs(material.get(OrePrefixes.pipeTiny, 1)).duration(material.getStats().getMass() * 1L).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Small.get(0L, new Object[0])).fluidInputs(material.getMolten(144)).itemOutputs(material.get(OrePrefixes.pipeSmall, 1)).duration(material.getStats().getMass() * 2L * 1L).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Medium.get(0L, new Object[0])).fluidInputs(material.getMolten(432)).itemOutputs(material.get(OrePrefixes.pipeMedium, 1)).duration(material.getStats().getMass() * 6L * 1L).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Large.get(0L, new Object[0])).fluidInputs(material.getMolten(864)).itemOutputs(material.get(OrePrefixes.pipeLarge, 1)).duration(material.getStats().getMass() * 12L * 1L).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
        GTValues.RA.stdBuilder().itemInputs(ItemList.Shape_Mold_Pipe_Huge.get(0L, new Object[0])).fluidInputs(material.getMolten(1728)).itemOutputs(material.get(OrePrefixes.pipeHuge, 1)).duration(material.getStats().getMass() * 24L * 1L).eut(TierEU.RECIPE_LV).addTo(RecipeMaps.fluidSolidifierRecipes);
    }

    public static void registerWire(int ID, Werkstoff material, int aAmperage, int aVoltage, int aLoss, boolean cover) {
        String unName = material.getDefaultName().replace(" ", "_").toLowerCase();
        String Name2 = material.getDefaultName();
        String aTextWire1 = "wire.";
        String aTextCable1 = "cable.";
        String aTextWire2 = " Wire";
        String aTextCable2 = " Cable";
        int aLossInsulated = aLoss / 4;
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt01, material.getBridgeMaterial(), new MTECable(ID + 0, aTextWire1 + unName + ".01", "1x " + Name2 + aTextWire2, 0.125f, material.getBridgeMaterial(), aLoss, 1L * (long)aAmperage, aVoltage, false, true).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt02, material.getBridgeMaterial(), new MTECable(ID + 1, aTextWire1 + unName + ".02", "2x " + Name2 + aTextWire2, 0.25f, material.getBridgeMaterial(), aLoss, 2L * (long)aAmperage, aVoltage, false, true).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt04, material.getBridgeMaterial(), new MTECable(ID + 2, aTextWire1 + unName + ".04", "4x " + Name2 + aTextWire2, 0.375f, material.getBridgeMaterial(), aLoss, 4L * (long)aAmperage, aVoltage, false, true).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt08, material.getBridgeMaterial(), new MTECable(ID + 3, aTextWire1 + unName + ".08", "8x " + Name2 + aTextWire2, 0.5f, material.getBridgeMaterial(), aLoss, 8L * (long)aAmperage, aVoltage, false, true).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt12, material.getBridgeMaterial(), new MTECable(ID + 4, aTextWire1 + unName + ".12", "12x " + Name2 + aTextWire2, 0.625f, material.getBridgeMaterial(), aLoss, 12L * (long)aAmperage, aVoltage, false, true).getStackForm(1L));
        GTOreDictUnificator.registerOre(OrePrefixes.wireGt16, material.getBridgeMaterial(), new MTECable(ID + 5, aTextWire1 + unName + ".16", "16x " + Name2 + aTextWire2, 0.75f, material.getBridgeMaterial(), aLoss, 16L * (long)aAmperage, aVoltage, false, true).getStackForm(1L));
        if (cover) {
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt01, material.getBridgeMaterial(), new MTECable(ID + 6, aTextCable1 + unName + ".01", "1x " + Name2 + aTextCable2, 0.25f, material.getBridgeMaterial(), aLossInsulated, 1L * (long)aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt02, material.getBridgeMaterial(), new MTECable(ID + 7, aTextCable1 + unName + ".02", "2x " + Name2 + aTextCable2, 0.375f, material.getBridgeMaterial(), aLossInsulated, 2L * (long)aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt04, material.getBridgeMaterial(), new MTECable(ID + 8, aTextCable1 + unName + ".04", "4x " + Name2 + aTextCable2, 0.5f, material.getBridgeMaterial(), aLossInsulated, 4L * (long)aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt08, material.getBridgeMaterial(), new MTECable(ID + 9, aTextCable1 + unName + ".08", "8x " + Name2 + aTextCable2, 0.625f, material.getBridgeMaterial(), aLossInsulated, 8L * (long)aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt12, material.getBridgeMaterial(), new MTECable(ID + 10, aTextCable1 + unName + ".12", "12x " + Name2 + aTextCable2, 0.75f, material.getBridgeMaterial(), aLossInsulated, 12L * (long)aAmperage, aVoltage, true, false).getStackForm(1L));
            GTOreDictUnificator.registerOre(OrePrefixes.cableGt16, material.getBridgeMaterial(), new MTECable(ID + 11, aTextCable1 + unName + ".16", "16x " + Name2 + aTextCable2, 0.875f, material.getBridgeMaterial(), aLossInsulated, 16L * (long)aAmperage, aVoltage, true, false).getStackForm(1L));
        }
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 1), GTUtility.getIntegratedCircuit(1)).itemOutputs(material.get(OrePrefixes.wireGt01, 2)).duration(100).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 1), GTUtility.getIntegratedCircuit(2)).itemOutputs(material.get(OrePrefixes.wireGt02, 1)).duration(150).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 2), GTUtility.getIntegratedCircuit(4)).itemOutputs(material.get(OrePrefixes.wireGt04, 1)).duration(200).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 4), GTUtility.getIntegratedCircuit(8)).itemOutputs(material.get(OrePrefixes.wireGt08, 1)).duration(250).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 6), GTUtility.getIntegratedCircuit(12)).itemOutputs(material.get(OrePrefixes.wireGt12, 1)).duration(300).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 8), GTUtility.getIntegratedCircuit(16)).itemOutputs(material.get(OrePrefixes.wireGt16, 1)).duration(350).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.stick, 1), GTUtility.getIntegratedCircuit(1)).itemOutputs(material.get(OrePrefixes.wireGt01, 1)).duration(50).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.stick, 2), GTUtility.getIntegratedCircuit(2)).itemOutputs(material.get(OrePrefixes.wireGt02, 1)).duration(100).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.stick, 4), GTUtility.getIntegratedCircuit(4)).itemOutputs(material.get(OrePrefixes.wireGt04, 1)).duration(150).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.stick, 8), GTUtility.getIntegratedCircuit(8)).itemOutputs(material.get(OrePrefixes.wireGt08, 1)).duration(200).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.stick, 12), GTUtility.getIntegratedCircuit(12)).itemOutputs(material.get(OrePrefixes.wireGt12, 1)).duration(250).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.stick, 16), GTUtility.getIntegratedCircuit(16)).itemOutputs(material.get(OrePrefixes.wireGt16, 1)).duration(300).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 1), GTUtility.getIntegratedCircuit(3)).itemOutputs(material.get(OrePrefixes.wireFine, 8)).duration(100).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.stick, 1), GTUtility.getIntegratedCircuit(3)).itemOutputs(material.get(OrePrefixes.wireFine, 4)).duration(50).eut(4).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.wireGt01, 1), GTUtility.getIntegratedCircuit(1)).itemOutputs(material.get(OrePrefixes.wireFine, 4)).duration(200).eut(8).addTo(RecipeMaps.wiremillRecipes);
        GTValues.RA.stdBuilder().itemInputs(material.get(OrePrefixes.ingot, 1), ItemList.Shape_Extruder_Wire.get(0L, new Object[0])).itemOutputs(material.get(OrePrefixes.wireGt01, 2)).duration(material.getStats().getMass() * 8L * 1L).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.extruderRecipes);
    }
}

