/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg;

import galacticgreg.GalacticGreg;
import galacticgreg.TileEntitySpaceOres;
import galacticgreg.api.ModContainer;
import galacticgreg.api.ModDimensionDef;
import galacticgreg.auxiliary.GTOreGroup;
import galacticgreg.registry.GalacticGregRegistry;
import gregtech.api.enums.GTValues;
import gregtech.api.util.GTLog;
import gregtech.api.world.GTWorldgen;
import gregtech.common.OreMixBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldgenOreLayerSpace
extends GTWorldgen {
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public final short mPrimaryMeta;
    public final short mSecondaryMeta;
    public final short mBetweenMeta;
    public final short mSporadicMeta;
    private long mProfilingStart;
    private long mProfilingEnd;
    private Map<String, Boolean> allowedDims;
    private static Map<String, List<String>> _mBufferedVeinList = new HashMap<String, List<String>>();

    public WorldgenOreLayerSpace(OreMixBuilder mix) {
        super(mix.oreMixName, GalacticGreg.oreVeinWorldgenList, mix.enabledByDefault);
        this.mMinY = (short)mix.minY;
        this.mMaxY = (short)Math.max(this.mMinY + 5, mix.maxY);
        this.mWeight = (short)mix.weight;
        this.mDensity = (short)mix.density;
        this.mSize = (short)Math.max(1, mix.size);
        this.mPrimaryMeta = (short)mix.primary.mMetaItemSubID;
        this.mSecondaryMeta = (short)mix.secondary.mMetaItemSubID;
        this.mBetweenMeta = (short)mix.between.mMetaItemSubID;
        this.mSporadicMeta = (short)mix.sporadic.mMetaItemSubID;
        this.allowedDims = new HashMap<String, Boolean>();
        for (ModContainer mc : GalacticGregRegistry.getModContainers()) {
            if (!mc.isModLoaded()) continue;
            for (ModDimensionDef mdd : mc.getDimensionList()) {
                String tDimIdentifier = mdd.getDimIdentifier();
                if (this.allowedDims.containsKey(tDimIdentifier)) {
                    GalacticGreg.Logger.error("Found 2 Dimensions with the same Identifier: %s Dimension will not generate Ores", tDimIdentifier);
                    continue;
                }
                boolean tFlag = mix.dimsEnabled.getOrDefault(mdd.getDimensionName(), false);
                this.allowedDims.put(tDimIdentifier, tFlag);
            }
        }
        GalacticGreg.Logger.trace("Initialized new OreLayer: %s", mix.oreMixName);
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    public boolean isEnabledForDim(ModDimensionDef pDimensionDef) {
        return this.allowedDims.getOrDefault(pDimensionDef.getDimIdentifier(), false);
    }

    private static List<String> getOreMixIDsForDim(ModDimensionDef pDimensionDef) {
        ArrayList<String> tReturn;
        if (_mBufferedVeinList.containsKey(pDimensionDef.getDimIdentifier())) {
            tReturn = _mBufferedVeinList.get(pDimensionDef.getDimIdentifier());
        } else {
            tReturn = new ArrayList();
            for (GTWorldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                if (!(tWorldGen instanceof WorldgenOreLayerSpace) || !((WorldgenOreLayerSpace)tWorldGen).isEnabledForDim(pDimensionDef)) continue;
                tReturn.add(tWorldGen.mWorldGenName);
            }
            _mBufferedVeinList.put(pDimensionDef.getDimIdentifier(), tReturn);
        }
        return tReturn;
    }

    public static GTOreGroup getRandomOreGroup(ModDimensionDef pDimensionDef, Random pRandom, boolean pIgnoreWeight) {
        short primaryMeta = 0;
        short secondaryMeta = 0;
        short betweenMeta = 0;
        short sporadicMeta = 0;
        if (pIgnoreWeight) {
            List<String> tEnabledVeins = WorldgenOreLayerSpace.getOreMixIDsForDim(pDimensionDef);
            int tRnd = pRandom.nextInt(tEnabledVeins.size());
            String tVeinName = tEnabledVeins.get(tRnd);
            GTWorldgen tGen = null;
            for (GTWorldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                if (!(tWorldGen instanceof WorldgenOreLayerSpace) || !((WorldgenOreLayerSpace)tWorldGen).mWorldGenName.equals(tVeinName)) continue;
                tGen = tWorldGen;
            }
            if (tGen != null) {
                GalacticGreg.Logger.trace("Using Oremix %s for asteroid", tGen.mWorldGenName);
                primaryMeta = ((WorldgenOreLayerSpace)tGen).mPrimaryMeta;
                secondaryMeta = ((WorldgenOreLayerSpace)tGen).mSecondaryMeta;
                betweenMeta = ((WorldgenOreLayerSpace)tGen).mBetweenMeta;
                sporadicMeta = ((WorldgenOreLayerSpace)tGen).mSporadicMeta;
            }
        } else if (sWeight > 0 && GalacticGreg.oreVeinWorldgenList.size() > 0) {
            GalacticGreg.Logger.trace("About to select oremix", new Object[0]);
            boolean temp = true;
            block3: for (int i = 0; i < 256 && temp; ++i) {
                int tRandomWeight = pRandom.nextInt(sWeight);
                for (GTWorldgen tWorldGen : GalacticGreg.oreVeinWorldgenList) {
                    if (!(tWorldGen instanceof WorldgenOreLayerSpace) || (tRandomWeight -= ((WorldgenOreLayerSpace)tWorldGen).mWeight) > 0) continue;
                    try {
                        if (!((WorldgenOreLayerSpace)tWorldGen).isEnabledForDim(pDimensionDef)) continue;
                        GalacticGreg.Logger.trace("Using Oremix %s for asteroid", tWorldGen.mWorldGenName);
                        primaryMeta = ((WorldgenOreLayerSpace)tWorldGen).mPrimaryMeta;
                        secondaryMeta = ((WorldgenOreLayerSpace)tWorldGen).mSecondaryMeta;
                        betweenMeta = ((WorldgenOreLayerSpace)tWorldGen).mBetweenMeta;
                        sporadicMeta = ((WorldgenOreLayerSpace)tWorldGen).mSporadicMeta;
                        temp = false;
                        continue block3;
                    }
                    catch (Throwable e) {
                        e.printStackTrace(GTLog.err);
                    }
                }
            }
        }
        if (primaryMeta != 0 || secondaryMeta != 0 || betweenMeta != 0 || sporadicMeta != 0) {
            return new GTOreGroup(primaryMeta, secondaryMeta, betweenMeta, sporadicMeta);
        }
        return null;
    }

    @Override
    public boolean executeWorldgen(World pWorld, Random pRandom, String pBiome, int pDimensionType, int pChunkX, int pChunkZ, IChunkProvider pChunkGenerator, IChunkProvider pChunkProvider) {
        GalacticGreg.Logger.trace("Entering executeWorldgen for [%s]", this.mWorldGenName);
        ModDimensionDef tMDD = GalacticGregRegistry.getDimensionTypeByChunkGenerator(pChunkGenerator);
        if (tMDD == null) {
            GalacticGreg.Logger.trace("Can't find dimension definition for ChunkProvider %s, skipping", pChunkGenerator.toString());
            return false;
        }
        if (!this.isEnabledForDim(tMDD)) {
            GalacticGreg.Logger.trace("OreGen for %s is disallowed in dimension %s, skipping", this.mWorldGenName, tMDD.getDimensionName());
            return false;
        }
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            this.mProfilingStart = System.currentTimeMillis();
        }
        int tMinY = this.mMinY + pRandom.nextInt(this.mMaxY - this.mMinY - 7);
        int cX = pChunkX - pRandom.nextInt(this.mSize);
        int eX = pChunkX + 16 + pRandom.nextInt(this.mSize);
        int cZ = pChunkZ - pRandom.nextInt(this.mSize);
        int eZ = pChunkZ + 16 + pRandom.nextInt(this.mSize);
        for (int tX = cX; tX <= eX; ++tX) {
            for (int tZ = cZ; tZ <= eZ; ++tZ) {
                int placeZ;
                int placeX;
                int i;
                if (this.mSecondaryMeta > 0) {
                    for (i = tMinY - 1; i < tMinY + 3; ++i) {
                        placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                        placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                        if (pRandom.nextInt(placeZ) != 0 && pRandom.nextInt(placeX) != 0) continue;
                        TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, i, tZ, this.mSecondaryMeta);
                    }
                }
                if (this.mBetweenMeta > 0) {
                    for (i = tMinY + 2; i < tMinY + 6; ++i) {
                        placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                        placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                        if (pRandom.nextInt(placeZ) != 0 && pRandom.nextInt(placeX) != 0 || pRandom.nextInt(2) != 0) continue;
                        TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, i, tZ, this.mBetweenMeta);
                    }
                }
                if (this.mPrimaryMeta > 0) {
                    for (i = tMinY + 4; i < tMinY + 8; ++i) {
                        placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                        placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                        if (pRandom.nextInt(placeZ) != 0 && pRandom.nextInt(placeX) != 0) continue;
                        TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, i, tZ, this.mPrimaryMeta);
                    }
                }
                if (this.mSporadicMeta <= 0) continue;
                for (i = tMinY - 1; i < tMinY + 8; ++i) {
                    placeX = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cX - tX)), MathHelper.func_76130_a((int)(eX - tX))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                    placeZ = Math.max(1, Math.max(MathHelper.func_76130_a((int)(cZ - tZ)), MathHelper.func_76130_a((int)(eZ - tZ))) / this.getDensityFromPos(tX, tZ, pChunkX, pChunkZ));
                    if (pRandom.nextInt(placeX) != 0 && pRandom.nextInt(placeZ) != 0 || pRandom.nextInt(7) != 0) continue;
                    TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, i, tZ, this.mSporadicMeta);
                }
            }
        }
        if (GTValues.oreveinPlacerOres) {
            int nSmallOres = (cX - eX) * (cZ - eZ) * this.mDensity / 10 * GTValues.oreveinPlacerOresMultiplier;
            for (int nSmallOresCount = 0; nSmallOresCount < nSmallOres; ++nSmallOresCount) {
                int tX = pRandom.nextInt(16) + pChunkX + 2;
                int tZ = pRandom.nextInt(16) + pChunkZ + 2;
                int tY = pRandom.nextInt(160) + 10;
                if (this.mPrimaryMeta > 0) {
                    TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, tY, tZ, this.mPrimaryMeta + 16000);
                }
                tX = pRandom.nextInt(16) + pChunkX + 2;
                tZ = pRandom.nextInt(16) + pChunkZ + 2;
                tY = pRandom.nextInt(160) + 10;
                if (this.mSecondaryMeta > 0) {
                    TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, tY, tZ, this.mSecondaryMeta + 16000);
                }
                tX = pRandom.nextInt(16) + pChunkX + 2;
                tZ = pRandom.nextInt(16) + pChunkZ + 2;
                tY = pRandom.nextInt(160) + 10;
                if (this.mBetweenMeta > 0) {
                    TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, tY, tZ, this.mBetweenMeta + 16000);
                }
                tX = pRandom.nextInt(16) + pChunkX + 2;
                tZ = pRandom.nextInt(16) + pChunkZ + 2;
                tY = pRandom.nextInt(190) + 10;
                if (this.mSporadicMeta <= 0) continue;
                TileEntitySpaceOres.setOuterSpaceOreBlock(tMDD, pWorld, tX, tY, tZ, this.mSporadicMeta + 16000);
            }
        }
        if (GalacticGreg.GalacticConfig.ProfileOreGen) {
            try {
                this.mProfilingEnd = System.currentTimeMillis();
                long tTotalTime = this.mProfilingEnd - this.mProfilingStart;
                GalacticGreg.Profiler.AddTimeToList(tMDD, tTotalTime);
                GalacticGreg.Logger.debug("Done with OreLayer-Worldgen in DimensionType %s. Generation took %d ms", tMDD.getDimensionName(), tTotalTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GalacticGreg.Logger.trace("Leaving executeWorldgen", new Object[0]);
        return true;
    }

    public int getDensityFromPos(int aX, int aZ, int aSeedX, int aSeedZ) {
        if (aX < 0) {
            aX -= 16;
        }
        if (aZ < 0) {
            aZ -= 16;
        }
        return Math.max(1, this.mDensity / (int)Math.sqrt(2.0 + Math.pow(aX / 16 - aSeedX / 16, 2.0) + Math.pow(aZ / 16 - aSeedZ / 16, 2.0)));
    }
}

