/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.tileentities.multis;

import bartworks.API.SideReference;
import bartworks.API.recipe.BartWorksRecipeMaps;
import bartworks.MainMod;
import bartworks.common.configs.Configuration;
import bartworks.common.items.ItemLabParts;
import bartworks.common.loaders.FluidLoader;
import bartworks.common.net.RendererPacket;
import bartworks.common.tileentities.tiered.GT_MetaTileEntity_RadioHatch;
import bartworks.util.BWTooltipReference;
import bartworks.util.BWUtil;
import bartworks.util.BioCulture;
import bartworks.util.Coords;
import bartworks.util.MathUtils;
import bartworks.util.ResultWrongSievert;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ParallelHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEBioVat
extends MTEEnhancedMultiBlockBase<MTEBioVat> {
    public static final HashMap<Coords, Integer> staticColorMap = new HashMap();
    private static final byte TIMERDIVIDER = 20;
    private final HashSet<EntityPlayerMP> playerMPHashSet = new HashSet();
    private final ArrayList<GT_MetaTileEntity_RadioHatch> mRadHatches = new ArrayList();
    private int height = 1;
    private Fluid mFluid = FluidRegistry.LAVA;
    private BioCulture mCulture;
    private ItemStack mStack;
    private boolean needsVisualUpdate = true;
    private byte mGlassTier;
    private int mSievert;
    private int mNeededSievert;
    private int mCasing = 0;
    private int mExpectedMultiplier = 0;
    private int mTimes = 0;
    private boolean isVisibleFluid = false;
    private static final int CASING_INDEX = 49;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<MTEBioVat> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ccccc", "ccccc", "ccccc", "ccccc"}, {"ggggg", "gaaag", "gaaag", "gaaag", "ggggg"}, {"ggggg", "gaaag", "gaaag", "gaaag", "ggggg"}, {"cc~cc", "ccccc", "ccccc", "ccccc", "ccccc"}})).addElement('c', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEBioVat::addRadiationInputToMachineList, 49, 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, 49, 1), StructureUtility.onElementPass(e -> ++e.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)1))})).addElement('a', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), StructureUtility.ofBlockAnyMeta((Block)FluidLoader.bioFluidBlock)})).addElement('g', BWUtil.ofGlassTiered((byte)1, (byte)127, (byte)0, (te, v) -> {
        te.mGlassTier = v;
    }, te -> te.mGlassTier, 1)).build();

    public MTEBioVat(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEBioVat(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<MTEBioVat> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Bacterial Vat").addInfo("Controller block for the Bacterial Vat").addInfo("For maximum efficiency boost keep the Output Hatch always half filled!").addSeparator().beginStructureBlock(5, 4, 5, false).addController("Front bottom center").addCasingInfoMin("Clean Stainless Steel Casings", 19, false).addOtherStructurePart("Glass", "Hollow two middle layers", 2).addStructureInfo("The glass can be any glass, i.e. Tinkers Construct Clear Glass").addStructureInfo("Some Recipes need more advanced Glass Types").addMaintenanceHatch("Any casing", 1).addOtherStructurePart("Radio Hatch", "Any casing", 1).addInputBus("Any casing", 1).addOutputBus("Any casing", 1).addInputHatch("Any casing", 1).addOutputHatch("Any casing", 1).addEnergyHatch("Any casing", 1).toolTipFinisher(BWTooltipReference.MULTIBLOCK_ADDED_BY_BARTWORKS);
        return tt;
    }

    public static int[] specialValueUnpack(int aSpecialValue) {
        int[] ret = new int[]{aSpecialValue & 0xF, aSpecialValue >>> 4 & 3, aSpecialValue >>> 6 & 1, aSpecialValue >>> 7 & Integer.MAX_VALUE};
        return ret;
    }

    private int getInputCapacity() {
        return this.mInputHatches.stream().mapToInt(MTEHatchInput::getCapacity).sum();
    }

    private int getOutputCapacity() {
        return this.mOutputHatches.stream().mapToInt(MTEHatchOutput::getCapacity).sum();
    }

    @Override
    public int getCapacity() {
        int ret = 0;
        return ret += this.getInputCapacity();
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        return super.fill(resource, doFill);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack itemStack) {
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return BartWorksRecipeMaps.bacterialVatRecipes;
    }

    private int getExpectedMultiplier(@Nullable FluidStack recipeFluidOutput, boolean needEqual) {
        FluidStack storedFluidOutputs = this.getStoredFluidOutputs();
        if (storedFluidOutputs == null) {
            return 1;
        }
        if (!needEqual || storedFluidOutputs.isFluidEqual(recipeFluidOutput)) {
            return this.calcMod(storedFluidOutputs.amount) + 1;
        }
        return 1;
    }

    private int calcMod(double x) {
        double y = (double)this.getOutputCapacity() / 2.0;
        double z = Configuration.Multiblocks.bioVatMaxParallelBonus;
        int ret = MathUtils.ceilInt((-1.0 / y * Math.pow(x - y, 2.0) + y) / y * z);
        return MathUtils.clamp(1, ret, Configuration.Multiblocks.bioVatMaxParallelBonus);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (!BWUtil.areStacksEqualOrNull((ItemStack)recipe.mSpecialItems, MTEBioVat.this.getControllerSlot())) {
                    return CheckRecipeResultRegistry.NO_RECIPE;
                }
                int[] conditions = MTEBioVat.specialValueUnpack(recipe.mSpecialValue);
                MTEBioVat.this.mNeededSievert = conditions[3];
                if (MTEBioVat.this.mGlassTier < conditions[0]) {
                    return CheckRecipeResultRegistry.insufficientMachineTier(conditions[0]);
                }
                if (conditions[2] == 0) {
                    if (MTEBioVat.this.mSievert < MTEBioVat.this.mNeededSievert) {
                        return ResultWrongSievert.insufficientSievert(MTEBioVat.this.mNeededSievert);
                    }
                } else if (MTEBioVat.this.mSievert != conditions[3]) {
                    return ResultWrongSievert.wrongSievert(conditions[3]);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected ParallelHelper createParallelHelper(@NotNull GTRecipe recipe) {
                return super.createParallelHelper(MTEBioVat.this.recipeWithMultiplier(recipe, this.inputFluids));
            }
        };
    }

    protected GTRecipe recipeWithMultiplier(GTRecipe recipe, FluidStack[] fluidInputs) {
        int multiplier;
        GTRecipe tRecipe = recipe.copy();
        this.mExpectedMultiplier = multiplier = this.getExpectedMultiplier(recipe.getFluidOutput(0), true);
        long fluidAmount = 0L;
        for (FluidStack fluid : fluidInputs) {
            if (!recipe.mFluidInputs[0].isFluidEqual(fluid)) continue;
            fluidAmount += (long)fluid.amount;
        }
        multiplier = (int)Math.min((long)multiplier, fluidAmount / (long)recipe.mFluidInputs[0].amount);
        this.mTimes = multiplier = Math.max(multiplier, 1);
        tRecipe.mFluidInputs[0].amount *= multiplier;
        tRecipe.mFluidOutputs[0].amount *= multiplier;
        return tRecipe;
    }

    @Override
    protected void setupProcessingLogic(ProcessingLogic logic) {
        super.setupProcessingLogic(logic);
        logic.setSpecialSlotItem(this.getControllerSlot());
    }

    public FluidStack getStoredFluidOutputs() {
        assert (this.mOutputHatches.size() == 1);
        return ((MTEHatchOutput)this.mOutputHatches.get(0)).getFluid();
    }

    private boolean addRadiationInputToMachineList(IGregTechTileEntity aTileEntity, int CasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null || !(aMetaTileEntity instanceof GT_MetaTileEntity_RadioHatch)) {
            return false;
        }
        ((GT_MetaTileEntity_RadioHatch)aMetaTileEntity).updateTexture(CasingIndex);
        return this.mRadHatches.add((GT_MetaTileEntity_RadioHatch)aMetaTileEntity);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack itemStack) {
        this.mRadHatches.clear();
        this.mGlassTier = 0;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 3, 0)) {
            return false;
        }
        return this.mCasing >= 19 && this.mRadHatches.size() <= 1 && this.mOutputHatches.size() == 1 && this.mMaintenanceHatches.size() == 1 && this.mInputHatches.size() > 0 && this.mEnergyHatches.size() > 0;
    }

    @Override
    public int getMaxEfficiency(ItemStack itemStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack itemStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack itemStack) {
        return 0;
    }

    private void sendAllRequiredRendererPackets() {
        int height = this.reCalculateHeight();
        if (this.mFluid != null && height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 1; y < height; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        this.sendPackagesOrRenewRenderer(x, y, z, this.mCulture);
                    }
                }
            }
        }
    }

    private void sendPackagesOrRenewRenderer(int x, int y, int z, BioCulture lCulture) {
        int xDir = this.getXDir();
        int zDir = this.getZDir();
        staticColorMap.remove(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g));
        staticColorMap.put(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB());
        if (SideReference.Side.Server) {
            MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), true), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
            MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), lCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : lCulture.getColorRGB(), false), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
        }
        this.needsVisualUpdate = true;
    }

    private void check_Chunk() {
        World aWorld = this.getBaseMetaTileEntity().getWorld();
        if (!aWorld.field_72995_K) {
            for (Object tObject : aWorld.field_73010_i) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.func_72938_d(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
                if (tPlayer.func_71121_q().func_73040_p().func_72694_a(tPlayer, tChunk.field_76635_g, tChunk.field_76647_h)) {
                    if (this.playerMPHashSet.contains(tPlayer)) continue;
                    this.playerMPHashSet.add(tPlayer);
                    this.sendAllRequiredRendererPackets();
                    continue;
                }
                this.playerMPHashSet.remove(tPlayer);
            }
        }
    }

    private void placeFluid() {
        this.isVisibleFluid = true;
        int xDir = this.getXDir();
        int zDir = this.getZDir();
        this.height = this.reCalculateHeight();
        if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        if (!this.getBaseMetaTileEntity().getWorld().func_147439_a(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()).equals(Blocks.field_150350_a)) continue;
                        this.getBaseMetaTileEntity().getWorld().func_147449_b(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), FluidLoader.bioFluidBlock);
                    }
                }
            }
        }
    }

    private void removeFluid(int xDir, int zDir) {
        this.isVisibleFluid = false;
        for (int x = -1; x < 2; ++x) {
            for (int y = 1; y < 3; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (this.getBaseMetaTileEntity().getWorld().func_147439_a(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()).equals(FluidLoader.bioFluidBlock)) {
                        this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord());
                    }
                    staticColorMap.remove(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord()), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g);
                }
            }
        }
    }

    private int reCalculateFluidAmmount() {
        return this.getStoredFluids().stream().mapToInt(fluidStack -> fluidStack.amount).sum();
    }

    private int reCalculateHeight() {
        return this.reCalculateFluidAmmount() > this.getCapacity() / 4 - 1 ? (this.reCalculateFluidAmmount() >= this.getCapacity() / 2 ? 3 : 2) : 1;
    }

    public void doAllVisualThings() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mMachine) {
                int z;
                int y;
                int x;
                ItemStack aStack = this.mInventory[1];
                BioCulture lCulture = null;
                int xDir = this.getXDir();
                int zDir = this.getZDir();
                if (this.getBaseMetaTileEntity().getTimer() % 200L == 0L) {
                    this.check_Chunk();
                }
                if (this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 0L) {
                    for (x = -1; x < 2; ++x) {
                        for (y = 1; y < 3; ++y) {
                            for (z = -1; z < 2; ++z) {
                                this.getBaseMetaTileEntity().getWorld().func_147468_f(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord());
                            }
                        }
                    }
                }
                this.height = this.reCalculateHeight();
                if (this.mFluid != null && this.height > 1 && this.reCalculateFluidAmmount() > 0) {
                    if (!BWUtil.areStacksEqualOrNull(aStack, this.mStack) || this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 1L) {
                        for (x = -1; x < 2; ++x) {
                            for (y = 1; y < this.height; ++y) {
                                for (z = -1; z < 2; ++z) {
                                    if (aStack != null && (!(aStack.func_77973_b() instanceof ItemLabParts) || aStack.func_77960_j() != 0) || this.mCulture != null && aStack != null && aStack.func_77978_p() != null && this.mCulture.getID() == aStack.func_77978_p().func_74762_e("ID")) continue;
                                    lCulture = aStack == null || aStack.func_77978_p() == null ? null : BioCulture.getBioCulture(aStack.func_77978_p().func_74779_i("Name"));
                                    this.sendPackagesOrRenewRenderer(x, y, z, lCulture);
                                }
                            }
                        }
                        this.mStack = aStack;
                        this.mCulture = lCulture;
                    }
                    if (this.needsVisualUpdate && this.getBaseMetaTileEntity().getTimer() % 20L == 1L) {
                        if (this.getBaseMetaTileEntity().isClientSide()) {
                            new Throwable().printStackTrace();
                        }
                        this.placeFluid();
                        this.needsVisualUpdate = false;
                    }
                }
            } else {
                this.onRemoval();
            }
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.height != this.reCalculateHeight()) {
            this.needsVisualUpdate = true;
        }
        this.doAllVisualThings();
        if (this.getBaseMetaTileEntity().isServerSide() && this.mRadHatches.size() == 1) {
            this.mSievert = this.mRadHatches.get(0).getSievert();
            if (this.getBaseMetaTileEntity().isActive() && this.mNeededSievert > this.mSievert) {
                this.mOutputFluids = null;
            }
        }
        if (aBaseMetaTileEntity.isServerSide() && this.mMaxProgresstime <= 0) {
            this.mTimes = 0;
            this.mMaxProgresstime = 0;
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFluidHeight", this.height);
        if (this.mCulture != null && !this.mCulture.getName().isEmpty()) {
            aNBT.func_74778_a("mCulture", this.mCulture.getName());
        } else if ((this.mCulture == null || this.mCulture.getName().isEmpty()) && !aNBT.func_74779_i("mCulture").isEmpty()) {
            aNBT.func_82580_o("mCulture");
        }
        if (this.mFluid != null) {
            aNBT.func_74778_a("mFluid", this.mFluid.getName());
        }
        aNBT.func_74768_a("mSievert", this.mSievert);
        aNBT.func_74768_a("mNeededSievert", this.mNeededSievert);
        aNBT.func_74757_a("isVisibleFluid", this.isVisibleFluid);
        super.saveNBTData(aNBT);
    }

    @Override
    public void onRemoval() {
        if (this.isVisibleFluid) {
            int xDir = this.getXDir();
            int zDir = this.getZDir();
            this.removeFluid(xDir, zDir);
            this.sendRenderPackets(xDir, zDir);
        } else if (this.getBaseMetaTileEntity().getWorld().func_72820_D() % 20L == 7L) {
            this.sendRenderPackets();
        }
        super.onRemoval();
    }

    private int getXDir() {
        return this.getBaseMetaTileEntity().getBackFacing().offsetX * 2;
    }

    private int getZDir() {
        return this.getBaseMetaTileEntity().getBackFacing().offsetZ * 2;
    }

    private void sendRenderPackets() {
        int xDir = this.getXDir();
        int zDir = this.getZDir();
        this.sendRenderPackets(xDir, zDir);
    }

    private void sendRenderPackets(int xDir, int zDir) {
        if (SideReference.Side.Server) {
            for (int x = -1; x < 2; ++x) {
                for (int y = 1; y < 3; ++y) {
                    for (int z = -1; z < 2; ++z) {
                        MainMod.BW_Network_instance.sendPacketToAllPlayersInRange(this.getBaseMetaTileEntity().getWorld(), new RendererPacket(new Coords(xDir + x + this.getBaseMetaTileEntity().getXCoord(), y + this.getBaseMetaTileEntity().getYCoord(), zDir + z + this.getBaseMetaTileEntity().getZCoord(), this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g), this.mCulture == null ? BioCulture.NULLCULTURE.getColorRGB() : this.mCulture.getColorRGB(), true), this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord());
                    }
                }
            }
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.height = aNBT.func_74762_e("mFluidHeight");
        this.mCulture = BioCulture.getBioCulture(aNBT.func_74779_i("mCulture"));
        if (!aNBT.func_74779_i("mFluid").isEmpty()) {
            this.mFluid = FluidRegistry.getFluid((String)aNBT.func_74779_i("mFluid"));
        }
        this.mSievert = aNBT.func_74762_e("mSievert");
        this.mNeededSievert = aNBT.func_74762_e("mNeededSievert");
        super.loadNBTData(aNBT);
        this.isVisibleFluid = aNBT.func_74767_n("isVisibleFluid");
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack itemStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEBioVat(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 2, 3, 0);
    }

    @Override
    public String[] getInfoData() {
        String[] baseInfoData = super.getInfoData();
        String[] infoData = new String[baseInfoData.length + 2];
        System.arraycopy(baseInfoData, 0, infoData, 0, baseInfoData.length);
        infoData[infoData.length - 2] = StatCollector.func_74838_a((String)"BW.infoData.BioVat.expectedProduction") + ": " + EnumChatFormatting.GREEN + (this.mMachine ? (this.mMaxProgresstime <= 0 ? this.getExpectedMultiplier(null, false) : this.mExpectedMultiplier) * 100 : -1) + EnumChatFormatting.RESET + " %";
        infoData[infoData.length - 1] = StatCollector.func_74838_a((String)"BW.infoData.BioVat.production") + ": " + EnumChatFormatting.GREEN + (this.mMaxProgresstime <= 0 ? 0 : this.mTimes) * 100 + EnumChatFormatting.RESET + " %";
        return infoData;
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }
}

