/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.net;

import bartworks.system.oredict.OreDictHandler;
import bartworks.util.Pair;
import com.google.common.io.ByteArrayDataInput;
import gregtech.api.net.GTPacketNew;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.world.IBlockAccess;

public class OreDictCachePacket
extends GTPacketNew {
    private HashSet<Pair<Integer, Short>> hashSet = new HashSet();

    public OreDictCachePacket() {
        super(true);
    }

    public OreDictCachePacket(HashSet<Pair<Integer, Short>> set) {
        super(false);
        this.hashSet = set;
    }

    @Override
    public byte getPacketID() {
        return 3;
    }

    @Override
    public void encode(ByteBuf aOut) {
        int size = this.hashSet.size();
        aOut.writeInt(size);
        for (Pair<Integer, Short> p : this.hashSet) {
            aOut.writeInt(p.getKey().intValue()).writeShort((int)p.getValue().shortValue());
        }
    }

    @Override
    public GTPacketNew decode(ByteArrayDataInput byteArrayDataInput) {
        int size = byteArrayDataInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.hashSet.add(new Pair<Integer, Short>(byteArrayDataInput.readInt(), byteArrayDataInput.readShort()));
        }
        return new OreDictCachePacket(this.hashSet);
    }

    @Override
    public void process(IBlockAccess iBlockAccess) {
        OreDictHandler.getNonBWCache().clear();
        OreDictHandler.getNonBWCache().addAll(this.hashSet);
    }
}

