/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.CustomInteractable;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.ComponentDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.TooltipLine;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.GregTechOreProcessing;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.LabelHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.oreprocessing.RecipeHandler;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.ComponentTransformer;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFluidDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTOreDictUnificator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class DiagramBuilder {
    private static final ItemComponent STONE_DUST = ItemComponent.create(GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Stone, (long)1L));
    private final LayoutHandler layoutHandler;
    private final LabelHandler labelHandler;
    private final RecipeHandler recipeHandler;
    private final ItemComponent rawOre;
    private final Optional<ItemComponent> trueRawOre;
    private final Set<Component> craftingComponents;
    private final Set<Component> usageComponents;
    private final Diagram.Builder diagramBuilder;

    DiagramBuilder(LayoutHandler layoutHandler, LabelHandler labelHandler, RecipeHandler recipeHandler, List<ItemComponent> rawOres, Optional<ItemComponent> trueRawOre) {
        this.layoutHandler = layoutHandler;
        this.labelHandler = labelHandler;
        this.recipeHandler = recipeHandler;
        List filteredRawOres = rawOres.stream().filter(rawOre -> GregTechOreDictUtil.getItemData(rawOre).isPresent()).collect(Collectors.toList());
        List gregTechOres = filteredRawOres.stream().filter(GregTechOreProcessing::isGregTechOreBlock).collect(Collectors.toList());
        this.rawOre = !gregTechOres.isEmpty() ? (ItemComponent)gregTechOres.get(0) : (!filteredRawOres.isEmpty() ? (ItemComponent)filteredRawOres.get(0) : rawOres.get(0));
        this.trueRawOre = trueRawOre;
        this.craftingComponents = new HashSet(filteredRawOres);
        this.trueRawOre.ifPresent(this.craftingComponents::add);
        this.usageComponents = new HashSet(filteredRawOres);
        this.trueRawOre.ifPresent(this.usageComponents::add);
        this.diagramBuilder = Diagram.builder();
    }

    void buildDiagram(ComponentDiagramMatcher.Builder matcherBuilder) {
        Optional<Object> centrifugedOreOptional;
        this.diagramBuilder.addAllOptionalLayouts((Iterable<Layout>)this.layoutHandler.layouts()).insertIntoSlot(LayoutHandler.SlotKeys.RAW_ORE, DisplayComponent.builder(this.rawOre).build());
        this.trueRawOre.ifPresent(v -> {
            this.diagramBuilder.insertIntoSlot(LayoutHandler.SlotKeys.TRUE_RAW_ORE, DisplayComponent.builder(v).build());
            Optional<ItemComponent> crushedOreOptional = this.handleRecipes(RecipeHandler.RecipeMap.MACERATOR, (ItemComponent)v, LayoutHandler.SlotGroupKeys.TRUE_RAW_ORE_MACERATE);
        });
        Optional<ItemComponent> crushedOreOptional = this.handleRecipes(RecipeHandler.RecipeMap.MACERATOR, this.rawOre, LayoutHandler.SlotGroupKeys.RAW_ORE_MACERATE);
        Optional impureDustOptional = crushedOreOptional.flatMap(crushedOre -> this.handleRecipes(RecipeHandler.RecipeMap.MACERATOR, (ItemComponent)crushedOre, LayoutHandler.SlotGroupKeys.CRUSHED_ORE_MACERATE));
        Optional purifiedOreOptional = crushedOreOptional.flatMap(crushedOre -> this.handleRecipes(RecipeHandler.RecipeMap.ORE_WASHING_PLANT, (ItemComponent)crushedOre, LayoutHandler.SlotGroupKeys.CRUSHED_ORE_WASH));
        Optional purifiedDustOptional = purifiedOreOptional.flatMap(purifiedOre -> this.handleRecipes(RecipeHandler.RecipeMap.MACERATOR, (ItemComponent)purifiedOre, LayoutHandler.SlotGroupKeys.PURIFIED_ORE_MACERATE));
        if (crushedOreOptional.isPresent() && purifiedOreOptional.isPresent()) {
            ItemComponent crushedOre2 = crushedOreOptional.get();
            ItemComponent purifiedOre2 = (ItemComponent)purifiedOreOptional.get();
            Optional<ImmutableList<DisplayComponent>> crushedOreOutputs = this.recipeHandler.getUniqueRecipeOutput(RecipeHandler.RecipeMap.THERMAL_CENTRIFUGE, crushedOre2);
            Optional<ImmutableList<DisplayComponent>> purifiedOreOutputs = this.recipeHandler.getUniqueRecipeOutput(RecipeHandler.RecipeMap.THERMAL_CENTRIFUGE, purifiedOre2);
            Optional<List> filteredCrushedOreOutputs = crushedOreOutputs.map(Lists::newArrayList);
            filteredCrushedOreOutputs.ifPresent(outputs -> ComponentTransformer.removeComponent(outputs, STONE_DUST));
            if (filteredCrushedOreOutputs.equals(purifiedOreOutputs)) {
                if (purifiedOreOutputs.isPresent()) {
                    centrifugedOreOptional = this.handleRecipes(RecipeHandler.RecipeMap.THERMAL_CENTRIFUGE, purifiedOre2, LayoutHandler.SlotGroupKeys.ORE_THERMAL_CENTRIFUGE);
                    this.usageComponents.addAll(GregTechOreDictUtil.getAssociatedComponents(crushedOre2));
                } else {
                    centrifugedOreOptional = Optional.empty();
                }
            } else {
                Logger.GREGTECH_5_ORE_PROCESSING.warn("Crushed ore and purified ore have different thermal centrifuge outputs:\n[{}]\n ->\n[{}]\n\n[{}]\n ->\n[{}]", new Object[]{crushedOre2, crushedOreOutputs, purifiedOre2, purifiedOreOutputs});
                centrifugedOreOptional = Optional.empty();
            }
        } else {
            centrifugedOreOptional = crushedOreOptional.flatMap(crushedOre -> {
                Logger.GREGTECH_5_ORE_PROCESSING.warn("Crushed ore had thermal centrifuge recipe, but no ore washing plant recipe: [{}]", new Object[]{crushedOre});
                return this.handleRecipes(RecipeHandler.RecipeMap.THERMAL_CENTRIFUGE, (ItemComponent)crushedOre, LayoutHandler.SlotGroupKeys.ORE_THERMAL_CENTRIFUGE);
            });
        }
        crushedOreOptional.ifPresent(crushedOre -> {
            this.handleChemicalBathFluid(RecipeHandler.ChemicalBathFluid.MERCURY, (ItemComponent)crushedOre, LayoutHandler.SlotGroupKeys.CRUSHED_ORE_BATH_MERCURY);
            this.handleChemicalBathFluid(RecipeHandler.ChemicalBathFluid.SODIUM_PERSULFATE, (ItemComponent)crushedOre, LayoutHandler.SlotGroupKeys.CRUSHED_ORE_BATH_SODIUM_PERSULFATE);
        });
        purifiedOreOptional.ifPresent(purifiedOre -> this.handleRecipes(RecipeHandler.RecipeMap.SIFTER, (ItemComponent)purifiedOre, LayoutHandler.SlotGroupKeys.PURIFIED_ORE_SIFT));
        impureDustOptional.ifPresent(impureDust -> this.handleRecipes(RecipeHandler.RecipeMap.CENTRIFUGE, (ItemComponent)impureDust, LayoutHandler.SlotGroupKeys.IMPURE_DUST_CENTRIFUGE));
        purifiedDustOptional.ifPresent(purifiedDust -> {
            this.handleRecipes(RecipeHandler.RecipeMap.CENTRIFUGE, (ItemComponent)purifiedDust, LayoutHandler.SlotGroupKeys.PURIFIED_DUST_CENTRIFUGE);
            this.handleRecipes(RecipeHandler.RecipeMap.ELECTROMAGNETIC_SEPARATOR, (ItemComponent)purifiedDust, LayoutHandler.SlotGroupKeys.PURIFIED_DUST_ELECTROMAGNETIC_SEPARATE);
        });
        centrifugedOreOptional.ifPresent(centrifugedOre -> this.handleRecipes(RecipeHandler.RecipeMap.MACERATOR, (ItemComponent)centrifugedOre, LayoutHandler.SlotGroupKeys.ORE_THERMAL_CENTRIFUGE_MACERATE));
        HashSet<Component> additionalRecipeOutputs = new HashSet<Component>();
        additionalRecipeOutputs.addAll(this.addAdditionalFurnaceRecipesInteractable(LabelHandler.ItemLabel.FURNACE, LayoutHandler.AdditionalRecipeLabelPositions.FURNACE, Optional.of(this.rawOre), crushedOreOptional, purifiedOreOptional, centrifugedOreOptional, impureDustOptional, purifiedDustOptional));
        additionalRecipeOutputs.addAll(this.addAdditionalRecipesInteractable(LabelHandler.ItemLabel.ELECTRIC_BLAST_FURNACE, LayoutHandler.AdditionalRecipeLabelPositions.ELECTRIC_BLAST_FURNACE, RecipeHandler.RecipeMap.BLAST_FURNACE, Optional.of(this.rawOre), crushedOreOptional));
        additionalRecipeOutputs.addAll(this.addAdditionalRecipesInteractable(LabelHandler.ItemLabel.CHEMICAL_BATH, LayoutHandler.AdditionalRecipeLabelPositions.CHEMICAL_BATH, RecipeHandler.RecipeMap.CHEMICAL_BATH, crushedOreOptional, purifiedOreOptional));
        additionalRecipeOutputs.addAll(this.addAdditionalRecipesInteractable(LabelHandler.ItemLabel.CHEMICAL_REACTOR, LayoutHandler.AdditionalRecipeLabelPositions.CHEMICAL_REACTOR, RecipeHandler.RecipeMap.CHEMICAL_REACTOR, crushedOreOptional, purifiedOreOptional));
        additionalRecipeOutputs.addAll(this.addAdditionalRecipesInteractable(LabelHandler.ItemLabel.MIXER, LayoutHandler.AdditionalRecipeLabelPositions.MIXER, RecipeHandler.RecipeMap.MIXER, crushedOreOptional, purifiedOreOptional, impureDustOptional, purifiedDustOptional));
        additionalRecipeOutputs.addAll(this.addAdditionalRecipesInteractable(LabelHandler.ItemLabel.AUTOCLAVE, LayoutHandler.AdditionalRecipeLabelPositions.AUTOCLAVE, RecipeHandler.RecipeMap.AUTOCLAVE, impureDustOptional, purifiedDustOptional));
        additionalRecipeOutputs.removeIf(STONE_DUST::equals);
        for (Component component : ImmutableList.copyOf(additionalRecipeOutputs)) {
            this.craftingComponents.addAll(GregTechOreDictUtil.getAssociatedComponents(component));
            Optional<FluidComponent> fluidOptional = GregTechFluidDictUtil.getFluidContents(component);
            if (!fluidOptional.isPresent()) continue;
            FluidComponent fluid = fluidOptional.get();
            this.craftingComponents.addAll(GregTechFluidDictUtil.getAssociatedComponents(fluid));
            Optional<ItemComponent> cell = GregTechFluidDictUtil.fillCell(fluid);
            if (!cell.isPresent()) continue;
            additionalRecipeOutputs.remove(component);
            additionalRecipeOutputs.add(cell.get());
        }
        this.diagramBuilder.autoInsertIntoSlotGroup(LayoutHandler.SlotGroupKeys.ADDITIONAL_RECIPE_OUTPUTS).insertEachSafe(ComponentTransformer.transformToDisplay(additionalRecipeOutputs));
        matcherBuilder.addDiagram(this.diagramBuilder.build()).addAllComponents(Interactable.RecipeType.CRAFTING, this.craftingComponents).addAllComponents(Interactable.RecipeType.USAGE, this.usageComponents);
    }

    private Optional<ItemComponent> handleRecipes(RecipeHandler.RecipeMap recipeMap, ItemComponent input, Layout.SlotGroupKey key) {
        Optional<ImmutableList<DisplayComponent>> outputsOptional = this.recipeHandler.getUniqueRecipeOutput(recipeMap, input);
        if (!outputsOptional.isPresent()) {
            return Optional.empty();
        }
        ArrayList<DisplayComponent> outputs = new ArrayList<DisplayComponent>((Collection)outputsOptional.get());
        ComponentTransformer.removeComponent(outputs, STONE_DUST);
        if (outputs.size() == 0) {
            Logger.GREGTECH_5_ORE_PROCESSING.warn("Found no recipe outputs: [{}] [{}]", new Object[]{key, input});
            return Optional.empty();
        }
        this.diagramBuilder.autoInsertIntoSlotGroup(key).insertEachSafe(outputs);
        this.usageComponents.addAll(GregTechOreDictUtil.getAssociatedComponents(input));
        for (DisplayComponent output : outputs) {
            this.craftingComponents.addAll(GregTechOreDictUtil.getAssociatedComponents(output.component()));
        }
        return this.getFirstOutput(outputs, input, key);
    }

    private void handleChemicalBathFluid(RecipeHandler.ChemicalBathFluid chemicalBathFluid, ItemComponent input, Layout.SlotGroupKey key) {
        Optional<RecipeHandler.ChemicalBathFluidRecipe> recipeOptional = this.recipeHandler.getUniqueChemicalBathOutput(chemicalBathFluid, input);
        if (!recipeOptional.isPresent()) {
            return;
        }
        DisplayComponent fluid = DisplayComponent.builder(chemicalBathFluid.fluid).setStackSize(recipeOptional.get().inputFluidAmount()).build();
        Optional<DisplayComponent> fluidDisplayItem = GregTechFluidDictUtil.getDisplayItem(fluid.component()).map(itemComponent -> fluid.toBuilder().setComponent((Component)itemComponent).build());
        ArrayList<DisplayComponent> outputs = new ArrayList<DisplayComponent>((Collection<DisplayComponent>)recipeOptional.get().outputs());
        ComponentTransformer.removeComponent(outputs, STONE_DUST);
        if (outputs.size() == 0) {
            Logger.GREGTECH_5_ORE_PROCESSING.warn("Found no recipe outputs: [{}] [{}]", new Object[]{key, input});
            return;
        }
        this.diagramBuilder.autoInsertIntoSlotGroup(key).insertIntoNextSlot(fluidDisplayItem.orElse(fluid)).insertEachSafe(outputs);
        this.usageComponents.addAll(GregTechOreDictUtil.getAssociatedComponents(input));
        this.usageComponents.addAll(GregTechFluidDictUtil.getAssociatedComponents(fluid.component()));
        for (DisplayComponent output : outputs) {
            this.craftingComponents.addAll(GregTechOreDictUtil.getAssociatedComponents(output.component()));
        }
    }

    private Optional<ItemComponent> getFirstOutput(List<DisplayComponent> outputs, ItemComponent input, Layout.SlotGroupKey key) {
        Component firstOutput = outputs.get(0).component();
        if (firstOutput.type() == Component.ComponentType.FLUID) {
            Logger.GREGTECH_5_ORE_PROCESSING.warn("Found unexpected fluid output: [{}] [{}] [{}]", new Object[]{key, input, outputs});
            return Optional.empty();
        }
        return Optional.of((ItemComponent)firstOutput);
    }

    @SafeVarargs
    private final Collection<Component> addAdditionalRecipesInteractable(LabelHandler.ItemLabel label, Point pos, RecipeHandler.RecipeMap recipeMap, Optional<ItemComponent> ... components) {
        return this.addAdditionalRecipesInteractable(label, pos, (ItemComponent component) -> this.getRecipeOutputs(recipeMap, (ItemComponent)component), components);
    }

    private Collection<Component> getRecipeOutputs(RecipeHandler.RecipeMap recipeMap, ItemComponent component) {
        return this.recipeHandler.getRecipeOutputs(recipeMap, component).stream().flatMap(Collection::stream).map(DisplayComponent::component).collect(Collectors.toSet());
    }

    @SafeVarargs
    private final Collection<Component> addAdditionalFurnaceRecipesInteractable(LabelHandler.ItemLabel label, Point pos, Optional<ItemComponent> ... components) {
        return this.addAdditionalRecipesInteractable(label, pos, this::getFurnaceRecipeOutputs, components);
    }

    private Collection<Component> getFurnaceRecipeOutputs(ItemComponent component) {
        Optional<ItemComponent> output = this.recipeHandler.getFurnaceRecipeOutput(component);
        return output.isPresent() ? Lists.newArrayList((Object[])new Component[]{output.get()}) : Lists.newArrayList();
    }

    @SafeVarargs
    private final Collection<Component> addAdditionalRecipesInteractable(LabelHandler.ItemLabel label, Point pos, Function<ItemComponent, Collection<Component>> recipeOutputs, Optional<ItemComponent> ... components) {
        SetMultimap multimap = MultimapBuilder.linkedHashKeys().hashSetValues().build();
        Arrays.stream(components).filter(Optional::isPresent).map(Optional::get).forEach(component -> multimap.putAll(component, (Iterable)recipeOutputs.apply((ItemComponent)component)));
        if (multimap.keySet().isEmpty()) {
            return Lists.newArrayList();
        }
        CustomInteractable baseLabel = this.labelHandler.buildLabel(label, pos);
        Tooltip.Builder tooltipBuilder = Tooltip.builder().addAllLines((Iterable<TooltipLine>)baseLabel.tooltip().lines()).addSpacing();
        multimap.keySet().forEach(tooltipBuilder::addComponent);
        this.diagramBuilder.addInteractable(CustomInteractable.builder(baseLabel.drawable()).setTooltip(tooltipBuilder.build()).build());
        return multimap.values();
    }
}

