/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.Cursor;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IDraggable;
import com.gtnewhorizons.modularui.api.widget.IWidgetParent;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.SortableListWidget;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortableListItem<T>
extends Widget
implements IWidgetParent,
IDraggable {
    private final Widget upButton;
    private final Widget downButton;
    private final Widget removeButton;
    private Widget content;
    private final List<Widget> allChildren = new ArrayList<Widget>();
    private int currentIndex;
    private SortableListWidget<T> listWidget;
    private final T value;
    private boolean moving;
    private Pos2d relativeClickPos;
    private boolean active = true;

    public SortableListItem(T value) {
        this.value = value;
        this.upButton = new ButtonWidget().setOnClick((clickData, widget) -> this.listWidget.moveElementUp(this.currentIndex)).setBackground(ModularUITextures.BASE_BUTTON, ModularUITextures.ARROW_UP).setSize(10, 10);
        this.downButton = new ButtonWidget().setOnClick((clickData, widget) -> this.listWidget.moveElementDown(this.currentIndex)).setBackground(ModularUITextures.BASE_BUTTON, ModularUITextures.ARROW_DOWN).setSize(10, 10);
        this.removeButton = new ButtonWidget().setOnClick((clickData, widget) -> this.listWidget.removeElement(this.currentIndex)).setBackground(ModularUITextures.BASE_BUTTON, ModularUITextures.CROSS).setSize(10, 20);
    }

    protected void init(SortableListWidget<T> listWidget) {
        this.listWidget = listWidget;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void initChildren() {
        this.content = this.listWidget.getWidgetCreator().apply(this.value);
        this.makeChildrenList();
    }

    @Override
    public void onRebuild() {
        this.setEnabled(this.relativeClickPos == null);
    }

    @Override
    public Widget setEnabled(boolean enabled) {
        enabled = this.active;
        return super.setEnabled(enabled);
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        int w = this.content.getSize().width + (this.listWidget.areElementsRemovable() ? 20 : 10);
        int h = Math.max(this.content.getSize().height, 20);
        Size size = new Size(w, h);
        if (this.content.getSize().height >= 20) {
            this.content.setPosSilent(Pos2d.ZERO);
        } else {
            this.content.setPosSilent(new Pos2d(0, size.height / 2 - this.content.getSize().height / 2));
        }
        this.upButton.setPosSilent(new Pos2d(this.content.getSize().width, 0));
        this.downButton.setPosSilent(new Pos2d(this.content.getSize().width, size.height - 10));
        this.removeButton.setSize(10, size.height);
        this.removeButton.setPosSilent(new Pos2d(size.width - 10, 0));
        return size;
    }

    private void makeChildrenList() {
        this.allChildren.clear();
        this.allChildren.add(this.content);
        this.allChildren.add(this.upButton);
        this.allChildren.add(this.downButton);
        if (this.listWidget.areElementsRemovable()) {
            this.allChildren.add(this.removeButton);
        }
    }

    @Override
    public boolean canHover() {
        return true;
    }

    @Override
    public void renderMovingState(float partialTicks) {
        Cursor cursor = this.getContext().getCursor();
        GlStateManager.pushMatrix();
        GlStateManager.translate(-this.getAbsolutePos().x, -this.getAbsolutePos().y, 0.0f);
        GlStateManager.translate(cursor.getX() - this.relativeClickPos.x, cursor.getY() - this.relativeClickPos.y, 0.0f);
        this.drawInternal(partialTicks, true);
        GlStateManager.popMatrix();
    }

    @Override
    public boolean onDragStart(int button) {
        this.setActive(false);
        this.setEnabled(false);
        this.relativeClickPos = this.getContext().getMousePos().subtract(this.getAbsolutePos());
        return true;
    }

    @Override
    public void onDragEnd(boolean successful) {
        this.setActive(true);
        this.setEnabled(true);
        this.checkNeedsRebuild();
        this.relativeClickPos = null;
    }

    @Override
    public boolean canDropHere(@Nullable Widget widget, boolean isInBounds) {
        if (widget != null && widget.getParent() instanceof SortableListItem) {
            SortableListItem listItem = (SortableListItem)widget.getParent();
            return this.value.getClass().isAssignableFrom(listItem.value.getClass()) && this.currentIndex != listItem.currentIndex;
        }
        return false;
    }

    @Override
    public void onDrag(int mouseButton, long timeSinceLastClick) {
        SortableListItem<T> listItem = this.findSortableListItem();
        if (listItem != null) {
            this.listWidget.putAtIndex(this.currentIndex, listItem.currentIndex);
        }
    }

    @Nullable
    private SortableListItem<T> findSortableListItem() {
        if (!this.listWidget.isUnderMouse(this.getContext().getMousePos())) {
            return null;
        }
        for (Object hovered : this.getContext().getCursor().getAllHovered()) {
            if (hovered instanceof ModularWindow && hovered != this.getWindow()) {
                return null;
            }
            if (!(hovered instanceof SortableListItem) || ((SortableListItem)hovered).listWidget != this.listWidget) continue;
            return (SortableListItem)hovered;
        }
        return null;
    }

    @Override
    public boolean isMoving() {
        return this.moving;
    }

    @Override
    public void setMoving(boolean moving) {
        this.moving = moving;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public List<Widget> getChildren() {
        return this.allChildren;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

