/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.triggers;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.triggers.BinnieTrigger;
import binnie.core.triggers.TriggerData;

public class TriggerPower {
    public static TriggerData powerNone(Object tile) {
        double percent = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerNone, percent < (double)0.05f);
    }

    public static TriggerData powerLow(Object tile) {
        double percent = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerLow, percent < (double)0.35f);
    }

    public static TriggerData powerMedium(Object tile) {
        double percent = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerMedium, percent >= (double)0.35f && percent <= (double)0.65f);
    }

    public static TriggerData powerHigh(Object tile) {
        double percent = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerHigh, percent > (double)0.65f);
    }

    public static TriggerData powerFull(Object tile) {
        double percent = TriggerPower.getPercentage(tile);
        return new TriggerData(BinnieTrigger.triggerPowerFull, percent > (double)0.95f);
    }

    private static double getPercentage(Object tile) {
        IPoweredMachine process = Machine.getInterface(IPoweredMachine.class, tile);
        if (process != null) {
            return process.getInterface().getEnergy() / process.getInterface().getCapacity();
        }
        return 0.0;
    }
}

