/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.config.AccessRestriction;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseItemBlock;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class AEBaseItemBlockChargeable
extends AEBaseItemBlock
implements IAEItemPowerStorage {
    public AEBaseItemBlockChargeable(Block id) {
        super(id);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack itemStack, EntityPlayer player, List<String> toolTip, boolean advancedTooltips) {
        NBTTagCompound tag = itemStack.func_77978_p();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getMaxEnergyCapacity();
        if (tag != null) {
            internalCurrentPower = tag.func_74769_h("internalCurrentPower");
        }
        double percent = internalCurrentPower / internalMaxPower;
        toolTip.add(GuiText.StoredEnergy.getLocal() + ": " + NumberFormat.getNumberInstance(Locale.US).format(internalCurrentPower) + Platform.gui_localize(PowerUnits.AE.unlocalizedName) + " - " + MessageFormat.format(" {0,number,#.##%} ", percent));
    }

    private double getMaxEnergyCapacity() {
        Block blockID = Block.func_149634_a((Item)this);
        ITileDefinition energyCell = Api.INSTANCE.definitions().blocks().energyCell();
        Iterator iterator = energyCell.maybeBlock().asSet().iterator();
        if (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            if (blockID == block) {
                return 200000.0;
            }
            return 1600000.0;
        }
        return 0.0;
    }

    @Override
    public double injectAEPower(ItemStack is, double amt) {
        double internalCurrentPower = this.getInternal(is);
        double internalMaxPower = this.getMaxEnergyCapacity();
        if ((internalCurrentPower += amt) > internalMaxPower) {
            amt = internalCurrentPower - internalMaxPower;
            internalCurrentPower = internalMaxPower;
            this.setInternal(is, internalCurrentPower);
            return amt;
        }
        this.setInternal(is, internalCurrentPower);
        return 0.0;
    }

    private double getInternal(ItemStack is) {
        NBTTagCompound nbt = Platform.openNbtData(is);
        return nbt.func_74769_h("internalCurrentPower");
    }

    private void setInternal(ItemStack is, double amt) {
        NBTTagCompound nbt = Platform.openNbtData(is);
        nbt.func_74780_a("internalCurrentPower", amt);
    }

    @Override
    public double extractAEPower(ItemStack is, double amt) {
        double internalCurrentPower = this.getInternal(is);
        if (internalCurrentPower > amt) {
            this.setInternal(is, internalCurrentPower -= amt);
            return amt;
        }
        amt = internalCurrentPower;
        this.setInternal(is, 0.0);
        return amt;
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.getMaxEnergyCapacity();
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        return this.getInternal(is);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }
}

