/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import mrtjp.projectred.core.libmc.fx.ParticleLogic;

public final class ParticleLogicColorShift
extends ParticleLogic {
    private float minRed = 0.0f;
    private float maxRed = 1.0f;
    private float minGreen = 0.0f;
    private float maxGreen = 1.0f;
    private float minBlue = 0.0f;
    private float maxBlue = 1.0f;
    private float targetRed;
    private float targetGreen;
    private float targetBlue;
    private boolean endOnReachingColor = false;
    private float shiftSpeed = 0.01f;
    private float redShift;
    private float greenShift;
    private float blueShift;

    public ParticleLogicColorShift() {
        this.generateNextColorTarget();
    }

    public ParticleLogicColorShift setColorTarget(float red, float green, float blue) {
        this.targetRed = red;
        this.targetGreen = green;
        this.targetBlue = blue;
        this.redShift = Math.abs(this.particle.r() - this.targetRed) * this.shiftSpeed;
        this.greenShift = Math.abs(this.particle.g() - this.targetGreen) * this.shiftSpeed;
        this.blueShift = Math.abs(this.particle.b() - this.targetBlue) * this.shiftSpeed;
        return this;
    }

    public ParticleLogicColorShift setShiftSpeed(float speed) {
        this.redShift = this.shiftSpeed = speed;
        this.greenShift = this.shiftSpeed;
        this.blueShift = this.shiftSpeed;
        return this;
    }

    public ParticleLogicColorShift setColorRange(float minRed, float minBlue, float minGreen, float maxRed, float maxGreen, float maxBlue) {
        this.minRed = minRed;
        this.maxRed = maxRed;
        this.minGreen = minGreen;
        this.maxGreen = maxGreen;
        this.minBlue = minBlue;
        this.maxBlue = maxBlue;
        return this;
    }

    public ParticleLogicColorShift setEndOnReachingTargetColor() {
        this.endOnReachingColor = true;
        return this;
    }

    private void generateNextColorTarget() {
        this.targetRed = this.rand.nextFloat() * (this.maxRed - this.minRed) + this.minRed;
        this.targetGreen = this.rand.nextFloat() * (this.maxGreen - this.minGreen) + this.minGreen;
        this.targetBlue = this.rand.nextFloat() * (this.maxBlue - this.minBlue) + this.minBlue;
    }

    @Override
    public void doUpdate() {
        float currentRed = this.particle.r();
        float currentGreen = this.particle.g();
        float currentBlue = this.particle.b();
        if (currentRed == this.targetRed && currentGreen == this.targetGreen && currentBlue == this.targetBlue) {
            if (this.endOnReachingColor) {
                this.finishLogic();
                return;
            }
            this.generateNextColorTarget();
        }
        this.particle.setRGBColorF(this.shiftValue(currentRed, this.targetRed, this.redShift), this.shiftValue(currentGreen, this.targetGreen, this.greenShift), this.shiftValue(currentBlue, this.targetBlue, this.blueShift));
    }

    private float shiftValue(float current, float target, float step) {
        float curDist = Math.abs(target - current);
        if (curDist < step) {
            step = curDist;
        }
        if (current < target) {
            current += step;
        } else if (current > target) {
            current -= step;
        }
        return current;
    }

    @Override
    public ParticleLogic clone() {
        ParticleLogicColorShift clone = new ParticleLogicColorShift().setShiftSpeed(this.shiftSpeed).setColorRange(this.minRed, this.minBlue, this.minGreen, this.maxRed, this.maxGreen, this.maxBlue).setColorTarget(this.targetRed, this.targetGreen, this.targetBlue);
        if (this.endOnReachingColor) {
            clone.setEndOnReachingTargetColor();
        }
        clone.setFinal(this.finalLogic).setPriority(this.priority);
        return clone;
    }
}

