/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import crazypants.enderio.EnderIO;
import crazypants.enderio.Log;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.soul.BasicSoulBinderRecipe;
import crazypants.enderio.machine.soul.SoulBinderAttractorCystalRecipe;
import crazypants.enderio.machine.soul.SoulBinderEnderCystalRecipe;
import crazypants.enderio.machine.soul.SoulBinderPrecientCystalRecipe;
import crazypants.enderio.machine.soul.SoulBinderReanimationRecipe;
import crazypants.enderio.machine.soul.SoulBinderSentientRecipe;
import crazypants.enderio.machine.soul.SoulBinderSpawnerRecipe;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SoulBinderRecipeManager {
    private static final SoulBinderRecipeManager instance = new SoulBinderRecipeManager();
    public static final String KEY_RECIPE_UID = "recipeUID";
    public static final String KEY_INPUT_STACK = "inputStack";
    public static final String KEY_OUTPUT_STACK = "outputStack";
    public static final String KEY_REQUIRED_ENERGY = "requiredEnergyRF";
    public static final String KEY_REQUIRED_XP = "requiredXP";
    public static final String KEY_SOUL_TYPES = "entityTypes";

    public static SoulBinderRecipeManager getInstance() {
        return instance;
    }

    public void addDefaultRecipes() {
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, SoulBinderSpawnerRecipe.instance);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, SoulBinderReanimationRecipe.instance);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, SoulBinderSentientRecipe.instance);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, SoulBinderEnderCystalRecipe.instance);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, SoulBinderAttractorCystalRecipe.instance);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, SoulBinderPrecientCystalRecipe.instance);
        if (Config.transceiverEnabled && Config.enderRailEnabled) {
            BasicSoulBinderRecipe err = new BasicSoulBinderRecipe(new ItemStack(Blocks.field_150319_E), new ItemStack((Block)EnderIO.blockEnderRail), Config.soulBinderEnderRailRF, Config.soulBinderEnderRailLevels, "EnderRail", "SpecialMobs.SpecialEnderman", "Enderman");
            MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, err);
        }
    }

    public boolean addRecipeFromNBT(NBTTagCompound root) {
        try {
            String recipeUid = root.func_74779_i(KEY_RECIPE_UID);
            if (recipeUid == null || recipeUid.trim().length() == 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as recipe UID not set: " + root);
                return false;
            }
            ItemStack inputStack = this.getStackFromRoot(root, KEY_INPUT_STACK);
            if (inputStack == null) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no input stack defined: " + root);
                return false;
            }
            ItemStack outputStack = this.getStackFromRoot(root, KEY_OUTPUT_STACK);
            if (outputStack == null) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no output stack defined: " + root);
                return false;
            }
            int energyRequired = root.func_74762_e(KEY_REQUIRED_ENERGY);
            if (energyRequired <= 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as energy required was <= 0: " + root);
                return false;
            }
            int xpLevelsRequired = root.func_74762_e(KEY_REQUIRED_XP);
            if (xpLevelsRequired <= 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as energy required was <= 0: " + root);
                return false;
            }
            String str = root.func_74779_i(KEY_SOUL_TYPES);
            if (str == null || str.trim().length() == 0) {
                Log.error("SoulBinderRecipeManager: Could not add custom soul binder recipe from IMC as no soul types defined: " + root);
                return false;
            }
            String[] entityNames = str.split("\\|");
            BasicSoulBinderRecipe recipe = new BasicSoulBinderRecipe(inputStack, outputStack, energyRequired, xpLevelsRequired, recipeUid, entityNames);
            MachineRecipeRegistry.instance.registerRecipe(ModObject.blockSoulBinder.unlocalisedName, recipe);
            return true;
        }
        catch (Exception e) {
            Log.error("SoulBinderRecipeManager: Could not add custom soul binder exception thrown when parsing message: " + e);
            return false;
        }
    }

    private ItemStack getStackFromRoot(NBTTagCompound root, String string) {
        NBTTagCompound stackRoot = root.func_74775_l(string);
        if (stackRoot == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)stackRoot);
    }
}

