/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gregtech.common.tileentities.automation.MTEChestBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class MTESuperBuffer
extends MTEChestBuffer {
    public MTESuperBuffer(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 257, new String[]{"Buffers up to 256 Item Stacks", "Use Screwdriver to regulate output stack size", MTESuperBuffer.getTickRateDesc(aTier)});
    }

    public MTESuperBuffer(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public MTESuperBuffer(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESuperBuffer(this.mName, (int)this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_SUPERBUFFER), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_SUPERBUFFER_GLOW).glow().build());
    }

    @Override
    protected void fillStacksIntoFirstSlots() {
        int i;
        HashMap<GTUtility.ItemId, Integer> slots = new HashMap<GTUtility.ItemId, Integer>(this.mInventory.length);
        HashMap<GTUtility.ItemId, ItemStack> stacks = new HashMap<GTUtility.ItemId, ItemStack>(this.mInventory.length);
        ArrayList<Integer> validSlots = new ArrayList<Integer>(this.mInventory.length);
        for (i = 0; i < this.mInventory.length - 1; ++i) {
            if (!this.isValidSlot(i)) continue;
            validSlots.add(i);
            ItemStack s = this.mInventory[i];
            if (s == null) continue;
            GTUtility.ItemId itemId = GTUtility.ItemId.createNoCopy(s);
            slots.merge(itemId, s.field_77994_a, Integer::sum);
            if (!stacks.containsKey(itemId)) {
                stacks.put(itemId, s);
            }
            this.mInventory[i] = null;
        }
        i = 0;
        for (Map.Entry entry : slots.entrySet()) {
            do {
                int toSet;
                int slot = (Integer)validSlots.get(i);
                this.mInventory[slot] = ((ItemStack)stacks.get(entry.getKey())).func_77946_l();
                this.mInventory[slot].field_77994_a = toSet = Math.min((Integer)entry.getValue(), this.mInventory[slot].func_77976_d());
                entry.setValue((Integer)entry.getValue() - toSet);
                ++i;
            } while ((Integer)entry.getValue() > 0);
        }
    }

    @Override
    protected void addMainUI(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SUPER_BUFFER).setPos(61, 4).setSize(54, 54));
    }
}

