/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.util;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEItemStack;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IInvTweaks;
import appeng.util.Platform;
import com.glodblock.github.common.item.ItemFluidDrop;
import com.glodblock.github.util.Util;
import java.util.Comparator;
import net.minecraftforge.fluids.Fluid;

public class FluidSorters {
    private static SortDir Direction = SortDir.ASCENDING;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_MOD = new Comparator<IAEItemStack>(){

        @Override
        public int compare(IAEItemStack o1, IAEItemStack o2) {
            Fluid f1 = ItemFluidDrop.getAeFluidStack(o1).getFluid();
            Fluid f2 = ItemFluidDrop.getAeFluidStack(o2).getFluid();
            if (FluidSorters.getDirection() == SortDir.ASCENDING) {
                return this.secondarySort(Util.getFluidModName(f2).compareToIgnoreCase(Util.getFluidModName(f1)), f1, f2);
            }
            return this.secondarySort(Util.getFluidModName(f1).compareToIgnoreCase(Util.getFluidModName(f2)), f2, f1);
        }

        private int secondarySort(int compareToIgnoreCase, Fluid f1, Fluid f2) {
            if (compareToIgnoreCase == 0) {
                return f2.getLocalizedName().compareToIgnoreCase(f1.getLocalizedName());
            }
            return compareToIgnoreCase;
        }
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_NAME = (o1, o2) -> {
        if (FluidSorters.getDirection() == SortDir.ASCENDING) {
            return Platform.getItemDisplayName((Object)o1).compareToIgnoreCase(Platform.getItemDisplayName((Object)o2));
        }
        return Platform.getItemDisplayName((Object)o2).compareToIgnoreCase(Platform.getItemDisplayName((Object)o1));
    };
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_SIZE = (o1, o2) -> {
        if (FluidSorters.getDirection() == SortDir.ASCENDING) {
            return FluidSorters.compareLong(o2.getStackSize(), o1.getStackSize());
        }
        return FluidSorters.compareLong(o1.getStackSize(), o2.getStackSize());
    };
    private static IInvTweaks api;
    public static final Comparator<IAEItemStack> CONFIG_BASED_SORT_BY_INV_TWEAKS;

    public static void init() {
        if (api != null) {
            return;
        }
        api = IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.InvTweaks) ? (IInvTweaks)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.InvTweaks) : null;
    }

    public static int compareInt(int a, int b) {
        return Integer.compare(a, b);
    }

    public static int compareLong(long a, long b) {
        return Long.compare(a, b);
    }

    public static int compareDouble(double a, double b) {
        return Double.compare(a, b);
    }

    private static SortDir getDirection() {
        return Direction;
    }

    public static void setDirection(SortDir direction) {
        Direction = direction;
    }

    static {
        CONFIG_BASED_SORT_BY_INV_TWEAKS = new Comparator<IAEItemStack>(){

            @Override
            public int compare(IAEItemStack o1, IAEItemStack o2) {
                if (api == null) {
                    return CONFIG_BASED_SORT_BY_NAME.compare(o1, o2);
                }
                int cmp = api.compareItems(o1.getItemStack(), o2.getItemStack());
                if (FluidSorters.getDirection() == SortDir.ASCENDING) {
                    return cmp;
                }
                return -cmp;
            }
        };
    }
}

