/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui.container;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.ITerminalHost;
import appeng.api.util.DimensionalCoord;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.inv.ItemSlot;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.api.registries.ILevelViewable;
import com.glodblock.github.client.gui.container.base.FCBaseContainer;
import com.glodblock.github.common.parts.PartLevelTerminal;
import com.glodblock.github.coremod.registries.LevelTerminalRegistry;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.network.SPacketLevelTerminalUpdate;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerLevelTerminal
extends FCBaseContainer {
    private int nextId = 0;
    private final Map<IGridHost, InvTracker> tracked = new HashMap<IGridHost, InvTracker>();
    private final Map<Long, InvTracker> trackedById = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private SPacketLevelTerminalUpdate dirty;
    private boolean isDirty;
    private boolean wasOff;
    private int ticks = 0;

    public ContainerLevelTerminal(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable);
        if (Platform.isServer()) {
            if (monitorable instanceof PartLevelTerminal) {
                PartLevelTerminal terminal = (PartLevelTerminal)monitorable;
                this.grid = terminal.getActionableNode().getGrid();
            } else if (monitorable instanceof IWirelessTerminal) {
                IWirelessTerminal wirelessTerminal = (IWirelessTerminal)monitorable;
                this.grid = wirelessTerminal.getActionableNode().getGrid();
            }
            this.dirty = this.updateList();
            if (this.dirty != null) {
                this.isDirty = true;
            } else {
                this.dirty = new SPacketLevelTerminalUpdate();
            }
        }
        this.bindPlayerInventory(ip, 14, 0);
    }

    @Override
    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        IActionHost host = this.getActionHost();
        if (!host.getActionableNode().isActive()) {
            if (!this.wasOff) {
                SPacketLevelTerminalUpdate update = new SPacketLevelTerminalUpdate();
                update.setDisconnect();
                this.wasOff = true;
                FluidCraft.proxy.netHandler.sendTo(update, (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            return;
        }
        this.wasOff = false;
        if (this.isDirty) {
            FluidCraft.proxy.netHandler.sendTo(this.dirty, (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            this.dirty = new SPacketLevelTerminalUpdate();
            this.isDirty = false;
        } else if (++this.ticks % 20 == 0) {
            this.ticks = 0;
            SPacketLevelTerminalUpdate update = this.updateList();
            if (update != null) {
                FluidCraft.proxy.netHandler.sendTo(update, (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
        }
    }

    private ItemStack mergeToPlayerInventory(InventoryAdaptor playerInv, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (ItemSlot slot : playerInv) {
            if (!Platform.isSameItemPrecise((ItemStack)slot.getItemStack(), (ItemStack)stack) || slot.getItemStack().field_77994_a >= slot.getItemStack().func_77976_d()) continue;
            ++slot.getItemStack().field_77994_a;
            return null;
        }
        return playerInv.addItems(stack);
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slotIdx, long id) {
        InvTracker invTracker = this.trackedById.get(id);
        if (invTracker != null) {
            ItemStack handStack = player.field_71071_by.func_70445_o();
            if (handStack != null && !(handStack.func_77973_b() instanceof ItemEncodedPattern)) {
                return;
            }
            ItemStack slotStack = invTracker.requests.func_70301_a(slotIdx);
            AdaptorPlayerHand playerHand = new AdaptorPlayerHand((EntityPlayer)player);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (handStack != null) {
                        for (int s = 0; s < invTracker.requests.func_70302_i_(); ++s) {
                            if (!Platform.isSameItemPrecise((ItemStack)invTracker.requests.func_70301_a(s), (ItemStack)handStack)) continue;
                            return;
                        }
                    }
                    if (slotStack == null) {
                        if (handStack == null) {
                            return;
                        }
                        invTracker.requests.func_70299_a(slotIdx, playerHand.removeItems(1, null, null));
                    } else {
                        if (handStack != null && handStack.field_77994_a > 1) {
                            return;
                        }
                        invTracker.requests.func_70299_a(slotIdx, playerHand.removeItems(1, null, null));
                        playerHand.addItems(slotStack.func_77946_l());
                    }
                    this.syncLevelTerminalSlot(invTracker, id, slotIdx, invTracker.requests.func_70301_a(slotIdx));
                    break;
                }
                case SHIFT_CLICK: {
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((Object)player.field_71071_by, (ForgeDirection)ForgeDirection.UNKNOWN);
                    ItemStack leftOver = this.mergeToPlayerInventory(playerInv, slotStack);
                    if (leftOver != null) break;
                    invTracker.requests.func_70299_a(slotIdx, null);
                    this.syncLevelTerminalSlot(invTracker, id, slotIdx, null);
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                    ArrayList<Integer> valid = new ArrayList<Integer>();
                    for (int i = 0; i < invTracker.requests.func_70302_i_(); ++i) {
                        ItemStack toExtract = invTracker.requests.func_70301_a(i);
                        if (toExtract == null) continue;
                        ItemStack leftOver = this.mergeToPlayerInventory(playerInv, toExtract);
                        if (leftOver != null) break;
                        invTracker.requests.func_70299_a(i, null);
                        valid.add(i);
                    }
                    if (valid.isEmpty()) break;
                    int[] validIndices = Ints.toArray(valid);
                    NBTTagList tag = new NBTTagList();
                    for (int i = 0; i < valid.size(); ++i) {
                        tag.func_74742_a((NBTBase)new NBTTagCompound());
                    }
                    this.dirty.addOverwriteEntry(id).setItems(validIndices, tag);
                    this.isDirty = true;
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d) break;
                    playerHand.addItems(handStack);
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private void syncLevelTerminalSlot(InvTracker inv, long id, int slot, ItemStack stack) {
        int[] validIndices = new int[]{slot};
        NBTTagList list = new NBTTagList();
        NBTTagCompound item = new NBTTagCompound();
        if (stack != null) {
            stack.func_77955_b(item);
        }
        list.func_74742_a((NBTBase)item);
        inv.updateNBT();
        this.dirty.addOverwriteEntry(id).setItems(validIndices, list);
        this.isDirty = true;
    }

    private SPacketLevelTerminalUpdate updateList() {
        SPacketLevelTerminalUpdate update = null;
        Set<Class<? extends ILevelViewable>> supported = LevelTerminalRegistry.instance().getSupportedClasses();
        HashSet<IGridHost> visited = new HashSet<IGridHost>();
        for (Class<? extends ILevelViewable> clz : supported) {
            boolean isAdopted = LevelTerminalRegistry.instance().isAdopted(clz);
            Class<? extends ILevelViewable> machineClass = isAdopted ? LevelTerminalRegistry.instance().getAdopted(clz) : clz;
            for (IGridNode gridNode : this.grid.getMachines(machineClass)) {
                ILevelViewable machine;
                IGridHost gridHost = gridNode.getMachine();
                ILevelViewable iLevelViewable = machine = isAdopted ? LevelTerminalRegistry.instance().getAdapter(clz).adapt(gridHost) : (ILevelViewable)gridHost;
                if (this.tracked.containsKey(gridHost)) {
                    boolean isActive;
                    InvTracker knownTracker = this.tracked.get(gridHost);
                    String name = machine.getCustomName();
                    if (!Objects.equals(knownTracker.name, name)) {
                        if (update == null) {
                            update = new SPacketLevelTerminalUpdate();
                        }
                        update.addRenamedEntry(knownTracker.id, name);
                        knownTracker.name = name;
                    }
                    boolean bl = isActive = gridNode.isActive() || machine.shouldDisplay();
                    if (!knownTracker.online && isActive) {
                        knownTracker.online = true;
                        if (update == null) {
                            update = new SPacketLevelTerminalUpdate();
                        }
                        knownTracker.updateNBT();
                        update.addOverwriteEntry(knownTracker.id).setOnline(true).setItems(knownTracker.requests.func_70302_i_(), knownTracker.inventoryNbt);
                    } else if (knownTracker.online && !isActive) {
                        knownTracker.online = false;
                        if (update == null) {
                            update = new SPacketLevelTerminalUpdate();
                        }
                        update.addOverwriteEntry(knownTracker.id).setOnline(false);
                    }
                    for (int i = 0; i < knownTracker.requests.func_70302_i_(); ++i) {
                        ItemStack machineItemStack;
                        ItemStack knowmItemStack = ItemStack.func_77949_a((NBTTagCompound)knownTracker.inventoryNbt.func_150305_b(i));
                        if (!this.isDifferent(knowmItemStack, machineItemStack = machine.getInventoryByName("config").func_70301_a(i))) continue;
                        if (update == null) {
                            update = new SPacketLevelTerminalUpdate();
                        }
                        knownTracker.updateNBT();
                        update.addOverwriteEntry(knownTracker.id).setItems(knownTracker.requests.func_70302_i_(), knownTracker.inventoryNbt);
                    }
                } else {
                    if (update == null) {
                        update = new SPacketLevelTerminalUpdate();
                    }
                    InvTracker entry = new InvTracker(this.nextId++, machine, gridNode.isActive());
                    update.addNewEntry(entry.id, entry.name, entry.online).setLocation(entry.x, entry.y, entry.z, entry.dim, entry.side.ordinal()).setItems(entry.rows, entry.rowSize, entry.inventoryNbt).setViewItemStack(machine.getSelfItemStack(), machine.getDisplayItemStack());
                    this.tracked.put(gridHost, entry);
                    this.trackedById.put(entry.id, entry);
                }
                visited.add(gridHost);
            }
        }
        Iterator<Map.Entry<IGridHost, InvTracker>> it = this.tracked.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IGridHost, InvTracker> entry = it.next();
            if (visited.contains(entry.getKey())) continue;
            if (update == null) {
                update = new SPacketLevelTerminalUpdate();
            }
            this.trackedById.remove(entry.getValue().id);
            it.remove();
            update.addRemovalEntry(entry.getValue().id);
        }
        return update;
    }

    @Override
    protected boolean isWirelessTerminal() {
        return false;
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null || b == null) {
            return true;
        }
        return !ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    private static class InvTracker {
        private final long id;
        private String name;
        private final IInventory requests;
        private final int rowSize;
        private final int rows;
        private final int x;
        private final int y;
        private final int z;
        private final int dim;
        private final ForgeDirection side;
        private boolean online;
        private NBTTagList inventoryNbt;

        public InvTracker(long id, ILevelViewable machine, boolean online) {
            DimensionalCoord location = machine.getLocation();
            this.id = id;
            this.name = machine.getCustomName();
            this.requests = machine.getInventoryByName("config");
            this.rowSize = machine.rowSize();
            this.rows = machine.rows();
            this.x = location.x;
            this.y = location.y;
            this.z = location.z;
            this.dim = location.getDimension();
            this.side = machine.getSide();
            this.online = online;
            this.inventoryNbt = new NBTTagList();
            this.updateNBT();
        }

        private void updateNBT() {
            this.inventoryNbt = new NBTTagList();
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.rowSize; ++j) {
                    int offset = this.rowSize * i;
                    ItemStack stack = this.requests.func_70301_a(offset + j);
                    if (stack != null) {
                        this.inventoryNbt.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
                        continue;
                    }
                    this.inventoryNbt.func_74742_a((NBTBase)new NBTTagCompound());
                }
            }
        }
    }
}

