/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import toast.specialMobs.DataWatcherHelper;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.network.MessageTexture;

public class SpecialMobData {
    private static final float RANDOM_SCALING = (float)Properties.getDouble("_general", "random_scaling");
    private static final byte SCALE = DataWatcherHelper.instance.GENERIC.nextKey();
    private EntityLiving theEntity;
    private ResourceLocation[] textures;
    private boolean updateTextures;
    private byte healTimeMax;
    private byte healTime;
    public float arrowDamage = 2.0f;
    public float arrowSpread = 14.0f;
    public float arrowMoveSpeed;
    public short arrowRefireMin;
    public short arrowRefireMax;
    public float arrowRange;
    public byte armor;
    public boolean isImmuneToFire;
    public boolean isImmuneToBurning;
    public boolean allowLeashing;
    public boolean isImmuneToWebs;
    public boolean isImmuneToFalling;
    public boolean ignorePressurePlates;
    public boolean canBreatheInWater;
    public boolean ignoreWaterPush;
    public boolean isDamagedByWater;
    public HashSet<Integer> immuneToPotions = new HashSet();

    public static void init() {
    }

    public static NBTTagCompound getSaveLocation(NBTTagCompound tag) {
        if (!tag.func_74764_b("ForgeData")) {
            tag.func_74782_a("ForgeData", (NBTBase)new NBTTagCompound());
        }
        if (!(tag = tag.func_74775_l("ForgeData")).func_74764_b("SMData")) {
            tag.func_74782_a("SMData", (NBTBase)new NBTTagCompound());
        }
        return tag.func_74775_l("SMData");
    }

    public SpecialMobData(EntityLiving entity, ResourceLocation ... baseTextures) {
        this.theEntity = entity;
        this.textures = baseTextures;
        this.theEntity.func_70096_w().func_75682_a((int)SCALE, (Object)Float.valueOf(RANDOM_SCALING > 0.0f ? 1.0f + (entity.func_70681_au().nextFloat() - 0.5f) * RANDOM_SCALING : 1.0f));
        if (entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            this.immuneToPotions.add(Potion.field_76428_l.field_76415_H);
            this.immuneToPotions.add(Potion.field_76436_u.field_76415_H);
        }
    }

    public void onUpdate() {
        if (this.updateTextures && !this.theEntity.field_70170_p.field_72995_K && this.theEntity.field_70173_aa > 1) {
            this.updateTextures = false;
            _SpecialMobs.CHANNEL.sendToDimension((IMessage)new MessageTexture((Entity)this.theEntity), this.theEntity.field_71093_bK);
        }
        if (this.healTimeMax > 0 && (this.healTime = (byte)(this.healTime + 1)) >= this.healTimeMax) {
            this.healTime = 0;
            this.theEntity.func_70691_i(1.0f);
        }
        if (this.isDamagedByWater && this.theEntity.func_70026_G()) {
            this.theEntity.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data, EntityLiving proxy) {
        NBTTagCompound entityData = new NBTTagCompound();
        this.theEntity.func_70109_d(entityData);
        proxy.func_70020_e(entityData);
        data = proxy.func_110161_a(data);
        entityData = new NBTTagCompound();
        proxy.func_70109_d(entityData);
        this.theEntity.func_70020_e(entityData);
        ((ISpecialMob)this.theEntity).adjustEntityAttributes();
        if (proxy.field_70153_n != null) {
            proxy.field_70153_n.func_70078_a((Entity)this.theEntity);
        }
        this.theEntity.func_70078_a(proxy.field_70154_o);
        return data;
    }

    public void addAttribute(IAttribute attribute, double amount) {
        this.theEntity.func_110148_a(attribute).func_111128_a(this.theEntity.func_110148_a(attribute).func_111126_e() + amount);
    }

    public void multAttribute(IAttribute attribute, double amount) {
        this.theEntity.func_110148_a(attribute).func_111128_a(this.theEntity.func_110148_a(attribute).func_111126_e() * amount);
    }

    public void setHealTime(int time) {
        this.healTimeMax = (byte)time;
    }

    public int getTextureCount() {
        return this.textures.length;
    }

    public ResourceLocation getTexture() {
        return this.textures[0];
    }

    public ResourceLocation getTexture(int index) {
        return this.textures[index];
    }

    public ResourceLocation[] getTextures() {
        return this.textures;
    }

    public void setTextures(ResourceLocation ... tex) {
        this.textures = tex;
    }

    public void loadTextures(String ... tex) {
        try {
            ResourceLocation[] newTextures = new ResourceLocation[this.textures.length];
            int i = newTextures.length;
            while (i-- > 0) {
                if (!this.textures[i].toString().equals(tex[i])) {
                    this.updateTextures = true;
                    newTextures[i] = new ResourceLocation(tex[i]);
                    continue;
                }
                newTextures[i] = this.textures[i];
            }
            if (this.updateTextures) {
                this.setTextures(newTextures);
            }
        }
        catch (Exception ex) {
            _SpecialMobs.console("Failed to load textures!");
        }
    }

    public float getRenderScale() {
        return this.theEntity.func_70096_w().func_111145_d((int)SCALE);
    }

    public void setRenderScale(float scale) {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            this.theEntity.func_70096_w().func_75692_b((int)SCALE, (Object)Float.valueOf(scale));
        }
    }

    public void resetRenderScale(float scale) {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            this.theEntity.func_70096_w().func_75692_b((int)SCALE, (Object)Float.valueOf(RANDOM_SCALING > 0.0f ? scale + (this.theEntity.func_70681_au().nextFloat() - 0.5f) * RANDOM_SCALING : scale));
        }
    }

    public boolean isPotionApplicable(PotionEffect effect) {
        return !this.immuneToPotions.contains(effect.func_76456_a());
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74776_a("SMScale", this.getRenderScale());
        tag.func_74774_a("SMRegen", this.healTimeMax);
        tag.func_74774_a("SMRegenTick", this.healTime);
        NBTTagList textureTag = new NBTTagList();
        for (ResourceLocation texture : this.textures) {
            textureTag.func_74742_a((NBTBase)new NBTTagString(texture.toString()));
        }
        tag.func_74782_a("SMTex", (NBTBase)textureTag);
        tag.func_74776_a("SMArrowDamage", this.arrowDamage);
        tag.func_74776_a("SMArrowSpread", this.arrowSpread);
        tag.func_74776_a("SMArrowMoveSpeed", this.arrowMoveSpeed);
        tag.func_74777_a("SMArrowRefireMin", this.arrowRefireMin);
        tag.func_74777_a("SMArrowRefireMax", this.arrowRefireMax);
        tag.func_74776_a("SMArrowRange", this.arrowRange);
        tag.func_74774_a("SMArmor", this.armor);
        tag.func_74757_a("SMFireImmune", this.isImmuneToFire);
        tag.func_74757_a("SMBurningImmune", this.isImmuneToBurning);
        tag.func_74757_a("SMLeash", this.allowLeashing);
        tag.func_74757_a("SMWebImmune", this.isImmuneToWebs);
        tag.func_74757_a("SMFallImmune", this.isImmuneToFalling);
        tag.func_74757_a("SMUnderPressure", this.ignorePressurePlates);
        tag.func_74757_a("SMWaterBreath", this.canBreatheInWater);
        tag.func_74757_a("SMWaterPushImmune", this.ignoreWaterPush);
        tag.func_74757_a("SMWaterDamage", this.isDamagedByWater);
        int[] potionIds = new int[this.immuneToPotions.size()];
        int i = 0;
        for (int id : this.immuneToPotions) {
            potionIds[i++] = id;
        }
        tag.func_74783_a("SMPotionImmune", potionIds);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("SMScale")) {
            this.setRenderScale(tag.func_74760_g("SMScale"));
        }
        if (tag.func_74764_b("SMRegen")) {
            this.healTimeMax = tag.func_74771_c("SMRegen");
            this.healTime = tag.func_74771_c("SMRegenTick");
        }
        if (tag.func_74764_b("SMTex")) {
            try {
                NBTTagList textureTag = tag.func_150295_c("SMTex", (int)new NBTTagString().func_74732_a());
                String[] newTextures = new String[this.textures.length];
                int i = newTextures.length;
                while (i-- > 0) {
                    newTextures[i] = textureTag.func_150307_f(i);
                }
                this.loadTextures(newTextures);
            }
            catch (Exception ex) {
                _SpecialMobs.console("Failed to load textures from NBT! " + this.theEntity.toString());
            }
        }
        if (tag.func_74764_b("SMArrowDamage")) {
            this.arrowDamage = tag.func_74760_g("SMArrowDamage");
        }
        if (tag.func_74764_b("SMArrowSpread")) {
            this.arrowSpread = tag.func_74760_g("SMArrowSpread");
        }
        if (tag.func_74764_b("SMArrowMoveSpeed")) {
            this.arrowMoveSpeed = tag.func_74760_g("SMArrowMoveSpeed");
        }
        if (tag.func_74764_b("SMArrowRefireMin")) {
            this.arrowRefireMin = tag.func_74765_d("SMArrowRefireMin");
        }
        if (tag.func_74764_b("SMArrowRefireMax")) {
            this.arrowRefireMax = tag.func_74765_d("SMArrowRefireMax");
        }
        if (tag.func_74764_b("SMArrowRange")) {
            this.arrowRange = tag.func_74760_g("SMArrowRange");
        }
        if (tag.func_74764_b("SMArmor")) {
            this.armor = tag.func_74771_c("SMArmor");
        }
        if (tag.func_74764_b("SMFireImmune")) {
            this.isImmuneToFire = tag.func_74767_n("SMFireImmune");
        }
        if (tag.func_74764_b("SMBurningImmune")) {
            this.isImmuneToBurning = tag.func_74767_n("SMBurningImmune");
        }
        if (tag.func_74764_b("SMLeash")) {
            this.allowLeashing = tag.func_74767_n("SMLeash");
        }
        if (tag.func_74764_b("SMWebImmune")) {
            this.isImmuneToWebs = tag.func_74767_n("SMWebImmune");
        }
        if (tag.func_74764_b("SMFallImmune")) {
            this.isImmuneToFalling = tag.func_74767_n("SMFallImmune");
        }
        if (tag.func_74764_b("SMUnderPressure")) {
            this.ignorePressurePlates = tag.func_74767_n("SMUnderPressure");
        }
        if (tag.func_74764_b("SMWaterBreath")) {
            this.canBreatheInWater = tag.func_74767_n("SMWaterBreath");
        }
        if (tag.func_74764_b("SMWaterPushImmune")) {
            this.ignoreWaterPush = tag.func_74767_n("SMWaterPushImmune");
        }
        if (tag.func_74764_b("SMWaterDamage")) {
            this.isDamagedByWater = tag.func_74767_n("SMWaterDamage");
        }
        if (tag.func_74764_b("SMPotionImmune")) {
            int[] potionIds = tag.func_74759_k("SMPotionImmune");
            this.immuneToPotions.clear();
            for (int id : potionIds) {
                this.immuneToPotions.add(id);
            }
        }
    }
}

