/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockColored;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import toast.specialMobs.Properties;
import toast.specialMobs._SpecialMobs;

public abstract class EffectHelper {
    public static final boolean POISON_STACKS = Properties.getBoolean("_enchants", "poison_stacks");

    public static void stackEffect(EntityLivingBase entity, Potion potion, int duration, int amplifier) {
        if (POISON_STACKS && entity.func_70644_a(potion)) {
            PotionEffect potionEffect = entity.func_70660_b(potion);
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, Math.max(duration, potionEffect.func_76459_b()), potionEffect.func_76458_c() + amplifier + 1));
        } else {
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, duration, amplifier));
        }
    }

    public static void stackEffect(EntityLivingBase entity, Potion potion, int duration, int amplifier, int amplifierMax) {
        if (amplifierMax < 0) {
            EffectHelper.stackEffect(entity, potion, duration, amplifier);
            return;
        }
        if (POISON_STACKS && entity.func_70644_a(potion)) {
            PotionEffect potionEffect = entity.func_70660_b(potion);
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, Math.max(duration, potionEffect.func_76459_b()), Math.min(amplifierMax, potionEffect.func_76458_c() + amplifier + 1)));
        } else if (amplifier >= 0) {
            entity.func_70690_d(new PotionEffect(potion.field_76415_H, duration, Math.min(amplifier, amplifierMax)));
        }
    }

    public static void plagueEffect(EntityLivingBase target, int level) {
        Potion effect = null;
        int time = 10;
        int amplifier = 0;
        int amplifierMax = 0;
        switch (target.func_70681_au().nextInt(6)) {
            case 0: {
                effect = Potion.field_76421_d;
                time = 8;
                amplifierMax = 5;
                break;
            }
            case 1: {
                effect = Potion.field_76431_k;
                amplifierMax = 2;
                break;
            }
            case 2: {
                effect = Potion.field_76440_q;
                break;
            }
            case 3: {
                effect = Potion.field_76438_s;
                time = 8;
                amplifierMax = 1;
                break;
            }
            case 4: {
                effect = Potion.field_76437_t;
                amplifierMax = 6;
                break;
            }
            case 5: {
                effect = Potion.field_76436_u;
                time = 6;
                amplifierMax = 1;
            }
        }
        if (effect != null) {
            EffectHelper.stackEffect(target, effect, time * 20, amplifier, amplifierMax);
        }
        if (level > 1) {
            EffectHelper.plagueEffect(target, level - 1);
        }
    }

    public static void setItemName(ItemStack itemStack, String name) {
        EffectHelper.setItemName(itemStack, name, 11);
    }

    public static void setItemName(ItemStack itemStack, String name, int rarityColor) {
        if (itemStack == null || itemStack.func_82837_s()) {
            return;
        }
        itemStack.func_151001_c("\u00a7" + Integer.toHexString(rarityColor) + name);
    }

    public static void addItemText(ItemStack itemStack, String text) {
        NBTTagCompound displayTag;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_74764_b("display")) {
            itemStack.field_77990_d.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        if (!(displayTag = itemStack.field_77990_d.func_74775_l("display")).func_74764_b("Lore")) {
            displayTag.func_74782_a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagString textTag = new NBTTagString(text);
        displayTag.func_150295_c("Lore", (int)textTag.func_74732_a()).func_74742_a((NBTBase)textTag);
    }

    public static void addModifier(ItemStack itemStack, String name, IAttribute attribute, double value, int operation) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        if (!itemStack.field_77990_d.func_74764_b("AttributeModifiers")) {
            itemStack.field_77990_d.func_74782_a("AttributeModifiers", (NBTBase)new NBTTagList());
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Name", name);
        tag.func_74778_a("AttributeName", attribute.func_111108_a());
        tag.func_74780_a("Amount", value);
        tag.func_74768_a("Operation", operation);
        UUID id = UUID.randomUUID();
        tag.func_74772_a("UUIDMost", id.getMostSignificantBits());
        tag.func_74772_a("UUIDLeast", id.getLeastSignificantBits());
        itemStack.field_77990_d.func_150295_c("AttributeModifiers", (int)tag.func_74732_a()).func_74742_a((NBTBase)tag);
    }

    public static void addPotionEffect(ItemStack potionStack, Potion potion, int duration, int amplifier) {
        EffectHelper.addPotionEffect(potionStack, potion, duration, amplifier, false);
    }

    public static void addPotionEffect(ItemStack potionStack, Potion potion, int duration, int amplifier, boolean ambient) {
        if (potionStack.field_77990_d == null) {
            potionStack.field_77990_d = new NBTTagCompound();
        }
        if (!potionStack.field_77990_d.func_74764_b("CustomPotionEffects")) {
            potionStack.field_77990_d.func_74782_a("CustomPotionEffects", (NBTBase)new NBTTagList());
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Id", (byte)potion.field_76415_H);
        tag.func_74768_a("Duration", duration);
        tag.func_74774_a("Amplifier", (byte)amplifier);
        tag.func_74757_a("Ambient", ambient);
        potionStack.field_77990_d.func_150295_c("CustomPotionEffects", (int)tag.func_74732_a()).func_74742_a((NBTBase)tag);
    }

    public static void overrideEnchantment(ItemStack itemStack, Enchantment enchantment, int level) {
        NBTTagCompound enchTag;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_74764_b("ench")) {
            itemStack.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList enchList = (NBTTagList)itemStack.field_77990_d.func_74781_a("ench");
        int i = enchList.func_74745_c();
        while (i-- > 0) {
            enchTag = enchList.func_150305_b(i);
            if (enchTag.func_74765_d("id") != enchantment.field_77352_x) continue;
            if (enchTag.func_74765_d("lvl") < level) {
                enchTag.func_74777_a("lvl", (short)((byte)level));
            }
            return;
        }
        enchTag = new NBTTagCompound();
        enchTag.func_74777_a("id", (short)enchantment.field_77352_x);
        enchTag.func_74777_a("lvl", (short)((byte)level));
        enchList.func_74742_a((NBTBase)enchTag);
    }

    public static ArrayList<NBTTagCompound> getEnchantments(ItemStack itemStack) {
        ArrayList<NBTTagCompound> enchantments = new ArrayList<NBTTagCompound>(0);
        if (itemStack.field_77990_d == null || !itemStack.field_77990_d.func_74764_b("ench")) {
            return enchantments;
        }
        NBTTagList enchList = (NBTTagList)itemStack.field_77990_d.func_74781_a("ench");
        int length = enchList.func_74745_c();
        enchantments.ensureCapacity(length);
        for (int i = 0; i < length; ++i) {
            enchantments.add((NBTTagCompound)enchList.func_150305_b(i).func_74737_b());
        }
        return enchantments;
    }

    public static void setEnchantments(ItemStack itemStack, ArrayList<NBTTagCompound> enchantments) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagList enchList = new NBTTagList();
        for (NBTTagCompound enchTag : enchantments) {
            enchList.func_74742_a(enchTag.func_74737_b());
        }
        itemStack.field_77990_d.func_74782_a("ench", (NBTBase)enchList);
    }

    public static void addEnchantments(ItemStack itemStack, int[] ... enchantments) {
        NBTTagCompound enchTag;
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (!itemStack.field_77990_d.func_74764_b("ench")) {
            itemStack.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList enchList = (NBTTagList)itemStack.field_77990_d.func_74781_a("ench");
        HashMap<Short, NBTTagCompound> existing = new HashMap<Short, NBTTagCompound>();
        int i = enchList.func_74745_c();
        while (i-- > 0) {
            enchTag = enchList.func_150305_b(i);
            existing.put(enchTag.func_74765_d("id"), enchTag);
        }
        for (int[] enchant : enchantments) {
            if (existing.containsKey((short)enchant[0])) {
                enchTag = (NBTTagCompound)existing.get((short)enchant[0]);
                if (enchTag.func_74765_d("lvl") >= enchant[1]) continue;
                enchTag.func_74777_a("lvl", (short)enchant[1]);
                continue;
            }
            enchTag = new NBTTagCompound();
            enchTag.func_74777_a("id", (short)enchant[0]);
            enchTag.func_74777_a("lvl", (short)enchant[1]);
            enchList.func_74742_a((NBTBase)enchTag);
        }
    }

    public static void enchantItem(ItemStack itemStack, Enchantment enchantment, int level) {
        itemStack.func_77966_a(enchantment, level);
    }

    public static void enchantItem(ItemStack itemStack, int enchantmentID, int level) {
        EffectHelper.enchantItem(itemStack, Enchantment.field_77331_b[enchantmentID], level);
    }

    public static boolean enchantItem(ItemStack itemStack, int level) {
        return EffectHelper.enchantItem(_SpecialMobs.random, itemStack, level);
    }

    public static boolean enchantItem(Random random, ItemStack itemStack, int level) {
        if (level <= 0 || itemStack == null || !itemStack.func_77956_u()) {
            return false;
        }
        try {
            EnchantmentHelper.func_77504_a((Random)random, (ItemStack)itemStack, (int)level);
        }
        catch (Exception ex) {
            _SpecialMobs.console("Error applying enchantments! item:" + itemStack.toString());
            ex.printStackTrace();
        }
        return true;
    }

    public static boolean enchantItem(ItemStack itemStack, String type) {
        Item item;
        if (itemStack == null || !itemStack.func_77956_u()) {
            return false;
        }
        boolean isSuper = false;
        boolean silkTouch = false;
        if (type != "max") {
            if (type == "maxSilkTouch") {
                silkTouch = true;
            } else if (type == "super") {
                isSuper = true;
            } else if (type == "superSilkTouch") {
                silkTouch = true;
                isSuper = true;
            } else {
                return false;
            }
        }
        if ((item = itemStack.func_77973_b()) instanceof ItemArmor) {
            EffectHelper.enchantItem(itemStack, Enchantment.field_77332_c, isSuper ? 10 : Enchantment.field_77332_c.func_77325_b());
            if (((ItemArmor)item).field_77881_a == 0) {
                EffectHelper.enchantItem(itemStack, Enchantment.field_77340_h, isSuper ? 10 : Enchantment.field_77340_h.func_77325_b());
                if (silkTouch) {
                    EffectHelper.enchantItem(itemStack, Enchantment.field_77341_i, isSuper ? 10 : Enchantment.field_77341_i.func_77325_b());
                }
            } else if (((ItemArmor)item).field_77881_a == 3) {
                EffectHelper.enchantItem(itemStack, Enchantment.field_77330_e, isSuper ? 10 : Enchantment.field_77330_e.func_77325_b());
            }
        } else if (item instanceof ItemSword) {
            EffectHelper.enchantItem(itemStack, Enchantment.field_77338_j, isSuper ? 10 : Enchantment.field_77338_j.func_77325_b());
            EffectHelper.enchantItem(itemStack, Enchantment.field_77337_m, isSuper ? 10 : Enchantment.field_77337_m.func_77325_b());
            if (silkTouch) {
                EffectHelper.enchantItem(itemStack, Enchantment.field_77335_o, isSuper ? 10 : Enchantment.field_77335_o.func_77325_b());
            }
        } else if (item instanceof ItemTool) {
            EffectHelper.enchantItem(itemStack, Enchantment.field_77349_p, isSuper ? 10 : Enchantment.field_77349_p.func_77325_b());
            EffectHelper.enchantItem(itemStack, Enchantment.field_77347_r, isSuper ? 10 : Enchantment.field_77347_r.func_77325_b());
            if (silkTouch) {
                EffectHelper.enchantItem(itemStack, Enchantment.field_77348_q, isSuper ? 10 : Enchantment.field_77348_q.func_77325_b());
            } else {
                EffectHelper.enchantItem(itemStack, Enchantment.field_77346_s, isSuper ? 10 : Enchantment.field_77346_s.func_77325_b());
            }
        } else if (item instanceof ItemBow) {
            EffectHelper.enchantItem(itemStack, Enchantment.field_77345_t, isSuper ? 10 : Enchantment.field_77345_t.func_77325_b());
            EffectHelper.enchantItem(itemStack, Enchantment.field_77344_u, isSuper ? 10 : Enchantment.field_77344_u.func_77325_b());
            if (silkTouch) {
                EffectHelper.enchantItem(itemStack, Enchantment.field_77342_w, isSuper ? 10 : Enchantment.field_77342_w.func_77325_b());
            }
        }
        return true;
    }

    public static boolean dye(ItemStack itemStack, String colorName) {
        int i = ItemDye.field_150922_c.length;
        while (i-- > 0) {
            if (!colorName.equalsIgnoreCase(ItemDye.field_150921_b[i])) continue;
            return EffectHelper.dye(itemStack, (byte)i);
        }
        _SpecialMobs.debugException("Tried to dye with an invalid dye name (" + colorName + ")! Valid dye names: black, red, green, brown, blue, purple, cyan, silver, gray, pink, lime, yellow, lightBlue, magenta, orange, white.");
        return false;
    }

    public static boolean dye(ItemStack itemStack, byte colorIndex) {
        if (colorIndex < 0 || colorIndex >= ItemDye.field_150922_c.length) {
            _SpecialMobs.debugException("Tried to dye with an invalid dye index (" + colorIndex + ")!");
            return false;
        }
        float[] rgb = EntitySheep.field_70898_d[BlockColored.func_150031_c((int)colorIndex)];
        return EffectHelper.dye(itemStack, (int)(rgb[0] * 255.0f), (int)(rgb[1] * 255.0f), (int)(rgb[2] * 255.0f));
    }

    public static boolean dye(ItemStack itemStack, int red, int green, int blue) {
        if (red > 255 || green > 255 || blue > 255 || red < 0 || green < 0 || blue < 0) {
            _SpecialMobs.debugException("Tried to dye with an invalid RGB value (" + red + ", " + green + ", " + blue + ")!");
            return false;
        }
        return EffectHelper.dye(itemStack, (red << 16) + (green << 8) + blue);
    }

    public static boolean dye(ItemStack itemStack, int color) {
        if (color < 0 || color > 0xFFFFFF) {
            _SpecialMobs.debugException("Tried to dye with an invalid color value (" + color + ")!");
            return false;
        }
        try {
            ((ItemArmor)itemStack.func_77973_b()).func_82813_b(itemStack, color);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

