/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.client.render;

import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.RenderShape;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.common.shape.Shape;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.Trans3;
import gcewing.architecture.compat.Vector3;
import net.minecraft.util.EnumFacing;

public class RenderRoof
extends RenderShape {
    protected static final Shape[] ridgeShapes = new Shape[]{Shape.RoofRidge, Shape.RoofSmartRidge};
    protected static final Shape[] ridgeOrSlopeShapes = new Shape[]{Shape.RoofRidge, Shape.RoofSmartRidge, Shape.RoofTile, Shape.RoofOuterCorner, Shape.RoofInnerCorner};
    protected static final Shape[] valleyShapes = new Shape[]{Shape.RoofValley, Shape.RoofSmartValley};
    protected static final Shape[] valleyOrSlopeShapes = new Shape[]{Shape.RoofValley, Shape.RoofSmartValley, Shape.RoofTile, Shape.RoofInnerCorner};
    protected EnumFacing face;
    protected boolean outerFace;
    protected boolean renderBase;
    protected boolean renderSecondary;

    public RenderRoof() {
    }

    public RenderRoof(TileShape te, ITexture[] textures, Trans3 t, IRenderTarget target, boolean renderBase, boolean renderSecondary) {
        super(te, textures, t, target);
        this.renderBase = renderBase;
        this.renderSecondary = renderSecondary;
    }

    @Override
    public void render() {
        switch (this.te.shape) {
            case RoofTile: 
            case RoofTileSE: {
                this.renderSlope();
                break;
            }
            case SlopeTileA1: 
            case SlopeTileA1SE: {
                this.renderSlopeA1();
                break;
            }
            case SlopeTileA2: 
            case SlopeTileA2SE: {
                this.renderSlopeA2();
                break;
            }
            case SlopeTileB1: 
            case SlopeTileB1SE: {
                this.renderSlopeB1();
                break;
            }
            case SlopeTileB2: 
            case SlopeTileB2SE: {
                this.renderSlopeB2();
                break;
            }
            case SlopeTileB3: 
            case SlopeTileB3SE: {
                this.renderSlopeB3();
                break;
            }
            case SlopeTileC1: 
            case SlopeTileC1SE: {
                this.renderSlopeC1();
                break;
            }
            case SlopeTileC2: 
            case SlopeTileC2SE: {
                this.renderSlopeC2();
                break;
            }
            case SlopeTileC3: 
            case SlopeTileC3SE: {
                this.renderSlopeC3();
                break;
            }
            case SlopeTileC4: 
            case SlopeTileC4SE: {
                this.renderSlopeC4();
                break;
            }
            case RoofOuterCorner: {
                this.renderOuterCorner();
                break;
            }
            case RoofInnerCorner: {
                this.renderInnerCorner();
                break;
            }
            case RoofRidge: {
                this.renderRidge();
                break;
            }
            case RoofSmartRidge: {
                this.renderSmartRidge();
                break;
            }
            case RoofValley: {
                this.renderValley();
                break;
            }
            case RoofSmartValley: {
                this.renderSmartValley();
            }
        }
    }

    protected void renderSlope() {
        boolean valley = this.valleyAt(0, 0, 1);
        if (this.renderSecondary) {
            this.beginNegZSlope();
            if (valley) {
                this.beginTriangle();
                this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.newTriangle();
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.newTriangle();
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
                this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
                this.endFace();
                this.connectValleyBack();
            } else {
                this.beginQuad();
                this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
                this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
                this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
                this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
                this.endFace();
            }
        }
        if (this.renderBase) {
            this.leftTriangle();
            this.rightTriangle();
            this.bottomQuad();
            if (!valley) {
                this.backQuad();
            }
        }
        if (this.renderSecondary && this.ridgeAt(0, 0, -1)) {
            this.connectRidgeFront();
        }
    }

    protected void renderSlopeA1() {
        this.renderVariableSlope(1.0, 0.5);
        this.renderVariableFaceLeft(0.0, 0.5);
        this.renderVariableTriangleLeft(0.5, 0.5);
        this.renderVariableFaceRight(0.0, 0.5);
        this.renderVariableTriangleRight(0.5, 0.5);
        this.renderVariableFrontFace(0.5);
        this.bottomQuad();
        this.backQuad();
    }

    protected void renderSlopeA2() {
        this.renderVariableSlope(0.5, 0.0);
        this.renderVariableTriangleLeft(0.0, 0.5);
        this.renderVariableTriangleRight(0.0, 0.5);
        this.bottomQuad();
        this.renderVariableBackFace(0.5);
    }

    protected void renderSlopeB1() {
        this.renderVariableSlope(1.0, 0.66666);
        this.renderVariableFaceLeft(0.0, 0.66666);
        this.renderVariableTriangleLeft(0.66666, 0.33333);
        this.renderVariableFaceRight(0.0, 0.66666);
        this.renderVariableTriangleRight(0.66666, 0.33333);
        this.renderVariableFrontFace(0.66666);
        this.bottomQuad();
        this.backQuad();
    }

    protected void renderSlopeB2() {
        this.renderVariableSlope(0.66666, 0.33333);
        this.renderVariableFaceLeft(0.0, 0.33333);
        this.renderVariableTriangleLeft(0.33333, 0.33333);
        this.renderVariableFaceRight(0.0, 0.33333);
        this.renderVariableTriangleRight(0.33333, 0.33333);
        this.renderVariableFrontFace(0.33333);
        this.bottomQuad();
        this.renderVariableBackFace(0.66666);
    }

    protected void renderSlopeB3() {
        this.renderVariableSlope(0.33333, 0.0);
        this.renderVariableTriangleLeft(0.0, 0.33333);
        this.renderVariableTriangleRight(0.0, 0.33333);
        this.bottomQuad();
        this.renderVariableBackFace(0.33333);
    }

    protected void renderSlopeC1() {
        this.renderVariableSlope(1.0, 0.75);
        this.renderVariableFaceLeft(0.0, 0.75);
        this.renderVariableTriangleLeft(0.75, 0.25);
        this.renderVariableFaceRight(0.0, 0.75);
        this.renderVariableTriangleRight(0.75, 0.25);
        this.renderVariableFrontFace(0.75);
        this.bottomQuad();
        this.backQuad();
    }

    protected void renderSlopeC2() {
        this.renderVariableSlope(0.75, 0.5);
        this.renderVariableFaceLeft(0.0, 0.5);
        this.renderVariableTriangleLeft(0.5, 0.25);
        this.renderVariableFaceRight(0.0, 0.5);
        this.renderVariableTriangleRight(0.5, 0.25);
        this.renderVariableFrontFace(0.5);
        this.bottomQuad();
        this.renderVariableBackFace(0.75);
    }

    protected void renderSlopeC3() {
        this.renderVariableSlope(0.5, 0.25);
        this.renderVariableFaceLeft(0.0, 0.25);
        this.renderVariableTriangleLeft(0.25, 0.25);
        this.renderVariableFaceRight(0.0, 0.25);
        this.renderVariableTriangleRight(0.25, 0.25);
        this.renderVariableFrontFace(0.25);
        this.bottomQuad();
        this.renderVariableBackFace(0.5);
    }

    protected void renderSlopeC4() {
        this.renderVariableSlope(0.25, 0.0);
        this.renderVariableTriangleLeft(0.0, 0.25);
        this.renderVariableTriangleRight(0.0, 0.25);
        this.bottomQuad();
        this.renderVariableBackFace(0.25);
    }

    protected void renderVariableSlope(double start, double end) {
        this.beginNegZSlope();
        this.beginQuad();
        this.vertex(1.0, start, 1.0, 0.0, 0.0);
        this.vertex(1.0, end, 0.0, 0.0, 1.0);
        this.vertex(0.0, end, 0.0, 1.0, 1.0);
        this.vertex(0.0, start, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void renderVariableTriangleLeft(double offset, double height) {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, offset + height, 1.0, 0.0, 0.0);
        this.vertex(1.0, offset, 1.0, 0.0, 1.0 - height);
        this.vertex(1.0, offset, 0.0, 1.0, 1.0 - height);
        this.endFace();
    }

    protected void renderVariableTriangleRight(double offset, double height) {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, offset + height, 1.0, 1.0, 0.0);
        this.vertex(0.0, offset, 0.0, 0.0, 1.0 - height);
        this.vertex(0.0, offset, 1.0, 1.0, 1.0 - height);
        this.endFace();
    }

    protected void renderVariableFaceLeft(double offset, double height) {
        this.beginNegXFace();
        this.beginQuad();
        this.vertex(0.0, offset + height, 0.0, 0.0, 1.0 - height);
        this.vertex(0.0, offset, 0.0, 0.0, 1.0);
        this.vertex(0.0, offset, 1.0, 1.0, 1.0);
        this.vertex(0.0, offset + height, 1.0, 1.0, 1.0 - height);
        this.endFace();
    }

    protected void renderVariableFaceRight(double offset, double height) {
        this.beginPosXFace();
        this.beginQuad();
        this.vertex(1.0, offset + height, 1.0, 0.0, 1.0 - height);
        this.vertex(1.0, offset, 1.0, 0.0, 1.0);
        this.vertex(1.0, offset, 0.0, 1.0, 1.0);
        this.vertex(1.0, offset + height, 0.0, 1.0, 1.0 - height);
        this.endFace();
    }

    protected void renderVariableFrontFace(double height) {
        this.beginNegZFace();
        this.beginQuad();
        this.vertex(1.0, height, 0.0, 0.0, 1.0 - height);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, height, 0.0, 1.0, 1.0 - height);
        this.endFace();
    }

    protected void renderVariableBackFace(double height) {
        this.beginPosZFace();
        this.beginQuad();
        this.vertex(0.0, height, 1.0, 0.0, 1.0 - height);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, height, 1.0, 1.0, 1.0 - height);
        this.endFace();
    }

    protected void renderOuterCorner() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.beginPosZFace();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
            this.rightTriangle();
            this.bottomQuad();
        }
        if (this.renderSecondary) {
            if (this.ridgeAt(0, 0, -1)) {
                this.connectRidgeFront();
            }
            if (this.ridgeAt(1, 0, 0)) {
                this.connectRidgeLeft();
            }
        }
    }

    protected void renderInnerCorner() {
        if (this.renderSecondary) {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.endFace();
        }
        if (this.renderBase) {
            this.beginNegZFace();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
            this.leftTriangle();
            this.bottomQuad();
        }
        if (this.valleyAt(0, 0, 1)) {
            this.connectValleyBack();
        } else {
            this.terminateValleyBack();
        }
        if (this.valleyAt(-1, 0, 0)) {
            this.connectValleyRight();
        } else {
            this.terminateValleyRight();
        }
    }

    protected void renderRidge() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginQuad();
            this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
            this.endFace();
            this.ridgeBackSlope();
            this.ridgeFront(false);
            this.ridgeBack(false);
        }
        if (this.renderBase) {
            this.ridgeLeftFace();
            this.ridgeRightFace();
            this.bottomQuad();
        }
    }

    protected void renderSmartRidge() {
        if (this.renderSecondary) {
            this.ridgeLeft();
            this.ridgeRight();
            this.ridgeBack(true);
            this.ridgeFront(true);
        }
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void renderValley() {
        this.connectValleyLeft();
        this.connectValleyRight();
        this.smartValleyFront();
        this.smartValleyBack();
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void renderSmartValley() {
        this.smartValleyLeft();
        this.smartValleyRight();
        this.smartValleyFront();
        this.smartValleyBack();
        if (this.renderBase) {
            this.bottomQuad();
        }
    }

    protected void smartValleyLeft() {
        if (this.valleyOrSlopeAt(1, 0, 0)) {
            this.connectValleyLeft();
        } else {
            this.terminateValleyLeft();
        }
    }

    protected void terminateValleyLeft() {
        if (this.renderSecondary) {
            this.beginNegXSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.leftQuad();
        }
    }

    protected void smartValleyRight() {
        if (this.valleyOrSlopeAt(-1, 0, 0)) {
            this.connectValleyRight();
        } else {
            this.terminateValleyRight();
        }
    }

    protected void terminateValleyRight() {
        if (this.renderSecondary) {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.rightQuad();
        }
    }

    protected void smartValleyFront() {
        if (this.valleyOrSlopeAt(0, 0, -1)) {
            this.connectValleyFront();
        } else {
            this.terminateValleyFront();
        }
    }

    protected void terminateValleyFront() {
        if (this.renderSecondary) {
            this.beginPosZSlope();
            this.beginTriangle();
            this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.frontQuad();
        }
    }

    protected void smartValleyBack() {
        if (this.valleyOrSlopeAt(0, 0, 1)) {
            this.connectValleyBack();
        } else {
            this.terminateValleyBack();
        }
    }

    protected void terminateValleyBack() {
        if (this.renderSecondary) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
            this.endFace();
        }
        if (this.renderBase) {
            this.backQuad();
        }
    }

    protected void leftQuad() {
        this.beginPosXFace();
        this.beginQuad();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
    }

    protected void rightQuad() {
        this.beginNegXFace();
        this.beginQuad();
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void frontQuad() {
        this.beginNegZFace();
        this.beginQuad();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
    }

    protected void backQuad() {
        this.beginPosZFace();
        this.beginQuad();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void bottomQuad() {
        this.beginBottomFace();
        this.beginQuad();
        this.vertex(0.0, 0.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 0.0);
        this.endFace();
    }

    protected void leftTriangle() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void rightTriangle() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeLeftFace() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeRightFace() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeBackFace() {
        this.beginPosZFace();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeFrontFace() {
        this.beginNegZFace();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeFrontSlope() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.endFace();
    }

    protected void ridgeBackSlope() {
        this.beginPosZSlope();
        this.beginQuad();
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
    }

    protected void ridgeLeft() {
        if (this.ridgeOrSlopeAt(1, 0, 0)) {
            this.connectRidgeLeft();
        } else {
            this.beginPosXSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeLeft() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.endFace();
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
    }

    protected void ridgeRight() {
        if (this.ridgeOrSlopeAt(-1, 0, 0)) {
            this.connectRidgeRight();
        } else {
            this.beginNegXSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeRight() {
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
        this.endFace();
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.endFace();
    }

    protected void ridgeFront(boolean fill) {
        if (this.ridgeOrSlopeAt(0, 0, -1)) {
            this.connectRidgeFront();
        } else if (fill) {
            this.beginNegZSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
            this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeFront() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 1.0, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 0.0, 0.0, 0.5);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.endFace();
    }

    protected void ridgeBack(boolean fill) {
        if (this.ridgeOrSlopeAt(0, 0, 1)) {
            this.connectRidgeBack();
        } else if (fill) {
            this.beginPosZSlope();
            this.beginTriangle();
            this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
            this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
            this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
            this.endFace();
        }
    }

    protected void connectRidgeBack() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 1.0, 0.0, 0.5);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 1.0, 0.5);
        this.endFace();
    }

    protected void connectValleyLeft() {
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 0.5, 0.5, 1.0, 0.5);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.endFace();
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.5, 0.5, 0.0, 0.5);
        this.endFace();
        this.valleyEndLeft();
    }

    protected void connectValleyRight() {
        this.beginPosZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.5, 0.5, 0.0, 0.5);
        this.endFace();
        this.beginNegZSlope();
        this.beginTriangle();
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.0, 0.5, 0.5, 1.0, 0.5);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.endFace();
        this.valleyEndRight();
    }

    protected void connectValleyFront() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 0.0, 1.0, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.5, 0.5, 0.0, 0.0, 0.5);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
        this.valleyEndFront();
    }

    protected void connectValleyBack() {
        this.beginPosXSlope();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.5, 0.5, 1.0, 0.0, 0.5);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
        this.beginNegXSlope();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.5, 0.5, 0.5);
        this.vertex(0.5, 0.5, 1.0, 1.0, 0.5);
        this.endFace();
        this.valleyEndBack();
    }

    protected void valleyEndLeft() {
        this.beginPosXFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(1.0, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndRight() {
        this.beginNegXFace();
        this.beginTriangle();
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.0, 0.5, 0.5, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndFront() {
        this.beginNegZFace();
        this.beginTriangle();
        this.vertex(1.0, 1.0, 0.0, 0.0, 0.0);
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 0.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 0.0, 1.0, 1.0);
        this.vertex(0.0, 1.0, 0.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 0.0, 0.5, 0.5);
        this.endFace();
    }

    protected void valleyEndBack() {
        this.beginPosZFace();
        this.beginTriangle();
        this.vertex(0.0, 1.0, 1.0, 0.0, 0.0);
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(0.0, 0.0, 1.0, 0.0, 1.0);
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.newTriangle();
        this.vertex(1.0, 0.0, 1.0, 1.0, 1.0);
        this.vertex(1.0, 1.0, 1.0, 1.0, 0.0);
        this.vertex(0.5, 0.5, 1.0, 0.5, 0.5);
        this.endFace();
    }

    protected boolean ridgeAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, ridgeShapes);
    }

    protected boolean ridgeOrSlopeAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, ridgeOrSlopeShapes);
    }

    protected boolean valleyAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, valleyShapes);
    }

    protected boolean valleyOrSlopeAt(int dx, int dy, int dz) {
        return this.hasNeighbour(dx, dy, dz, valleyOrSlopeShapes);
    }

    protected boolean hasNeighbour(int dx, int dy, int dz, Shape[] shapes) {
        Vector3 v = this.t.v(dx, dy, dz);
        EnumFacing dir = v.facing();
        TileShape nte = this.te.getConnectedNeighbourGlobal(dir);
        if (nte != null) {
            for (int i = 0; i < shapes.length; ++i) {
                if (nte.shape != shapes[i]) continue;
                return true;
            }
        }
        return false;
    }

    protected void beginTopFace() {
        this.beginOuterFaces(Vector3.unitY);
    }

    protected void beginBottomFace() {
        this.beginOuterFaces(Vector3.unitNY);
    }

    protected void beginPosXFace() {
        this.beginOuterFaces(Vector3.unitX);
    }

    protected void beginNegXFace() {
        this.beginOuterFaces(Vector3.unitNX);
    }

    protected void beginPosZFace() {
        this.beginOuterFaces(Vector3.unitZ);
    }

    protected void beginNegZFace() {
        this.beginOuterFaces(Vector3.unitNZ);
    }

    protected void beginPosXSlope() {
        this.beginInnerFaces(Vector3.unitPXPY);
    }

    protected void beginNegXSlope() {
        this.beginInnerFaces(Vector3.unitNXPY);
    }

    protected void beginPosZSlope() {
        this.beginInnerFaces(Vector3.unitPYPZ);
    }

    protected void beginNegZSlope() {
        this.beginInnerFaces(Vector3.unitPYNZ);
    }

    protected void beginInnerFaces(Vector3 n) {
        this.outerFace = false;
        this.normal(n);
        this.target.setTexture(this.textures[2]);
    }

    protected void beginOuterFaces(Vector3 n) {
        this.outerFace = true;
        this.normal(n);
        this.target.setTexture(this.textures[1]);
    }

    protected void beginTriangle() {
        this.target.beginTriangle();
    }

    protected void beginQuad() {
        this.target.beginQuad();
    }

    protected void newTriangle() {
        this.endFace();
        this.beginTriangle();
    }

    protected void newQuad() {
        this.endFace();
        this.beginQuad();
    }

    protected void endFace() {
        this.target.endFace();
    }

    protected void normal(Vector3 n) {
        Vector3 tn = this.t.v(n);
        this.face = tn.facing();
        this.target.setNormal(tn);
    }

    protected void vertex(double x, double y, double z, double u, double v) {
        Vector3 q = this.t.p(x - 0.5, y - 0.5, z - 0.5);
        this.target.addVertex(q, u, v);
    }

    public void prepare(TileShape te, ITexture[] textures, Trans3 t, IRenderTarget target, boolean renderBase, boolean renderSecondary) {
        this.prepare(te, textures, t, target);
        this.renderBase = renderBase;
        this.renderSecondary = renderSecondary;
    }
}

