/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.widget.IWidget;
import com.cleanroommc.modularui.screen.ModularPanel;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.widget.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ParentWidget<W extends ParentWidget<W>>
extends Widget<W> {
    private final List<IWidget> children = new ArrayList<IWidget>();

    @Override
    @NotNull
    public List<IWidget> getChildren() {
        return this.children;
    }

    @Override
    public boolean canHover() {
        if (IDrawable.isVisible(this.getBackground()) || IDrawable.isVisible(this.getHoverBackground()) || IDrawable.isVisible(this.getHoverOverlay()) || this.getTooltip() != null) {
            return true;
        }
        WidgetTheme widgetTheme = this.getWidgetTheme(this.getContext().getTheme());
        if (this.getBackground() == null && IDrawable.isVisible(widgetTheme.getBackground())) {
            return true;
        }
        return this.getHoverBackground() == null && IDrawable.isVisible(widgetTheme.getHoverBackground());
    }

    public boolean addChild(IWidget child, int index) {
        if (child == null || child == this || this.getChildren().contains(child)) {
            return false;
        }
        if (child instanceof ModularPanel) {
            throw new IllegalStateException("ModularPanel should not be added as child widget; Use ModularScreen#openPanel instead");
        }
        if (index < 0) {
            index = this.getChildren().size() + index + 1;
        }
        this.children.add(index, child);
        if (this.isValid()) {
            child.initialise(this);
        }
        this.onChildAdd(child);
        return true;
    }

    public boolean remove(IWidget child) {
        if (this.children.remove(child)) {
            child.dispose();
            this.onChildRemove(child);
            return true;
        }
        return false;
    }

    public boolean remove(int index) {
        if (index < 0) {
            index = this.getChildren().size() + index + 1;
        }
        IWidget child = this.children.remove(index);
        child.dispose();
        this.onChildRemove(child);
        return true;
    }

    public void onChildAdd(IWidget child) {
    }

    public void onChildRemove(IWidget child) {
    }

    public W child(IWidget child) {
        if (!this.addChild(child, -1)) {
            throw new IllegalStateException("Failed to add child");
        }
        return (W)((ParentWidget)this.getThis());
    }

    public W childIf(boolean condition, IWidget child) {
        if (condition) {
            return this.child(child);
        }
        return (W)((ParentWidget)this.getThis());
    }

    public W childIf(BooleanSupplier condition, IWidget child) {
        if (condition.getAsBoolean()) {
            return this.child(child);
        }
        return (W)((ParentWidget)this.getThis());
    }

    public W childIf(boolean condition, Supplier<IWidget> child) {
        if (condition) {
            return this.child(child.get());
        }
        return (W)((ParentWidget)this.getThis());
    }

    public W childIf(BooleanSupplier condition, Supplier<IWidget> child) {
        if (condition.getAsBoolean()) {
            return this.child(child.get());
        }
        return (W)((ParentWidget)this.getThis());
    }
}

