/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.SortOrder;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.definitions.IParts;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.items.IAEWrench;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IAETagCompound;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.client.me.SlotME;
import appeng.container.slot.SlotFake;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.core.stats.Stats;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.GuiHostType;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.me.GridAccessException;
import appeng.me.GridNode;
import appeng.me.helpers.AENetworkProxy;
import appeng.util.BlockUpdate;
import appeng.util.LookDirection;
import appeng.util.item.AEItemStack;
import appeng.util.item.AESharedNBT;
import appeng.util.item.OreHelper;
import appeng.util.item.OreReference;
import appeng.util.prioitylist.IPartitionList;
import buildcraft.api.tools.IToolWrench;
import cofh.api.item.IToolHammer;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S21PacketChunkData;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class Platform {
    public static final Block AIR_BLOCK = Blocks.field_150350_a;
    public static final int DEF_OFFSET = 16;
    private static final Random RANDOM_GENERATOR = new Random();
    private static final WeakHashMap<World, WeakReference<EntityPlayer>> FAKE_PLAYERS = new WeakHashMap();
    private static Field tagList;
    private static Class playerInstance;
    private static Method getOrCreateChunkWatcher;
    private static Method sendToAllPlayersWatchingChunk;
    private static GameProfile fakeProfile;
    private static final String[] BYTE_UNIT;
    private static final double[] BYTE_LIMIT;
    private static final DecimalFormat df;
    private static IRecipe lastUsedRecipe;

    public static Random getRandom() {
        return RANDOM_GENERATOR;
    }

    public static float getRandomFloat() {
        return RANDOM_GENERATOR.nextFloat();
    }

    public static void seedFromGrid(Random rng, long worldSeed, long x, long z) {
        rng.setSeed(worldSeed);
        long xSeed = rng.nextLong() >> 3;
        long zSeed = rng.nextLong() >> 3;
        long gridSeed = xSeed * x + zSeed * z ^ worldSeed;
        rng.setSeed(gridSeed);
    }

    public static String formatPowerLong(long n, boolean isRate) {
        double p = (double)n / 100.0;
        PowerUnits displayUnits = AEConfig.instance.selectedPowerUnit();
        p = PowerUnits.AE.convertTo(displayUnits, p);
        String unitName = displayUnits.name();
        if (displayUnits == PowerUnits.WA) {
            unitName = "J";
        }
        if (displayUnits == PowerUnits.MK) {
            unitName = "J";
        }
        String[] preFixes = new String[]{"k", "M", "G", "T", "P", "T", "P", "E", "Z", "Y"};
        String level = "";
        for (int offset = 0; p > 1000.0 && offset < preFixes.length; p /= 1000.0, ++offset) {
            level = preFixes[offset];
        }
        DecimalFormat df = new DecimalFormat("#.##");
        return df.format(p) + ' ' + level + unitName + (isRate ? "/t" : "");
    }

    public static ForgeDirection crossProduct(ForgeDirection forward, ForgeDirection up) {
        ForgeDirection forgeDirection;
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        switch (west_x + west_y * 2 + west_z * 3) {
            case 1: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case -1: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 2: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case -2: {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case 3: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case -3: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        return forgeDirection;
    }

    public static <T extends Enum> T rotateEnum(T ce, boolean backwards, EnumSet validOptions) {
        while (!validOptions.contains(ce = backwards ? Platform.prevEnum(ce) : Platform.nextEnum(ce)) || Platform.isNotValidSetting(ce)) {
        }
        return ce;
    }

    private static <T extends Enum> T prevEnum(T ce) {
        EnumSet valList = EnumSet.allOf(ce.getClass());
        int pLoc = ce.ordinal() - 1;
        if (pLoc < 0) {
            pLoc = valList.size() - 1;
        }
        if (pLoc < 0 || pLoc >= valList.size()) {
            pLoc = 0;
        }
        int pos = 0;
        for (Object g : valList) {
            if (pos == pLoc) {
                return (T)((Enum)g);
            }
            ++pos;
        }
        return null;
    }

    public static <T extends Enum> T nextEnum(T ce) {
        EnumSet valList = EnumSet.allOf(ce.getClass());
        int pLoc = ce.ordinal() + 1;
        if (pLoc >= valList.size()) {
            pLoc = 0;
        }
        if (pLoc < 0 || pLoc >= valList.size()) {
            pLoc = 0;
        }
        int pos = 0;
        for (Object g : valList) {
            if (pos == pLoc) {
                return (T)((Enum)g);
            }
            ++pos;
        }
        return null;
    }

    private static boolean isNotValidSetting(Enum e) {
        if (e == SortOrder.INVTWEAKS && !IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.InvTweaks)) {
            return true;
        }
        if (e == SearchBoxMode.NEI_AUTOSEARCH && !IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI)) {
            return true;
        }
        return e == SearchBoxMode.NEI_MANUAL_SEARCH && !IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.NEI);
    }

    public static void openGUI(@Nonnull EntityPlayer p, @Nullable TileEntity tile, @Nullable ForgeDirection side, @Nonnull GuiBridge type) {
        if (Platform.isClient()) {
            return;
        }
        int x = (int)p.field_70165_t;
        int y = (int)p.field_70163_u;
        int z = (int)p.field_70161_v;
        if (tile != null) {
            x = tile.field_145851_c;
            y = tile.field_145848_d;
            z = tile.field_145849_e;
        }
        if (type.getType().isItem() && tile == null || type.hasPermissions(tile, x, y, z, side, p)) {
            if (tile == null && type.getType() == GuiHostType.ITEM) {
                p.openGui((Object)AppEng.instance(), type.ordinal() << 5 | 0x10, p.func_130014_f_(), p.field_71071_by.field_70461_c, 0, 0);
            } else if (tile == null || type.getType() == GuiHostType.ITEM) {
                p.openGui((Object)AppEng.instance(), type.ordinal() << 5 | 8, p.func_130014_f_(), x, y, z);
            } else {
                p.openGui((Object)AppEng.instance(), type.ordinal() << 5 | side.ordinal(), tile.func_145831_w(), x, y, z);
            }
        }
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public static boolean hasPermissions(DimensionalCoord dc, EntityPlayer player) {
        return dc.getWorld().func_72962_a(player, dc.x, dc.y, dc.z);
    }

    public static boolean isBlockAir(World w, int x, int y, int z) {
        try {
            return w.func_147439_a(x, y, z).isAir((IBlockAccess)w, x, y, z);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean sameStackStags(ItemStack a, ItemStack b) {
        NBTTagCompound tb;
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        NBTTagCompound ta = a.func_77978_p();
        if (ta == (tb = b.func_77978_p())) {
            return true;
        }
        if (ta == null && tb == null || ta != null && ta.func_82582_d() && tb == null || tb != null && tb.func_82582_d() && ta == null || ta != null && ta.func_82582_d() && tb != null && tb.func_82582_d()) {
            return true;
        }
        if (ta == null && tb != null || ta != null && tb == null) {
            return false;
        }
        if (AESharedNBT.isShared(ta) && AESharedNBT.isShared(tb)) {
            return ta == tb;
        }
        return Platform.NBTEqualityTest((NBTBase)ta, (NBTBase)tb);
    }

    public static boolean NBTEqualityTest(NBTBase left, NBTBase right) {
        byte id = left.func_74732_a();
        if (id == right.func_74732_a()) {
            switch (id) {
                case 10: {
                    NBTTagCompound ctA = (NBTTagCompound)left;
                    NBTTagCompound ctB = (NBTTagCompound)right;
                    Set cA = ctA.func_150296_c();
                    Set cB = ctB.func_150296_c();
                    if (cA.size() != cB.size()) {
                        return false;
                    }
                    for (String name : cA) {
                        NBTBase tag = ctA.func_74781_a(name);
                        NBTBase aTag = ctB.func_74781_a(name);
                        if (aTag == null) {
                            return false;
                        }
                        if (Platform.NBTEqualityTest(tag, aTag)) continue;
                        return false;
                    }
                    return true;
                }
                case 9: {
                    NBTTagList lA = (NBTTagList)left;
                    NBTTagList lB = (NBTTagList)right;
                    if (lA.func_74745_c() != lB.func_74745_c()) {
                        return false;
                    }
                    List<NBTBase> tag = Platform.tagList(lA);
                    List<NBTBase> aTag = Platform.tagList(lB);
                    if (tag.size() != aTag.size()) {
                        return false;
                    }
                    for (int x = 0; x < tag.size(); ++x) {
                        if (aTag.get(x) == null) {
                            return false;
                        }
                        if (Platform.NBTEqualityTest(tag.get(x), aTag.get(x))) continue;
                        return false;
                    }
                    return true;
                }
                case 1: {
                    return ((NBTBase.NBTPrimitive)left).func_150287_d() == ((NBTBase.NBTPrimitive)right).func_150287_d();
                }
                case 4: {
                    return ((NBTBase.NBTPrimitive)left).func_150291_c() == ((NBTBase.NBTPrimitive)right).func_150291_c();
                }
                case 8: {
                    return ((NBTTagString)left).func_150285_a_().equals(((NBTTagString)right).func_150285_a_()) || ((NBTTagString)left).func_150285_a_().equals(((NBTTagString)right).func_150285_a_());
                }
                case 6: {
                    return ((NBTBase.NBTPrimitive)left).func_150286_g() == ((NBTBase.NBTPrimitive)right).func_150286_g();
                }
                case 5: {
                    return ((NBTBase.NBTPrimitive)left).func_150288_h() == ((NBTBase.NBTPrimitive)right).func_150288_h();
                }
                case 3: {
                    return ((NBTBase.NBTPrimitive)left).func_150287_d() == ((NBTBase.NBTPrimitive)right).func_150287_d();
                }
            }
            return left.equals((Object)right);
        }
        return false;
    }

    private static List<NBTBase> tagList(NBTTagList lB) {
        if (tagList == null) {
            try {
                tagList = lB.getClass().getDeclaredField("tagList");
            }
            catch (Throwable t) {
                try {
                    tagList = lB.getClass().getDeclaredField("field_74747_a");
                }
                catch (Throwable z) {
                    AELog.debug(t);
                    AELog.debug(z);
                }
            }
        }
        try {
            tagList.setAccessible(true);
            return (List)tagList.get(lB);
        }
        catch (Throwable t) {
            AELog.debug(t);
            return new ArrayList<NBTBase>();
        }
    }

    public static int NBTOrderlessHash(NBTBase nbt) {
        int hash = 0;
        byte id = nbt.func_74732_a();
        hash += id;
        switch (id) {
            case 10: {
                NBTTagCompound ctA = (NBTTagCompound)nbt;
                Set cA = ctA.func_150296_c();
                for (String name : cA) {
                    hash += name.hashCode() ^ Platform.NBTOrderlessHash(ctA.func_74781_a(name));
                }
                return hash;
            }
            case 9: {
                NBTTagList lA = (NBTTagList)nbt;
                hash += 9 * lA.func_74745_c();
                List<NBTBase> l = Platform.tagList(lA);
                for (int x = 0; x < l.size(); ++x) {
                    hash += Integer.valueOf(x).hashCode() ^ Platform.NBTOrderlessHash(l.get(x));
                }
                return hash;
            }
            case 1: {
                return hash + ((NBTBase.NBTPrimitive)nbt).func_150290_f();
            }
            case 4: {
                return hash + (int)((NBTBase.NBTPrimitive)nbt).func_150291_c();
            }
            case 8: {
                return hash + ((NBTTagString)nbt).func_150285_a_().hashCode();
            }
            case 6: {
                return hash + (int)((NBTBase.NBTPrimitive)nbt).func_150286_g();
            }
            case 5: {
                return hash + (int)((NBTBase.NBTPrimitive)nbt).func_150288_h();
            }
            case 3: {
                return hash + ((NBTBase.NBTPrimitive)nbt).func_150287_d();
            }
        }
        return hash;
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting inventoryCrafting, World par2World) {
        if (lastUsedRecipe != null && lastUsedRecipe.func_77569_a(inventoryCrafting, par2World)) {
            return lastUsedRecipe;
        }
        CraftingManager cm = CraftingManager.func_77594_a();
        List rl = cm.func_77592_b();
        for (IRecipe r : rl) {
            if (!r.func_77569_a(inventoryCrafting, par2World)) continue;
            lastUsedRecipe = r;
            return r;
        }
        return null;
    }

    public static ItemStack[] getBlockDrops(World w, int x, int y, int z) {
        ArrayList out = new ArrayList();
        Block which = w.func_147439_a(x, y, z);
        if (which != null) {
            out = which.getDrops(w, x, y, z, w.func_72805_g(x, y, z), 0);
        }
        if (out == null) {
            return new ItemStack[0];
        }
        return out.toArray(new ItemStack[0]);
    }

    public static ForgeDirection cycleOrientations(ForgeDirection dir, boolean upAndDown) {
        ForgeDirection forgeDirection;
        if (upAndDown) {
            ForgeDirection forgeDirection2;
            switch (dir) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NORTH: {
                    forgeDirection2 = ForgeDirection.SOUTH;
                    break;
                }
                case SOUTH: {
                    forgeDirection2 = ForgeDirection.EAST;
                    break;
                }
                case EAST: {
                    forgeDirection2 = ForgeDirection.WEST;
                    break;
                }
                case WEST: {
                    forgeDirection2 = ForgeDirection.NORTH;
                    break;
                }
                case UP: {
                    forgeDirection2 = ForgeDirection.UP;
                    break;
                }
                case DOWN: {
                    forgeDirection2 = ForgeDirection.DOWN;
                    break;
                }
                case UNKNOWN: {
                    forgeDirection2 = ForgeDirection.UNKNOWN;
                }
            }
            return forgeDirection2;
        }
        switch (dir) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case UP: {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case DOWN: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case NORTH: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case SOUTH: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case EAST: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case WEST: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case UNKNOWN: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        return forgeDirection;
    }

    public static NBTTagCompound openNbtData(ItemStack i) {
        NBTTagCompound compound = i.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            i.func_77982_d(compound);
        }
        return compound;
    }

    public static void spawnDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (Platform.isServer()) {
            for (ItemStack i : drops) {
                if (i == null || i.field_77994_a <= 0) continue;
                double offset_x = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_y = (Platform.getRandomInt() % 32 - 16) / 82;
                double offset_z = (Platform.getRandomInt() % 32 - 16) / 82;
                EntityItem ei = new EntityItem(w, 0.5 + offset_x + (double)x, 0.5 + offset_y + (double)y, 0.2 + offset_z + (double)z, i.func_77946_l());
                w.func_72838_d((Entity)ei);
            }
        }
    }

    public static boolean isServer() {
        return FMLCommonHandler.instance().getEffectiveSide().isServer();
    }

    public static int getRandomInt() {
        return Math.abs(RANDOM_GENERATOR.nextInt());
    }

    public static IInventory GetChestInv(Object te) {
        TileEntityChest x;
        TileEntityChest teA = (TileEntityChest)te;
        TileEntity teB = null;
        Block myBlockID = teA.func_145831_w().func_147439_a(teA.field_145851_c, teA.field_145848_d, teA.field_145849_e);
        if (teA.func_145831_w().func_147439_a(teA.field_145851_c + 1, teA.field_145848_d, teA.field_145849_e) == myBlockID && !((teB = teA.func_145831_w().func_147438_o(teA.field_145851_c + 1, teA.field_145848_d, teA.field_145849_e)) instanceof TileEntityChest)) {
            teB = null;
        }
        if (teB == null && teA.func_145831_w().func_147439_a(teA.field_145851_c - 1, teA.field_145848_d, teA.field_145849_e) == myBlockID) {
            teB = teA.func_145831_w().func_147438_o(teA.field_145851_c - 1, teA.field_145848_d, teA.field_145849_e);
            if (!(teB instanceof TileEntityChest)) {
                teB = null;
            } else {
                x = teA;
                teA = (TileEntityChest)teB;
                teB = x;
            }
        }
        if (teB == null && teA.func_145831_w().func_147439_a(teA.field_145851_c, teA.field_145848_d, teA.field_145849_e + 1) == myBlockID && !((teB = teA.func_145831_w().func_147438_o(teA.field_145851_c, teA.field_145848_d, teA.field_145849_e + 1)) instanceof TileEntityChest)) {
            teB = null;
        }
        if (teB == null && teA.func_145831_w().func_147439_a(teA.field_145851_c, teA.field_145848_d, teA.field_145849_e - 1) == myBlockID) {
            teB = teA.func_145831_w().func_147438_o(teA.field_145851_c, teA.field_145848_d, teA.field_145849_e - 1);
            if (!(teB instanceof TileEntityChest)) {
                teB = null;
            } else {
                x = teA;
                teA = (TileEntityChest)teB;
                teB = x;
            }
        }
        if (teB == null) {
            return teA;
        }
        return new InventoryLargeChest("", (IInventory)teA, (IInventory)teB);
    }

    public static boolean isModLoaded(String modid) {
        try {
            return Loader.isModLoaded((String)modid);
        }
        catch (Throwable throwable) {
            for (ModContainer f : Loader.instance().getActiveModList()) {
                if (!f.getModId().equals(modid)) continue;
                return true;
            }
            return false;
        }
    }

    public static ItemStack findMatchingRecipeOutput(InventoryCrafting ic, World worldObj) {
        return CraftingManager.func_77594_a().func_82787_a(ic, worldObj);
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getTooltip(Object o) {
        if (o == null) {
            return new ArrayList<String>();
        }
        ItemStack itemStack = null;
        if (o instanceof AEItemStack) {
            AEItemStack ais = (AEItemStack)o;
            return ais.getToolTip();
        }
        if (!(o instanceof ItemStack)) {
            return new ArrayList<String>();
        }
        itemStack = (ItemStack)o;
        try {
            return itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, false);
        }
        catch (Exception errB) {
            return new ArrayList<String>();
        }
    }

    public static String getModId(IAEItemStack is) {
        if (is == null) {
            return "** Null";
        }
        String n = ((AEItemStack)is).getModID();
        return n == null ? "** Null" : n;
    }

    public static String getItemDisplayName(Object o) {
        if (o == null) {
            return "** Null";
        }
        ItemStack itemStack = null;
        if (o instanceof AEItemStack) {
            String n = ((AEItemStack)o).getDisplayName();
            return n == null ? "** Null" : n;
        }
        if (!(o instanceof ItemStack)) {
            return "**Invalid Object";
        }
        itemStack = (ItemStack)o;
        try {
            String name = itemStack.func_82833_r();
            if (name == null || name.isEmpty()) {
                name = itemStack.func_77973_b().func_77667_c(itemStack);
            }
            return name == null ? "** Null" : name;
        }
        catch (Exception errA) {
            try {
                String n = itemStack.func_77977_a();
                return n == null ? "** Null" : n;
            }
            catch (Exception errB) {
                return "** Exception";
            }
        }
    }

    public static boolean hasSpecialComparison(IAEItemStack willAdd) {
        if (willAdd == null) {
            return false;
        }
        IAETagCompound tag = willAdd.getTagCompound();
        return tag != null && tag.getSpecialComparison() != null;
    }

    public static boolean hasSpecialComparison(ItemStack willAdd) {
        return AESharedNBT.isShared(willAdd.func_77978_p()) && ((IAETagCompound)willAdd.func_77978_p()).getSpecialComparison() != null;
    }

    public static boolean isWrench(EntityPlayer player, ItemStack stack, int x, int y, int z) {
        if (stack != null) {
            Item itemWrench = stack.func_77973_b();
            if (itemWrench instanceof IAEWrench) {
                IAEWrench wrench = (IAEWrench)itemWrench;
                return wrench.canWrench(stack, player, x, y, z);
            }
            if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.CoFHWrench) && itemWrench instanceof IToolHammer) {
                IToolHammer wrench = (IToolHammer)itemWrench;
                return wrench.isUsable(stack, (EntityLivingBase)player, x, y, z);
            }
            if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.BuildCraftCore) && itemWrench instanceof IToolWrench) {
                IToolWrench wrench = (IToolWrench)itemWrench;
                return wrench.canWrench(player, x, y, z);
            }
        }
        return false;
    }

    public static boolean isChargeable(ItemStack i) {
        if (i == null) {
            return false;
        }
        Item it = i.func_77973_b();
        if (it instanceof IAEItemPowerStorage) {
            return ((IAEItemPowerStorage)it).getPowerFlow(i) != AccessRestriction.READ;
        }
        return false;
    }

    public static EntityPlayer getPlayer(WorldServer w) {
        EntityPlayer fakePlayer;
        if (w == null) {
            throw new InvalidParameterException("World is null.");
        }
        WeakReference<EntityPlayer> weakRef = FAKE_PLAYERS.get(w);
        if (weakRef != null && (fakePlayer = (EntityPlayer)weakRef.get()) != null) {
            return fakePlayer;
        }
        FakePlayer p = FakePlayerFactory.get((WorldServer)w, (GameProfile)fakeProfile);
        FAKE_PLAYERS.put((World)w, new WeakReference<FakePlayer>(p));
        return p;
    }

    public static int MC2MEColor(int color) {
        switch (color) {
            case 4: {
                return 0;
            }
            case 0: {
                return 1;
            }
            case 15: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 2: {
                return 6;
            }
        }
        return -1;
    }

    public static int findEmpty(Object[] l) {
        for (int x = 0; x < l.length; ++x) {
            if (l[x] != null) continue;
            return x;
        }
        return -1;
    }

    public static <T> T pickRandom(Collection<T> outs) {
        int index;
        Iterator<T> i = outs.iterator();
        for (index = RANDOM_GENERATOR.nextInt(outs.size()); i.hasNext() && index > 0; --index) {
            i.next();
        }
        --index;
        if (i.hasNext()) {
            return i.next();
        }
        return null;
    }

    public static ForgeDirection rotateAround(ForgeDirection forward, ForgeDirection axis) {
        if (axis == ForgeDirection.UNKNOWN || forward == ForgeDirection.UNKNOWN) {
            return forward;
        }
        switch (forward) {
            case DOWN: {
                switch (axis) {
                    case DOWN: {
                        return forward;
                    }
                    case UP: {
                        return forward;
                    }
                    case NORTH: {
                        return ForgeDirection.EAST;
                    }
                    case SOUTH: {
                        return ForgeDirection.WEST;
                    }
                    case EAST: {
                        return ForgeDirection.NORTH;
                    }
                    case WEST: {
                        return ForgeDirection.SOUTH;
                    }
                }
                break;
            }
            case UP: {
                switch (axis) {
                    case NORTH: {
                        return ForgeDirection.WEST;
                    }
                    case SOUTH: {
                        return ForgeDirection.EAST;
                    }
                    case EAST: {
                        return ForgeDirection.SOUTH;
                    }
                    case WEST: {
                        return ForgeDirection.NORTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (axis) {
                    case UP: {
                        return ForgeDirection.WEST;
                    }
                    case DOWN: {
                        return ForgeDirection.EAST;
                    }
                    case EAST: {
                        return ForgeDirection.UP;
                    }
                    case WEST: {
                        return ForgeDirection.DOWN;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (axis) {
                    case UP: {
                        return ForgeDirection.EAST;
                    }
                    case DOWN: {
                        return ForgeDirection.WEST;
                    }
                    case EAST: {
                        return ForgeDirection.DOWN;
                    }
                    case WEST: {
                        return ForgeDirection.UP;
                    }
                }
                break;
            }
            case EAST: {
                switch (axis) {
                    case UP: {
                        return ForgeDirection.NORTH;
                    }
                    case DOWN: {
                        return ForgeDirection.SOUTH;
                    }
                    case NORTH: {
                        return ForgeDirection.UP;
                    }
                    case SOUTH: {
                        return ForgeDirection.DOWN;
                    }
                }
            }
            case WEST: {
                switch (axis) {
                    case UP: {
                        return ForgeDirection.SOUTH;
                    }
                    case DOWN: {
                        return ForgeDirection.NORTH;
                    }
                    case NORTH: {
                        return ForgeDirection.DOWN;
                    }
                    case SOUTH: {
                        return ForgeDirection.UP;
                    }
                }
            }
        }
        return forward;
    }

    @SideOnly(value=Side.CLIENT)
    public static String gui_localize(String string) {
        return StatCollector.func_74838_a((String)string);
    }

    public static boolean isSameItemPrecise(@Nullable ItemStack is, @Nullable ItemStack filter) {
        return Platform.isSameItem(is, filter) && Platform.sameStackStags(is, filter);
    }

    public static boolean isSameItemFuzzy(ItemStack a, ItemStack b, FuzzyMode mode) {
        OreReference bOR;
        if (a == null && b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (a.func_77973_b() != null && b.func_77973_b() != null && a.func_77973_b().func_77645_m() && a.func_77973_b() == b.func_77973_b()) {
            try {
                if (mode == FuzzyMode.IGNORE_ALL) {
                    return true;
                }
                if (mode == FuzzyMode.PERCENT_99) {
                    return a.func_77952_i() > 1 == b.func_77952_i() > 1;
                }
                float percentDamagedOfA = 1.0f - (float)a.func_77952_i() / (float)a.func_77958_k();
                float percentDamagedOfB = 1.0f - (float)b.func_77952_i() / (float)b.func_77958_k();
                return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
            }
            catch (Throwable e) {
                if (mode == FuzzyMode.IGNORE_ALL) {
                    return true;
                }
                if (mode == FuzzyMode.PERCENT_99) {
                    return a.func_77960_j() > 1 == b.func_77960_j() > 1;
                }
                float percentDamagedOfA = (float)a.func_77960_j() / (float)a.func_77958_k();
                float percentDamagedOfB = (float)b.func_77960_j() / (float)b.func_77958_k();
                return percentDamagedOfA > mode.breakPoint == percentDamagedOfB > mode.breakPoint;
            }
        }
        OreReference aOR = OreHelper.INSTANCE.isOre(a);
        if (OreHelper.INSTANCE.sameOre(aOR, bOR = OreHelper.INSTANCE.isOre(b))) {
            return true;
        }
        return a.func_77969_a(b);
    }

    public static LookDirection getPlayerRay(EntityPlayer player, float eyeOffset) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * 1.0f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * 1.0f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * 1.0;
        double d1 = eyeOffset;
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * 1.0;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 5.0;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return new LookDirection(vec3, vec31);
    }

    public static MovingObjectPosition rayTrace(EntityPlayer p, boolean hitBlocks, boolean hitEntities) {
        World w = p.func_130014_f_();
        float f = 1.0f;
        float f1 = p.field_70127_C + (p.field_70125_A - p.field_70127_C) * 1.0f;
        float f2 = p.field_70126_B + (p.field_70177_z - p.field_70126_B) * 1.0f;
        double d0 = p.field_70169_q + (p.field_70165_t - p.field_70169_q) * 1.0;
        double d1 = p.field_70167_r + (p.field_70163_u - p.field_70167_r) * 1.0 + 1.62 - (double)p.field_70129_M;
        double d2 = p.field_70166_s + (p.field_70161_v - p.field_70166_s) * 1.0;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = 32.0;
        Vec3 vec31 = vec3.func_72441_c((double)f7 * 32.0, (double)f6 * 32.0, (double)f8 * 32.0);
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)Math.min(vec3.field_72450_a, vec31.field_72450_a), (double)Math.min(vec3.field_72448_b, vec31.field_72448_b), (double)Math.min(vec3.field_72449_c, vec31.field_72449_c), (double)Math.max(vec3.field_72450_a, vec31.field_72450_a), (double)Math.max(vec3.field_72448_b, vec31.field_72448_b), (double)Math.max(vec3.field_72449_c, vec31.field_72449_c)).func_72314_b(16.0, 16.0, 16.0);
        Entity entity = null;
        double closest = 9999999.0;
        if (hitEntities) {
            List list = w.func_72839_b((Entity)p, bb);
            for (Object o : list) {
                double nd;
                AxisAlignedBB boundingBox;
                MovingObjectPosition movingObjectPosition;
                Entity entity1 = (Entity)o;
                if (entity1.field_70128_L || entity1 == p || entity1 instanceof EntityItem || !entity1.func_70089_S() || entity1.field_70153_n == p || (movingObjectPosition = (boundingBox = entity1.field_70121_D.func_72314_b((double)(f1 = 0.3f), (double)f1, (double)f1)).func_72327_a(vec3, vec31)) == null || !((nd = vec3.func_72436_e(movingObjectPosition.field_72307_f)) < closest)) continue;
                entity = entity1;
                closest = nd;
            }
        }
        MovingObjectPosition pos = null;
        Vec3 vec = null;
        if (hitBlocks) {
            vec = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
            pos = w.func_72901_a(vec3, vec31, true);
        }
        if (entity != null && pos != null && pos.field_72307_f.func_72436_e(vec) > closest) {
            pos = new MovingObjectPosition(entity);
        } else if (entity != null && pos == null) {
            pos = new MovingObjectPosition(entity);
        }
        return pos;
    }

    public static long nanoTime() {
        return 0L;
    }

    public static <StackType extends IAEStack> StackType poweredExtraction(IEnergySource energy, IMEInventory<StackType> cell, StackType request, BaseActionSource src) {
        double availablePower;
        long itemToExtract;
        StackType possible = cell.extractItems(request.copy(), Actionable.SIMULATE, src);
        long retrieved = 0L;
        if (possible != null) {
            retrieved = possible.getStackSize();
        }
        if ((itemToExtract = Math.min((long)((availablePower = energy.extractAEPower(retrieved, Actionable.SIMULATE, PowerMultiplier.CONFIG)) + 0.9), retrieved)) > 0L) {
            energy.extractAEPower(retrieved, Actionable.MODULATE, PowerMultiplier.CONFIG);
            possible.setStackSize(itemToExtract);
            StackType ret = cell.extractItems(possible, Actionable.MODULATE, src);
            if (ret != null && src.isPlayer()) {
                Stats.ItemsExtracted.addToPlayer(((PlayerSource)src).player, (int)ret.getStackSize());
            }
            return ret;
        }
        return null;
    }

    public static <StackType extends IAEStack> StackType poweredInsert(IEnergySource energy, IMEInventory<StackType> cell, StackType input, BaseActionSource src) {
        long typeMultiplier;
        double availablePower;
        long itemToAdd;
        StackType possible = cell.injectItems(input.copy(), Actionable.SIMULATE, src);
        long stored = input.getStackSize();
        if (possible != null) {
            stored -= possible.getStackSize();
        }
        if ((itemToAdd = Math.min((long)((availablePower = energy.extractAEPower(Platform.ceilDiv(stored, typeMultiplier = input instanceof IAEFluidStack ? 1000L : 1L), Actionable.SIMULATE, PowerMultiplier.CONFIG)) * (double)typeMultiplier + 0.9), stored)) > 0L) {
            energy.extractAEPower(Platform.ceilDiv(stored, typeMultiplier), Actionable.MODULATE, PowerMultiplier.CONFIG);
            if (itemToAdd < input.getStackSize()) {
                long original = input.getStackSize();
                StackType split = input.copy();
                split.decStackSize(itemToAdd);
                input.setStackSize(itemToAdd);
                split.add(cell.injectItems(input, Actionable.MODULATE, src));
                if (src.isPlayer()) {
                    long diff = original - split.getStackSize();
                    Stats.ItemsInserted.addToPlayer(((PlayerSource)src).player, (int)diff);
                }
                return split;
            }
            StackType ret = cell.injectItems(input, Actionable.MODULATE, src);
            if (src.isPlayer()) {
                long diff = ret == null ? input.getStackSize() : input.getStackSize() - ret.getStackSize();
                Stats.ItemsInserted.addToPlayer(((PlayerSource)src).player, (int)diff);
            }
            return ret;
        }
        return input;
    }

    public static void postChanges(IStorageGrid gs, ItemStack removed, ItemStack added, BaseActionSource src) {
        IItemList<IAEItemStack> itemChanges = AEApi.instance().storage().createItemList();
        IItemList<IAEFluidStack> fluidChanges = AEApi.instance().storage().createFluidList();
        IMEInventoryHandler myItems = null;
        IMEInventoryHandler myFluids = null;
        if (removed != null) {
            myItems = AEApi.instance().registries().cell().getCellInventory(removed, null, StorageChannel.ITEMS);
            if (myItems != null) {
                for (IAEItemStack iAEItemStack : myItems.getAvailableItems(itemChanges)) {
                    iAEItemStack.setStackSize(-iAEItemStack.getStackSize());
                }
            }
            if ((myFluids = AEApi.instance().registries().cell().getCellInventory(removed, null, StorageChannel.FLUIDS)) != null) {
                for (IAEFluidStack iAEFluidStack : myFluids.getAvailableItems(fluidChanges)) {
                    iAEFluidStack.setStackSize(-iAEFluidStack.getStackSize());
                }
            }
        }
        if (added != null) {
            myItems = AEApi.instance().registries().cell().getCellInventory(added, null, StorageChannel.ITEMS);
            if (myItems != null) {
                myItems.getAvailableItems(itemChanges);
            }
            if ((myFluids = AEApi.instance().registries().cell().getCellInventory(added, null, StorageChannel.FLUIDS)) != null) {
                myFluids.getAvailableItems(fluidChanges);
            }
        }
        if (myItems == null) {
            gs.postAlterationOfStoredItems(StorageChannel.FLUIDS, fluidChanges, src);
        } else {
            gs.postAlterationOfStoredItems(StorageChannel.ITEMS, itemChanges, src);
        }
    }

    public static <T extends IAEStack<T>> void postListChanges(IItemList<T> before, IItemList<T> after, IMEMonitorHandlerReceiver<T> meMonitorPassthrough, BaseActionSource source) {
        LinkedList<IAEStack> changes = new LinkedList<IAEStack>();
        for (IAEStack is : before) {
            is.setStackSize(-is.getStackSize());
        }
        for (IAEStack is : after) {
            before.add(is);
        }
        for (IAEStack is : before) {
            if (is.getStackSize() == 0L) continue;
            changes.add(is);
        }
        if (!changes.isEmpty()) {
            meMonitorPassthrough.postChange(null, changes, source);
        }
    }

    public static int generateTileHash(TileEntity target) {
        int hash;
        block9: {
            block7: {
                TileEntityChest chest;
                block11: {
                    block10: {
                        block8: {
                            if (target == null) {
                                return 0;
                            }
                            hash = target.hashCode();
                            if (target instanceof ITileStorageMonitorable) {
                                return 0;
                            }
                            if (!(target instanceof TileEntityChest)) break block7;
                            chest = (TileEntityChest)target;
                            chest.func_145979_i();
                            if (chest.field_145992_i == null) break block8;
                            hash ^= chest.field_145992_i.hashCode();
                            break block9;
                        }
                        if (chest.field_145988_l == null) break block10;
                        hash ^= chest.field_145988_l.hashCode();
                        break block9;
                    }
                    if (chest.field_145990_j == null) break block11;
                    hash ^= chest.field_145990_j.hashCode();
                    break block9;
                }
                if (chest.field_145991_k == null) break block9;
                hash ^= chest.field_145991_k.hashCode();
                break block9;
            }
            if (target instanceof IInventory) {
                hash ^= ((IInventory)target).func_70302_i_();
                if (target instanceof ISidedInventory) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        int[] sides = ((ISidedInventory)target).func_94128_d(dir.ordinal());
                        if (sides == null) {
                            return 0;
                        }
                        int offset = 0;
                        for (int side : sides) {
                            int c = side << offset % 8 ^ 1 << dir.ordinal();
                            ++offset;
                            hash = c + (hash << 6) + (hash << 16) - hash;
                        }
                    }
                }
            }
        }
        return hash;
    }

    public static boolean securityCheck(GridNode a, GridNode b) {
        boolean b_isSecure;
        if (a.getLastSecurityKey() == -1L && b.getLastSecurityKey() == -1L) {
            return false;
        }
        if (a.getLastSecurityKey() == b.getLastSecurityKey()) {
            return false;
        }
        boolean a_isSecure = Platform.isPowered(a.getGrid()) && a.getLastSecurityKey() != -1L;
        boolean bl = b_isSecure = Platform.isPowered(b.getGrid()) && b.getLastSecurityKey() != -1L;
        if (AEConfig.instance.isFeatureEnabled(AEFeature.LogSecurityAudits)) {
            AELog.info("Audit: " + a_isSecure + " : " + b_isSecure + " @ " + a.getLastSecurityKey() + " vs " + b.getLastSecurityKey() + " & " + a.getPlayerID() + " vs " + b.getPlayerID(), new Object[0]);
        }
        if (a_isSecure && b_isSecure) {
            return true;
        }
        if (!a_isSecure && b_isSecure) {
            return Platform.checkPlayerPermissions(b.getGrid(), a.getPlayerID());
        }
        if (a_isSecure && !b_isSecure) {
            return Platform.checkPlayerPermissions(a.getGrid(), b.getPlayerID());
        }
        return false;
    }

    private static boolean isPowered(IGrid grid) {
        if (grid == null) {
            return false;
        }
        IEnergyGrid eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
        return eg.isNetworkPowered();
    }

    private static boolean checkPlayerPermissions(IGrid grid, int playerID) {
        if (grid == null) {
            return false;
        }
        ISecurityGrid gs = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        if (gs == null) {
            return false;
        }
        if (!gs.isAvailable()) {
            return false;
        }
        return !gs.hasPermission(playerID, SecurityPermissions.BUILD);
    }

    public static void configurePlayer(EntityPlayer player, ForgeDirection side, TileEntity tile) {
        player.field_70129_M = 1.8f;
        float yaw = 0.0f;
        float pitch = 0.0f;
        switch (side) {
            case DOWN: {
                pitch = 90.0f;
                player.field_70129_M = -1.8f;
                break;
            }
            case EAST: {
                yaw = -90.0f;
                break;
            }
            case NORTH: {
                yaw = 180.0f;
                break;
            }
            case SOUTH: {
                yaw = 0.0f;
                break;
            }
            case UNKNOWN: {
                break;
            }
            case UP: {
                pitch = 90.0f;
                break;
            }
            case WEST: {
                yaw = 90.0f;
            }
        }
        player.field_70165_t = (double)tile.field_145851_c + 0.5;
        player.field_70163_u = (double)tile.field_145848_d + 0.5;
        player.field_70161_v = (double)tile.field_145849_e + 0.5;
        player.field_70727_aS = player.field_70726_aT = pitch;
        player.field_70125_A = player.field_70726_aT;
        player.field_71107_bF = player.field_71109_bG = yaw;
        player.field_70177_z = player.field_71109_bG;
    }

    public static boolean canAccess(AENetworkProxy gridProxy, BaseActionSource src) {
        try {
            if (src.isPlayer()) {
                return gridProxy.getSecurity().hasPermission(((PlayerSource)src).player, SecurityPermissions.BUILD);
            }
            if (src.isMachine()) {
                IActionHost te = ((MachineSource)src).via;
                IGridNode n = te.getActionableNode();
                if (n == null) {
                    return false;
                }
                int playerID = n.getPlayerID();
                return gridProxy.getSecurity().hasPermission(playerID, SecurityPermissions.BUILD);
            }
            return false;
        }
        catch (GridAccessException gae) {
            return false;
        }
    }

    public static ItemStack extractItemsByRecipe(IEnergySource energySrc, BaseActionSource mySrc, IMEMonitor<IAEItemStack> src, World w, IRecipe r, ItemStack output, InventoryCrafting ci, ItemStack providedTemplate, int slot, IItemList<IAEItemStack> items, Actionable realForFake, IPartitionList<IAEItemStack> filter) {
        return Platform.extractItemsByRecipe(energySrc, mySrc, src, w, r, output, ci, providedTemplate, slot, items, realForFake, filter, 1);
    }

    public static ItemStack extractItemsByRecipe(IEnergySource energySrc, BaseActionSource mySrc, IMEMonitor<IAEItemStack> src, World w, IRecipe r, ItemStack output, InventoryCrafting ci, ItemStack providedTemplate, int slot, IItemList<IAEItemStack> items, Actionable realForFake, IPartitionList<IAEItemStack> filter, int multiple) {
        if (energySrc.extractAEPower(multiple, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.9) {
            boolean checkFuzzy;
            ItemStack extracted;
            IAEItemStack ae_ext;
            if (providedTemplate == null) {
                return null;
            }
            AEItemStack ae_req = AEItemStack.create(providedTemplate);
            ae_req.setStackSize(multiple);
            if ((filter == null || filter.isListed(ae_req)) && (ae_ext = (IAEItemStack)src.extractItems(ae_req, realForFake, mySrc)) != null && (extracted = ae_ext.getItemStack()) != null) {
                energySrc.extractAEPower(multiple, realForFake, PowerMultiplier.CONFIG);
                return extracted;
            }
            boolean bl = checkFuzzy = ae_req.isOre() || providedTemplate.func_77960_j() == Short.MAX_VALUE || providedTemplate.func_77942_o() || providedTemplate.func_77984_f();
            if (items != null && checkFuzzy) {
                for (IAEItemStack x : items) {
                    ItemStack sh = x.getItemStack();
                    if (!Platform.isSameItemType(providedTemplate, sh) && !ae_req.sameOre(x) || Platform.isSameItem(sh, output)) continue;
                    ItemStack cp = Platform.cloneItemStack(sh);
                    cp.field_77994_a = 1;
                    ci.func_70299_a(slot, cp);
                    if (r.func_77569_a(ci, w) && Platform.isSameItem(r.func_77572_b(ci), output)) {
                        IAEItemStack ex;
                        IAEItemStack ax = x.copy();
                        ax.setStackSize(multiple);
                        if ((filter == null || filter.isListed(ax)) && (ex = src.extractItems(ax, realForFake, mySrc)) != null) {
                            energySrc.extractAEPower(multiple, realForFake, PowerMultiplier.CONFIG);
                            return ex.getItemStack();
                        }
                    }
                    ci.func_70299_a(slot, providedTemplate);
                }
            }
        }
        return null;
    }

    public static boolean isSameItemType(ItemStack that, ItemStack other) {
        if (that != null && other != null && that.func_77973_b() == other.func_77973_b()) {
            if (that.func_77984_f()) {
                return true;
            }
            return that.func_77960_j() == other.func_77960_j();
        }
        return false;
    }

    public static boolean isSameItem(@Nullable ItemStack left, @Nullable ItemStack right) {
        return left != null && right != null && left.func_77969_a(right);
    }

    public static ItemStack cloneItemStack(ItemStack a) {
        return a.func_77946_l();
    }

    public static ItemStack getContainerItem(ItemStack stackInSlot) {
        if (stackInSlot == null) {
            return null;
        }
        Item i = stackInSlot.func_77973_b();
        if (i == null || !i.hasContainerItem(stackInSlot)) {
            if (stackInSlot.field_77994_a > 1) {
                --stackInSlot.field_77994_a;
                return stackInSlot;
            }
            return null;
        }
        ItemStack ci = i.getContainerItem(stackInSlot.func_77946_l());
        if (ci != null && ci.func_77984_f() && ci.func_77960_j() > ci.func_77958_k()) {
            ci = null;
        }
        return ci;
    }

    public static void notifyBlocksOfNeighbors(World worldObj, int xCoord, int yCoord, int zCoord) {
        if (!worldObj.field_72995_K) {
            TickHandler.INSTANCE.addCallable(worldObj, new BlockUpdate(xCoord, yCoord, zCoord));
        }
    }

    public static boolean canRepair(AEFeature type, ItemStack a, ItemStack b) {
        if (b == null || a == null) {
            return false;
        }
        if (type == AEFeature.CertusQuartzTools) {
            IItemDefinition certusQuartzCrystal = AEApi.instance().definitions().materials().certusQuartzCrystal();
            return certusQuartzCrystal.isSameAs(b);
        }
        if (type == AEFeature.NetherQuartzTools) {
            return Items.field_151128_bU == b.func_77973_b();
        }
        return false;
    }

    public static Object findPreferred(ItemStack[] is) {
        IParts parts = AEApi.instance().definitions().parts();
        for (ItemStack stack : is) {
            if (parts.cableGlass().sameAs(AEColor.Transparent, stack)) {
                return stack;
            }
            if (parts.cableCovered().sameAs(AEColor.Transparent, stack)) {
                return stack;
            }
            if (parts.cableSmart().sameAs(AEColor.Transparent, stack)) {
                return stack;
            }
            if (parts.cableDense().sameAs(AEColor.Transparent, stack)) {
                return stack;
            }
            if (parts.cableDenseCovered().sameAs(AEColor.Transparent, stack)) {
                return stack;
            }
            if (parts.cableUltraDenseCovered().sameAs(AEColor.Transparent, stack)) {
                return stack;
            }
            if (!parts.cableUltraDenseSmart().sameAs(AEColor.Transparent, stack)) continue;
            return stack;
        }
        return is;
    }

    public static void sendChunk(Chunk c, int verticalBits) {
        try {
            Object playerInstance;
            WorldServer ws = (WorldServer)c.field_76637_e;
            PlayerManager pm = ws.func_73040_p();
            if (getOrCreateChunkWatcher == null) {
                getOrCreateChunkWatcher = ReflectionHelper.findMethod(PlayerManager.class, (Object)pm, (String[])new String[]{"getOrCreateChunkWatcher", "func_72690_a"}, (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
            }
            if (getOrCreateChunkWatcher != null && (playerInstance = getOrCreateChunkWatcher.invoke((Object)pm, c.field_76635_g, c.field_76647_h, false)) != null) {
                Platform.playerInstance = playerInstance.getClass();
                if (sendToAllPlayersWatchingChunk == null) {
                    sendToAllPlayersWatchingChunk = ReflectionHelper.findMethod((Class)Platform.playerInstance, (Object)playerInstance, (String[])new String[]{"sendToAllPlayersWatchingChunk", "func_151251_a"}, (Class[])new Class[]{Packet.class});
                }
                if (sendToAllPlayersWatchingChunk != null) {
                    sendToAllPlayersWatchingChunk.invoke(playerInstance, new S21PacketChunkData(c, false, verticalBits));
                }
            }
        }
        catch (Throwable t) {
            AELog.debug(t);
        }
    }

    public static AxisAlignedBB getPrimaryBox(ForgeDirection side, int facadeThickness) {
        switch (side) {
            case DOWN: {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)((double)facadeThickness / 16.0), (double)1.0);
            }
            case EAST: {
                return AxisAlignedBB.func_72330_a((double)((16.0 - (double)facadeThickness) / 16.0), (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            case NORTH: {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)((double)facadeThickness / 16.0));
            }
            case SOUTH: {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)((16.0 - (double)facadeThickness) / 16.0), (double)1.0, (double)1.0, (double)1.0);
            }
            case UP: {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)((16.0 - (double)facadeThickness) / 16.0), (double)0.0, (double)1.0, (double)1.0, (double)1.0);
            }
            case WEST: {
                return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)((double)facadeThickness / 16.0), (double)1.0, (double)1.0);
            }
        }
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    }

    public static float getEyeOffset(EntityPlayer player) {
        assert (player.field_70170_p.field_72995_K) : "Valid only on client";
        return (float)(player.field_70163_u + (double)player.func_70047_e() - (double)player.getDefaultEyeHeight());
    }

    public static void addStat(int playerID, Achievement achievement) {
        EntityPlayer p = AEApi.instance().registries().players().findPlayer(playerID);
        if (p != null) {
            p.func_71064_a((StatBase)achievement, 1);
        }
    }

    public static boolean isRecipePrioritized(ItemStack what) {
        IMaterials materials = AEApi.instance().definitions().materials();
        boolean isPurified = materials.purifiedCertusQuartzCrystal().isSameAs(what);
        isPurified |= materials.purifiedFluixCrystal().isSameAs(what);
        return isPurified |= materials.purifiedNetherQuartzCrystal().isSameAs(what);
    }

    public static ItemStack loadItemStackFromNBT(NBTTagCompound tagCompound) {
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        if (stack != null) {
            stack.field_77994_a = tagCompound.func_74762_e("Count");
        }
        return stack;
    }

    public static NBTTagCompound writeItemStackToNBT(ItemStack is, NBTTagCompound tagCompound) {
        is.func_77955_b(tagCompound);
        tagCompound.func_74768_a("Count", is.field_77994_a);
        return tagCompound;
    }

    public static IAEItemStack getAEStackInSlot(Slot slot) {
        if (slot == null || !slot.func_75216_d()) {
            return null;
        }
        if (slot instanceof SlotME) {
            return ((SlotME)slot).getAEStack();
        }
        if (slot instanceof SlotFake) {
            return ((SlotFake)slot).getAEStack();
        }
        return AEItemStack.create(slot.func_75211_c());
    }

    public static long ceilDiv(long a, long b) {
        return Math.addExact(Math.addExact(a, b), -1L) / b;
    }

    public static String formatByteDouble(double n) {
        for (int i = 1; i < 10; ++i) {
            if (!(n < BYTE_LIMIT[i])) continue;
            return df.format(n / BYTE_LIMIT[i - 1]) + " " + BYTE_UNIT[i - 1];
        }
        return n / BYTE_LIMIT[0] + " " + BYTE_UNIT[0];
    }

    static {
        fakeProfile = new GameProfile(UUID.fromString("839eb18c-50bc-400c-8291-9383f09763e7"), "[AE2Player]");
        BYTE_UNIT = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB", "BB"};
        df = new DecimalFormat("#.##");
        BYTE_LIMIT = new double[10];
        for (int i = 0; i < 10; ++i) {
            Platform.BYTE_LIMIT[i] = Math.pow(2.0, i * 10);
        }
        lastUsedRecipe = null;
    }
}

