/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.inventory;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.iterators.AEInvIterator;
import appeng.util.iterators.InvIterator;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class AppEngInternalAEInventory
implements IInventory,
Iterable<ItemStack> {
    private final IAEAppEngInventory te;
    private final IAEItemStack[] inv;
    private final int size;
    private int maxStack;

    public AppEngInternalAEInventory(IAEAppEngInventory te, int s) {
        this.te = te;
        this.size = s;
        this.maxStack = 64;
        this.inv = new IAEItemStack[s];
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.size; ++x) {
            if (this.func_70301_a(x) == null) continue;
            return false;
        }
        return true;
    }

    public void setMaxStackSize(int s) {
        this.maxStack = s;
    }

    public IAEItemStack getAEStackInSlot(int var1) {
        return this.inv[var1];
    }

    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = new NBTTagCompound();
        this.writeToNBT(c);
        data.func_74782_a(name, (NBTBase)c);
    }

    private void writeToNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = new NBTTagCompound();
                if (this.inv[x] != null) {
                    this.inv[x].writeToNBT(c);
                }
                target.func_74782_a("#" + x, (NBTBase)c);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void readFromNBT(NBTTagCompound data, String name) {
        NBTTagCompound c = data.func_74775_l(name);
        if (c != null) {
            this.readFromNBT(c);
        }
    }

    private void readFromNBT(NBTTagCompound target) {
        for (int x = 0; x < this.size; ++x) {
            try {
                NBTTagCompound c = target.func_74775_l("#" + x);
                if (c == null) continue;
                this.inv[x] = AEItemStack.loadItemStackFromNBT(c);
                continue;
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int var1) {
        if (this.inv[var1] == null) {
            return null;
        }
        return this.inv[var1].getItemStack();
    }

    public ItemStack func_70298_a(int slot, int qty) {
        if (this.inv[slot] != null) {
            ItemStack split = this.func_70301_a(slot);
            ItemStack ns = null;
            if (qty >= split.field_77994_a) {
                ns = this.func_70301_a(slot);
                this.inv[slot] = null;
            } else {
                ns = split.func_77979_a(qty);
            }
            if (this.te != null && Platform.isServer()) {
                this.te.onChangeInventory(this, slot, InvOperation.decreaseStackSize, ns, null);
            }
            return ns;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack newItemStack) {
        ItemStack oldStack = this.func_70301_a(slot);
        this.inv[slot] = AEApi.instance().storage().createItemStack(newItemStack);
        if (this.te != null && Platform.isServer()) {
            ItemStack removed = oldStack;
            ItemStack added = newItemStack;
            if (oldStack != null && newItemStack != null && Platform.isSameItem(oldStack, newItemStack)) {
                if (oldStack.field_77994_a > newItemStack.field_77994_a) {
                    removed = removed.func_77946_l();
                    removed.field_77994_a -= newItemStack.field_77994_a;
                    added = null;
                } else if (oldStack.field_77994_a < newItemStack.field_77994_a) {
                    added = added.func_77946_l();
                    added.field_77994_a -= oldStack.field_77994_a;
                    removed = null;
                } else {
                    added = null;
                    removed = null;
                }
            }
            this.te.onChangeInventory(this, slot, InvOperation.setInventorySlotContents, removed, added);
        }
    }

    public String func_145825_b() {
        return "appeng-internal";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.maxStack > 64 ? 64 : this.maxStack;
    }

    public void func_70296_d() {
        if (this.te != null && Platform.isServer()) {
            this.te.onChangeInventory(this, -1, InvOperation.markDirty, null, null);
        }
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new InvIterator(this);
    }

    public Iterator<IAEItemStack> getNewAEIterator() {
        return new AEInvIterator(this);
    }
}

