/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.chat;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.api.chat.INicknameHandler;
import pl.asie.lib.network.Packet;

public class NicknameNetworkHandler
implements INicknameHandler {
    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player != null) {
            AsieLibMod.nick.updateNickname(event.player.func_70005_c_());
        }
        HashMap<String, String> names = new HashMap<String, String>();
        for (Object o : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            EntityPlayer e;
            String username;
            String nickname;
            if (o == null || !(o instanceof EntityPlayer) || (nickname = AsieLibMod.nick.getNickname(username = (e = (EntityPlayer)o).func_70005_c_())).equals(username)) continue;
            names.put(username, nickname);
        }
        this.sendNicknameSyncPacket(names, event.player);
    }

    private void sendNicknameSyncPacket(HashMap<String, String> names, EntityPlayer target) {
        try {
            Packet packet = AsieLibMod.packet.create(2).writeInt(names.size());
            for (String username : names.keySet()) {
                String nickname = names.get(username);
                packet.writeString(username).writeString(nickname);
            }
            if (target == null) {
                AsieLibMod.packet.sendToAll(packet);
            } else {
                AsieLibMod.packet.sendTo(packet, (EntityPlayerMP)target);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendNicknamePacket(String realname, String nickname) {
        try {
            Packet packet = AsieLibMod.packet.create(1).writeString(realname).writeString(nickname);
            AsieLibMod.packet.sendToAll(packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onNicknameUpdate(String realname, String nickname) {
        this.sendNicknamePacket(realname, nickname);
    }
}

