/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.ints.maps.interfaces;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import speiger.src.collections.ints.functions.consumer.IntObjectConsumer;
import speiger.src.collections.ints.functions.function.IntFunction;
import speiger.src.collections.ints.functions.function.IntObjectUnaryOperator;
import speiger.src.collections.ints.maps.impl.misc.Int2ObjectArrayMap;
import speiger.src.collections.ints.sets.IntSet;
import speiger.src.collections.objects.collections.ObjectCollection;
import speiger.src.collections.objects.collections.ObjectIterable;
import speiger.src.collections.objects.collections.ObjectIterator;
import speiger.src.collections.objects.functions.ObjectSupplier;
import speiger.src.collections.objects.functions.function.ObjectObjectUnaryOperator;
import speiger.src.collections.objects.sets.ObjectSet;

public interface Int2ObjectMap<V>
extends Map<Integer, V>,
IntFunction<V> {
    public static MapBuilder builder() {
        return MapBuilder.INSTANCE;
    }

    public V getDefaultReturnValue();

    public Int2ObjectMap<V> setDefaultReturnValue(V var1);

    public Int2ObjectMap<V> copy();

    @Override
    public V put(int var1, V var2);

    default public V put(Entry<V> entry) {
        return this.put(entry.getIntKey(), (V)entry.getValue());
    }

    default public V put(Map.Entry<Integer, V> entry) {
        return this.put(entry.getKey(), entry.getValue());
    }

    default public void putAll(int[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalStateException("Array sizes do not match");
        }
        this.putAll(keys, values, 0, keys.length);
    }

    public void putAll(int[] var1, V[] var2, int var3, int var4);

    default public void putAll(Integer[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalStateException("Array sizes do not match");
        }
        this.putAll(keys, values, 0, keys.length);
    }

    public void putAll(Integer[] var1, V[] var2, int var3, int var4);

    @Override
    public V putIfAbsent(int var1, V var2);

    public void putAllIfAbsent(Int2ObjectMap<V> var1);

    public void putAll(Int2ObjectMap<V> var1);

    public boolean containsKey(int var1);

    @Override
    default public boolean containsKey(Object key) {
        return key instanceof Integer && this.containsKey((Integer)key);
    }

    public V remove(int var1);

    @Override
    default public V remove(Object key) {
        return key instanceof Integer ? this.remove((Integer)key) : this.getDefaultReturnValue();
    }

    public boolean remove(int var1, V var2);

    @Override
    default public boolean remove(Object key, Object value) {
        return key instanceof Integer && this.remove((Integer)key, value);
    }

    public V removeOrDefault(int var1, V var2);

    @Override
    public boolean replace(int var1, V var2, V var3);

    @Override
    public V replace(int var1, V var2);

    public void replaceObjects(Int2ObjectMap<V> var1);

    public void replaceObjects(IntObjectUnaryOperator<V> var1);

    public V compute(int var1, IntObjectUnaryOperator<V> var2);

    public V computeIfAbsent(int var1, IntFunction<V> var2);

    public V supplyIfAbsent(int var1, ObjectSupplier<V> var2);

    public V computeIfPresent(int var1, IntObjectUnaryOperator<V> var2);

    public V merge(int var1, V var2, ObjectObjectUnaryOperator<V, V> var3);

    public void mergeAll(Int2ObjectMap<V> var1, ObjectObjectUnaryOperator<V, V> var2);

    @Override
    @Deprecated
    default public boolean replace(Integer key, V oldValue, V newValue) {
        return this.replace((int)key, oldValue, newValue);
    }

    @Override
    @Deprecated
    default public V replace(Integer key, V value) {
        return this.replace((int)key, value);
    }

    @Override
    default public V apply(int key) {
        return this.get(key);
    }

    public V get(int var1);

    public V getOrDefault(int var1, V var2);

    @Override
    @Deprecated
    default public V get(Object key) {
        return key instanceof Integer ? this.get((Integer)key) : this.getDefaultReturnValue();
    }

    @Override
    @Deprecated
    default public V getOrDefault(Object key, V defaultValue) {
        V value = key instanceof Integer ? this.get((Integer)key) : this.getDefaultReturnValue();
        return !Objects.equals(value, this.getDefaultReturnValue()) || this.containsKey(key) ? value : defaultValue;
    }

    @Override
    @Deprecated
    default public void replaceAll(BiFunction<? super Integer, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        this.replaceObjects(mappingFunction instanceof IntObjectUnaryOperator ? (IntObjectUnaryOperator<Object>)mappingFunction : (K, V) -> mappingFunction.apply((Integer)K, (Object)V));
    }

    @Override
    @Deprecated
    default public V compute(Integer key, BiFunction<? super Integer, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)this.compute((int)key, mappingFunction instanceof IntObjectUnaryOperator ? (IntObjectUnaryOperator<Object>)mappingFunction : (K, V) -> mappingFunction.apply((Integer)K, (Object)V));
    }

    @Override
    @Deprecated
    default public V computeIfAbsent(Integer key, Function<? super Integer, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)this.computeIfAbsent((int)key, mappingFunction instanceof IntFunction ? (IntFunction<Object>)((Object)mappingFunction) : K -> mappingFunction.apply(K));
    }

    @Override
    @Deprecated
    default public V computeIfPresent(Integer key, BiFunction<? super Integer, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return (V)this.computeIfPresent((int)key, mappingFunction instanceof IntObjectUnaryOperator ? (IntObjectUnaryOperator<Object>)mappingFunction : (K, V) -> mappingFunction.apply((Integer)K, (Object)V));
    }

    @Override
    @Deprecated
    default public V merge(Integer key, V value, BiFunction<? super V, ? super V, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(value);
        return this.merge((int)key, value, mappingFunction instanceof ObjectObjectUnaryOperator ? (ObjectObjectUnaryOperator)mappingFunction : (K, V) -> mappingFunction.apply((Object)K, (Object)V));
    }

    public void forEach(IntObjectConsumer<V> var1);

    @Override
    @Deprecated
    default public void forEach(BiConsumer<? super Integer, ? super V> action) {
        Objects.requireNonNull(action);
        this.forEach(action instanceof IntObjectConsumer ? (IntObjectConsumer<Object>)action : (K, V) -> action.accept((Integer)K, (Object)V));
    }

    public IntSet keySet();

    @Override
    public ObjectCollection<V> values();

    @Override
    @Deprecated
    public ObjectSet<Map.Entry<Integer, V>> entrySet();

    public ObjectSet<Entry<V>> int2ObjectEntrySet();

    @Override
    @Deprecated
    default public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    @Deprecated
    default public V putIfAbsent(Integer key, V value) {
        return this.put((int)key, value);
    }

    public static class BuilderCache<V> {
        int[] keys;
        V[] values;
        int size;

        public BuilderCache() {
            this(16);
        }

        public BuilderCache(int initialSize) {
            if (initialSize < 0) {
                throw new IllegalStateException("Minimum Capacity is negative. This is not allowed");
            }
            this.keys = new int[initialSize];
            this.values = new Object[initialSize];
        }

        private void ensureSize(int newSize) {
            if (this.keys.length >= newSize) {
                return;
            }
            newSize = (int)Math.max(Math.min((long)this.keys.length + (long)(this.keys.length >> 1), 0x7FFFFFF7L), (long)newSize);
            this.keys = Arrays.copyOf(this.keys, newSize);
            this.values = Arrays.copyOf(this.values, newSize);
        }

        public BuilderCache<V> put(int key, V value) {
            this.ensureSize(this.size + 1);
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            return this;
        }

        public BuilderCache<V> put(Integer key, V value) {
            return this.put((int)key, value);
        }

        public BuilderCache<V> put(Entry<V> entry) {
            return this.put(entry.getIntKey(), (V)entry.getValue());
        }

        public BuilderCache<V> putAll(Int2ObjectMap<V> map) {
            return this.putAll(map.int2ObjectEntrySet());
        }

        public BuilderCache<V> putAll(Map<? extends Integer, ? extends V> map) {
            for (Map.Entry<Integer, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public BuilderCache<V> putAll(ObjectIterable<Entry<V>> c) {
            if (c instanceof Collection) {
                this.ensureSize(this.size + ((Collection)((Object)c)).size());
            }
            for (Entry entry : c) {
                this.put(entry);
            }
            return this;
        }

        public Int2ObjectArrayMap<V> arrayMap() {
            return new Int2ObjectArrayMap<V>(this.keys, this.values, this.size);
        }
    }

    public static final class MapBuilder {
        static final MapBuilder INSTANCE = new MapBuilder();

        public <V> BuilderCache<V> start() {
            return new BuilderCache();
        }

        public <V> BuilderCache<V> start(int size) {
            return new BuilderCache(size);
        }

        public <V> BuilderCache<V> put(int key, V value) {
            return new BuilderCache<V>().put(key, value);
        }

        public <V> BuilderCache<V> put(Integer key, V value) {
            return new BuilderCache<V>().put(key, value);
        }

        public <V> Int2ObjectArrayMap<V> arrayMap() {
            return new Int2ObjectArrayMap();
        }

        public <V> Int2ObjectArrayMap<V> arrayMap(int size) {
            return new Int2ObjectArrayMap(size);
        }

        public <V> Int2ObjectArrayMap<V> arrayMap(int[] keys, V[] values) {
            return new Int2ObjectArrayMap<V>(keys, values);
        }

        public <V> Int2ObjectArrayMap<V> arrayMap(Integer[] keys, V[] values) {
            return new Int2ObjectArrayMap<V>(keys, values);
        }

        public <V> Int2ObjectArrayMap<V> arrayMap(Int2ObjectMap<V> map) {
            return new Int2ObjectArrayMap<V>(map);
        }

        public <V> Int2ObjectArrayMap<V> arrayMap(Map<? extends Integer, ? extends V> map) {
            return new Int2ObjectArrayMap<V>(map);
        }
    }

    public static interface Entry<V>
    extends Map.Entry<Integer, V> {
        public int getIntKey();

        @Override
        default public Integer getKey() {
            return this.getIntKey();
        }
    }

    public static interface FastEntrySet<V>
    extends ObjectSet<Entry<V>> {
        public ObjectIterator<Entry<V>> fastIterator();

        default public void fastForEach(Consumer<? super Entry<V>> action) {
            this.forEach(action);
        }
    }
}

