/*
 * Decompiled with CFR 0.152.
 */
package speiger.src.collections.chars.functions;

import java.util.Comparator;
import java.util.Objects;

public interface CharComparator
extends Comparator<Character> {
    @Override
    public int compare(char var1, char var2);

    @Override
    @Deprecated
    default public int compare(Character o1, Character o2) {
        return this.compare(o1.charValue(), o2.charValue());
    }

    public static CharComparator of(Comparator<Character> c) {
        Objects.requireNonNull(c);
        return (K, V) -> c.compare(Character.valueOf(K), Character.valueOf(V));
    }

    default public CharComparator reversed() {
        return new Reversed(this);
    }

    public static class Reversed
    implements CharComparator {
        CharComparator original;

        public Reversed(CharComparator original) {
            this.original = original;
        }

        @Override
        public int compare(char o1, char o2) {
            return this.original.compare(o2, o1);
        }

        @Override
        public CharComparator reversed() {
            return this.original;
        }
    }
}

