/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.common.widget;

import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.widget.SyncedWidget;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FakeSyncWidget<T>
extends SyncedWidget {
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private final BiConsumer<PacketBuffer, T> writeToBuffer;
    private final Function<PacketBuffer, T> readFromBuffer;
    private T lastValue;
    private Consumer<T> onClientUpdate;
    private static final int MAX_PACKET_LENGTH = Short.MAX_VALUE;

    public FakeSyncWidget(Supplier<T> getter, Consumer<T> setter, BiConsumer<PacketBuffer, T> writeToBuffer, Function<PacketBuffer, T> readFromBuffer) {
        this.getter = getter;
        this.setter = setter;
        this.writeToBuffer = writeToBuffer;
        this.readFromBuffer = readFromBuffer;
    }

    @Override
    public void readOnClient(int id, PacketBuffer buf) throws IOException {
        if (id == 0) {
            T newValue = this.readFromBuffer.apply(buf);
            this.setter.accept(newValue);
            if (this.onClientUpdate != null) {
                this.onClientUpdate.accept(newValue);
            }
        }
    }

    @Override
    public void readOnServer(int id, PacketBuffer buf) throws IOException {
    }

    @Override
    public void detectAndSendChanges(boolean init) {
        T newValue = this.getter.get();
        if (init || !Objects.equals(this.lastValue, newValue)) {
            this.lastValue = newValue;
            this.syncToClient(0, buffer -> this.writeToBuffer.accept((PacketBuffer)buffer, (PacketBuffer)newValue));
        }
    }

    @Override
    public void drawBackground(float partialTicks) {
    }

    @Override
    @NotNull
    protected Size determineSize(int maxWidth, int maxHeight) {
        return Size.ZERO;
    }

    public static <E> void writeListToBuffer(PacketBuffer buffer, List<E> toWrite, BiConsumer<PacketBuffer, E> writeElementToBuffer) {
        buffer.func_150787_b(toWrite.size());
        for (E element : toWrite) {
            writeElementToBuffer.accept(buffer, element);
        }
    }

    public static <E> List<E> readListFromBuffer(PacketBuffer buffer, Function<PacketBuffer, E> readElementFromBuffer) {
        int size = buffer.func_150792_a();
        ArrayList<E> list = new ArrayList<E>();
        for (int i = 0; i < size; ++i) {
            list.add(readElementFromBuffer.apply(buffer));
        }
        return list;
    }

    public FakeSyncWidget<T> setOnClientUpdate(Consumer<T> onClientUpdate) {
        this.onClientUpdate = onClientUpdate;
        return this;
    }

    public static class ListSyncer<U>
    extends FakeSyncWidget<List<U>> {
        public ListSyncer(Supplier<List<U>> getter, Consumer<List<U>> setter, BiConsumer<PacketBuffer, U> writeElementToBuffer, Function<PacketBuffer, U> readElementFromBuffer) {
            super(getter, setter, (PacketBuffer buffer, T val) -> FakeSyncWidget.writeListToBuffer(buffer, val, writeElementToBuffer), (PacketBuffer buffer) -> FakeSyncWidget.readListFromBuffer(buffer, readElementFromBuffer));
        }
    }

    public static class FluidStackSyncer
    extends FakeSyncWidget<FluidStack> {
        public FluidStackSyncer(Supplier<FluidStack> getter, Consumer<FluidStack> setter) {
            super(getter, setter, NetworkUtils::writeFluidStack, NetworkUtils::readFluidStack);
        }
    }

    public static class ItemStackSyncer
    extends FakeSyncWidget<ItemStack> {
        public ItemStackSyncer(Supplier<ItemStack> getter, Consumer<ItemStack> setter) {
            super(getter, setter, NetworkUtils::writeItemStack, NetworkUtils::readItemStack);
        }
    }

    public static class StringSyncer
    extends FakeSyncWidget<String> {
        public StringSyncer(Supplier<String> getter, Consumer<String> setter) {
            super(getter, setter, NetworkUtils::writeStringSafe, NetworkUtils::readStringSafe);
        }
    }

    public static class DoubleSyncer
    extends FakeSyncWidget<Double> {
        public DoubleSyncer(Supplier<Double> getter, Consumer<Double> setter) {
            super(getter, setter, PacketBuffer::writeDouble, PacketBuffer::readDouble);
        }
    }

    public static class FloatSyncer
    extends FakeSyncWidget<Float> {
        public FloatSyncer(Supplier<Float> getter, Consumer<Float> setter) {
            super(getter, setter, PacketBuffer::writeFloat, PacketBuffer::readFloat);
        }
    }

    public static class BigIntegerSyncer
    extends FakeSyncWidget<BigInteger> {
        public BigIntegerSyncer(Supplier<BigInteger> getter, Consumer<BigInteger> setter) {
            super(getter, setter, (buffer, bigInteger) -> NetworkUtils.writeStringSafe(buffer, bigInteger.toString()), buffer -> new BigInteger(NetworkUtils.readStringSafe(buffer)));
        }
    }

    public static class LongSyncer
    extends FakeSyncWidget<Long> {
        public LongSyncer(Supplier<Long> getter, Consumer<Long> setter) {
            super(getter, setter, PacketBuffer::writeLong, PacketBuffer::readLong);
        }
    }

    public static class IntegerSyncer
    extends FakeSyncWidget<Integer> {
        public IntegerSyncer(Supplier<Integer> getter, Consumer<Integer> setter) {
            super(getter, setter, PacketBuffer::func_150787_b, PacketBuffer::func_150792_a);
        }
    }

    public static class ShortSyncer
    extends FakeSyncWidget<Short> {
        public ShortSyncer(Supplier<Short> getter, Consumer<Short> setter) {
            super(getter, setter, PacketBuffer::writeShort, PacketBuffer::readShort);
        }
    }

    public static class ByteSyncer
    extends FakeSyncWidget<Byte> {
        public ByteSyncer(Supplier<Byte> getter, Consumer<Byte> setter) {
            super(getter, setter, PacketBuffer::writeByte, PacketBuffer::readByte);
        }
    }

    public static class BooleanSyncer
    extends FakeSyncWidget<Boolean> {
        public BooleanSyncer(Supplier<Boolean> getter, Consumer<Boolean> setter) {
            super(getter, setter, PacketBuffer::writeBoolean, PacketBuffer::readBoolean);
        }
    }
}

