/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.AEApi;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.storage.CellType;
import com.glodblock.github.common.storage.FluidCellInventoryHandler;
import com.glodblock.github.common.storage.IFluidCellInventory;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.google.common.base.Optional;
import java.text.NumberFormat;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class FCBaseItemCell
extends AEBaseItem
implements IStorageFluidCell {
    protected CellType component;
    protected long totalBytes;
    protected int perType;
    protected double idleDrain;
    protected int maxType = 1;
    private final ReadableNumberConverter format = ReadableNumberConverter.INSTANCE;

    public FCBaseItemCell(long bytes, int perType, int totalType, double drain) {
        super(Optional.of((Object)(bytes / 1024L + "k")));
        this.setFeature(EnumSet.of(AEFeature.StorageCells));
        this.func_77625_d(1);
        this.totalBytes = bytes;
        this.perType = perType;
        this.idleDrain = drain;
        this.maxType = totalType;
        this.component = null;
    }

    public FCBaseItemCell(Optional<String> subName) {
        super(subName);
    }

    public ItemStack getHousing() {
        return ItemAndBlockHolder.CELL_HOUSING.stack();
    }

    public ItemStack getComponent() {
        return this.component.stack(1);
    }

    @Override
    public long getBytes(ItemStack cellItem) {
        return this.totalBytes;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        return this.perType;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getFluid() == null || FluidCraftAPI.instance().isBlacklistedInStorage(requestedAddition.getFluid().getClass());
    }

    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        FluidCellInventoryHandler handler;
        IFluidCellInventory cellInventory;
        IMEInventoryHandler inventory = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
        if (inventory instanceof FluidCellInventoryHandler && (cellInventory = (handler = (FluidCellInventoryHandler)inventory).getCellInv()) != null) {
            lines.add(EnumChatFormatting.WHITE + NumberFormat.getInstance().format(cellInventory.getUsedBytes()) + EnumChatFormatting.GRAY + " " + GuiText.Of.getLocal() + " " + EnumChatFormatting.DARK_GREEN + NumberFormat.getInstance().format(cellInventory.getTotalBytes()) + " " + EnumChatFormatting.GRAY + GuiText.BytesUsed.getLocal());
            lines.add(EnumChatFormatting.WHITE + NumberFormat.getInstance().format(cellInventory.getStoredFluidTypes()) + EnumChatFormatting.GRAY + " " + GuiText.Of.getLocal() + " " + EnumChatFormatting.DARK_GREEN + cellInventory.getTotalFluidTypes() + " " + EnumChatFormatting.GRAY + GuiText.Types.getLocal());
            if (GuiScreen.func_146271_m()) {
                if (cellInventory.getStoredFluidTypes() > 0L) {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.cell_contents"));
                    for (IAEFluidStack fluid : cellInventory.getContents()) {
                        if (fluid == null) continue;
                        lines.add(String.format("  %s x%s mB", fluid.getFluidStack().getLocalizedName(), this.format.toWideReadableForm(fluid.getStackSize())));
                    }
                } else {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.cell_empty"));
                }
            } else {
                lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.ctrl_for_more"));
            }
            if (handler.isPreformatted()) {
                String list = (handler.getIncludeExcludeMode() == IncludeExclude.WHITELIST ? GuiText.Included : GuiText.Excluded).getLocal();
                lines.add(GuiText.Partitioned.getLocal() + " - " + list + ' ' + GuiText.Precise.getLocal());
                if (GuiScreen.func_146272_n()) {
                    lines.add(GuiText.Filter.getLocal() + ": ");
                    for (IAEFluidStack aeFluidStack : handler.getPartitionInv()) {
                        if (aeFluidStack == null) continue;
                        lines.add("  " + aeFluidStack.getFluidStack().getLocalizedName());
                    }
                } else {
                    lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.shift_for_more"));
                }
                if (handler.getSticky()) {
                    lines.add(GuiText.Sticky.getLocal());
                }
            }
        }
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        return this.idleDrain;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return this.maxType;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 2);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new CellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        Platform.openNbtData((ItemStack)is).func_74778_a("FuzzyMode", fzMode.name());
    }

    protected boolean disassembleDrive(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer playerInventory = player.field_71071_by;
            IMEInventoryHandler inv = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.FLUIDS);
            if (inv != null && playerInventory.func_70448_g() == stack) {
                InventoryAdaptor ia = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                IItemList list = inv.getAvailableItems(StorageChannel.FLUIDS.createList());
                if (list.isEmpty() && ia != null) {
                    playerInventory.func_70299_a(playerInventory.field_70461_c, null);
                    ItemStack extraB = ia.addItems(this.component.stack(1));
                    if (extraB != null) {
                        player.func_71019_a(extraB, false);
                    }
                    IInventory upgradesInventory = this.getUpgradesInventory(stack);
                    for (int upgradeIndex = 0; upgradeIndex < upgradesInventory.func_70302_i_(); ++upgradeIndex) {
                        ItemStack upgradeStack = upgradesInventory.func_70301_a(upgradeIndex);
                        ItemStack leftStack = ia.addItems(upgradeStack);
                        if (leftStack == null || !(upgradeStack.func_77973_b() instanceof IUpgradeModule)) continue;
                        player.func_71019_a(upgradeStack, false);
                    }
                    ItemStack extraA = ia.addItems(this.getHousing());
                    if (extraA != null) {
                        player.func_71019_a(this.getHousing(), false);
                    }
                    if (player.field_71069_bz != null) {
                        player.field_71069_bz.func_75142_b();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack stack(int size) {
        return new ItemStack((Item)this, size);
    }

    public ItemStack stack() {
        return new ItemStack((Item)this, 1);
    }
}

